/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.curl;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.netty.codec.MockServerRequestEncoder;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.NottableString;
import org.mockserver.model.OutboundHttpRequest;

public class OutboundRequestToCurlSerializer {
    public String toCurl(OutboundHttpRequest outboundHttpRequest) {
        StringBuilder curlString = new StringBuilder();
        if (outboundHttpRequest != null) {
            boolean isSsl = outboundHttpRequest.isSecure() != null && outboundHttpRequest.isSecure() != false;
            curlString.append("curl -v");
            curlString.append(" ");
            curlString.append("'");
            curlString.append(isSsl ? "https" : "http");
            curlString.append("://");
            curlString.append(this.getHostAndPort(outboundHttpRequest));
            curlString.append(this.getUri(outboundHttpRequest));
            curlString.append("'");
            if (!this.hasDefaultMethod(outboundHttpRequest)) {
                curlString.append(" -X ").append(outboundHttpRequest.getMethod().getValue());
            }
            for (Header header : outboundHttpRequest.getHeaders()) {
                for (NottableString headerValue : header.getValues()) {
                    curlString.append(" -H '").append(header.getName().getValue()).append(": ").append(headerValue.getValue()).append("'");
                    if (!header.getName().getValue().toLowerCase().contains("Accept-Encoding".toLowerCase()) || !headerValue.getValue().toLowerCase().contains("gzip") && !headerValue.getValue().toLowerCase().contains("deflate") && !headerValue.getValue().toLowerCase().contains("sdch")) continue;
                    curlString.append(" ");
                    curlString.append("--compress");
                }
            }
            curlString.append(this.getCookieHeader(outboundHttpRequest));
        }
        return curlString.toString();
    }

    private boolean hasDefaultMethod(OutboundHttpRequest outboundHttpRequest) {
        return Strings.isNullOrEmpty((String)outboundHttpRequest.getMethod().getValue()) || outboundHttpRequest.getMethod().getValue().equalsIgnoreCase("GET");
    }

    private String getUri(OutboundHttpRequest outboundHttpRequest) {
        String uri = new MockServerRequestEncoder().getURI(outboundHttpRequest);
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "/";
        } else if (!StringUtils.startsWith((CharSequence)uri, (CharSequence)"/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private String getHostAndPort(OutboundHttpRequest outboundHttpRequest) {
        String host = outboundHttpRequest.getFirstHeader("Host");
        if (Strings.isNullOrEmpty((String)host)) {
            host = outboundHttpRequest.getDestination().getHostName() + ":" + outboundHttpRequest.getDestination().getPort();
        }
        return host;
    }

    private String getCookieHeader(OutboundHttpRequest outboundHttpRequest) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : outboundHttpRequest.getCookies()) {
            cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
        }
        if (cookies.size() > 0) {
            return " -H 'Cookie: " + ClientCookieEncoder.LAX.encode(cookies) + "'";
        }
        return "";
    }
}

