/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class KeyStoreFactory {
    public X509Certificate createCACert(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        String issuer = "CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK";
        String subject = "CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK";
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        x509V1CertificateGenerator.setSerialNumber(BigInteger.valueOf(10L));
        x509V1CertificateGenerator.setIssuerDN((X509Name)new X509Principal(issuer));
        x509V1CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        x509V1CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 2592000000L));
        x509V1CertificateGenerator.setSubjectDN((X509Name)new X509Principal(subject));
        x509V1CertificateGenerator.setPublicKey(publicKey);
        x509V1CertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509Certificate cert = x509V1CertificateGenerator.generate(privateKey);
        cert.checkValidity(new Date());
        cert.verify(publicKey);
        return cert;
    }

    public X509Certificate createClientCert(PublicKey publicKey, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String distinguishingName, String ... subjectAlternativeNameDomains) throws Exception {
        String issuer = "CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK";
        Hashtable<ASN1ObjectIdentifier, String> attrs = new Hashtable<ASN1ObjectIdentifier, String>();
        Vector<ASN1ObjectIdentifier> order = new Vector<ASN1ObjectIdentifier>();
        attrs.put(RFC4519Style.cn, distinguishingName);
        order.addElement(RFC4519Style.cn);
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(20L));
        x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(issuer));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 2592000000L));
        x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(order, attrs));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        for (String subjectAlternativeName : subjectAlternativeNameDomains) {
            subjectAlternativeNames.add(new GeneralName(2, StringUtils.substringBefore((String)subjectAlternativeName, (String)".")));
            subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeName));
        }
        DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[subjectAlternativeNames.size()]));
        x509V3CertificateGenerator.addExtension((DERObjectIdentifier)Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        X509Certificate cert = x509V3CertificateGenerator.generate(certificateAuthorityPrivateKey);
        cert.checkValidity(new Date());
        cert.verify(certificateAuthorityPublicKey);
        return cert;
    }

    public static KeyPair generateRSAKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(2056, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    KeyStore generateCertificate(String certificationAlias, String certificateAuthorityAlias, char[] keyStorePassword, String distinguishingName, String ... subjectAlternativeNameDomains) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPair keyPair = KeyStoreFactory.generateRSAKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        KeyPair certificateAuthorityKeyPair = KeyStoreFactory.generateRSAKeyPair();
        PrivateKey certificateAuthorityPrivateKey = certificateAuthorityKeyPair.getPrivate();
        PublicKey certificateAuthorityPublicKey = certificateAuthorityKeyPair.getPublic();
        X509Certificate caCert = this.createCACert(certificateAuthorityPublicKey, certificateAuthorityPrivateKey);
        X509Certificate clientCert = this.createClientCert(publicKey, certificateAuthorityPrivateKey, certificateAuthorityPublicKey, distinguishingName, subjectAlternativeNameDomains);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, keyStorePassword);
        keyStore.setKeyEntry(certificationAlias, privateKey, keyStorePassword, new X509Certificate[]{clientCert});
        keyStore.setKeyEntry(certificateAuthorityAlias, privateKey, keyStorePassword, new X509Certificate[]{caCert});
        return keyStore;
    }
}

