/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.filters;

import org.mockserver.collections.CircularMultiMap;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.proxy.filters.ProxyRequestFilter;
import org.mockserver.proxy.filters.ProxyResponseFilter;

public class Filters {
    private final CircularMultiMap<HttpRequestMatcher, ProxyResponseFilter> responseFilters = new CircularMultiMap(100, 100);
    private final CircularMultiMap<HttpRequestMatcher, ProxyRequestFilter> requestFilters = new CircularMultiMap(100, 100);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();

    public Filters withFilter(HttpRequest httpRequest, ProxyRequestFilter filter) {
        this.requestFilters.put(this.matcherBuilder.transformsToMatcher(httpRequest), filter);
        return this;
    }

    public Filters withFilter(HttpRequest httpRequest, ProxyResponseFilter filter) {
        this.responseFilters.put(this.matcherBuilder.transformsToMatcher(httpRequest), filter);
        return this;
    }

    public HttpRequest applyFilters(HttpRequest httpRequest) {
        for (HttpRequestMatcher httpRequestMatcher : this.requestFilters.keySet()) {
            if (!httpRequestMatcher.matches(httpRequest)) continue;
            for (ProxyRequestFilter proxyRequestFilter : this.requestFilters.getAll(httpRequestMatcher)) {
                if (httpRequest == null) continue;
                httpRequest = proxyRequestFilter.onRequest(httpRequest);
            }
        }
        return httpRequest;
    }

    public HttpResponse applyFilters(HttpRequest httpRequest, HttpResponse httpResponse) {
        for (HttpRequestMatcher httpRequestMatcher : this.responseFilters.keySet()) {
            if (!httpRequestMatcher.matches(httpRequest)) continue;
            for (ProxyResponseFilter proxyFilter : this.responseFilters.getAll(httpRequestMatcher)) {
                httpResponse = proxyFilter.onResponse(httpRequest, httpResponse);
                if (httpResponse != null) continue;
                throw new IllegalStateException(proxyFilter.getClass().getName() + " returned a null HttpResponse, Filters are not allowed to return a null HttpResponse object, a Filter can only return null for an HttpRequest which will prevent the request being sent.");
            }
        }
        return httpResponse;
    }
}

