/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.Times;
import org.mockserver.model.Action;
import org.mockserver.model.EqualsHashCodeToString;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class Expectation
extends EqualsHashCodeToString {
    private final HttpRequest httpRequest;
    private final Times times;
    private final HttpRequestMatcher httpRequestMatcher;
    private HttpResponse httpResponse;
    private HttpForward httpForward;

    public Expectation(HttpRequest httpRequest, Times times) {
        this.httpRequest = httpRequest;
        this.times = times;
        this.httpRequestMatcher = new MatcherBuilder().transformsToMatcher(this.httpRequest);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse(boolean applyDelay) {
        if (this.httpResponse != null) {
            if (applyDelay) {
                return this.httpResponse.applyDelay();
            }
            return this.httpResponse;
        }
        return null;
    }

    public HttpForward getHttpForward() {
        return this.httpForward;
    }

    public Action getAction(boolean applyDelay) {
        if (this.httpResponse != null) {
            return this.getHttpResponse(applyDelay);
        }
        return this.getHttpForward();
    }

    public Times getTimes() {
        return this.times;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        if (httpResponse != null) {
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward has been set");
            }
            this.httpResponse = httpResponse;
        }
        return this;
    }

    public Expectation thenForward(HttpForward httpForward) {
        if (httpForward != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response has been set");
            }
            this.httpForward = httpForward;
        }
        return this;
    }

    public boolean matches(HttpRequest httpRequest) {
        boolean matches;
        this.logger.trace("\nMatching expectation: \n{} \nwith incoming http: \n{}\n", (Object)this.httpRequest, (Object)httpRequest);
        boolean bl = matches = (this.times == null || this.times.greaterThenZero()) && (httpRequest == null && this.httpRequest == null || this.httpRequestMatcher.matches(httpRequest));
        if (matches && this.times != null) {
            this.times.decrement();
        }
        return matches;
    }

    public void setNotUnlimitedResponses() {
        if (this.times != null) {
            this.times.setNotUnlimitedResponses();
        }
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }
}

