/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.model.EqualsHashCodeToString;

public class Times
extends EqualsHashCodeToString {
    private int remainingTimes;
    private boolean unlimited;

    private Times(int remainingTimes, boolean unlimited) {
        this.remainingTimes = remainingTimes;
        this.unlimited = unlimited;
    }

    public static Times unlimited() {
        return new Times(0, true);
    }

    public static Times once() {
        return new Times(1, false);
    }

    public static Times exactly(int count) {
        return new Times(count, false);
    }

    public int getRemainingTimes() {
        return this.remainingTimes;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean greaterThenZero() {
        if (this.unlimited || this.remainingTimes > 0) {
            return true;
        }
        this.logger.trace("Remaining count is 0");
        return false;
    }

    public Times decrement() {
        if (!this.unlimited) {
            --this.remainingTimes;
        }
        return this;
    }

    public Times setNotUnlimitedResponses() {
        if (this.unlimited) {
            this.remainingTimes = 1;
            this.unlimited = false;
        }
        return this;
    }
}

