/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MapMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterStringMatcher
extends BodyMatcher
implements Matcher<String> {
    private static Logger logger = LoggerFactory.getLogger(ParameterStringMatcher.class);
    private final MapMatcher matcher;

    public ParameterStringMatcher(List<Parameter> parameters) {
        this.matcher = new MapMatcher(KeyToMultiValue.toMultiMap(parameters));
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (this.matcher.matches(this.parseString(matched))) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return result;
    }

    private List<KeyToMultiValue> parseString(String matched) {
        HashMap<String, Parameter> mappedParameters = new HashMap<String, Parameter>();
        Map parameters = new QueryStringDecoder("?" + matched).parameters();
        for (String name : parameters.keySet()) {
            for (String value : (List)parameters.get(name)) {
                if (mappedParameters.containsKey(name)) {
                    ((Parameter)mappedParameters.get(name)).addValue(value);
                    continue;
                }
                mappedParameters.put(name, new Parameter(name, value));
            }
        }
        return new ArrayList<KeyToMultiValue>(mappedParameters.values());
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xpathExpression"};
    }
}

