/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Strings;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactStringMatcher
extends BodyMatcher
implements Matcher<String> {
    private static Logger logger = LoggerFactory.getLogger(ExactStringMatcher.class);
    private final String matcher;

    public ExactStringMatcher(String matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (Strings.isNullOrEmpty((String)matcher)) {
            result = true;
        } else if (matched != null) {
            if (matched.equals(matcher)) {
                result = true;
            }
            if (ignoreCase && matched.equalsIgnoreCase(matcher)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (ExactStringMatcher.matches(this.matcher, matched, false)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return result;
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xpathExpression"};
    }
}

