/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.EqualsHashCodeToString;

public class CaseInsensitiveRegexMultiMap
extends EqualsHashCodeToString
implements Map<String, String> {
    private final CaseInsensitiveRegexHashMap<List<String>> backingMap = new CaseInsensitiveRegexHashMap();

    @Override
    public synchronized int size() {
        return this.backingMap.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        for (String matcherKey : this.backingMap.keySet()) {
            for (List<String> allMatcherKeyValues : this.backingMap.getAll(matcherKey)) {
                for (String matcherKeyValue : allMatcherKeyValues) {
                    if (!RegexStringMatcher.matches(matcherKey, key, true) || !RegexStringMatcher.matches(matcherKeyValue, value, false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (value instanceof String) {
            for (String key : this.backingMap.keySet()) {
                for (List<String> allKeyValues : this.backingMap.getAll(key)) {
                    for (String keyValue : allKeyValues) {
                        if (!RegexStringMatcher.matches(keyValue, (String)value, false)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean containsAll(CaseInsensitiveRegexMultiMap subSet) {
        for (String subSetKey : subSet.keySet()) {
            if (!this.containsKey(subSetKey)) {
                return false;
            }
            for (String subSetValue : subSet.getAll(subSetKey)) {
                if (this.containsKeyValue(subSetKey, subSetValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized String get(Object key) {
        List<String> values = this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public synchronized List<String> getAll(Object key) {
        ArrayList<String> all = new ArrayList<String>();
        for (List<String> subList : this.backingMap.getAll(key)) {
            all.addAll(subList);
        }
        return all;
    }

    @Override
    public synchronized String put(String key, String value) {
        List<String> list = Collections.synchronizedList(new ArrayList());
        if (this.containsKey(key)) {
            list.addAll((Collection)this.backingMap.get(key));
        }
        list.add(value);
        this.backingMap.put(key, list);
        return value;
    }

    @Override
    public synchronized List<String> put(String key, List<String> values) {
        if (this.containsKey(key)) {
            for (String value : values) {
                this.put(key, value);
            }
        } else {
            this.backingMap.put(key, values);
        }
        return values;
    }

    public void putValuesForNewKeys(CaseInsensitiveRegexMultiMap multiMap) {
        for (String key : multiMap.keySet()) {
            if (this.containsKey(key)) continue;
            this.backingMap.put(key, multiMap.getAll(key));
        }
    }

    @Override
    public synchronized String remove(Object key) {
        List<String> values = this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            return values.remove(0);
        }
        return null;
    }

    public synchronized List<String> removeAll(String key) {
        return this.backingMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.backingMap.clear();
    }

    @Override
    public synchronized Set<String> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public synchronized Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (List valuesForKey : this.backingMap.values()) {
            values.addAll(valuesForKey);
        }
        return values;
    }

    @Override
    public synchronized Set<Map.Entry<String, String>> entrySet() {
        LinkedHashSet<Map.Entry<String, String>> entrySet = new LinkedHashSet<Map.Entry<String, String>>();
        for (Map.Entry entry : this.backingMap.entrySet()) {
            for (String value : (List)entry.getValue()) {
                entrySet.add(new ImmutableEntry((String)entry.getKey(), value));
            }
        }
        return entrySet;
    }

    class ImmutableEntry
    extends EqualsHashCodeToString
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        ImmutableEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("ImmutableEntry is immutable");
        }
    }
}

