/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.tools.maven.plugins.library;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mobicents.slee.tools.maven.plugins.library.pojos.LibraryRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryDescriptorMojo
extends AbstractMojo {
    private LibraryRef libraryId;
    private List<LibraryRef> libraryRefs = new ArrayList<LibraryRef>();
    private String libraryRefsInConfig = null;
    private String eventTypeRefs = null;
    private String profileSpecRefs = null;
    private String raTypeRefs = null;
    private String sbbRefs = null;
    private String securityPermissions = null;
    private MavenProject project;
    private File jarInputDirectory;
    private String jarDirectory;
    private File workDirectory;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Executing Maven JAIN SLEE 1.1 Library Plugin");
        }
        this.setupDirectories();
        this.libraryId = this.getLibraryRef(this.project);
        this.libraryRefsInConfig = this.getRefs(this.project, "library");
        this.getLog().info((CharSequence)("Library Refs Configuration:\n" + this.libraryRefsInConfig));
        this.eventTypeRefs = this.getRefs(this.project, "event-type");
        this.getLog().info((CharSequence)("EventType Refs:\n" + this.eventTypeRefs));
        this.profileSpecRefs = this.getRefs(this.project, "profile-spec");
        this.getLog().info((CharSequence)("ProfileSpec Refs:\n" + this.profileSpecRefs));
        this.raTypeRefs = this.getRefs(this.project, "resource-adaptor-type");
        this.getLog().info((CharSequence)("RA Type Refs:\n" + this.raTypeRefs));
        this.sbbRefs = this.getRefs(this.project, "sbb");
        this.getLog().info((CharSequence)("SBB Refs:\n" + this.sbbRefs));
        this.securityPermissions = this.getSecurityPermission(this.project);
        this.getLog().info((CharSequence)("Security Permissions:\n" + this.securityPermissions));
        if (this.libraryId == null) {
            throw new MojoExecutionException("Unable to get Library ID from pom, please verify.");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)(this.libraryId.getName() + "#" + this.libraryId.getVendor() + "#" + this.libraryId.getVersion()));
        }
        Set<String> jars = this.collectFiles(this.jarInputDirectory, ".jar");
        this.generateLibraryDeploymentDescritptor(jars);
    }

    private void setupDirectories() {
        if (this.jarInputDirectory == null) {
            this.jarInputDirectory = this.jarDirectory == null ? this.workDirectory : new File(this.workDirectory, this.jarDirectory);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Jar input directory: " + this.jarInputDirectory.getAbsolutePath()));
        }
    }

    private void generateLibraryDeploymentDescritptor(Set<String> jars) throws MojoExecutionException {
        File libraryDescriptorDir = new File(this.project.getBuild().getOutputDirectory(), "META-INF");
        if (!libraryDescriptorDir.exists()) {
            libraryDescriptorDir.mkdirs();
        }
        File libraryDD = new File(libraryDescriptorDir.getAbsolutePath(), "library-jar.xml");
        String xml = null;
        xml = this.eventTypeRefs != null || this.profileSpecRefs != null || this.raTypeRefs != null || this.sbbRefs != null ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE library-jar PUBLIC \r\n\t\t\"-//Sun Microsystems, Inc.//DTD JAIN SLEE Ext Library 1.1//EN\" \r\n\t\t\"http://mobicents.org/slee/dtd/slee-library-jar_1_1-ext.dtd\">\r\n\r\n<library-jar>\r\n\t<library>\r\n" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE library-jar PUBLIC \r\n\t\"-//Sun Microsystems, Inc.//DTD JAIN SLEE Library 1.1//EN\" \r\n\t\"http://java.sun.com/dtd/slee-library-jar_1_1.dtd\">\r\n<library-jar>\r\n\t<library>\r\n";
        xml = xml + this.libraryId.toXmlEntry();
        if (this.eventTypeRefs != null) {
            xml = xml + this.eventTypeRefs + "\r\n";
        }
        if (this.libraryRefsInConfig != null) {
            xml = xml + this.libraryRefsInConfig + "\r\n";
        }
        if (this.libraryRefs != null && !this.libraryRefs.isEmpty()) {
            for (LibraryRef libraryRef : this.libraryRefs) {
                xml = xml + libraryRef.toXmlEntryWithRef();
            }
            xml = xml + "\r\n";
        }
        if (this.profileSpecRefs != null) {
            xml = xml + this.profileSpecRefs + "\r\n";
        }
        if (this.raTypeRefs != null) {
            xml = xml + this.raTypeRefs + "\r\n";
        }
        if (this.sbbRefs != null) {
            xml = xml + this.sbbRefs + "\r\n";
        }
        for (String jar : jars) {
            xml = xml + "\t\t<jar>\r\n\t\t\t<jar-name>";
            xml = this.jarDirectory == null ? xml + jar : xml + this.jarDirectory + '/' + jar;
            xml = xml + "</jar-name>\r\n\t\t</jar>\r\n";
        }
        xml = xml + "\t</library>\r\n";
        if (this.securityPermissions != null) {
            xml = xml + this.securityPermissions;
        }
        xml = xml + "</library-jar>\r\n";
        this.getLog().info((CharSequence)("Generated Library descriptor: " + libraryDD.getAbsolutePath() + "\n" + xml + "\n"));
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(libraryDD));
            out.write(xml);
            out.close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failed to create deployment descriptor in " + libraryDD.getAbsolutePath()), (Throwable)e);
        }
    }

    private LibraryRef getLibraryRef(MavenProject mavenProject) {
        String libraryDescription = null;
        for (Object pObject : mavenProject.getBuildPlugins()) {
            String libraryVersion;
            String libraryVendor;
            String libraryName;
            Plugin plugin = (Plugin)pObject;
            if (!plugin.getArtifactId().equals("maven-library-plugin")) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration != null) {
                if (configuration.getChildren("library-name").length <= 0) {
                    this.getLog().error((CharSequence)"Library Name missing in plugin configuration!");
                    return null;
                }
                libraryName = configuration.getChildren("library-name")[0].getValue();
                if (configuration.getChildren("library-vendor").length <= 0) {
                    this.getLog().error((CharSequence)"Library Vendor missing in plugin configuration!");
                    return null;
                }
                libraryVendor = configuration.getChildren("library-vendor")[0].getValue();
                if (configuration.getChildren("library-version").length <= 0) {
                    this.getLog().error((CharSequence)"Library Version missing in plugin configuration!");
                    return null;
                }
                libraryVersion = configuration.getChildren("library-version")[0].getValue();
                if (configuration.getChildren("description").length > 0) {
                    libraryDescription = configuration.getChildren("description")[0].getValue();
                }
            } else {
                this.getLog().error((CharSequence)"Configuration missing in plugin!");
                return null;
            }
            return new LibraryRef(libraryName, libraryVendor, libraryVersion, libraryDescription);
        }
        return null;
    }

    private String getRefs(MavenProject mavenProject, String refName) {
        for (Object pObject : mavenProject.getBuildPlugins()) {
            Plugin plugin = (Plugin)pObject;
            if (!plugin.getArtifactId().equals("maven-library-plugin")) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration != null) {
                String result = null;
                for (Xpp3Dom child : configuration.getChildren(refName + "-ref")) {
                    String childXml = "\t\t<" + refName + "-ref>";
                    try {
                        childXml = childXml + "\n\t\t\t<" + refName + "-name>" + child.getChild(refName + "-name").getValue() + "</" + refName + "-name>";
                        childXml = childXml + "\n\t\t\t<" + refName + "-vendor>" + child.getChild(refName + "-vendor").getValue() + "</" + refName + "-vendor>";
                        childXml = childXml + "\n\t\t\t<" + refName + "-version>" + child.getChild(refName + "-version").getValue() + "</" + refName + "-version>";
                        childXml = childXml + "\n\t\t</" + refName + "-ref>";
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to load ref of type " + refName), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    result = result == null ? childXml : result + "\r\n" + childXml;
                }
                return result;
            }
            this.getLog().info((CharSequence)"Configuration missing in plugin!");
            return null;
        }
        return null;
    }

    private String getSecurityPermission(MavenProject mavenProject) {
        for (Object pObject : mavenProject.getBuildPlugins()) {
            Plugin plugin = (Plugin)pObject;
            if (!plugin.getArtifactId().equals("maven-library-plugin")) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration == null) {
                this.getLog().info((CharSequence)"Configuration missing in plugin!");
                return null;
            }
            String result = null;
            Xpp3Dom child = configuration.getChild("security-permissions");
            if (child != null) {
                Xpp3Dom securityPermissionSpec;
                result = "\t<security-permissions>\r\n";
                Xpp3Dom description = child.getChild("description");
                if (description != null && description.getValue() != null) {
                    result = result + "\t\t<description>\r\n\t\t\t" + description.getValue() + "\r\n\t\t</description>\r\n";
                }
                if ((securityPermissionSpec = child.getChild("security-permission-spec")) != null && securityPermissionSpec.getValue() != null) {
                    result = result + "\t\t<security-permission-spec>\r\n\t\t\t" + securityPermissionSpec.getValue() + "\r\n\t\t</security-permission-spec>\r\n";
                }
                result = result + "\t</security-permissions>\r\n";
            }
            return result;
        }
        return null;
    }

    private Set<String> collectFiles(File inputDirectory, String suffix) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Collecting non hidden files with " + suffix + " name sufix from directory " + inputDirectory.getAbsolutePath()));
        }
        if (inputDirectory == null || !inputDirectory.exists() || !inputDirectory.isDirectory()) {
            return Collections.emptySet();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Directory " + inputDirectory.getAbsolutePath() + " sucessfully validated."));
        }
        HashSet<String> result = new HashSet<String>();
        for (File f : inputDirectory.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().endsWith(suffix)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Collecting file " + f.getName()));
            }
            result.add(f.getName());
        }
        return result;
    }
}

