/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup.loading.rules;

import org.mobicents.servlet.sip.startup.loading.rules.AndRule;
import org.mobicents.servlet.sip.startup.loading.rules.ContainsRule;
import org.mobicents.servlet.sip.startup.loading.rules.EqualsRule;
import org.mobicents.servlet.sip.startup.loading.rules.ExistsRule;
import org.mobicents.servlet.sip.startup.loading.rules.MatchingRule;
import org.mobicents.servlet.sip.startup.loading.rules.NotRule;
import org.mobicents.servlet.sip.startup.loading.rules.OrRule;
import org.mobicents.servlet.sip.startup.loading.rules.SubdomainRule;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MatchingRuleParser {
    public static MatchingRule buildRule(Element e) {
        String name = e.getNodeName();
        if ("and".equals(name)) {
            AndRule and = new AndRule();
            NodeList list = e.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                and.addCriterion(MatchingRuleParser.buildRule((Element)n));
            }
            return and;
        }
        if ("equal".equals(name)) {
            String var = MatchingRuleParser.getString(e, "var");
            String value = MatchingRuleParser.getString(e, "value");
            boolean ignoreCase = "true".equalsIgnoreCase(e.getAttribute("ignore-case"));
            return new EqualsRule(var, value, ignoreCase);
        }
        if ("subdomain-of".equals(name)) {
            String var = MatchingRuleParser.getString(e, "var");
            String value = MatchingRuleParser.getString(e, "value");
            return new SubdomainRule(var, value);
        }
        if ("or".equals(name)) {
            OrRule or = new OrRule();
            NodeList list = e.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                or.addCriterion(MatchingRuleParser.buildRule((Element)n));
            }
            return or;
        }
        if ("not".equals(name)) {
            NotRule not = new NotRule();
            NodeList list = e.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                not.setCriterion(MatchingRuleParser.buildRule((Element)n));
            }
            return not;
        }
        if ("contains".equals(name)) {
            String var = MatchingRuleParser.getString(e, "var");
            String value = MatchingRuleParser.getString(e, "value");
            boolean ignoreCase = "true".equalsIgnoreCase(e.getAttribute("ignore-case"));
            return new ContainsRule(var, value, ignoreCase);
        }
        if ("exists".equals(name)) {
            return new ExistsRule(MatchingRuleParser.getString(e, "var"));
        }
        throw new IllegalArgumentException("Unknown rule: " + name);
    }

    public static String getString(Element e, String name) {
        NodeList list = e.getElementsByTagName(name);
        return ((Element)list.item(0)).getTextContent();
    }
}

