/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.SipStackExt;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sip.SipListener;
import javax.sip.SipStack;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardService;
import org.apache.coyote.ProtocolHandler;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.CongestionControlPolicy;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.startup.SipProtocolHandler;
import org.mobicents.servlet.sip.startup.SipService;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SipStandardService
extends StandardService
implements SipService {
    private static final Logger logger = Logger.getLogger(SipStandardService.class);
    private static final String DEFAULT_SIP_PATH_NAME = "gov.nist";
    private static final String INFO = "org.mobicents.servlet.sip.startup.SipStandardService/1.0";
    protected String sipApplicationDispatcherClassName;
    protected SipApplicationDispatcher sipApplicationDispatcher;
    private boolean gatherStatistics = true;
    protected int sipMessageQueueSize = 1500;
    private int backToNormalSipMessageQueueSize = 1300;
    protected int memoryThreshold = 95;
    private int backToNormalMemoryThreshold = 90;
    protected String outboundProxy;
    protected long congestionControlCheckingInterval = 30000L;
    private int baseTimerInterval = 500;
    private int t2Interval = 4000;
    private int t4Interval = 5000;
    private int timerDInterval = 32000;
    protected int dispatcherThreadPoolSize = 4;
    protected String concurrencyControlMode = ConcurrencyControlMode.None.toString();
    protected String congestionControlPolicy = CongestionControlPolicy.ErrorResponse.toString();
    protected String additionalParameterableHeaders;
    protected boolean bypassResponseExecutor = true;
    protected boolean bypassRequestExecutor = true;
    protected String darConfigurationFileLocation;
    protected boolean connectorsStartedExternally = false;
    private String sipPathName;
    private boolean usePrettyEncoding = true;
    @Deprecated
    private String balancers;

    public String getInfo() {
        return INFO;
    }

    public void addConnector(Connector connector) {
        ProtocolHandler protocolHandler;
        ExtendedListeningPoint extendedListeningPoint = (ExtendedListeningPoint)connector.getProtocolHandler().getAttribute(ExtendedListeningPoint.class.getSimpleName());
        if (extendedListeningPoint != null) {
            try {
                extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
            }
            catch (TooManyListenersException e) {
                logger.error((Object)"Connector.initialize", (Throwable)e);
            }
        }
        if ((protocolHandler = connector.getProtocolHandler()) instanceof SipProtocolHandler) {
            connector.setPort(((SipProtocolHandler)protocolHandler).getPort());
            protocolHandler.setAttribute(SipApplicationDispatcher.class.getSimpleName(), (Object)this.sipApplicationDispatcher);
            if (this.balancers != null) {
                protocolHandler.setAttribute("balancers", (Object)this.balancers);
            }
            this.registerSipConnector(connector);
        }
        super.addConnector(connector);
    }

    protected void registerSipConnector(Connector connector) {
        try {
            ObjectName objectName = this.createSipConnectorObjectName(connector, this.getName(), "SipConnector");
            Registry.getRegistry(null, null).registerComponent((Object)connector, objectName, null);
            connector.setController(objectName);
        }
        catch (Exception e) {
            logger.error((Object)"Error registering connector ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating name for connector " + this.oname));
        }
    }

    public void removeConnector(Connector connector) {
        ExtendedListeningPoint extendedListeningPoint = (ExtendedListeningPoint)connector.getProtocolHandler().getAttribute(ExtendedListeningPoint.class.getSimpleName());
        if (extendedListeningPoint != null) {
            extendedListeningPoint.getSipProvider().removeSipListener((SipListener)this.sipApplicationDispatcher);
            this.sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint(extendedListeningPoint);
        }
        super.removeConnector(connector);
    }

    public void initialize() throws LifecycleException {
        StaticServiceHolder.sipStandardService = this;
        try {
            this.sipApplicationDispatcher = (SipApplicationDispatcher)Class.forName(this.sipApplicationDispatcherClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException("Impossible to load the Sip Application Dispatcher", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new LifecycleException("Sip Application Dispatcher defined does not implement " + SipApplicationDispatcher.class.getName(), (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Pretty encoding of headers enabled ? " + this.usePrettyEncoding));
        }
        if (this.sipPathName == null) {
            this.sipPathName = DEFAULT_SIP_PATH_NAME;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Sip Stack path name : " + this.sipPathName));
        }
        SipFactories.initialize(this.sipPathName, this.usePrettyEncoding);
        if (this.darConfigurationFileLocation != null) {
            if (!this.darConfigurationFileLocation.startsWith("file:///")) {
                this.darConfigurationFileLocation = "file:///" + System.getProperty("catalina.home").replace(File.separatorChar, '/') + "/" + this.darConfigurationFileLocation;
            }
            System.setProperty("javax.servlet.sip.dar", this.darConfigurationFileLocation);
        }
        super.initialize();
        this.sipApplicationDispatcher.setDomain(this.getName());
        if (this.baseTimerInterval < 1) {
            throw new LifecycleException("It's forbidden to set the Base Timer Interval to a non positive value");
        }
        this.sipApplicationDispatcher.setBaseTimerInterval(this.baseTimerInterval);
        this.sipApplicationDispatcher.setT2Interval(this.t2Interval);
        this.sipApplicationDispatcher.setT4Interval(this.t4Interval);
        this.sipApplicationDispatcher.setTimerDInterval(this.timerDInterval);
        this.sipApplicationDispatcher.setMemoryThreshold(this.getMemoryThreshold());
        this.sipApplicationDispatcher.setBackToNormalMemoryThreshold(this.backToNormalMemoryThreshold);
        this.sipApplicationDispatcher.setCongestionControlCheckingInterval(this.getCongestionControlCheckingInterval());
        this.sipApplicationDispatcher.setCongestionControlPolicyByName(this.getCongestionControlPolicy());
        this.sipApplicationDispatcher.setQueueSize(this.getSipMessageQueueSize());
        this.sipApplicationDispatcher.setBackToNormalQueueSize(this.backToNormalSipMessageQueueSize);
        this.sipApplicationDispatcher.setGatherStatistics(this.gatherStatistics);
        this.sipApplicationDispatcher.setConcurrencyControlMode(ConcurrencyControlMode.valueOf((String)this.getConcurrencyControlMode()));
        this.sipApplicationDispatcher.setBypassRequestExecutor(this.bypassRequestExecutor);
        this.sipApplicationDispatcher.setBypassResponseExecutor(this.bypassResponseExecutor);
        this.sipApplicationDispatcher.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        super.start();
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                ProtocolHandler protocolHandler = connector.getProtocolHandler();
                Boolean isSipConnector = (Boolean)protocolHandler.getAttribute("isSipConnector");
                if (isSipConnector != null && isSipConnector.booleanValue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attaching the sip application dispatcher as a sip listener to connector listening on port " + connector.getPort()));
                    }
                    protocolHandler.setAttribute(SipApplicationDispatcher.class.getSimpleName(), (Object)this.sipApplicationDispatcher);
                    if (this.balancers != null) {
                        protocolHandler.setAttribute("balancers", (Object)this.balancers);
                    }
                    if (this.container != null && this.container instanceof Engine && ((Engine)this.container).getJvmRoute() != null) {
                        protocolHandler.setAttribute("jvmRoute", (Object)((Engine)this.container).getJvmRoute());
                    }
                    this.connectorsStartedExternally = true;
                }
                ExtendedListeningPoint extendedListeningPoint = (ExtendedListeningPoint)protocolHandler.getAttribute(ExtendedListeningPoint.class.getSimpleName());
                SipStack sipStack = (SipStack)protocolHandler.getAttribute(SipStack.class.getSimpleName());
                if (extendedListeningPoint == null || sipStack == null) continue;
                String dnsAddressResolverClass = ((SipProtocolHandler)protocolHandler).getAddressResolverClass();
                if (sipStack instanceof SipStackExt && dnsAddressResolverClass != null && dnsAddressResolverClass.trim().length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sip Stack " + sipStack.getStackName() + " will be using " + dnsAddressResolverClass + " as AddressResolver"));
                    }
                    try {
                        extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                        this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
                        this.connectorsStartedExternally = false;
                        Class[] paramTypes = new Class[]{SipApplicationDispatcher.class};
                        Constructor<?> addressResolverConstructor = Class.forName(dnsAddressResolverClass).getConstructor(paramTypes);
                        Object[] conArgs = new Object[]{this.sipApplicationDispatcher};
                        AddressResolver addressResolver = (AddressResolver)addressResolverConstructor.newInstance(conArgs);
                        ((SipStackExt)sipStack).setAddressResolver(addressResolver);
                        continue;
                    }
                    catch (Exception e) {
                        throw new LifecycleException("Couldn't set the AddressResolver " + dnsAddressResolverClass, (Throwable)e);
                    }
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)"no AddressResolver will be used since none has been specified.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.connectorsStartedExternally) {
                this.sipApplicationDispatcher.start();
            }
            if (this.getSipMessageQueueSize() <= 0) {
                throw new IllegalArgumentException("Message queue size can not be 0 or less");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.connectorsStartedExternally) {
            this.sipApplicationDispatcher.stop();
        }
        super.stop();
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                ExtendedListeningPoint extendedListeningPoint = (ExtendedListeningPoint)connector.getProtocolHandler().getAttribute(ExtendedListeningPoint.class.getSimpleName());
                if (extendedListeningPoint == null) continue;
                extendedListeningPoint.getSipProvider().removeSipListener((SipListener)this.sipApplicationDispatcher);
                this.sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint(extendedListeningPoint);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getSipApplicationDispatcherClassName() {
        return this.sipApplicationDispatcherClassName;
    }

    public void setSipApplicationDispatcherClassName(String sipApplicationDispatcherName) {
        this.sipApplicationDispatcherClassName = sipApplicationDispatcherName;
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        return this.sipApplicationDispatcher;
    }

    public void setSipApplicationDispatcher(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public String getDarConfigurationFileLocation() {
        return this.darConfigurationFileLocation;
    }

    public void setDarConfigurationFileLocation(String darConfigurationFileLocation) {
        this.darConfigurationFileLocation = darConfigurationFileLocation;
    }

    public int getSipMessageQueueSize() {
        return this.sipMessageQueueSize;
    }

    public void setSipMessageQueueSize(int sipMessageQueueSize) {
        this.sipMessageQueueSize = sipMessageQueueSize;
    }

    public String getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    public void setConcurrencyControlMode(String concurrencyControlMode) {
        this.concurrencyControlMode = concurrencyControlMode;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setGatherStatistics(boolean skipStatistics) {
        this.gatherStatistics = skipStatistics;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Gathering Statistics set to " + skipStatistics));
        }
    }

    public boolean isGatherStatistics() {
        return this.gatherStatistics;
    }

    public boolean getGatherStatistics() {
        return this.gatherStatistics;
    }

    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
    }

    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    public void setBackToNormalSipMessageQueueSize(int backToNormalSipMessageQueueSize) {
        this.backToNormalSipMessageQueueSize = backToNormalSipMessageQueueSize;
    }

    public int getBackToNormalSipMessageQueueSize() {
        return this.backToNormalSipMessageQueueSize;
    }

    public void setCongestionControlPolicy(String congestionControlPolicy) {
        this.congestionControlPolicy = congestionControlPolicy;
    }

    public String getCongestionControlPolicy() {
        return this.congestionControlPolicy;
    }

    public void setCongestionControlCheckingInterval(long congestionControlCheckingInterval) {
        this.congestionControlCheckingInterval = congestionControlCheckingInterval;
    }

    public long getCongestionControlCheckingInterval() {
        return this.congestionControlCheckingInterval;
    }

    public String getAdditionalParameterableHeaders() {
        return this.additionalParameterableHeaders;
    }

    public void setAdditionalParameterableHeaders(String additionalParameterableHeaders) {
        String[] headers;
        this.additionalParameterableHeaders = additionalParameterableHeaders;
        for (String header : headers = additionalParameterableHeaders.split(",")) {
            if (header == null || header.length() <= 0) continue;
            JainSipUtils.PARAMETERABLE_HEADER_NAMES.add(header);
        }
    }

    public boolean isBypassResponseExecutor() {
        return this.bypassResponseExecutor;
    }

    public void setBypassResponseExecutor(boolean bypassResponseExecutor) {
        this.bypassResponseExecutor = bypassResponseExecutor;
    }

    public boolean isBypassRequestExecutor() {
        return this.bypassRequestExecutor;
    }

    public void setBypassRequestExecutor(boolean bypassRequestExecutor) {
        this.bypassRequestExecutor = bypassRequestExecutor;
    }

    public void setUsePrettyEncoding(boolean usePrettyEncoding) {
        this.usePrettyEncoding = usePrettyEncoding;
    }

    public boolean isUsePrettyEncoding() {
        return this.usePrettyEncoding;
    }

    public void setSipPathName(String sipPathName) {
        this.sipPathName = sipPathName;
    }

    public String getSipPathName() {
        return this.sipPathName;
    }

    public void setBaseTimerInterval(int baseTimerInterval) {
        this.baseTimerInterval = baseTimerInterval;
    }

    public int getBaseTimerInterval() {
        return this.baseTimerInterval;
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public void setOutboundProxy(String outboundProxy) {
        this.outboundProxy = outboundProxy;
    }

    public int getDispatcherThreadPoolSize() {
        return this.dispatcherThreadPoolSize;
    }

    public void setDispatcherThreadPoolSize(int dispatcherThreadPoolSize) {
        this.dispatcherThreadPoolSize = dispatcherThreadPoolSize;
    }

    public void setBalancers(String balancers) {
        this.balancers = balancers;
    }

    public boolean addSipConnector(SipConnector sipConnector) throws Exception {
        if (sipConnector == null) {
            throw new IllegalArgumentException("The sip connector passed is null");
        }
        Connector connectorToAdd = this.findSipConnector(sipConnector.getIpAddress(), sipConnector.getPort(), sipConnector.getTransport());
        if (connectorToAdd == null) {
            Connector connector = new Connector(SipProtocolHandler.class.getName());
            SipProtocolHandler sipProtocolHandler = (SipProtocolHandler)connector.getProtocolHandler();
            sipProtocolHandler.setSipConnector(sipConnector);
            connector.setService((Service)this);
            connector.setContainer(this.container);
            connector.init();
            this.addConnector(connector);
            ExtendedListeningPoint extendedListeningPoint = (ExtendedListeningPoint)sipProtocolHandler.getAttribute(ExtendedListeningPoint.class.getSimpleName());
            if (extendedListeningPoint != null) {
                try {
                    extendedListeningPoint.getSipProvider().addSipListener((SipListener)this.sipApplicationDispatcher);
                    this.sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(extendedListeningPoint);
                }
                catch (TooManyListenersException e) {
                    logger.error((Object)"Connector.initialize", (Throwable)e);
                    this.removeConnector(connector);
                    return false;
                }
            }
            if (!sipProtocolHandler.isStarted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sip Connector couldn't be started, removing it automatically");
                }
                this.removeConnector(connector);
            }
            return sipProtocolHandler.isStarted();
        }
        return false;
    }

    public boolean removeSipConnector(String ipAddress, int port, String transport) throws Exception {
        Connector connectorToRemove = this.findSipConnector(ipAddress, port, transport);
        if (connectorToRemove != null) {
            this.removeConnector(connectorToRemove);
            return true;
        }
        return false;
    }

    private Connector findSipConnector(String ipAddress, int port, String transport) {
        Connector connectorToRemove = null;
        for (Connector connector : this.connectors) {
            SipProtocolHandler sipProtocolHandler;
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler) || !(sipProtocolHandler = (SipProtocolHandler)protocolHandler).getIpAddress().equals(ipAddress) || sipProtocolHandler.getPort() != port || !sipProtocolHandler.getSignalingTransport().equals(transport)) continue;
            connectorToRemove = connector;
            break;
        }
        return connectorToRemove;
    }

    public SipConnector findSipConnector(String transport) {
        ArrayList sipConnectors = new ArrayList();
        for (Connector connector : this.connectors) {
            SipConnector sc;
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler) || !(sc = ((SipProtocolHandler)protocolHandler).getSipConnector()).getTransport().equalsIgnoreCase(transport)) continue;
            return sc;
        }
        return null;
    }

    public SipConnector[] findSipConnectors() {
        ArrayList<SipConnector> sipConnectors = new ArrayList<SipConnector>();
        for (Connector connector : this.connectors) {
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            if (!(protocolHandler instanceof SipProtocolHandler)) continue;
            sipConnectors.add(((SipProtocolHandler)protocolHandler).getSipConnector());
        }
        return sipConnectors.toArray(new SipConnector[sipConnectors.size()]);
    }

    public void initializeSystemPortProperties() {
        for (Connector connector : this.connectors) {
            if (!connector.getProtocol().contains("HTTP")) continue;
            if (connector.getSecure()) {
                System.setProperty("org.mobicents.properties.sslPort", Integer.toString(connector.getPort()));
                continue;
            }
            System.setProperty("org.mobicents.properties.httpPort", Integer.toString(connector.getPort()));
        }
    }

    protected ObjectName createSipConnectorObjectName(Connector connector, String domain, String type) throws MalformedObjectNameException {
        String encodedAddr = null;
        if (connector.getProperty("address") != null) {
            encodedAddr = URLEncoder.encode(connector.getProperty("address").toString());
        }
        String addSuffix = connector.getProperty("address") == null ? "" : ",address=" + encodedAddr;
        ObjectName _oname = new ObjectName(domain + ":type=" + type + ",port=" + connector.getPort() + ",transport=" + connector.getProperty("transport") + addSuffix);
        return _oname;
    }

    public void setT2Interval(int t2Interval) {
        this.t2Interval = t2Interval;
    }

    public int getT2Interval() {
        return this.t2Interval;
    }

    public void setT4Interval(int t4Interval) {
        this.t4Interval = t4Interval;
    }

    public int getT4Interval() {
        return this.t4Interval;
    }

    public void setTimerDInterval(int timerDInterval) {
        this.timerDInterval = timerDInterval;
    }

    public int getTimerDInterval() {
        return this.timerDInterval;
    }
}

