/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.message.MessageFactoryExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sip.ListeningPoint;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.header.ServerHeader;
import javax.sip.header.UserAgentHeader;
import net.java.stun4j.StunAddress;
import net.java.stun4j.client.NetworkConfigurationDiscoveryProcess;
import net.java.stun4j.client.StunDiscoveryReport;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceImpl;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.core.DNSAddressResolver;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SipProtocolHandler
implements ProtocolHandler,
MBeanRegistration {
    private static final String PASS_INVITE_NON_2XX_ACK_TO_LISTENER = "gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER";
    private static final String TCP_POST_PARSING_THREAD_POOL_SIZE = "gov.nist.javax.sip.TCP_POST_PARSING_THREAD_POOL_SIZE";
    private static final String AUTOMATIC_DIALOG_SUPPORT_STACK_PROP = "javax.sip.AUTOMATIC_DIALOG_SUPPORT";
    private static final String LOOSE_DIALOG_VALIDATION = "gov.nist.javax.sip.LOOSE_DIALOG_VALIDATION";
    private static final String SERVER_LOG_STACK_PROP = "gov.nist.javax.sip.SERVER_LOG";
    private static final String DEBUG_LOG_STACK_PROP = "gov.nist.javax.sip.DEBUG_LOG";
    public static final String IS_SIP_CONNECTOR = "isSipConnector";
    private static final String SERVER_HEADER = "org.mobicents.servlet.sip.SERVER_HEADER";
    private static final String USER_AGENT_HEADER = "org.mobicents.servlet.sip.USER_AGENT_HEADER";
    private static final String BALANCERS = "balancers";
    private static final String JVM_ROUTE = "jvmRoute";
    private static final Logger logger = Logger.getLogger((String)SipProtocolHandler.class.getName());
    protected ObjectName tpOname = null;
    protected ObjectName rgOname = null;
    private static Random portNumberGenerator = new Random();
    private Adapter adapter = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private SipStack sipStack;
    public ExtendedListeningPoint extendedListeningPoint;
    private Properties sipStackProperties;
    private boolean started = false;
    private SipConnector sipConnector;
    private String addressResolverClass = DNSAddressResolver.class.getName();
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public SipProtocolHandler() {
        this.sipConnector = new SipConnector();
    }

    public SipProtocolHandler(SipConnector connector) {
        this.sipConnector = connector;
    }

    public void destroy() throws Exception {
        SipApplicationDispatcher sipApplicationDispatcher;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Stopping a sip protocol handler");
        }
        if ((sipApplicationDispatcher = (SipApplicationDispatcher)this.getAttribute(SipApplicationDispatcher.class.getSimpleName())) != null && this.extendedListeningPoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing the Sip Application Dispatcher as a sip listener for listening point " + this.extendedListeningPoint));
            }
            this.extendedListeningPoint.getSipProvider().removeSipListener((SipListener)sipApplicationDispatcher);
            sipApplicationDispatcher.getSipNetworkInterfaceManager().removeExtendedListeningPoint(this.extendedListeningPoint);
        }
        if (this.sipStack != null) {
            if (this.extendedListeningPoint != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing the following Listening Point " + this.extendedListeningPoint));
                }
                this.sipStack.deleteSipProvider(this.extendedListeningPoint.getSipProvider());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Removing the sip provider");
                }
                this.sipStack.deleteListeningPoint(this.extendedListeningPoint.getListeningPoint());
                this.extendedListeningPoint = null;
            }
            if (!this.sipStack.getListeningPoints().hasNext() && !this.sipStack.getSipProviders().hasNext()) {
                this.sipStack.stop();
                this.sipStack = null;
                logger.info((Object)"Sip stack stopped");
            }
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
        this.setStarted(false);
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void init() throws Exception {
        this.setAttribute(IS_SIP_CONNECTOR, Boolean.TRUE);
    }

    public void pause() throws Exception {
    }

    public void resume() throws Exception {
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public void setAttribute(String arg0, Object arg1) {
        this.attributes.put(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        String userAgent;
        String serverHeaderValue;
        String sipStackPropertiesFileLocation;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting a sip protocol handler");
        }
        StaticServiceHolder.sipStandardService.initializeSystemPortProperties();
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome == null) {
            catalinaHome = System.getProperty("catalina.base");
        }
        if (catalinaHome == null) {
            catalinaHome = ".";
        }
        if ((sipStackPropertiesFileLocation = this.sipConnector.getSipStackPropertiesFileLocation()) != null && !sipStackPropertiesFileLocation.startsWith("file:///")) {
            sipStackPropertiesFileLocation = "file:///" + catalinaHome.replace(File.separatorChar, '/') + "/" + sipStackPropertiesFileLocation;
        }
        boolean isPropsLoaded = false;
        if (this.sipStackProperties == null) {
            this.sipStackProperties = new Properties();
        } else {
            isPropsLoaded = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading SIP stack properties from following file : " + sipStackPropertiesFileLocation));
        }
        if (sipStackPropertiesFileLocation != null) {
            String serverLog;
            File sipStackPropertiesFile = null;
            URL url = null;
            try {
                url = new URL(sipStackPropertiesFileLocation);
            }
            catch (MalformedURLException e) {
                logger.fatal((Object)"Cannot find the sip stack properties file ! ", (Throwable)e);
                throw new IllegalArgumentException("The Default Application Router file Location : " + sipStackPropertiesFileLocation + " is not valid ! ", e);
            }
            try {
                sipStackPropertiesFile = new File(new URI(sipStackPropertiesFileLocation));
            }
            catch (URISyntaxException e) {
                sipStackPropertiesFile = new File(url.getPath());
            }
            FileInputStream sipStackPropertiesInputStream = null;
            try {
                sipStackPropertiesInputStream = new FileInputStream(sipStackPropertiesFile);
                this.sipStackProperties.load(sipStackPropertiesInputStream);
            }
            catch (Exception e) {
                logger.warn((Object)("Could not find or problem when loading the sip stack properties file : " + sipStackPropertiesFileLocation), (Throwable)e);
            }
            finally {
                if (sipStackPropertiesInputStream != null) {
                    try {
                        sipStackPropertiesInputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("fail to close the following file " + sipStackPropertiesFile.getAbsolutePath()), (Throwable)e);
                    }
                }
            }
            String debugLog = this.sipStackProperties.getProperty(DEBUG_LOG_STACK_PROP);
            if (debugLog != null && debugLog.length() > 0 && !debugLog.startsWith("file:///")) {
                this.sipStackProperties.setProperty(DEBUG_LOG_STACK_PROP, catalinaHome + "/" + debugLog);
            }
            if ((serverLog = this.sipStackProperties.getProperty(SERVER_LOG_STACK_PROP)) != null && serverLog.length() > 0 && !serverLog.startsWith("file:///")) {
                this.sipStackProperties.setProperty(SERVER_LOG_STACK_PROP, catalinaHome + "/" + serverLog);
            }
            this.sipStackProperties.setProperty(AUTOMATIC_DIALOG_SUPPORT_STACK_PROP, "off");
            this.sipStackProperties.setProperty(LOOSE_DIALOG_VALIDATION, "true");
            this.sipStackProperties.setProperty(PASS_INVITE_NON_2XX_ACK_TO_LISTENER, "true");
            isPropsLoaded = true;
        } else {
            logger.warn((Object)"no sip stack properties file defined ");
        }
        String ipAddress = this.sipConnector.getIpAddress();
        int port = this.sipConnector.getPort();
        String signalingTransport = this.sipConnector.getTransport();
        if (!isPropsLoaded) {
            logger.warn((Object)"loading default Mobicents Sip Servlets sip stack properties");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT", "true");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
            this.sipStackProperties.setProperty(DEBUG_LOG_STACK_PROP, catalinaHome + "/" + "mss-jsip-" + ipAddress + "-" + port + "-debug.txt");
            this.sipStackProperties.setProperty(SERVER_LOG_STACK_PROP, catalinaHome + "/" + "mss-jsip-" + ipAddress + "-" + port + "-messages.xml");
            this.sipStackProperties.setProperty("javax.sip.STACK_NAME", "mss-" + ipAddress + "-" + port);
            this.sipStackProperties.setProperty(AUTOMATIC_DIALOG_SUPPORT_STACK_PROP, "off");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "true");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "64");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
            this.sipStackProperties.setProperty("gov.nist.javax.sip.MAX_FORK_TIME_SECONDS", "1");
            this.sipStackProperties.setProperty(LOOSE_DIALOG_VALIDATION, "true");
            this.sipStackProperties.setProperty(PASS_INVITE_NON_2XX_ACK_TO_LISTENER, "true");
        }
        if (this.sipStackProperties.get(TCP_POST_PARSING_THREAD_POOL_SIZE) == null) {
            this.sipStackProperties.setProperty(TCP_POST_PARSING_THREAD_POOL_SIZE, "30");
        }
        if ((serverHeaderValue = this.sipStackProperties.getProperty(SERVER_HEADER)) != null) {
            ArrayList<String> serverHeaderList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(serverHeaderValue, ",");
            while (stringTokenizer.hasMoreTokens()) {
                serverHeaderList.add(stringTokenizer.nextToken());
            }
            ServerHeader serverHeader = SipFactories.headerFactory.createServerHeader(serverHeaderList);
            ((MessageFactoryExt)SipFactories.messageFactory).setDefaultServerHeader(serverHeader);
        }
        if ((userAgent = this.sipStackProperties.getProperty(USER_AGENT_HEADER)) != null) {
            ArrayList<String> userAgentList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(userAgent, ",");
            while (stringTokenizer.hasMoreTokens()) {
                userAgentList.add(stringTokenizer.nextToken());
            }
            UserAgentHeader userAgentHeader = SipFactories.headerFactory.createUserAgentHeader(userAgentList);
            ((MessageFactoryExt)SipFactories.messageFactory).setDefaultUserAgentHeader(userAgentHeader);
        }
        try {
            String balancers;
            String globalIpAddress = null;
            int globalPort = -1;
            boolean useStun = this.sipConnector.isUseStun();
            if (useStun) {
                if (InetAddress.getByName(ipAddress).isLoopbackAddress()) {
                    logger.warn((Object)"The Ip address provided is the loopback address, stun won't be enabled for it");
                } else {
                    DatagramSocket randomSocket = this.initRandomPortSocket();
                    int randomPort = randomSocket.getLocalPort();
                    randomSocket.disconnect();
                    randomSocket.close();
                    randomSocket = null;
                    StunAddress localStunAddress = new StunAddress(ipAddress, randomPort);
                    StunAddress serverStunAddress = new StunAddress(this.sipConnector.getStunServerAddress(), this.sipConnector.getStunServerPort());
                    NetworkConfigurationDiscoveryProcess addressDiscovery = new NetworkConfigurationDiscoveryProcess(localStunAddress, serverStunAddress);
                    addressDiscovery.start();
                    StunDiscoveryReport report = addressDiscovery.determineAddress();
                    if (report.getPublicAddress() != null) {
                        globalIpAddress = report.getPublicAddress().getSocketAddress().getAddress().getHostAddress();
                        globalPort = report.getPublicAddress().getPort();
                    } else {
                        useStun = false;
                        logger.error((Object)"Stun discovery failed to find a valid public ip address, disabling stun !");
                    }
                    logger.info((Object)("Stun report = " + report));
                    addressDiscovery.shutDown();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Mobicents Sip Servlets sip stack properties : " + this.sipStackProperties));
            }
            if ((balancers = (String)this.getAttribute(BALANCERS)) != null) {
                if (this.sipStackProperties.get("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName") == null) {
                    this.sipStackProperties.put("org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName", LoadBalancerHeartBeatingServiceImpl.class.getCanonicalName());
                }
                if (this.sipStackProperties.get("org.mobicents.ha.javax.sip.BALANCERS") == null) {
                    this.sipStackProperties.put("org.mobicents.ha.javax.sip.BALANCERS", balancers);
                }
            }
            this.sipStackProperties.put("org.mobicents.ha.javax.sip.REPLICATION_STRATEGY", "ConfirmedDialogNoApplicationData");
            this.sipStack = SipFactories.sipFactory.createSipStack(this.sipStackProperties);
            String jvmRoute = (String)this.getAttribute(JVM_ROUTE);
            LoadBalancerHeartBeatingService loadBalancerHeartBeatingService = null;
            if (this.sipStack instanceof ClusteredSipStack) {
                loadBalancerHeartBeatingService = ((ClusteredSipStack)this.sipStack).getLoadBalancerHeartBeatingService();
                if (jvmRoute != null) {
                    loadBalancerHeartBeatingService.setJvmRoute(jvmRoute);
                }
            }
            ListeningPoint listeningPoint = this.sipStack.createListeningPoint(ipAddress, port, signalingTransport);
            if (useStun) {
                listeningPoint.setSentBy(globalIpAddress + ":" + port);
            }
            SipProvider sipProvider = this.sipStack.createSipProvider(listeningPoint);
            SipApplicationDispatcher sipApplicationDispatcher = (SipApplicationDispatcher)this.getAttribute(SipApplicationDispatcher.class.getSimpleName());
            if (sipApplicationDispatcher != null && loadBalancerHeartBeatingService != null && sipApplicationDispatcher instanceof LoadBalancerHeartBeatingListener) {
                loadBalancerHeartBeatingService.addLoadBalancerHeartBeatingListener((LoadBalancerHeartBeatingListener)sipApplicationDispatcher);
            }
            this.sipStack.start();
            this.extendedListeningPoint = new ExtendedListeningPoint(sipProvider, listeningPoint, this.sipConnector);
            this.extendedListeningPoint.setUseStaticAddress(false);
            this.extendedListeningPoint.setGlobalIpAddress(globalIpAddress);
            this.extendedListeningPoint.setGlobalPort(globalPort);
            this.setAttribute(SipStack.class.getSimpleName(), this.sipStack);
            this.setAttribute(ExtendedListeningPoint.class.getSimpleName(), this.extendedListeningPoint);
            if (sipApplicationDispatcher != null) {
                if (this.sipConnector.getStaticServerAddress() != null) {
                    sipApplicationDispatcher.addHostName(this.sipConnector.getStaticServerAddress() + ":" + this.sipConnector.getStaticServerPort());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding hostname for IP load balancer " + this.sipConnector.getStaticServerAddress()));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding the Sip Application Dispatcher as a sip listener for connector listening on port " + port));
                }
                sipProvider.addSipListener((SipListener)sipApplicationDispatcher);
                sipApplicationDispatcher.getSipNetworkInterfaceManager().addExtendedListeningPoint(this.extendedListeningPoint);
                if (this.sipStack instanceof SipStackExt && this.addressResolverClass != null && this.addressResolverClass.trim().length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sip Stack " + this.sipStack.getStackName() + " will be using " + this.addressResolverClass + " as AddressResolver"));
                    }
                    try {
                        Class[] paramTypes = new Class[]{SipApplicationDispatcher.class};
                        Constructor<?> addressResolverConstructor = Class.forName(this.addressResolverClass).getConstructor(paramTypes);
                        Object[] conArgs = new Object[]{sipApplicationDispatcher};
                        AddressResolver addressResolver = (AddressResolver)addressResolverConstructor.newInstance(conArgs);
                        ((SipStackExt)this.sipStack).setAddressResolver(addressResolver);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Couldn't set the AddressResolver " + this.addressResolverClass), (Throwable)e);
                        throw e;
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)"no AddressResolver will be used since none has been specified.");
                }
            }
            logger.info((Object)("Sip Connector started on ip address : " + ipAddress + ",port " + port + ", transport " + signalingTransport + ", useStun " + useStun + ", stunAddress " + this.sipConnector.getStunServerAddress() + ", stunPort : " + this.sipConnector.getStaticServerPort()));
            if (this.domain != null) {
                this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.sipStack, this.rgOname, null);
            }
            this.setStarted(true);
        }
        catch (Exception ex) {
            logger.error((Object)("A problem occured while setting up SIP Connector " + ipAddress + ":" + port + "/" + signalingTransport + "-- check server.xml for tomcat. "), (Throwable)ex);
        }
        finally {
            if (!this.isStarted()) {
                this.destroy();
            }
        }
    }

    private DatagramSocket initRandomPortSocket() {
        int bindRetries = 5;
        int currentlyTriedPort = SipProtocolHandler.getRandomPortNumber(1024, 65535);
        DatagramSocket resultSocket = null;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                resultSocket = new DatagramSocket(currentlyTriedPort);
                break;
            }
            catch (SocketException exc) {
                if (exc.getMessage().indexOf("Address already in use") == -1) {
                    logger.fatal((Object)"An exception occurred while trying to createa local host discovery socket.", (Throwable)exc);
                    return null;
                }
                logger.debug((Object)("Port " + currentlyTriedPort + " seems in use."));
                currentlyTriedPort = SipProtocolHandler.getRandomPortNumber(1024, 65535);
                logger.debug((Object)("Retrying bind on port " + currentlyTriedPort));
                continue;
            }
        }
        return resultSocket;
    }

    public static int getRandomPortNumber(int min, int max) {
        return portNumberGenerator.nextInt(max - min) + min;
    }

    public String getSignalingTransport() {
        return this.sipConnector.getTransport();
    }

    public void setSignalingTransport(String transport) throws Exception {
        this.sipConnector.setTransport(transport);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public int getPort() {
        return this.sipConnector.getPort();
    }

    public void setPort(int port) throws Exception {
        this.sipConnector.setPort(port);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public void setIpAddress(String ipAddress) throws Exception {
        this.sipConnector.setIpAddress(ipAddress);
        if (this.isStarted()) {
            this.destroy();
            this.start();
        }
    }

    public String getIpAddress() {
        return this.sipConnector.getIpAddress();
    }

    public String getStunServerAddress() {
        return this.sipConnector.getStunServerAddress();
    }

    public void setStunServerAddress(String stunServerAddress) {
        this.sipConnector.setStunServerAddress(stunServerAddress);
    }

    public int getStunServerPort() {
        return this.sipConnector.getStunServerPort();
    }

    public void setStunServerPort(int stunServerPort) {
        this.sipConnector.setStunServerPort(stunServerPort);
    }

    public boolean isUseStun() {
        return this.sipConnector.isUseStun();
    }

    public void setUseStun(boolean useStun) {
        this.sipConnector.setUseStun(useStun);
    }

    public String getStaticServerAddress() {
        return this.sipConnector.getStaticServerAddress();
    }

    public void setStaticServerAddress(String staticServerAddress) {
        this.sipConnector.setStaticServerAddress(staticServerAddress);
    }

    public int getStaticServerPort() {
        return this.sipConnector.getStaticServerPort();
    }

    public void setStaticServerPort(int staticServerPort) {
        this.sipConnector.setStaticServerPort(staticServerPort);
    }

    public boolean isUseStaticAddress() {
        return this.sipConnector.isUseStaticAddress();
    }

    public void setUseStaticAddress(boolean useStaticAddress) {
        this.sipConnector.setUseStaticAddress(useStaticAddress);
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.sipConnector.getIpAddress());
        }
        catch (UnknownHostException e) {
            logger.error((Object)"unexpected exception while getting the ipaddress of the sip protocol handler", (Throwable)e);
            return null;
        }
    }

    public void setAddress(InetAddress ia) {
        this.sipConnector.setIpAddress(ia.getHostAddress());
    }

    public String getTransport() {
        return this.sipConnector.getTransport();
    }

    public void setSipStackPropertiesFile(String sipStackPropertiesFile) {
        this.sipConnector.setSipStackPropertiesFileLocation(sipStackPropertiesFile);
    }

    public Properties getSipStackProperties() {
        return this.sipStackProperties;
    }

    public void setSipStackProperties(Properties sipStackProperties) {
        this.sipStackProperties = sipStackProperties;
    }

    public String getSipStackPropertiesFile() {
        return this.sipConnector.getSipStackPropertiesFileLocation();
    }

    public void setSipConnector(SipConnector sipConnector) {
        this.sipConnector = sipConnector;
    }

    public SipConnector getSipConnector() {
        return this.sipConnector;
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "sip-" + encodedAddr + this.getPort();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void setAddressResolverClass(String dnsAddressResolverClass) {
        this.addressResolverClass = dnsAddressResolverClass;
    }

    public String getAddressResolverClass() {
        return this.addressResolverClass;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isStarted() {
        return this.started;
    }
}

