/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Context;
import org.apache.catalina.startup.HostConfig;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.annotations.SipApplicationAnnotationUtils;

public class SipHostConfig
extends HostConfig {
    private static final String WAR_EXTENSION = ".war";
    private static final String SAR_EXTENSION = ".sar";
    public static final String SIP_CONTEXT_CLASS = "org.mobicents.servlet.sip.startup.SipStandardContext";
    public static final String SIP_CONTEXT_CONFIG_CLASS = "org.mobicents.servlet.sip.startup.SipContextConfig";
    private static final Logger logger = Logger.getLogger(SipHostConfig.class);

    protected void deployApps() {
        super.deployApps();
    }

    protected String getDocBase(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected void deployApps(String name) {
        File sar;
        File dir;
        File war;
        File appBase = this.appBase();
        File configBase = this.configBase();
        String baseName = this.getConfigFile(name);
        String docBase = this.getDocBase(name);
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(name, xml, baseName + ".xml");
        }
        if ((war = new File(appBase, docBase + WAR_EXTENSION)).exists()) {
            boolean isSipServletApplication = this.isSipServletArchive(war);
            if (isSipServletApplication) {
                this.deploySAR(name, war, docBase + WAR_EXTENSION);
            } else {
                this.deployWAR(name, war, docBase + WAR_EXTENSION);
            }
        }
        if ((dir = new File(appBase, docBase)).exists()) {
            this.deployDirectory(name, dir, docBase);
        }
        if ((sar = new File(appBase, docBase + SAR_EXTENSION)).exists()) {
            this.deploySAR(name, sar, docBase + SAR_EXTENSION);
        }
    }

    private void deploySAR(String contextPath, File sar, String file) {
        if (this.deploymentExists(contextPath)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WEB-INF/sip.xml found in " + sar + ". Enabling sip servlet archive deployment"));
        }
        String initialConfigClass = this.configClass;
        String initialContextClass = this.contextClass;
        this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
        this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
        this.setContextClass(SIP_CONTEXT_CLASS);
        this.deployWAR(contextPath, sar, file);
        this.host.setConfigClass(initialConfigClass);
        this.configClass = initialConfigClass;
        this.contextClass = initialContextClass;
    }

    protected void deployWAR(String contextPath, File dir, String file) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Context class used to deploy the WAR : " + this.contextClass));
            logger.trace((Object)("Context config class used to deploy the WAR : " + this.configClass));
        }
        super.deployWAR(contextPath, dir, file);
    }

    protected void deployDirectory(String contextPath, File dir, String file) {
        if (this.deploymentExists(contextPath)) {
            return;
        }
        boolean isSipServletApplication = this.isSipServletDirectory(dir);
        if (isSipServletApplication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WEB-INF/sip.xml found in " + dir + ". Enabling sip servlet archive deployment"));
            }
            String initialConfigClass = this.configClass;
            String initialContextClass = this.contextClass;
            this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setContextClass(SIP_CONTEXT_CLASS);
            super.deployDirectory(contextPath, dir, file);
            this.host.setConfigClass(initialConfigClass);
            this.configClass = initialConfigClass;
            this.contextClass = initialContextClass;
        } else {
            super.deployDirectory(contextPath, dir, file);
        }
    }

    protected void deployDescriptor(String contextPath, File contextXml, String file) {
        super.deployDescriptor(contextPath, contextXml, file);
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File dir;
            boolean isSipServletApplication;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || !(isSipServletApplication = this.isSipServletArchive(dir = new File(appBase, files[i])))) continue;
            String contextPath = "/" + files[i];
            int period = contextPath.lastIndexOf(".");
            if (period >= 0) {
                contextPath = contextPath.substring(0, period);
            }
            if (contextPath.equals("/ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            String file = files[i];
            String initialConfigClass = this.configClass;
            String initialContextClass = this.contextClass;
            this.host.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setConfigClass(SIP_CONTEXT_CONFIG_CLASS);
            this.setContextClass(SIP_CONTEXT_CLASS);
            this.deploySAR(contextPath, dir, file);
            this.host.setConfigClass(initialConfigClass);
            this.configClass = initialConfigClass;
            this.contextClass = initialContextClass;
        }
        super.deployWARs(appBase, files);
    }

    private boolean isSipServletArchive(File file) {
        if (file.getName().toLowerCase().endsWith(SAR_EXTENSION)) {
            return true;
        }
        if (file.getName().toLowerCase().endsWith(WAR_EXTENSION)) {
            block5: {
                try {
                    JarFile jar = new JarFile(file);
                    JarEntry entry = jar.getJarEntry("WEB-INF/sip.xml");
                    if (entry != null) {
                        return true;
                    }
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block5;
                    logger.info((Object)("couldn't find WEB-INF/sip.xml in " + file + " checking for package-info.class"));
                }
            }
            return SipApplicationAnnotationUtils.findPackageInfoInArchive(file);
        }
        return false;
    }

    private boolean isSipServletDirectory(File dir) {
        if (dir.isDirectory()) {
            File sipXmlFile = new File(dir.getAbsoluteFile(), "WEB-INF/sip.xml");
            if (sipXmlFile.exists()) {
                return true;
            }
            if (SipApplicationAnnotationUtils.findPackageInfoinDirectory(dir)) {
                return true;
            }
        }
        return false;
    }

    public void manageApp(Context arg0) {
        super.manageApp(arg0);
    }
}

