/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.WWWAuthenticateHeader;
import org.apache.catalina.Realm;
import org.apache.catalina.util.MD5Encoder;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.security.authentication.AuthenticatorBase;
import org.mobicents.servlet.sip.security.authentication.MessageDigestResponseAlgorithm;
import org.mobicents.servlet.sip.startup.loading.SipLoginConfig;

public class DigestAuthenticator
extends AuthenticatorBase {
    private static final Logger log = Logger.getLogger(DigestAuthenticator.class);
    static final MD5Encoder MD5_ECNODER = new MD5Encoder();
    protected static final String INFO = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static volatile MessageDigest md5Helper;
    protected String key = "Catalina";
    private Principal principal;

    public String getInfo() {
        return INFO;
    }

    public boolean authenticate(SipServletRequestImpl request, SipServletResponseImpl response, SipLoginConfig config) throws IOException {
        this.principal = null;
        this.principal = request.getUserPrincipal();
        if (this.principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + this.principal.getName() + "'"));
            }
            return true;
        }
        String authorization = request.getHeader("authorization");
        if (authorization != null) {
            this.principal = DigestAuthenticator.findPrincipal(request, authorization, this.context.getRealm());
            if (this.principal != null) {
                String username = this.parseUsername(authorization);
                this.register(request, response, this.principal, "DIGEST", username, null);
                return true;
            }
        }
        String nOnce = this.generateNOnce(request);
        this.setAuthenticateHeader(request, response, config, nOnce);
        response.send();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Principal findPrincipal(SipServletRequestImpl request, String authorization, Realm realm) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        String tmpAuthorization = authorization.substring(7).trim();
        String[] tokens = tmpAuthorization.split(",");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        String method = request.getMethod();
        for (int i = 0; i < tokens.length; ++i) {
            String currentToken = tokens[i];
            if (currentToken.length() == 0) continue;
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = null;
        MessageDigest equalSign = md5Helper;
        synchronized (equalSign) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        String md5a2 = MD5_ECNODER.encode(buffer);
        return realm.authenticate(userName, response, nOnce, nc, cnonce, qop, realmName, md5a2);
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        String tmpAuthorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(tmpAuthorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNOnce(SipServletRequestImpl request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + this.key;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnceValue.getBytes());
        }
        nOnceValue = MD5_ECNODER.encode(buffer);
        return nOnceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthenticateHeader(SipServletRequestImpl request, SipServletResponseImpl response, SipLoginConfig config, String nOnce) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = request.getServerName() + ":" + request.getServerPort();
        }
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnce.getBytes());
        }
        String authenticateHeader = "Digest realm=\"" + realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + MD5_ECNODER.encode(buffer) + "\"";
        if (response.getStatus() == 407) {
            response.setHeader("Proxy-Authenticate", authenticateHeader);
        } else {
            response.setHeader("WWW-Authenticate", authenticateHeader);
        }
    }

    public static AuthorizationHeader getAuthorizationHeader(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, String username, String password) {
        String response = null;
        HeaderFactory headerFactory = SipFactories.headerFactory;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        try {
            response = MessageDigestResponseAlgorithm.calculateResponse(authHeader.getAlgorithm(), username, authHeader.getRealm(), password, authHeader.getNonce(), nc_value, cnonce, method, uri, requestBody, qop);
        }
        catch (NullPointerException exc) {
            throw new IllegalStateException("The authenticate header was malformatted", exc);
        }
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(username);
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null && authHeader.getOpaque().length() > 0) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new SecurityException("Failed to create an authorization header!", ex);
        }
        return authorization;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    static {
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

