/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.security;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import org.apache.catalina.Realm;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.security.authentication.DigestAuthenticator;
import org.mobicents.servlet.sip.startup.SipContext;
import org.mobicents.servlet.sip.startup.loading.SipLoginConfig;
import org.mobicents.servlet.sip.startup.loading.SipSecurityCollection;
import org.mobicents.servlet.sip.startup.loading.SipSecurityConstraint;

public class SipSecurityUtils {
    private static final Logger log = Logger.getLogger(SipSecurityUtils.class);

    public static boolean authenticate(SipContext sipStandardContext, SipServletRequestImpl request, SipSecurityConstraint sipConstraint) {
        boolean authenticated;
        block12: {
            authenticated = false;
            SipLoginConfig loginConfig = sipStandardContext.getSipLoginConfig();
            try {
                if (loginConfig != null) {
                    String authMethod = loginConfig.getAuthMethod();
                    if (authMethod != null) {
                        String pAssertedIdentitySetting = loginConfig.getIdetitySchemeSettings("P-Asserted-Identity");
                        if (pAssertedIdentitySetting != null && request.getHeader("P-Asserted-Identity") != null) {
                            String pAssertedHeaderValue = request.getHeader("P-Asserted-Identity");
                            if (pAssertedHeaderValue == null && "REQUIRED".equals(pAssertedIdentitySetting)) {
                                request.createResponse(428, "P-Asserted-Idetity header is required!").send();
                                return false;
                            }
                            Address address = SipFactories.addressFactory.createAddress(pAssertedHeaderValue);
                            String username = null;
                            if (address.getURI().isSipURI()) {
                                SipURI sipUri = (SipURI)address.getURI();
                                username = sipUri.getUser();
                            } else {
                                TelURL telUri = (TelURL)address.getURI();
                                username = telUri.getPhoneNumber();
                            }
                            Realm realm = sipStandardContext.getRealm();
                            Principal principal = SipSecurityUtils.impersonatePrincipal(username, realm);
                            if (principal != null) {
                                authenticated = true;
                                request.setUserPrincipal(principal);
                                request.getSipSession().setUserPrincipal(principal);
                                log.debug((Object)("P-Asserted-Identity authetication successful for user: " + username));
                            }
                        }
                        if (!authenticated && authMethod.equalsIgnoreCase("DIGEST")) {
                            DigestAuthenticator digestAuthenticator = new DigestAuthenticator();
                            digestAuthenticator.setContext(sipStandardContext);
                            SipServletResponseImpl response = SipSecurityUtils.createErrorResponse(request, sipConstraint);
                            authenticated = digestAuthenticator.authenticate(request, response, loginConfig);
                            request.setUserPrincipal(digestAuthenticator.getPrincipal());
                        } else if (authMethod.equalsIgnoreCase("BASIC")) {
                            throw new IllegalStateException("Basic authentication not supported in JSR 289");
                        }
                    }
                    break block12;
                }
                log.debug((Object)"No login configuration found in sip.xml. We won't authenticate.");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return authenticated;
    }

    private static SipServletResponseImpl createErrorResponse(SipServletRequestImpl request, SipSecurityConstraint sipConstraint) {
        SipServletResponseImpl response = null;
        response = sipConstraint.isProxyAuthentication() ? (SipServletResponseImpl)request.createResponse(407) : (SipServletResponseImpl)request.createResponse(401);
        return response;
    }

    public static boolean authorize(SipContext sipStandardContext, SipServletRequestImpl request) {
        boolean allConstrainsSatisfied = true;
        SecurityConstraint[] constraints = sipStandardContext.findConstraints();
        if (constraints.length == 0) {
            return true;
        }
        for (SecurityConstraint constraint : constraints) {
            if (!(constraint instanceof SipSecurityConstraint)) continue;
            SipSecurityConstraint sipConstraint = (SipSecurityConstraint)constraint;
            for (SecurityCollection security : sipConstraint.findCollections()) {
                SipSecurityCollection sipSecurity = (SipSecurityCollection)security;
                String servletName = request.getSipSession().getHandler();
                if (!sipSecurity.findMethod(request.getMethod()) || !sipSecurity.findServletName(servletName)) continue;
                boolean constraintSatisfied = false;
                if (SipSecurityUtils.authenticate(sipStandardContext, request, sipConstraint)) {
                    GenericPrincipal principal = (GenericPrincipal)request.getUserPrincipal();
                    if (principal == null) {
                        return false;
                    }
                    for (String assignedRole : constraint.findAuthRoles()) {
                        if (!principal.hasRole(assignedRole)) continue;
                        constraintSatisfied = true;
                        break;
                    }
                }
                if (constraintSatisfied) continue;
                allConstrainsSatisfied = false;
                log.error((Object)("Constraint \"" + constraint.getDisplayName() + "\" not satifsied"));
            }
        }
        return allConstrainsSatisfied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal impersonatePrincipal(String username, Realm realm) {
        Method getPrincipalMethod = null;
        Class<?> clazz = realm.getClass();
        try {
            Principal principal;
            if (!(realm instanceof RealmBase)) {
                throw new RuntimeException("Only Realms extending RealmBase are supported. Report this error. Current realm class is " + realm.getClass().getCanonicalName());
            }
            while (getPrincipalMethod == null) {
                try {
                    getPrincipalMethod = clazz.getDeclaredMethod("getPrincipal", String.class);
                }
                catch (NoSuchMethodException e) {
                    log.warn((Object)"unexpected exception while impersonatePrincipal", (Throwable)e);
                }
                if ((clazz = clazz.getSuperclass()) != null) continue;
            }
            getPrincipalMethod.setAccessible(true);
            Principal principal2 = principal = (Principal)getPrincipalMethod.invoke((Object)realm, username);
            return principal2;
        }
        catch (Throwable t) {
            log.error((Object)("Could not impersonate user " + username), t);
        }
        finally {
            if (getPrincipalMethod != null) {
                getPrincipalMethod.setAccessible(false);
            }
        }
        return null;
    }
}

