/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.header.HeaderFactoryExt;
import gov.nist.javax.sip.header.ims.PathHeader;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.Iterator;
import java.util.ListIterator;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;

public class ProxyUtils {
    private static final Logger logger = Logger.getLogger(ProxyUtils.class);
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Request createProxiedRequest(SipServletRequestImpl originalRequest, ProxyBranchImpl proxyBranch, javax.servlet.sip.URI destination, javax.servlet.sip.SipURI outboundInterface, javax.servlet.sip.SipURI routeRecord, javax.servlet.sip.SipURI path) {
        try {
            String paramName;
            Iterator paramNames;
            String branchId;
            Request clonedRequest = (Request)originalRequest.getMessage().clone();
            String method = clonedRequest.getMethod();
            ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
            SipFactoryImpl sipFactoryImpl = proxy.getSipFactoryImpl();
            ((SIPMessage)clonedRequest).setApplicationData(null);
            if (destination != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("request URI on the request to proxy : " + destination));
                }
                clonedRequest.setRequestURI(((URIImpl)destination).getURI());
            } else if (method.equals("CANCEL")) {
                clonedRequest.removeHeader("Via");
                clonedRequest.removeHeader("Record-Route");
            }
            MaxForwardsHeader mf = (MaxForwardsHeader)clonedRequest.getHeader("Max-Forwards");
            if (mf == null) {
                mf = SipFactories.headerFactory.createMaxForwardsHeader(70);
                clonedRequest.addHeader((Header)mf);
            } else {
                mf.setMaxForwards(mf.getMaxForwards() - 1);
            }
            if (method.equals("CANCEL")) {
                clonedRequest.removeHeader("Via");
            }
            SipApplicationSessionKey sipAppKey = originalRequest.getSipSession().getSipApplicationSession().getKey();
            String appName = sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(sipAppKey.getApplicationName());
            SipServletRequestImpl proxyBranchRequest = (SipServletRequestImpl)proxyBranch.getRequest();
            ViaHeader viaHeader = proxyBranch.viaHeader;
            if (viaHeader == null) {
                if (proxy.getOutboundInterface() == null) {
                    branchId = null;
                    if ("ACK".equals(method) && proxyBranchRequest != null && proxyBranchRequest.getTransaction() != null) {
                        branchId = proxyBranchRequest.getTransaction().getBranchId();
                        logger.debug((Object)("reusing original branch id " + branchId));
                    }
                    viaHeader = JainSipUtils.createViaHeader(sipFactoryImpl.getSipNetworkInterfaceManager(), clonedRequest, branchId, null);
                } else {
                    String outboundTransport = proxy.getOutboundInterface().getTransportParam();
                    if (outboundTransport == null) {
                        outboundTransport = proxy.getOutboundInterface().isSecure() ? "TCP" : "UDP";
                    }
                    String branchId2 = null;
                    if ("ACK".equals(method) && proxyBranchRequest != null && proxyBranchRequest.getTransaction() != null) {
                        branchId2 = proxyBranchRequest.getTransaction().getBranchId();
                        logger.debug((Object)("reusing original branch id " + branchId2));
                    }
                    viaHeader = SipFactories.headerFactory.createViaHeader(proxy.getOutboundInterface().getHost(), proxy.getOutboundInterface().getPort(), outboundTransport, branchId2);
                }
                proxyBranch.viaHeader = viaHeader;
            } else {
                branchId = null;
                viaHeader = (ViaHeader)viaHeader.clone();
                if ("ACK".equals(method) && proxyBranchRequest != null && proxyBranchRequest.getTransaction() != null) {
                    branchId = proxyBranchRequest.getTransaction().getBranchId();
                    logger.debug((Object)("reusing original branch id " + branchId));
                } else {
                    branchId = JainSipUtils.createBranch(sipAppKey.getId(), appName);
                }
                viaHeader.setBranch(branchId);
            }
            clonedRequest.addHeader((Header)viaHeader);
            if (routeRecord != null && !"REGISTER".equalsIgnoreCase(method)) {
                SipURI rrURI = null;
                rrURI = proxy.getOutboundInterface() == null ? JainSipUtils.createRecordRouteURI(sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)clonedRequest) : ((SipURIImpl)proxy.getOutboundInterface()).getSipURI();
                if (originalRequest.getTransport() != null) {
                    rrURI.setTransportParam(originalRequest.getTransport());
                }
                paramNames = routeRecord.getParameterNames();
                while (paramNames.hasNext()) {
                    paramName = (String)paramNames.next();
                    rrURI.setParameter(paramName, routeRecord.getParameter(paramName));
                }
                rrURI.setParameter("appname", appName);
                rrURI.setParameter("proxy", "true");
                rrURI.setParameter("app_id", sipAppKey.getId());
                rrURI.setLrParam();
                Address rraddress = SipFactories.addressFactory.createAddress(null, (URI)rrURI);
                RecordRouteHeader recordRouteHeader = SipFactories.headerFactory.createRecordRouteHeader(rraddress);
                clonedRequest.addFirst((Header)recordRouteHeader);
            }
            if (path != null && "REGISTER".equalsIgnoreCase(method)) {
                SipURI pathURI = JainSipUtils.createRecordRouteURI(sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)clonedRequest);
                paramNames = path.getParameterNames();
                while (paramNames.hasNext()) {
                    paramName = (String)paramNames.next();
                    pathURI.setParameter(paramName, path.getParameter(paramName));
                }
                Address pathAddress = SipFactories.addressFactory.createAddress(null, (URI)pathURI);
                PathHeader pathHeader = ((HeaderFactoryExt)SipFactories.headerFactory).createPathHeader(pathAddress);
                clonedRequest.addFirst((Header)pathHeader);
            }
            return clonedRequest;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while creating the proxied request for message " + originalRequest.getMessage(), e);
        }
    }

    public static SipServletResponseImpl createProxiedResponse(SipServletResponseImpl sipServetResponse, ProxyBranchImpl proxyBranch) {
        Response response = (Response)sipServetResponse.getMessage();
        Response clonedResponse = (Response)response.clone();
        ((MessageExt)clonedResponse).setApplicationData(null);
        Transaction transaction = sipServetResponse.getTransaction();
        int status = response.getStatusCode();
        if (transaction != null && ((SIPTransaction)transaction).getMethod().equals("INVITE")) {
            if (100 == status) {
                proxyBranch.cancel1xxTimer();
            }
            if (100 < status && status < 200) {
                proxyBranch.updateTimer(true);
            } else if (status >= 200) {
                proxyBranch.cancel1xxTimer();
                proxyBranch.cancelTimer();
            }
        }
        ListIterator viaHeaderIt = clonedResponse.getHeaders("Via");
        viaHeaderIt.next();
        viaHeaderIt.remove();
        if (!viaHeaderIt.hasNext()) {
            return null;
        }
        ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
        SipFactoryImpl sipFactoryImpl = proxy.getSipFactoryImpl();
        SipServletRequestImpl originalRequest = (SipServletRequestImpl)proxy.getOriginalRequest();
        if ("PRACK".equals(sipServetResponse.getMethod())) {
            originalRequest = proxyBranch.getPrackOriginalRequest();
        }
        SipServletResponseImpl newServletResponseImpl = null;
        newServletResponseImpl = transaction != null && originalRequest != null ? new SipServletResponseImpl(clonedResponse, sipFactoryImpl, originalRequest.getTransaction(), originalRequest.getSipSession(), sipServetResponse.getDialog(), false) : new SipServletResponseImpl(clonedResponse, sipFactoryImpl, null, sipServetResponse.getSipSession(), sipServetResponse.getDialog(), false);
        newServletResponseImpl.setOriginalRequest(originalRequest);
        newServletResponseImpl.setProxiedResponse(true);
        return newServletResponseImpl;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }
}

