/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.header.Via;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.TelURL;
import javax.sip.header.ContactHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.ProxyExt;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyImpl
implements Proxy,
ProxyExt,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProxyImpl.class);
    private SipServletRequestImpl originalRequest;
    private transient SipServletResponseImpl bestResponse;
    private transient ProxyBranchImpl bestBranch;
    private boolean recurse = true;
    private int proxyTimeout;
    private int proxy1xxTimeout;
    private int seqSearchTimeout;
    private boolean supervised = true;
    private boolean recordRoutingEnabled;
    private boolean parallel = true;
    private boolean addToPath;
    protected transient SipURI pathURI;
    protected transient SipURI recordRouteURI;
    private transient SipURI outboundInterface;
    private transient SipFactoryImpl sipFactoryImpl;
    private boolean isNoCancel;
    transient HashMap<String, Object> transactionMap = new HashMap();
    private transient Map<URI, ProxyBranchImpl> proxyBranches;
    private boolean started;
    private boolean ackReceived = false;
    private boolean tryingSent = false;
    private ProxyBranchImpl finalBranchForSubsequentRequests;
    private SipURI previousNode;
    private String callerFromHeader;

    public ProxyImpl() {
    }

    public ProxyImpl(SipServletRequestImpl request, SipFactoryImpl sipFactoryImpl) {
        this.originalRequest = request;
        this.sipFactoryImpl = sipFactoryImpl;
        this.proxyBranches = new LinkedHashMap<URI, ProxyBranchImpl>();
        this.proxyTimeout = 180;
        this.proxy1xxTimeout = -1;
        String outboundInterfaceStringified = ((MobicentsSipSession)request.getSession()).getOutboundInterface();
        if (outboundInterfaceStringified != null) {
            try {
                this.outboundInterface = (SipURI)sipFactoryImpl.createURI(outboundInterfaceStringified);
            }
            catch (ServletParseException e) {
                throw new IllegalArgumentException("couldn't parse the outbound interface " + this.outboundInterface, e);
            }
        }
        this.callerFromHeader = request.getFrom().toString();
        this.previousNode = this.extractPreviousNodeFromRequest(request);
        String txid = ((ViaHeader)request.getMessage().getHeader("Via")).getBranch();
        if (this.originalRequest.getTransactionApplicationData() != null) {
            this.transactionMap.put(txid, this.originalRequest.getTransactionApplicationData());
        }
    }

    private SipURI extractPreviousNodeFromRequest(SipServletRequestImpl request) {
        SipURIImpl uri = null;
        try {
            RecordRouteHeader rrh = (RecordRouteHeader)request.getMessage().getHeader("Record-Route");
            if (rrh != null) {
                javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)rrh.getAddress().getURI();
                uri = new SipURIImpl(sipUri);
            } else {
                ListIterator viaHeaders = request.getMessage().getHeaders("Via");
                ViaHeader lastVia = null;
                while (viaHeaders.hasNext()) {
                    lastVia = (ViaHeader)viaHeaders.next();
                }
                String uriString = ((Via)lastVia).getSentBy().toString();
                uri = this.sipFactoryImpl.createSipURI(null, uriString);
                if (lastVia.getTransport() != null) {
                    uri.setTransportParam(lastVia.getTransport());
                } else {
                    uri.setTransportParam("udp");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed parsing previous address ", (Throwable)e);
        }
        return uri;
    }

    public void cancel() {
        this.cancelAllExcept(null, null, null, null, true);
    }

    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        this.cancelAllExcept(null, protocol, reasonCode, reasonText, true);
    }

    public void cancelAllExcept(ProxyBranch except, String[] protocol, int[] reasonCode, String[] reasonText, boolean throwExceptionIfCannotCancel) {
        if (this.ackReceived) {
            throw new IllegalStateException("There has been an ACK received on this branch. Can not cancel.");
        }
        for (ProxyBranchImpl proxyBranch : this.proxyBranches.values()) {
            if (proxyBranch.equals(except)) continue;
            try {
                proxyBranch.cancel(protocol, reasonCode, reasonText);
            }
            catch (IllegalStateException e) {
                if (!throwExceptionIfCannotCancel) continue;
                throw e;
            }
        }
    }

    public List<ProxyBranch> createProxyBranches(List<? extends URI> targets) {
        ArrayList<ProxyBranch> list = new ArrayList<ProxyBranch>();
        for (URI uRI : targets) {
            if (uRI == null) {
                throw new NullPointerException("URI can't be null");
            }
            if (!JainSipUtils.checkScheme(uRI.toString())) {
                throw new IllegalArgumentException("Scheme " + uRI.getScheme() + " is not supported");
            }
            ProxyBranchImpl branch = new ProxyBranchImpl(uRI, this);
            branch.setRecordRoute(this.recordRoutingEnabled);
            branch.setRecurse(this.recurse);
            list.add(branch);
            this.proxyBranches.put(uRI, branch);
        }
        return list;
    }

    public boolean getAddToPath() {
        return this.addToPath;
    }

    public SipServletRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public boolean getParallel() {
        return this.parallel;
    }

    public SipURI getPathURI() {
        if (!this.addToPath) {
            throw new IllegalStateException("You must setAddToPath(true) before getting URI");
        }
        return this.pathURI;
    }

    public ProxyBranch getProxyBranch(URI uri) {
        return this.proxyBranches.get(uri);
    }

    public List<ProxyBranch> getProxyBranches() {
        return new ArrayList<ProxyBranch>(this.proxyBranches.values());
    }

    public Map<URI, ProxyBranchImpl> getProxyBranchesMap() {
        return this.proxyBranches;
    }

    public ProxyBranchImpl getFinalBranchForSubsequentRequests() {
        return this.finalBranchForSubsequentRequests;
    }

    public int getProxyTimeout() {
        return this.proxyTimeout;
    }

    public boolean getRecordRoute() {
        return this.recordRoutingEnabled;
    }

    public SipURI getRecordRouteURI() {
        if (!this.recordRoutingEnabled) {
            throw new IllegalStateException("You must setRecordRoute(true) before getting URI");
        }
        return this.recordRouteURI;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public int getSequentialSearchTimeout() {
        return this.seqSearchTimeout;
    }

    public boolean getStateful() {
        return true;
    }

    public boolean getSupervised() {
        return this.supervised;
    }

    public void proxyTo(List<? extends URI> uris) {
        for (URI uRI : uris) {
            if (uRI == null) {
                throw new NullPointerException("URI can't be null");
            }
            if (!JainSipUtils.checkScheme(uRI.toString())) {
                throw new IllegalArgumentException("Scheme " + uRI.getScheme() + " is not supported");
            }
            ProxyBranchImpl branch = new ProxyBranchImpl((URI)((SipURI)uRI), this);
            branch.setRecordRoute(this.recordRoutingEnabled);
            branch.setRecurse(this.recurse);
            this.proxyBranches.put(uRI, branch);
        }
        this.startProxy();
    }

    public void proxyTo(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI can't be null");
        }
        if (!JainSipUtils.checkScheme(uri.toString())) {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " is not supported");
        }
        ProxyBranchImpl branch = new ProxyBranchImpl(uri, this);
        branch.setRecordRoute(this.recordRoutingEnabled);
        branch.setRecurse(this.recurse);
        this.proxyBranches.put(uri, branch);
        this.startProxy();
    }

    public void setAddToPath(boolean p) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a record route on an already started proxy");
        }
        if (this.pathURI == null) {
            this.pathURI = new SipURIImpl(JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), null));
        }
        this.addToPath = p;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setProxyTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Negative or zero timeout not allowed");
        }
        this.proxyTimeout = seconds;
        for (ProxyBranchImpl proxyBranch : this.proxyBranches.values()) {
            boolean inactive = proxyBranch.isCanceled() || proxyBranch.isTimedOut();
            if (inactive) continue;
            proxyBranch.setProxyBranchTimeout(seconds);
        }
    }

    public void setRecordRoute(boolean rr) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a record route on an already started proxy");
        }
        if (rr) {
            this.recordRouteURI = new SipURIImpl(JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), null));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Record routing enabled for proxy, Record Route used will be : " + this.recordRouteURI.toString()));
            }
        }
        this.recordRoutingEnabled = rr;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setSequentialSearchTimeout(int seconds) {
        this.seqSearchTimeout = seconds;
    }

    public void setStateful(boolean stateful) {
    }

    public void setSupervised(boolean supervised) {
        this.supervised = supervised;
    }

    public void startProxy() {
        if (this.ackReceived) {
            throw new IllegalStateException("Can't start. ACK has been received.");
        }
        if (!this.originalRequest.isInitial()) {
            throw new IllegalStateException("Applications should not attepmt to proxy subsequent requests. Proxying the initial request is sufficient to carry all subsequent requests through the same path.");
        }
        if (this.originalRequest.getMethod().equals("INVITE") && !this.tryingSent) {
            this.tryingSent = true;
            logger.info((Object)"Sending 100 Trying to the source");
            SipServletResponse trying = this.originalRequest.createResponse(100);
            try {
                trying.send();
            }
            catch (IOException e) {
                logger.error((Object)"Cannot send the 100 Trying", (Throwable)e);
            }
        }
        this.started = true;
        if (this.parallel) {
            for (ProxyBranchImpl pb : this.proxyBranches.values()) {
                if (pb.isStarted()) continue;
                pb.start();
            }
        } else {
            this.startNextUntriedBranch();
        }
    }

    public SipURI getOutboundInterface() {
        return this.outboundInterface;
    }

    public void onFinalResponse(ProxyBranchImpl branch) {
        SipServletResponseImpl response = (SipServletResponseImpl)branch.getResponse();
        int status = response.getStatus();
        if (!this.isNoCancel && response.getTransaction() != null && this.getParallel() && (status >= 200 && status < 300 || status >= 600 && status < 700)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancelling all other broanches in this proxy");
            }
            this.cancelAllExcept(branch, null, null, null, false);
        }
        if (status >= 300 && status < 400 && this.recurse) {
            ListIterator headers = response.getMessage().getHeaders("Contact");
            while (headers.hasNext()) {
                ContactHeader contactHeader = (ContactHeader)headers.next();
                javax.sip.address.URI addressURI = contactHeader.getAddress().getURI();
                URIImpl contactURI = null;
                if (addressURI instanceof javax.sip.address.SipURI) {
                    contactURI = new SipURIImpl((javax.sip.address.SipURI)addressURI);
                } else if (addressURI instanceof TelURL) {
                    contactURI = new TelURLImpl((TelURL)addressURI);
                }
                ProxyBranchImpl recurseBranch = new ProxyBranchImpl(contactURI, this);
                recurseBranch.setRecordRoute(this.recordRoutingEnabled);
                recurseBranch.setRecurse(this.recurse);
                this.proxyBranches.put(contactURI, recurseBranch);
                branch.addRecursedBranch(branch);
                if (!this.parallel) continue;
                recurseBranch.start();
            }
        }
        if (this.bestResponse == null || this.bestResponse.getStatus() > status) {
            if (this.bestResponse != null) {
                if (status < 400) {
                    this.bestResponse = response;
                    this.bestBranch = branch;
                }
            } else {
                this.bestResponse = response;
                this.bestBranch = branch;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Best response so far is " + this.bestResponse));
        }
        if (this.parallel && this.allResponsesHaveArrived()) {
            this.finalBranchForSubsequentRequests = this.bestBranch;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"All responses have arrived, sending final response for parallel proxy");
            }
            this.sendFinalResponse(this.bestResponse, this.bestBranch);
        } else if (!this.parallel) {
            int bestResponseStatus = this.bestResponse.getStatus();
            if (bestResponseStatus >= 200 && bestResponseStatus < 300) {
                this.finalBranchForSubsequentRequests = this.bestBranch;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sending final response for sequential proxy");
                }
                this.sendFinalResponse(this.bestResponse, this.bestBranch);
            } else if (this.allResponsesHaveArrived()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"All responses have arrived for sequential proxy and we are sending the best one");
                }
                this.sendFinalResponse(this.bestResponse, this.bestBranch);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trying new branch in proxy");
                }
                this.startNextUntriedBranch();
                branch.onBranchTerminated();
            }
        }
    }

    public void onBranchTimeOut(ProxyBranchImpl branch) {
        if (this.bestBranch == null) {
            this.bestBranch = branch;
        }
        if (this.allResponsesHaveArrived()) {
            this.sendFinalResponse(this.bestResponse, this.bestBranch);
        } else if (!this.parallel) {
            branch.cancel();
            this.startNextUntriedBranch();
            branch.onBranchTerminated();
        }
    }

    public void startNextUntriedBranch() {
        if (this.parallel) {
            throw new IllegalStateException("This method is only for sequantial proxying");
        }
        for (ProxyBranchImpl pbi : this.proxyBranches.values()) {
            if (pbi.isStarted()) continue;
            pbi.start();
            return;
        }
    }

    public boolean allResponsesHaveArrived() {
        for (ProxyBranchImpl pbi : this.proxyBranches.values()) {
            SipServletResponse response = pbi.getResponse();
            if (!pbi.isStarted()) {
                return false;
            }
            if (!pbi.isStarted() || pbi.isTimedOut() || pbi.isCanceled() || response != null && response.getStatus() >= 200) continue;
            return false;
        }
        return true;
    }

    public void sendFinalResponse(SipServletResponseImpl response, ProxyBranchImpl proxyBranch) {
        SipServletResponseImpl proxiedResponse;
        if (proxyBranch.isTimedOut()) {
            try {
                this.originalRequest.createResponse(408).send();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Proxy branch has timed out");
                }
                return;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to send a timeout response", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Proxy branch has NOT timed out");
        }
        if ((proxiedResponse = ProxyUtils.createProxiedResponse(response, proxyBranch)).getMessage() == null) {
            return;
        }
        if (this.originalRequest != null && proxiedResponse.getRequest() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Response was dropped because getProxyUtils().createProxiedResponse(response, proxyBranch) returned null");
            }
            try {
                proxiedResponse.send();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sending out proxied final response with existing transaction");
                }
                this.proxyBranches.clear();
                this.originalRequest = null;
                this.bestBranch = null;
                this.bestResponse = null;
            }
            catch (Exception e) {
                logger.error((Object)"A problem occured while proxying the final response", (Throwable)e);
            }
        } else {
            Message message = proxiedResponse.getMessage();
            String transport = JainSipUtils.findTransport(message);
            SipProvider sipProvider = this.getSipFactoryImpl().getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending out proxied final response retransmission " + proxiedResponse));
                }
                sipProvider.sendResponse((Response)message);
            }
            catch (SipException e) {
                logger.error((Object)"A problem occured while proxying the final response retransmission", (Throwable)e);
            }
        }
    }

    public SipServletResponseImpl getBestResponse() {
        return this.bestResponse;
    }

    public void setOriginalRequest(SipServletRequestImpl originalRequest) {
        this.originalRequest = originalRequest;
    }

    public boolean getNoCancel() {
        return this.isNoCancel;
    }

    public void setNoCancel(boolean isNoCancel) {
        this.isNoCancel = isNoCancel;
    }

    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipFactoryImpl;
    }

    public void setSipFactoryImpl(SipFactoryImpl sipFactoryImpl) {
        this.sipFactoryImpl = sipFactoryImpl;
    }

    public void setOutboundInterface(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        String address = inetAddress.getHostAddress();
        List<SipURI> list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + inetAddress.getHostAddress() + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setOutboundInterface(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        String address = inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        List<SipURI> list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setOutboundInterface(SipURI outboundInterface) {
        if (outboundInterface == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        List<SipURI> list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.equals(outboundInterface)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + outboundInterface + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setAckReceived(boolean received) {
        this.ackReceived = received;
    }

    public boolean getAckReceived() {
        return this.ackReceived;
    }

    public SipURI getPreviousNode() {
        return this.previousNode;
    }

    public String getCallerFromHeader() {
        return this.callerFromHeader;
    }

    public void setCallerFromHeader(String initiatorFromHeader) {
        this.callerFromHeader = initiatorFromHeader;
    }

    public HashMap<String, Object> getTransactionMap() {
        return this.transactionMap;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originalRequest = (SipServletRequestImpl)in.readObject();
        this.recurse = in.readBoolean();
        this.proxyTimeout = in.readInt();
        this.seqSearchTimeout = in.readInt();
        this.supervised = in.readBoolean();
        this.recordRoutingEnabled = in.readBoolean();
        this.parallel = in.readBoolean();
        this.addToPath = in.readBoolean();
        this.isNoCancel = in.readBoolean();
        this.started = in.readBoolean();
        this.ackReceived = in.readBoolean();
        this.tryingSent = in.readBoolean();
        this.finalBranchForSubsequentRequests = (ProxyBranchImpl)in.readObject();
        if (this.finalBranchForSubsequentRequests != null) {
            this.finalBranchForSubsequentRequests.setProxy(this);
        }
        this.previousNode = (SipURI)in.readObject();
        this.callerFromHeader = in.readUTF();
        this.proxyBranches = new LinkedHashMap<URI, ProxyBranchImpl>();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.originalRequest);
        out.writeBoolean(this.recurse);
        out.writeInt(this.proxyTimeout);
        out.writeInt(this.seqSearchTimeout);
        out.writeBoolean(this.supervised);
        out.writeBoolean(this.recordRoutingEnabled);
        out.writeBoolean(this.parallel);
        out.writeBoolean(this.addToPath);
        out.writeBoolean(this.isNoCancel);
        out.writeBoolean(this.started);
        out.writeBoolean(this.ackReceived);
        out.writeBoolean(this.tryingSent);
        out.writeObject(this.finalBranchForSubsequentRequests);
        out.writeObject(this.previousNode);
        out.writeUTF(this.callerFromHeader);
    }

    public int getProxy1xxTimeout() {
        return this.proxy1xxTimeout;
    }

    public void setProxy1xxTimeout(int timeout) {
        this.proxy1xxTimeout = timeout;
    }
}

