/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.sip.Address;
import javax.sip.Transaction;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionApplicationData
implements Serializable {
    private static final long serialVersionUID = 9170581635026591070L;
    private static final Logger logger = Logger.getLogger(TransactionApplicationData.class);
    private transient ProxyBranchImpl proxyBranch;
    private SipServletMessageImpl sipServletMessage;
    private transient Set<SipServletResponseImpl> sipServletResponses;
    private transient Transaction transaction;
    private transient String initialRemoteHostAddress;
    private transient int initialRemotePort;
    private transient String initialRemoteTransport;
    private transient Address initialPoppedRoute;
    private transient AtomicInteger rseqNumber;
    private transient String appNotDeployed = null;
    private transient boolean noAppReturned = false;
    private transient String modifier = null;
    private transient boolean canceled = false;

    public TransactionApplicationData(SipServletMessageImpl sipServletMessage) {
        this.sipServletMessage = sipServletMessage;
        this.sipServletResponses = null;
    }

    public void setProxyBranch(ProxyBranchImpl proxyBranch) {
        this.proxyBranch = proxyBranch;
    }

    public ProxyBranchImpl getProxyBranch() {
        return this.proxyBranch;
    }

    public SipServletMessageImpl getSipServletMessage() {
        return this.sipServletMessage;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public void addSipServletResponse(SipServletResponseImpl sipServletResponse) {
        if (this.sipServletResponses == null) {
            this.sipServletResponses = new CopyOnWriteArraySet<SipServletResponseImpl>();
        }
        this.sipServletResponses.add(sipServletResponse);
    }

    public Set<SipServletResponseImpl> getSipServletResponses() {
        return this.sipServletResponses;
    }

    public void setInitialRemoteHostAddress(String initialRemoteHostAddress) {
        this.initialRemoteHostAddress = initialRemoteHostAddress;
    }

    public String getInitialRemoteHostAddress() {
        return this.initialRemoteHostAddress;
    }

    public void setInitialRemotePort(int initialRemotePort) {
        this.initialRemotePort = initialRemotePort;
    }

    public int getInitialRemotePort() {
        return this.initialRemotePort;
    }

    public void setInitialRemoteTransport(String initialRemoteTransport) {
        this.initialRemoteTransport = initialRemoteTransport;
    }

    public String getInitialRemoteTransport() {
        return this.initialRemoteTransport;
    }

    public Address getInitialPoppedRoute() {
        return this.initialPoppedRoute;
    }

    public void setInitialPoppedRoute(Address initialPoppedRoute) {
        this.initialPoppedRoute = initialPoppedRoute;
    }

    public AtomicInteger getRseqNumber() {
        if (this.rseqNumber == null) {
            this.rseqNumber = new AtomicInteger(1);
        }
        return this.rseqNumber;
    }

    public void setRseqNumber(AtomicInteger rseqNumber) {
        this.rseqNumber = rseqNumber;
    }

    public void setAppNotDeployed(String appNotDeployed) {
        this.appNotDeployed = appNotDeployed;
    }

    public String getAppNotDeployed() {
        return this.appNotDeployed;
    }

    public void setNoAppReturned(boolean noAppReturned) {
        this.noAppReturned = noAppReturned;
    }

    public boolean isNoAppReturned() {
        return this.noAppReturned;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void cleanUp() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cleaning up the application data");
        }
        this.initialPoppedRoute = null;
        this.proxyBranch = null;
        if (this.sipServletResponses != null) {
            this.sipServletResponses.clear();
            this.sipServletResponses = null;
        }
        this.transaction = null;
        this.rseqNumber = null;
    }
}

