/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.RSeqHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipServletResponseImpl
extends SipServletMessageImpl
implements SipServletResponse {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipServletResponseImpl.class);
    Response response;
    SipServletRequestImpl originalRequest;
    ProxyBranch proxyBranch;
    private boolean isProxiedResponse;
    private boolean isResponseForwardedUpstream;
    private boolean isAckGenerated;
    private boolean isPrackGenerated;
    private boolean hasBeenReceived;

    public SipServletResponseImpl(Response response, SipFactoryImpl sipFactoryImpl, Transaction transaction, MobicentsSipSession session, Dialog dialog, boolean hasBeenReceived) {
        super((Message)response, sipFactoryImpl, transaction, session, dialog);
        this.response = response;
        this.setProxiedResponse(false);
        this.isResponseForwardedUpstream = false;
        this.isAckGenerated = false;
        this.hasBeenReceived = hasBeenReceived;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public boolean isSystemHeader(String headerName) {
        String hName = SipServletResponseImpl.getFullHeaderName(headerName);
        boolean isSystemHeader = JainSipUtils.SYSTEM_HEADERS.contains(hName);
        if (isSystemHeader) {
            return isSystemHeader;
        }
        boolean isContactSystem = false;
        Response sipResponse = (Response)this.message;
        String method = ((CSeqHeader)sipResponse.getHeader("CSeq")).getMethod();
        isContactSystem = !(method.equals("REGISTER") || 300 <= sipResponse.getStatusCode() && sipResponse.getStatusCode() < 400 && !method.equals("CANCEL") || sipResponse.getStatusCode() == 485 && !method.equals("PRACK") && !method.equals("CANCEL") || sipResponse.getStatusCode() == 200 && method.equals("OPTIONS"));
        isSystemHeader = isContactSystem && hName.equals("Contact");
        return isSystemHeader;
    }

    public SipServletRequest createAck() {
        if (!"INVITE".equals(((SIPTransaction)this.getTransaction()).getMethod()) || this.response.getStatusCode() >= 100 && this.response.getStatusCode() < 200 || this.isAckGenerated) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transaction state " + ((SIPTransaction)this.getTransaction()).getMethod() + " status code " + this.response.getStatusCode() + " isAckGenerated " + this.isAckGenerated));
            }
            throw new IllegalStateException("the transaction state is such that it doesn't allow an ACK to be sent now, e.g. the original request was not an INVITE, or this response is provisional only, or an ACK has already been generated");
        }
        MobicentsSipSession session = this.getSipSession();
        Dialog dialog = session.getSessionCreatingDialog();
        CSeqHeader cSeqHeader = (CSeqHeader)this.response.getHeader("CSeq");
        SipServletRequestImpl sipServletAckRequest = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dialog to create the ack Request " + dialog));
            }
            Request ackRequest = dialog.createAck(cSeqHeader.getSeqNumber());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("ackRequest just created " + ackRequest));
            }
            ListIterator routeHeaders = ackRequest.getHeaders("Route");
            ackRequest.removeHeader("Route");
            while (routeHeaders.hasNext()) {
                RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
                String routeAppNameHashed = ((SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
                String routeAppName = null;
                if (routeAppNameHashed != null) {
                    routeAppName = this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
                }
                if (routeAppName != null && routeAppName.equals(this.getSipSession().getKey().getApplicationName())) continue;
                ackRequest.addHeader((Header)routeHeader);
            }
            sipServletAckRequest = new SipServletRequestImpl(ackRequest, this.sipFactoryImpl, this.getSipSession(), this.getTransaction(), dialog, false);
            this.isAckGenerated = true;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        catch (SipException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        return sipServletAckRequest;
    }

    public SipServletRequest createPrack() throws Rel100Exception {
        if (this.response.getStatusCode() == 100 && this.response.getStatusCode() >= 200 || this.isPrackGenerated) {
            throw new IllegalStateException("the transaction state is such that it doesn't allow a PRACK to be sent now, or this response is provisional only, or a PRACK has already been generated");
        }
        if (!"INVITE".equals(this.getTransaction().getRequest().getMethod())) {
            throw new Rel100Exception(1);
        }
        MobicentsSipSession session = this.getSipSession();
        Dialog dialog = session.getSessionCreatingDialog();
        SipServletRequestImpl sipServletPrackRequest = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dialog to create the prack Request " + dialog));
            }
            Request prackRequest = dialog.createPrack(this.response);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("prackRequest just created " + prackRequest));
            }
            ListIterator routeHeaders = prackRequest.getHeaders("Route");
            prackRequest.removeHeader("Route");
            while (routeHeaders.hasNext()) {
                RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
                String routeAppNameHashed = ((SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
                String routeAppName = null;
                if (routeAppNameHashed != null) {
                    routeAppName = this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
                }
                if (routeAppName != null && routeAppName.equals(this.getSipSession().getKey().getApplicationName())) continue;
                prackRequest.addHeader((Header)routeHeader);
            }
            sipServletPrackRequest = new SipServletRequestImpl(prackRequest, this.sipFactoryImpl, this.getSipSession(), this.getTransaction(), dialog, false);
            this.isPrackGenerated = true;
        }
        catch (SipException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        return sipServletPrackRequest;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public Proxy getProxy() {
        if (this.proxyBranch != null) {
            return this.proxyBranch.getProxy();
        }
        return null;
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public SipServletRequest getRequest() {
        return this.originalRequest;
    }

    public int getStatus() {
        return this.response.getStatusCode();
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public void sendReliably() throws Rel100Exception {
        int statusCode = this.getStatus();
        if (statusCode == 100 || statusCode >= 200) {
            throw new Rel100Exception(0);
        }
        if (!"INVITE".equals(this.originalRequest.getMethod())) {
            throw new Rel100Exception(1);
        }
        if (!this.containsRel100(this.originalRequest.getMessage())) {
            throw new Rel100Exception(2);
        }
        this.send(true);
    }

    public void setStatus(int statusCode) {
        try {
            this.response.setStatusCode(statusCode);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setStatus(int statusCode, String reasonPhrase) {
        try {
            this.response.setStatusCode(statusCode);
            this.response.setReasonPhrase(reasonPhrase);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public void setLocale(Locale arg0) {
    }

    @Override
    public void send() {
        this.send(false);
    }

    public void send(boolean sendReliably) {
        if (this.isMessageSent) {
            throw new IllegalStateException("message already sent");
        }
        if (this.hasBeenReceived) {
            throw new IllegalStateException("this response was received from downstream");
        }
        try {
            Dialog dialog;
            int statusCode = this.response.getStatusCode();
            MobicentsSipSession session = this.getSipSession();
            MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
            SipApplicationSessionKey sipAppSessionKey = sipApplicationSession.getKey();
            ProxyImpl proxy = session.getProxy();
            if (proxy != null && proxy.getFinalBranchForSubsequentRequests() == null && this.proxyBranch != null && this.proxyBranch.getRecordRoute() && statusCode > 100 && statusCode <= 606) {
                SipURI sipURI = JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)this.response);
                sipURI.setParameter("appname", this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(session.getKey().getApplicationName()));
                sipURI.setParameter("app_id", sipAppSessionKey.getId());
                sipURI.setLrParam();
                Address recordRouteAddress = SipFactories.addressFactory.createAddress((URI)sipURI);
                RecordRouteHeader recordRouteHeader = SipFactories.headerFactory.createRecordRouteHeader(recordRouteAddress);
                this.response.addFirst((Header)recordRouteHeader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Record Route added to the response " + recordRouteHeader));
                }
            }
            ServerTransaction transaction = (ServerTransaction)this.getTransaction();
            session.updateStateOnResponse(this, false);
            if ("SUBSCRIBE".equals(this.getMethod()) && statusCode >= 200 && statusCode <= 300 && session.getProxy() == null) {
                session.addSubscription(this);
            }
            if (sendReliably) {
                if (!this.containsRel100((Message)this.response)) {
                    RequireHeader requireHeader = SipFactories.headerFactory.createRequireHeader("100rel");
                    this.response.addHeader((Header)requireHeader);
                }
                RSeqHeader rseqHeader = SipFactories.headerFactory.createRSeqHeader(this.getTransactionApplicationData().getRseqNumber().getAndIncrement());
                this.response.addHeader((Header)rseqHeader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending response " + this.message));
            }
            if (this.originalRequest == null && proxy != null) {
                String txid = ((ViaHeader)this.message.getHeader("Via")).getBranch();
                TransactionApplicationData tad = (TransactionApplicationData)proxy.getTransactionMap().get(txid);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to recover lost transaction for proxy: " + txid));
                }
                if (tad != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Recovering lost transaction from the proxy transaction map is succesful: " + txid));
                    }
                    this.originalRequest = (SipServletRequestImpl)tad.getSipServletMessage();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("original req method " + this.originalRequest.getMethod()));
                logger.debug((Object)("original req routing state " + (Object)((Object)this.originalRequest.getRoutingState())));
                if (transaction != null) {
                    logger.debug((Object)("transaction dialog " + transaction.getDialog()));
                }
            }
            if (!"CANCEL".equals(this.originalRequest.getMethod()) && (RoutingState.INITIAL.equals((Object)this.originalRequest.getRoutingState()) || RoutingState.RELAYED.equals((Object)this.originalRequest.getRoutingState())) && transaction.getDialog() == null && JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
                String transport = JainSipUtils.findTransport((Message)transaction.getRequest());
                SipProvider sipProvider = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                Dialog dialog2 = null;
                if (statusCode != 100 && statusCode < 300) {
                    dialog2 = sipProvider.getNewDialog((Transaction)transaction);
                    ((DialogExt)dialog2).disableSequenceNumberValidation();
                }
                session.setSessionCreatingDialog(dialog2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("created following dialog since the application is acting as an endpoint " + dialog2));
                }
            }
            Dialog dialog3 = dialog = transaction == null ? null : transaction.getDialog();
            if (dialog != null) {
                if (dialog.getApplicationData() == null) {
                    dialog.setApplicationData((Object)this.originalRequest.getTransactionApplicationData());
                }
                ((TransactionApplicationData)dialog.getApplicationData()).setTransaction((Transaction)transaction);
            }
            if (statusCode >= 200 && statusCode <= 606) {
                this.originalRequest.setRoutingState(RoutingState.FINAL_RESPONSE_SENT);
            }
            if (this.originalRequest != null) {
                this.originalRequest.setResponse(this);
            }
            session.access();
            sipApplicationSession.access();
            if (transaction == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending response statelessly " + this.message));
                }
                String transport = JainSipUtils.findTransport(((SipServletRequestImpl)this.getRequest()).getMessage());
                SipProvider sipProvider = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                sipProvider.sendResponse((Response)this.message);
            } else if (sendReliably) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending response reliably " + this.message));
                }
                dialog.sendReliableProvisionalResponse((Response)this.message);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending response " + this.message + " through tx " + transaction));
                }
                transaction.sendResponse((Response)this.message);
                if (dialog != null) {
                    session.setSessionCreatingDialog(dialog);
                }
            }
            this.isMessageSent = true;
            if (this.isProxiedResponse) {
                this.isResponseForwardedUpstream = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("an exception occured when sending the response", e);
        }
    }

    public Iterator<String> getChallengeRealms() {
        ArrayList<String> realms = new ArrayList<String>();
        if (this.response.getStatusCode() == 401) {
            WWWAuthenticateHeader authenticateHeader = (WWWAuthenticateHeader)this.response.getHeader("WWW-Authenticate");
            realms.add(authenticateHeader.getRealm());
        } else if (this.response.getStatusCode() == 407) {
            ProxyAuthenticateHeader authenticateHeader = (ProxyAuthenticateHeader)this.response.getHeader("Proxy-Authenticate");
            realms.add(authenticateHeader.getRealm());
        }
        return realms.iterator();
    }

    public ProxyBranch getProxyBranch() {
        return this.proxyBranch;
    }

    public void setProxyBranch(ProxyBranch proxyBranch) {
        this.proxyBranch = proxyBranch;
    }

    public boolean isBranchResponse() {
        return this.proxyBranch != null;
    }

    public boolean isCommitted() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            if (tx instanceof ClientTransaction && this.getStatus() >= 101 && this.getStatus() <= 199 && this.getHeader("RSeq") == null) {
                return this.proxyBranch == null;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 101 && this.getStatus() <= 199 && this.getHeader("RSeq") != null && TransactionState.TERMINATED.equals((Object)tx.getState())) {
                return this.proxyBranch == null;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 200 && this.getStatus() <= 999 && !"INVITE".equals(((SIPClientTransaction)tx).getMethod())) {
                return this.proxyBranch == null;
            }
            if (this.isResponseForwardedUpstream) {
                return true;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 200 && this.getStatus() <= 999 && TransactionState.TERMINATED.equals((Object)tx.getState()) && this.isAckGenerated) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void checkMessageState() {
        if (this.isMessageSent || this.getTransaction() instanceof ClientTransaction) {
            throw new IllegalStateException("Message already sent or incoming message");
        }
    }

    public void setOriginalRequest(SipServletRequestImpl originalRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("original request set to " + originalRequest + " for response " + this.message));
        }
        this.originalRequest = originalRequest;
    }

    public void setProxiedResponse(boolean isProxiedResponse) {
        this.isProxiedResponse = isProxiedResponse;
    }

    public boolean isProxiedResponse() {
        return this.isProxiedResponse;
    }

    @Override
    public void setCharacterEncoding(String enc) {
        try {
            this.message.setContentEncoding(SipFactories.headerFactory.createContentEncodingHeader(enc));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Encoding " + enc + " not valid", ex);
        }
    }

    @Override
    public void cleanUp() {
        this.originalRequest = null;
        this.proxyBranch = null;
        this.response = null;
    }
}

