/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.address.TelURL;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipRequestDispatcher;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.B2buaHelperImpl;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.security.AuthInfoEntry;
import org.mobicents.servlet.sip.security.AuthInfoImpl;
import org.mobicents.servlet.sip.security.authentication.DigestAuthenticator;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;
import org.mobicents.servlet.sip.startup.loading.SipServletImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipServletRequestImpl
extends SipServletMessageImpl
implements SipServletRequest {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipServletRequestImpl.class);
    private static final String EXCEPTION_MESSAGE = "The context does not allow you to modify this request !";
    public static final Set<String> NON_INITIAL_SIP_REQUEST_METHODS = new HashSet<String>();
    private SipServletRequestImpl linkedRequest;
    private boolean createDialog;
    private AddressImpl poppedRoute;
    private RouteHeader poppedRouteHeader;
    private SipApplicationRoutingDirective routingDirective = SipApplicationRoutingDirective.NEW;
    private RoutingState routingState;
    private transient SipServletResponse lastFinalResponse;
    private transient SipServletResponse lastInformationalResponse;
    private SipApplicationRoutingRegion routingRegion;
    private transient URI subscriberURI;
    private boolean isInitial;
    private boolean isFinalResponseGenerated;
    private boolean is1xxResponseGenerated;
    private transient boolean isReadOnly;
    private transient Transaction inviteTransactionToCancel;

    public SipServletRequestImpl(Request request, SipFactoryImpl sipFactoryImpl, MobicentsSipSession sipSession, Transaction transaction, Dialog dialog, boolean createDialog) {
        super((Message)request, sipFactoryImpl, transaction, sipSession, dialog);
        this.createDialog = createDialog;
        this.routingState = SipServletRequestImpl.checkRoutingState(this, dialog);
        if (RoutingState.INITIAL.equals((Object)this.routingState)) {
            this.isInitial = true;
        }
        this.isFinalResponseGenerated = false;
    }

    @Override
    public boolean isSystemHeader(String headerName) {
        String hName = SipServletRequestImpl.getFullHeaderName(headerName);
        boolean isSystemHeader = JainSipUtils.SYSTEM_HEADERS.contains(hName);
        if (isSystemHeader) {
            return isSystemHeader;
        }
        boolean isContactSystem = false;
        Request request = (Request)this.message;
        String method = request.getMethod();
        isContactSystem = !method.equals("REGISTER");
        isSystemHeader = isContactSystem && hName.equals("Contact");
        return isSystemHeader;
    }

    public SipServletRequest createCancel() {
        this.checkReadOnly();
        if (!((Request)this.message).getMethod().equals("INVITE")) {
            throw new IllegalStateException("Cannot create CANCEL for non inivte");
        }
        if (super.getTransaction() == null || super.getTransaction() instanceof ServerTransaction) {
            throw new IllegalStateException("No client transaction found!");
        }
        if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)this.routingState) || this.lastFinalResponse != null) {
            throw new IllegalStateException("final response already sent!");
        }
        try {
            Request cancelRequest = ((ClientTransaction)this.getTransaction()).createCancel();
            SipServletRequestImpl newRequest = new SipServletRequestImpl(cancelRequest, this.sipFactoryImpl, this.getSipSession(), null, this.getTransaction().getDialog(), false);
            newRequest.inviteTransactionToCancel = super.getTransaction();
            return newRequest;
        }
        catch (SipException ex) {
            throw new IllegalStateException("Could not create cancel", ex);
        }
    }

    public SipServletResponse createResponse(int statusCode) {
        return this.createResponse(statusCode, null);
    }

    public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
        return this.createResponse(statusCode, reasonPhrase, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipServletResponse createResponse(int statusCode, String reasonPhrase, boolean validate) {
        this.checkReadOnly();
        Transaction transaction = this.getTransaction();
        if (RoutingState.CANCELLED.equals((Object)this.routingState)) {
            throw new IllegalStateException("Cannot create a response for the invite, a CANCEL has been received and the INVITE was replied with a 487!");
        }
        if ((transaction == null || transaction instanceof ClientTransaction) && validate) {
            throw new IllegalStateException("Cannot create a response - not a server transaction " + transaction);
        }
        try {
            Request request = (Request)this.getMessage();
            Response response = SipFactories.messageFactory.createResponse(statusCode, request);
            if (reasonPhrase != null) {
                response.setReasonPhrase(reasonPhrase);
            }
            MobicentsSipSession session = this.getSipSession();
            String requestMethod = this.getMethod();
            if (!(statusCode <= 100 && this.isInitial() || statusCode > 606)) {
                ToHeader toHeader = (ToHeader)response.getHeader("To");
                if (toHeader.getTag() == null) {
                    Dialog dialog = transaction.getDialog();
                    if (dialog != null && dialog.getLocalTag() != null && dialog.getLocalTag().length() > 0) {
                        toHeader.setTag(dialog.getLocalTag());
                    } else if (session != null && session.getSipApplicationSession() != null) {
                        SipApplicationSessionKey sipAppSessionKey = session.getSipApplicationSession().getKey();
                        SipSessionKey sipSessionKey = session.getKey();
                        SipServletRequestImpl sipServletRequestImpl = this;
                        synchronized (sipServletRequestImpl) {
                            String toTag = sipSessionKey.getToTag();
                            if (toTag == null) {
                                toTag = ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), sipSessionKey.getApplicationName(), sipAppSessionKey.getId());
                                session.getKey().setToTag(toTag);
                            }
                            toHeader.setTag(toTag);
                        }
                    } else {
                        toHeader.setTag(Integer.toString(new Random().nextInt(10000000)));
                    }
                }
                boolean setContactHeader = true;
                if (statusCode >= 300 && statusCode < 400 || statusCode == 485 || "REGISTER".equals(requestMethod) || "OPTIONS".equals(requestMethod) || "BYE".equals(requestMethod) || "CANCEL".equals(requestMethod) || "PRACK".equals(requestMethod) || "MESSAGE".equals(requestMethod) || "PUBLISH".equals(requestMethod)) {
                    setContactHeader = false;
                }
                if (setContactHeader) {
                    boolean sipURI;
                    SipConnector sipConnector;
                    String outboundInterface = null;
                    if (session != null) {
                        outboundInterface = session.getOutboundInterface();
                    }
                    ContactHeader contactHeader = JainSipUtils.createContactHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), request, null, outboundInterface);
                    String transport = "udp";
                    if (session != null && session.getTransport() != null) {
                        transport = session.getTransport();
                    }
                    if ((sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(transport)) != null && sipConnector.isUseStaticAddress() && session != null && session.getProxy() == null && (sipURI = contactHeader.getAddress().getURI().isSipURI())) {
                        javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)contactHeader.getAddress().getURI();
                        sipUri.setHost(sipConnector.getStaticServerAddress());
                        sipUri.setPort(sipConnector.getStaticServerPort());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("We're adding this contact header to our new response: '" + contactHeader + ", transport=" + JainSipUtils.findTransport((Message)request)));
                    }
                    response.setHeader((Header)contactHeader);
                }
            }
            SipServletResponseImpl newSipServletResponse = new SipServletResponseImpl(response, this.sipFactoryImpl, (Transaction)(validate ? (ServerTransaction)transaction : transaction), session, this.getDialog(), false);
            newSipServletResponse.setOriginalRequest(this);
            if (!"PRACK".equals(requestMethod) && statusCode >= 200 && statusCode <= 606) {
                this.isFinalResponseGenerated = true;
            }
            if (statusCode >= 100 && statusCode < 200) {
                this.is1xxResponseGenerated = true;
            }
            return newSipServletResponse;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad status code" + statusCode, ex);
        }
    }

    public B2buaHelper getB2buaHelper() {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getProxy() != null) {
            throw new IllegalStateException("Proxy already present");
        }
        B2buaHelperImpl b2buaHelper = session.getB2buaHelper();
        if (b2buaHelper != null) {
            return b2buaHelper;
        }
        b2buaHelper = new B2buaHelperImpl();
        b2buaHelper.setSipFactoryImpl(this.sipFactoryImpl);
        b2buaHelper.setSipManager(session.getSipApplicationSession().getSipContext().getSipManager());
        if (JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
            this.createDialog = true;
        }
        session.setB2buaHelper(b2buaHelper);
        return b2buaHelper;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public int getMaxForwards() {
        return ((MaxForwardsHeader)((Request)this.message).getHeader("Max-Forwards")).getMaxForwards();
    }

    public Address getPoppedRoute() {
        if (this.poppedRoute == null && this.poppedRouteHeader != null || this.poppedRoute != null && this.poppedRouteHeader != null && !this.poppedRoute.getAddress().equals(this.poppedRouteHeader.getAddress())) {
            this.poppedRoute = new AddressImpl(this.poppedRouteHeader.getAddress(), null, this.getTransaction() == null);
        }
        return this.poppedRoute;
    }

    public RouteHeader getPoppedRouteHeader() {
        return this.poppedRouteHeader;
    }

    public void setPoppedRoute(RouteHeader routeHeader) {
        this.poppedRouteHeader = routeHeader;
    }

    public Proxy getProxy() throws TooManyHopsException {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getB2buaHelper() != null) {
            throw new IllegalStateException("Cannot proxy request");
        }
        return this.getProxy(true);
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getB2buaHelper() != null) {
            throw new IllegalStateException("Cannot proxy request");
        }
        MaxForwardsHeader mfHeader = (MaxForwardsHeader)this.message.getHeader("Max-Forwards");
        if (mfHeader.getMaxForwards() <= 0) {
            try {
                this.createResponse(483, "Too many hops").send();
            }
            catch (IOException e) {
                throw new RuntimeException("could not send the Too many hops response out !", e);
            }
            throw new TooManyHopsException();
        }
        if (create) {
            ProxyImpl proxy = session.getProxy();
            boolean createNewProxy = false;
            if (this.isInitial() && proxy != null && proxy.getOriginalRequest() == null) {
                createNewProxy = true;
            }
            if (proxy == null || createNewProxy) {
                session.setProxy(new ProxyImpl(this, this.sipFactoryImpl));
            }
        }
        return session.getProxy();
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public URI getRequestURI() {
        Request request = (Request)this.message;
        if (request.getRequestURI() instanceof javax.sip.address.SipURI) {
            return new SipURIImpl((javax.sip.address.SipURI)request.getRequestURI());
        }
        if (request.getRequestURI() instanceof TelURL) {
            return new TelURLImpl((TelURL)request.getRequestURI());
        }
        throw new UnsupportedOperationException("Unsupported scheme");
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    public boolean isCommitted() {
        if (this.getTransaction() instanceof ServerTransaction && (RoutingState.FINAL_RESPONSE_SENT.equals((Object)this.routingState) || this.isFinalResponseGenerated)) {
            return true;
        }
        return this.getTransaction() instanceof ClientTransaction && this.isMessageSent;
    }

    @Override
    protected void checkMessageState() {
        if (this.isMessageSent || this.getTransaction() instanceof ServerTransaction) {
            throw new IllegalStateException("Message already sent or incoming message");
        }
    }

    public void pushPath(Address uri) {
        this.checkReadOnly();
        if (!"REGISTER".equalsIgnoreCase(((Request)this.message).getMethod())) {
            throw new IllegalStateException("Cannot push a Path on a non REGISTER request !");
        }
        if (uri.getURI() instanceof TelURL) {
            throw new IllegalArgumentException("Cannot push a TelUrl as a path !");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing path into message of value [" + uri + "]"));
        }
        try {
            Header p = SipFactories.headerFactory.createHeader("Path", uri.toString());
            this.message.addFirst(p);
        }
        catch (Exception e) {
            logger.error((Object)("Error while pushing path [" + uri + "]"));
            throw new IllegalArgumentException("Error pushing path ", e);
        }
    }

    public void pushRoute(Address address) {
        this.checkReadOnly();
        if (address.getURI() instanceof TelURL) {
            throw new IllegalArgumentException("Cannot push a TelUrl as a route !");
        }
        javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)((AddressImpl)address).getAddress().getURI();
        this.pushRoute(sipUri);
    }

    public void pushRoute(SipURI uri) {
        this.checkReadOnly();
        javax.sip.address.SipURI sipUri = ((SipURIImpl)uri).getSipURI();
        sipUri.setLrParam();
        this.pushRoute(sipUri);
    }

    private void pushRoute(javax.sip.address.SipURI sipUri) {
        if (this.isInitial()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pushing route into message of value [" + sipUri + "]"));
            }
            sipUri.setLrParam();
            try {
                RouteHeader p = SipFactories.headerFactory.createRouteHeader(SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipUri));
                this.message.addFirst((Header)p);
            }
            catch (SipException e) {
                logger.error((Object)("Error while pushing route [" + sipUri + "]"));
                throw new IllegalArgumentException("Error pushing route ", e);
            }
        } else {
            throw new IllegalStateException("Cannot push route on subsequent requests, only intial ones");
        }
    }

    public void setMaxForwards(int n) {
        this.checkReadOnly();
        MaxForwardsHeader mfh = (MaxForwardsHeader)this.message.getHeader("Max-Forwards");
        try {
            if (mfh != null) {
                mfh.setMaxForwards(n);
            }
        }
        catch (Exception ex) {
            String s = "Error while setting max forwards";
            logger.error((Object)s, (Throwable)ex);
            throw new IllegalArgumentException(s, ex);
        }
    }

    public void setRequestURI(URI uri) {
        this.checkReadOnly();
        Request request = (Request)this.message;
        URIImpl uriImpl = (URIImpl)uri;
        javax.sip.address.URI wrappedUri = uriImpl.getURI();
        request.setRequestURI(wrappedUri);
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) throws IllegalStateException {
        this.checkReadOnly();
        SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
        MobicentsSipSession session = this.getSipSession();
        if (directive == SipApplicationRoutingDirective.REVERSE || directive == SipApplicationRoutingDirective.CONTINUE) {
            if (origRequestImpl == null || !origRequestImpl.isInitial()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("directive to set : " + directive));
                    logger.debug((Object)("Original Request Routing State : " + (Object)((Object)origRequestImpl.getRoutingState())));
                }
                throw new IllegalStateException("Bad state -- cannot set routing directive");
            }
            session.setStateInfo(origRequestImpl.getSipSession().getStateInfo());
            this.currentApplicationName = origRequestImpl.getCurrentApplicationName();
            origRequestImpl.setLinkedRequest(this);
            this.setLinkedRequest(origRequestImpl);
        } else {
            Set<Transaction> ongoingTransactions = session.getOngoingTransactions();
            if (!SipSession.State.INITIAL.equals((Object)session.getState()) && ongoingTransactions != null && ongoingTransactions.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("session state : " + session.getState()));
                    logger.debug((Object)("numbers of ongoing transactions : " + ongoingTransactions.size()));
                }
                throw new IllegalStateException("Bad state -- cannot set routing directive");
            }
        }
        this.routingDirective = directive;
        this.linkedRequest = origRequestImpl;
    }

    public String getLocalName() {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String name) {
        if (this.getPoppedRoute() != null) {
            return this.getPoppedRoute().getURI().getParameter(name);
        }
        return this.getRequestURI().getParameter(name);
    }

    public Map<String, String> getParameterMap() {
        HashMap<String, String> retval = new HashMap<String, String>();
        if (this.getPoppedRoute() != null) {
            Iterator parameterNamesIt = this.getPoppedRoute().getURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.put(parameterName, this.getPoppedRoute().getURI().getParameter(parameterName));
            }
        } else {
            Iterator parameterNamesIt = this.getRequestURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.put(parameterName, this.getRequestURI().getParameter(parameterName));
            }
        }
        return retval;
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> retval = new Vector<String>();
        if (this.getPoppedRoute() != null) {
            Iterator parameterNamesIt = this.getPoppedRoute().getURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.add(parameterName);
            }
        } else {
            Iterator parameterNamesIt = this.getRequestURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.add(parameterName);
            }
        }
        return retval.elements();
    }

    public String[] getParameterValues(String name) {
        return new String[]{this.getParameter(name)};
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String handler) {
        SipServletImpl sipServletImpl = (SipServletImpl)this.getSipSession().getSipApplicationSession().getSipContext().findChildrenByName(handler);
        if (sipServletImpl == null) {
            throw new IllegalArgumentException(handler + " is not a valid servlet name");
        }
        return new SipRequestDispatcher(sipServletImpl);
    }

    public String getScheme() {
        return ((Request)this.message).getRequestURI().getScheme();
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public SipApplicationRoutingDirective getRoutingDirective() {
        if (!this.isInitial()) {
            throw new IllegalStateException("the request is not initial");
        }
        return this.routingDirective;
    }

    public static void optimizeRouteHeaderAddressForInternalRoutingrequest(SipConnector sipConnector, Request request, MobicentsSipSession session, SipFactoryImpl sipFactoryImpl, String transport) {
        javax.sip.address.URI uri;
        SipNetworkInterfaceManager sipNetworkInterfaceManager = sipFactoryImpl.getSipNetworkInterfaceManager();
        RouteHeader rh = (RouteHeader)request.getHeader("Route");
        if (rh != null && (uri = rh.getAddress().getURI()).isSipURI()) {
            try {
                javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
                boolean isExternal = sipFactoryImpl.getSipApplicationDispatcher().isExternal(sipUri.getHost(), sipUri.getPort(), transport);
                if (!isExternal) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("The request is going internally due to RR = " + rh));
                    }
                    ExtendedListeningPoint lp = null;
                    if (session.getOutboundInterface() != null) {
                        javax.sip.address.SipURI outboundInterfaceURI = (javax.sip.address.SipURI)SipFactories.addressFactory.createURI(session.getOutboundInterface());
                        lp = sipNetworkInterfaceManager.findMatchingListeningPoint(outboundInterfaceURI, false);
                    } else {
                        lp = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
                    }
                    sipUri.setHost(lp.getHost(false));
                    sipUri.setPort(lp.getPort());
                    sipUri.setTransportParam(lp.getTransport());
                }
            }
            catch (ParseException e) {
                logger.error((Object)"AR optimization error", (Throwable)e);
            }
        }
    }

    @Override
    public void send() {
        this.checkReadOnly();
        Request request = (Request)this.message;
        MobicentsSipSession session = this.getSipSession();
        try {
            String requestMethod;
            SipConnector sipConnector;
            ProxyImpl proxy = null;
            if (session != null) {
                proxy = session.getProxy();
            }
            SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactoryImpl.getSipNetworkInterfaceManager();
            String sessionTransport = session.getTransport();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("session transport is " + sessionTransport));
            }
            ((MessageExt)this.message).setApplicationData((Object)sessionTransport);
            ViaHeader viaHeader = (ViaHeader)this.message.getHeader("Via");
            if (!this.getMethod().equalsIgnoreCase("CANCEL") && viaHeader == null) {
                boolean addViaHeader = false;
                if (proxy == null) {
                    addViaHeader = true;
                } else if (this.isInitial) {
                    if (proxy.getRecordRoute()) {
                        addViaHeader = true;
                    }
                } else if (proxy.getFinalBranchForSubsequentRequests() != null && proxy.getFinalBranchForSubsequentRequests().getRecordRoute()) {
                    addViaHeader = true;
                }
                if (addViaHeader) {
                    viaHeader = JainSipUtils.createViaHeader(sipNetworkInterfaceManager, request, null, session.getOutboundInterface());
                    this.message.addHeader((Header)viaHeader);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added via Header" + viaHeader));
                    }
                }
            } else if (this.getMethod().equalsIgnoreCase("CANCEL") && this.getSipSession().getState().equals((Object)SipSession.State.INITIAL)) {
                Transaction tx = this.inviteTransactionToCancel;
                if (tx != null) {
                    logger.debug((Object)("Can not send CANCEL. Will try to STOP retransmissions " + tx));
                    StaticServiceHolder.disableRetransmissionTimer.invoke((Object)tx, new Object[0]);
                    if (tx.getApplicationData() instanceof TransactionApplicationData) {
                        TransactionApplicationData tad = (TransactionApplicationData)tx.getApplicationData();
                        tad.setCanceled(true);
                    }
                    return;
                }
                logger.debug((Object)"Can not send CANCEL because noe response arrived. Can not stop retransmissions. The transaction is null");
            }
            String transport = JainSipUtils.findTransport((Message)request);
            if (sessionTransport == null) {
                session.setTransport(transport);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The found transport for sending request is '" + transport + "'"));
            }
            if ((sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(transport)) != null && sipConnector.isUseStaticAddress()) {
                javax.sip.address.SipURI sipUri;
                RouteHeader rh = (RouteHeader)request.getHeader("Route");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("We are looking at route header " + rh + " and SC is" + sipConnector.getStaticServerAddress() + ":" + sipConnector.getStaticServerPort()));
                }
                if (rh != null && rh.getAddress().getURI().isSipURI() && (sipUri = (javax.sip.address.SipURI)rh.getAddress().getURI()).getHost().equals(sipConnector.getStaticServerAddress())) {
                    int port = sipUri.getPort();
                    if (port <= 0) {
                        port = 5060;
                    }
                    if (port == sipConnector.getStaticServerPort()) {
                        request.removeHeader("Route");
                    }
                }
            }
            if ("ACK".equals(requestMethod = this.getMethod())) {
                SipProvider sipProvider;
                session.getSessionCreatingDialog().sendAck(request);
                Transaction transaction = this.getTransaction();
                TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
                B2buaHelperImpl b2buaHelperImpl = this.sipSession.getB2buaHelper();
                if (b2buaHelperImpl != null && tad != null) {
                    b2buaHelperImpl.unlinkOriginalRequestInternal((SipServletRequestImpl)tad.getSipServletMessage());
                }
                session.removeOngoingTransaction(transaction);
                if (tad != null) {
                    tad.cleanUp();
                }
                if (((SipStackImpl)(sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false).getSipProvider()).getSipStack()).getMaxForkTime() == 0) {
                    transaction.setApplicationData(null);
                }
                return;
            }
            if (this.isInitial() && !"REGISTER".equalsIgnoreCase(requestMethod)) {
                SipApplicationRouterInfo routerInfo = this.sipFactoryImpl.getNextInterestedApplication(this);
                if (routerInfo.getNextApplicationName() != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("routing back to the container since the following app is interested " + routerInfo.getNextApplicationName()));
                    }
                    this.addInfoForRoutingBackToContainer(routerInfo, session.getSipApplicationSession().getKey().getId(), session.getKey().getApplicationName());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"routing outside the container since no more apps are interested.");
                    }
                    if (this.sipFactoryImpl.isUseLoadBalancer() && this.isInitial) {
                        this.sipFactoryImpl.addLoadBalancerRouteHeader(request);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"adding route to Load Balancer since we are in a HA configuration  and no more apps are interested.");
                        }
                    }
                }
            }
            MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
            if (viaHeader.getBranch() == null) {
                String branch = JainSipUtils.createBranch(sipApplicationSession.getKey().getId(), this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(session.getKey().getApplicationName()));
                viaHeader.setBranch(branch);
            }
            if (logger.isDebugEnabled()) {
                this.getSipSession().getSipApplicationSession().getSipContext().getSipManager().dumpSipSessions();
            }
            if (super.getTransaction() == null) {
                boolean sipURI;
                ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
                if (contactHeader == null && !"REGISTER".equalsIgnoreCase(requestMethod) && JainSipUtils.CONTACT_HEADER_METHODS.contains(requestMethod) && proxy == null) {
                    FromHeader fromHeader = (FromHeader)request.getHeader("From");
                    javax.sip.address.URI fromUri = fromHeader.getAddress().getURI();
                    String fromName = null;
                    if (fromUri instanceof javax.sip.address.SipURI) {
                        fromName = ((javax.sip.address.SipURI)fromUri).getUser();
                    }
                    contactHeader = JainSipUtils.createContactHeader(sipNetworkInterfaceManager, request, fromName, session.getOutboundInterface());
                    request.addHeader((Header)contactHeader);
                }
                if (sipConnector != null && sipConnector.isUseStaticAddress() && proxy == null && contactHeader != null && (sipURI = contactHeader.getAddress().getURI().isSipURI())) {
                    javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)contactHeader.getAddress().getURI();
                    sipUri.setHost(sipConnector.getStaticServerAddress());
                    sipUri.setPort(sipConnector.getStaticServerPort());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Getting new Client Tx for request " + request));
                }
                SipProvider sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false).getSipProvider();
                if (!this.isInitial() && sipConnector != null && sipConnector.isUseStaticAddress()) {
                    SipServletRequestImpl.optimizeRouteHeaderAddressForInternalRoutingrequest(sipConnector, request, session, this.sipFactoryImpl, transport);
                }
                ClientTransaction ctx = sipProvider.getNewClientTransaction(request);
                ctx.setRetransmitTimer(this.sipFactoryImpl.getSipApplicationDispatcher().getBaseTimerInterval());
                ((TransactionExt)ctx).setTimerT2(this.sipFactoryImpl.getSipApplicationDispatcher().getT2Interval());
                ((TransactionExt)ctx).setTimerT4(this.sipFactoryImpl.getSipApplicationDispatcher().getT4Interval());
                ((TransactionExt)ctx).setTimerD(this.sipFactoryImpl.getSipApplicationDispatcher().getTimerDInterval());
                Dialog dialog = ctx.getDialog();
                if (session.getProxy() != null) {
                    dialog = null;
                    if (this.isInitial() && session.getProxy().getRecordRoute()) {
                        RecordRouteHeader rrh = (RecordRouteHeader)request.getHeader("Record-Route");
                        if (rrh == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Unexpected RRH = null for this request" + request));
                            }
                        } else {
                            javax.sip.address.URI uri = rrh.getAddress().getURI();
                            if (uri.isSipURI()) {
                                javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
                                if (sipConnector != null && sipConnector.isUseStaticAddress()) {
                                    sipUri.setHost(sipConnector.getStaticServerAddress());
                                    sipUri.setPort(sipConnector.getStaticServerPort());
                                }
                                sipUri.setTransportParam(transport);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Updated the RRH with static server address " + sipUri));
                                }
                            }
                        }
                    }
                }
                if (dialog == null && this.createDialog && JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
                    dialog = sipProvider.getNewDialog((Transaction)ctx);
                    ((DialogExt)dialog).disableSequenceNumberValidation();
                    session.setSessionCreatingDialog(dialog);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("new Dialog for request " + request + ", ref = " + dialog));
                    }
                }
                if (this.linkedRequest != null) {
                    Transaction linkedTransaction = this.linkedRequest.getTransaction();
                    Dialog linkedDialog = this.linkedRequest.getDialog();
                    ((TransactionApplicationData)linkedTransaction.getApplicationData()).setTransaction((Transaction)ctx);
                    if (linkedDialog != null && linkedDialog.getApplicationData() != null) {
                        ((TransactionApplicationData)linkedDialog.getApplicationData()).setTransaction((Transaction)ctx);
                    }
                    this.transactionApplicationData.setTransaction(linkedTransaction);
                    if (dialog != null && dialog.getApplicationData() != null) {
                        ((TransactionApplicationData)dialog.getApplicationData()).setTransaction(linkedTransaction);
                    }
                }
                if (dialog != null) {
                    dialog.setApplicationData((Object)this.transactionApplicationData);
                }
                ctx.setApplicationData((Object)this.transactionApplicationData);
                super.setTransaction((Transaction)ctx);
                session.setSessionCreatingTransactionRequest(this);
            } else if ("PRACK".equals(request.getMethod())) {
                SipProvider sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false).getSipProvider();
                ClientTransaction ctx = sipProvider.getNewClientTransaction(request);
                ctx.setRetransmitTimer(this.sipFactoryImpl.getSipApplicationDispatcher().getBaseTimerInterval());
                ((TransactionExt)ctx).setTimerT2(this.sipFactoryImpl.getSipApplicationDispatcher().getT2Interval());
                ((TransactionExt)ctx).setTimerT4(this.sipFactoryImpl.getSipApplicationDispatcher().getT4Interval());
                ((TransactionExt)ctx).setTimerD(this.sipFactoryImpl.getSipApplicationDispatcher().getTimerDInterval());
                if (this.linkedRequest != null) {
                    ((TransactionApplicationData)this.linkedRequest.getTransaction().getApplicationData()).setTransaction((Transaction)ctx);
                    if (this.linkedRequest.getDialog() != null && this.linkedRequest.getDialog().getApplicationData() != null) {
                        ((TransactionApplicationData)this.linkedRequest.getDialog().getApplicationData()).setTransaction((Transaction)ctx);
                    }
                    this.transactionApplicationData.setTransaction(this.linkedRequest.getTransaction());
                    if (this.dialog != null && this.dialog.getApplicationData() != null) {
                        ((TransactionApplicationData)this.dialog.getApplicationData()).setTransaction(this.linkedRequest.getTransaction());
                    }
                }
                ctx.setApplicationData((Object)this.transactionApplicationData);
                this.setTransaction((Transaction)ctx);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction is not null, where was it created? " + this.getTransaction()));
            }
            if (this.linkedRequest != null && !SipApplicationRoutingDirective.NEW.equals((Object)this.routingDirective) && !RoutingState.PROXIED.equals((Object)this.linkedRequest.getRoutingState())) {
                this.linkedRequest.setRoutingState(RoutingState.RELAYED);
            }
            if (!"ACK".equals(this.getMethod())) {
                session.addOngoingTransaction(this.getTransaction());
            }
            session.updateStateOnSubsequentRequest(this, false);
            if ("NOTIFY".equals(this.getMethod()) && session.getProxy() == null) {
                SubscriptionStateHeader subscriptionStateHeader = (SubscriptionStateHeader)this.getMessage().getHeader("Subscription-State");
                if (subscriptionStateHeader != null && ("active".equalsIgnoreCase(subscriptionStateHeader.getState()) || "pending".equalsIgnoreCase(subscriptionStateHeader.getState()))) {
                    session.addSubscription(this);
                }
                if (subscriptionStateHeader != null && "terminated".equalsIgnoreCase(subscriptionStateHeader.getState())) {
                    session.removeSubscription(this);
                }
            }
            this.updateContactHeaderTransport(transport);
            session.access();
            sipApplicationSession.access();
            Dialog dialog = this.getDialog();
            if (session.getProxy() != null) {
                dialog = null;
            }
            if (dialog == null || dialog.getState() == null || dialog.getState() == DialogState.EARLY && !"PRACK".equals(requestMethod) || "CANCEL".equals(requestMethod)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending the request " + request));
                }
                ((ClientTransaction)super.getTransaction()).sendRequest();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending the in dialog request " + request));
                }
                dialog.sendRequest((ClientTransaction)this.getTransaction());
            }
            this.isMessageSent = true;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error sending request " + request, ex);
        }
    }

    protected void updateContactHeaderTransport(String transport) throws ParseException {
        javax.sip.address.URI uri;
        ContactHeader contactHeader = (ContactHeader)this.message.getHeader("Contact");
        if (contactHeader != null && (uri = contactHeader.getAddress().getURI()).isSipURI()) {
            javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
            if (!transport.equalsIgnoreCase("udp")) {
                sipUri.setTransportParam(transport);
            }
        }
    }

    public void addInfoForRoutingBackToContainer(SipApplicationRouterInfo routerInfo, String applicationSessionId, String applicationName) throws ParseException, SipException {
        Request request = (Request)this.message;
        javax.sip.address.SipURI sipURI = JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)request);
        sipURI.setLrParam();
        sipURI.setParameter("directive", this.routingDirective.toString());
        if (this.getSipSession().getRegionInternal() != null) {
            sipURI.setParameter("region_label", this.getSipSession().getRegionInternal().getLabel());
            sipURI.setParameter("region_type", this.getSipSession().getRegionInternal().getType().toString());
        }
        sipURI.setParameter("previousappname", applicationName);
        sipURI.setParameter("previousappid", applicationSessionId);
        javax.sip.address.Address routeAddress = SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipURI);
        RouteHeader routeHeader = SipFactories.headerFactory.createRouteHeader(routeAddress);
        request.addFirst((Header)routeHeader);
        MobicentsSipSession session = this.getSipSession();
        session.setNextSipApplicationRouterInfo(routerInfo);
    }

    public void setLinkedRequest(SipServletRequestImpl linkedRequest) {
        this.linkedRequest = linkedRequest;
    }

    public SipServletRequestImpl getLinkedRequest() {
        return this.linkedRequest;
    }

    public RoutingState getRoutingState() {
        return this.routingState;
    }

    public void setRoutingState(RoutingState routingState) throws IllegalStateException {
        if (routingState.equals((Object)RoutingState.CANCELLED) && (this.routingState.equals((Object)RoutingState.FINAL_RESPONSE_SENT) || this.routingState.equals((Object)RoutingState.PROXIED))) {
            throw new IllegalStateException("Cannot cancel final response already sent!");
        }
        if ((routingState.equals((Object)RoutingState.FINAL_RESPONSE_SENT) || routingState.equals((Object)RoutingState.PROXIED)) && this.routingState.equals((Object)RoutingState.CANCELLED)) {
            throw new IllegalStateException("Cancel received and already replied with a 487!");
        }
        if (routingState.equals((Object)RoutingState.SUBSEQUENT)) {
            this.isInitial = false;
        }
        this.routingState = routingState;
    }

    public void addAuthHeader(SipServletResponse challengeResponse, AuthInfo authInfo) {
        AuthInfoEntry authInfoEntry;
        WWWAuthenticateHeader wwwAuthHeader;
        this.checkReadOnly();
        AuthInfoImpl authInfoImpl = (AuthInfoImpl)authInfo;
        SipServletResponseImpl challengeResponseImpl = (SipServletResponseImpl)challengeResponse;
        Response response = (Response)challengeResponseImpl.getMessage();
        ListIterator authHeaderIterator = response.getHeaders("WWW-Authenticate");
        while (authHeaderIterator.hasNext()) {
            wwwAuthHeader = (WWWAuthenticateHeader)authHeaderIterator.next();
            authInfoEntry = authInfoImpl.getAuthInfo(wwwAuthHeader.getRealm());
            if (authInfoEntry == null) {
                throw new SecurityException("Cannot add authorization header. No credentials for the following realm: " + wwwAuthHeader.getRealm());
            }
            this.addChallengeResponse(wwwAuthHeader, authInfoEntry.getUserName(), authInfoEntry.getPassword(), this.getRequestURI().toString());
        }
        authHeaderIterator = response.getHeaders("Proxy-Authenticate");
        while (authHeaderIterator.hasNext()) {
            wwwAuthHeader = (ProxyAuthenticateHeader)authHeaderIterator.next();
            authInfoEntry = authInfoImpl.getAuthInfo(wwwAuthHeader.getRealm());
            if (authInfoEntry == null) {
                throw new SecurityException("No credentials for the following realm: " + wwwAuthHeader.getRealm());
            }
            this.addChallengeResponse(wwwAuthHeader, authInfoEntry.getUserName(), authInfoEntry.getPassword(), this.getRequestURI().toString());
        }
    }

    public void addAuthHeader(SipServletResponse challengeResponse, String username, String password) {
        WWWAuthenticateHeader wwwAuthHeader;
        this.checkReadOnly();
        SipServletResponseImpl challengeResponseImpl = (SipServletResponseImpl)challengeResponse;
        Response response = (Response)challengeResponseImpl.getMessage();
        ListIterator authHeaderIterator = response.getHeaders("WWW-Authenticate");
        while (authHeaderIterator.hasNext()) {
            wwwAuthHeader = (WWWAuthenticateHeader)authHeaderIterator.next();
            this.addChallengeResponse(wwwAuthHeader, username, password, this.getRequestURI().toString());
        }
        authHeaderIterator = response.getHeaders("Proxy-Authenticate");
        while (authHeaderIterator.hasNext()) {
            wwwAuthHeader = (ProxyAuthenticateHeader)authHeaderIterator.next();
            String uri = wwwAuthHeader.getParameter("uri");
            if (uri == null) {
                uri = this.getRequestURI().toString();
            }
            this.addChallengeResponse(wwwAuthHeader, username, password, uri);
        }
    }

    private void addChallengeResponse(WWWAuthenticateHeader wwwAuthHeader, String username, String password, String uri) {
        AuthorizationHeader authorization = DigestAuthenticator.getAuthorizationHeader(this.getMethod(), uri, "", wwwAuthHeader, username, password);
        this.message.addHeader((Header)authorization);
    }

    public SipServletResponse getLastFinalResponse() {
        return this.lastFinalResponse;
    }

    public void setResponse(SipServletResponseImpl response) {
        if (response.getStatus() >= 200 && (this.lastFinalResponse == null || this.lastFinalResponse.getStatus() < response.getStatus())) {
            this.lastFinalResponse = response;
        }
        if (this.containsRel100(response.getMessage()) && response.getStatus() > 100 && response.getStatus() < 200 && (this.lastInformationalResponse == null || this.lastInformationalResponse.getStatus() < response.getStatus())) {
            this.lastInformationalResponse = response;
        }
    }

    public Address getInitialPoppedRoute() {
        return this.transactionApplicationData.getInitialPoppedRoute();
    }

    public SipApplicationRoutingRegion getRegion() {
        return this.routingRegion;
    }

    public void setRoutingRegion(SipApplicationRoutingRegion routingRegion) {
        this.routingRegion = routingRegion;
    }

    public URI getSubscriberURI() {
        return this.subscriberURI;
    }

    public void setSubscriberURI(URI uri) {
        this.subscriberURI = uri;
    }

    private static RoutingState checkRoutingState(SipServletRequestImpl sipServletRequest, Dialog dialog) {
        if (dialog != null && DialogState.CONFIRMED.equals((Object)dialog.getState())) {
            return RoutingState.SUBSEQUENT;
        }
        if (NON_INITIAL_SIP_REQUEST_METHODS.contains(sipServletRequest.getMethod())) {
            return RoutingState.SUBSEQUENT;
        }
        if (dialog != null && !DialogState.EARLY.equals((Object)dialog.getState())) {
            return RoutingState.SUBSEQUENT;
        }
        return RoutingState.INITIAL;
    }

    public boolean is1xxResponseGenerated() {
        return this.is1xxResponseGenerated;
    }

    public boolean isFinalResponseGenerated() {
        return this.isFinalResponseGenerated;
    }

    public SipServletResponse getLastInformationalResponse() {
        return this.lastInformationalResponse;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    protected void checkReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalStateException(EXCEPTION_MESSAGE);
        }
    }

    @Override
    public void addAcceptLanguage(Locale locale) {
        this.checkReadOnly();
        super.addAcceptLanguage(locale);
    }

    @Override
    public void addAddressHeader(String name, Address addr, boolean first) throws IllegalArgumentException {
        this.checkReadOnly();
        super.addAddressHeader(name, addr, first);
    }

    @Override
    public void addHeader(String name, String value) {
        this.checkReadOnly();
        super.addHeader(name, value);
    }

    @Override
    public void addParameterableHeader(String name, Parameterable param, boolean first) {
        this.checkReadOnly();
        super.addParameterableHeader(name, param, first);
    }

    @Override
    public void removeAttribute(String name) {
        this.checkReadOnly();
        super.removeAttribute(name);
    }

    @Override
    public void removeHeader(String name) {
        this.checkReadOnly();
        super.removeHeader(name);
    }

    @Override
    public void setAcceptLanguage(Locale locale) {
        this.checkReadOnly();
        super.setAcceptLanguage(locale);
    }

    @Override
    public void setAddressHeader(String name, Address addr) {
        this.checkReadOnly();
        super.setAddressHeader(name, addr);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.checkReadOnly();
        super.setAttribute(name, o);
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.checkReadOnly();
        super.setCharacterEncoding(enc);
    }

    @Override
    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        this.checkReadOnly();
        super.setContent(content, contentType);
    }

    @Override
    public void setContentLanguage(Locale locale) {
        this.checkReadOnly();
        super.setContentLanguage(locale);
    }

    @Override
    public void setContentType(String type) {
        this.checkReadOnly();
        super.setContentType(type);
    }

    @Override
    public void setExpires(int seconds) {
        this.checkReadOnly();
        super.setExpires(seconds);
    }

    @Override
    public void setHeader(String name, String value) {
        this.checkReadOnly();
        super.setHeader(name, value);
    }

    @Override
    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        this.checkReadOnly();
        super.setHeaderForm(form);
    }

    @Override
    public void setParameterableHeader(String name, Parameterable param) {
        this.checkReadOnly();
        super.setParameterableHeader(name, param);
    }

    @Override
    public String getInitialRemoteAddr() {
        if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
            return ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress();
        }
        return ((SIPTransaction)this.getTransaction()).getPeerAddress();
    }

    @Override
    public int getInitialRemotePort() {
        if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
            return ((SIPTransaction)this.getTransaction()).getPeerPacketSourcePort();
        }
        return ((SIPTransaction)this.getTransaction()).getPeerPort();
    }

    @Override
    public String getInitialTransport() {
        return ((SIPTransaction)this.getTransaction()).getTransport();
    }

    @Override
    public void cleanUp() {
        if (this.transactionApplicationData != null) {
            this.transactionApplicationData.cleanUp();
            this.transactionApplicationData = null;
        }
        this.setTransaction(null);
        this.poppedRoute = null;
        this.poppedRouteHeader = null;
        this.routingDirective = null;
        this.routingRegion = null;
        this.routingState = null;
        this.subscriberURI = null;
        this.linkedRequest = null;
    }

    public void cleanUpLastResponses() {
        this.lastFinalResponse = null;
        this.lastInformationalResponse = null;
    }

    static {
        NON_INITIAL_SIP_REQUEST_METHODS.add("CANCEL");
        NON_INITIAL_SIP_REQUEST_METHODS.add("BYE");
        NON_INITIAL_SIP_REQUEST_METHODS.add("PRACK");
        NON_INITIAL_SIP_REQUEST_METHODS.add("ACK");
        NON_INITIAL_SIP_REQUEST_METHODS.add("UPDATE");
        NON_INITIAL_SIP_REQUEST_METHODS.add("INFO");
    }
}

