/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipFactory;
import javax.sip.Transaction;
import javax.sip.header.AcceptLanguageHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderAddress;
import javax.sip.header.Parameters;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.ParameterableHeaderImpl;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.startup.SipContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SipServletMessageImpl
implements SipServletMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipServletMessageImpl.class.getCanonicalName());
    private static final String CONTENT_TYPE_TEXT = "text";
    private static final String CONTENT_TYPE_MULTIPART = "multipart";
    private static final String MULTIPART_BOUNDARY = "boundary";
    private static final String MULTIPART_START = "start";
    private static final String MULTIPART_BOUNDARY_DELIM = "--";
    private static final String LINE_RETURN_DELIM = "\n";
    public static final String REL100_OPTION_TAG = "100rel";
    protected Message message;
    protected SipFactoryImpl sipFactoryImpl;
    protected SipSessionKey sessionKey;
    protected transient MobicentsSipSession sipSession;
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private transient Transaction transaction;
    protected TransactionApplicationData transactionApplicationData;
    protected SipServletMessage.HeaderForm headerForm = SipServletMessage.HeaderForm.DEFAULT;
    protected transient InetAddress remoteAddr = null;
    protected transient int remotePort = -1;
    protected transient String transport = null;
    protected String currentApplicationName = null;
    protected transient Principal userPrincipal;
    protected boolean isMessageSent;
    protected transient Dialog dialog;
    protected transient String method;

    protected SipServletMessageImpl(Message message, SipFactoryImpl sipFactoryImpl, Transaction transaction, MobicentsSipSession sipSession, Dialog dialog) {
        if (sipFactoryImpl == null) {
            throw new NullPointerException("Null factory");
        }
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        this.sipFactoryImpl = sipFactoryImpl;
        this.message = message;
        this.transaction = transaction;
        if (sipSession != null) {
            this.sessionKey = sipSession.getKey();
        }
        if (transaction != null && this.getMethod().equals("INVITE") && transaction.getApplicationData() != null) {
            this.transactionApplicationData = (TransactionApplicationData)transaction.getApplicationData();
        }
        if (this.transactionApplicationData == null) {
            this.transactionApplicationData = new TransactionApplicationData(this);
        }
        this.isMessageSent = false;
        this.dialog = dialog;
        if (sipSession != null && dialog != null) {
            sipSession.setSessionCreatingDialog(dialog);
            if (dialog.getApplicationData() == null) {
                dialog.setApplicationData((Object)this.transactionApplicationData);
            }
        }
        if (transaction != null && transaction.getApplicationData() == null) {
            transaction.setApplicationData((Object)this.transactionApplicationData);
        }
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("This message is in committed state. You can not modify it");
        }
    }

    public void addAcceptLanguage(Locale locale) {
        this.checkCommitted();
        AcceptLanguageHeader ach = SipFactories.headerFactory.createAcceptLanguageHeader(locale);
        this.message.addHeader((Header)ach);
    }

    public void addAddressHeader(String name, Address addr, boolean first) throws IllegalArgumentException {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding address header [" + hName + "] as first [" + first + "] value [" + addr + "]"));
        }
        if (this.isSystemHeader(hName)) {
            logger.error((Object)("Error, can't add system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, cant add, modify it!!!");
        }
        try {
            String nameToAdd = this.getCorrectHeaderName(hName);
            Header h = SipFactories.headerFactory.createHeader(nameToAdd, addr.toString());
            if (first) {
                this.message.addFirst(h);
            } else {
                this.message.addLast(h);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error adding header", e);
        }
    }

    public void addHeaderInternal(String name, String value, boolean bypassSystemHeaderCheck) {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding header under name [" + hName + "]"));
        }
        if (!bypassSystemHeaderCheck && this.isSystemHeader(hName)) {
            logger.error((Object)("Cant add system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, cant add,cant modify it!!!");
        }
        String nameToAdd = this.getCorrectHeaderName(hName);
        try {
            if (JainSipUtils.SINGLETON_HEADER_NAMES.contains(name)) {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(nameToAdd, value);
                this.message.setHeader(header);
            } else if (JainSipUtils.LIST_HEADER_NAMES.contains(name)) {
                List headers = SipFactory.getInstance().createHeaderFactory().createHeaders(name + ":" + value);
                for (Header header : headers) {
                    this.message.addHeader(header);
                }
            } else {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
                this.message.addLast(header);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied ", ex);
        }
    }

    public void setHeaderInternal(String name, String value, boolean bypassSystemHeaderCheck) {
        if (name == null) {
            throw new NullPointerException("name parameter is null");
        }
        if (value == null) {
            throw new NullPointerException("value parameter is null");
        }
        if (!bypassSystemHeaderCheck && this.isSystemHeader(name)) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        try {
            Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
            this.message.setHeader(header);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating header!", e);
        }
    }

    public void addHeader(String name, String value) {
        this.checkCommitted();
        this.addHeaderInternal(name, value, false);
    }

    public void addParameterableHeader(String name, Parameterable param, boolean first) {
        this.checkCommitted();
        try {
            String hName = SipServletMessageImpl.getFullHeaderName(name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding parametrable header under name [" + hName + "] as first [" + first + "] value [" + param + "]"));
            }
            String body = param.toString();
            String nameToAdd = this.getCorrectHeaderName(hName);
            Header header = SipFactories.headerFactory.createHeader(nameToAdd, body);
            if (first) {
                this.message.addFirst(header);
            } else {
                this.message.addLast(header);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied", ex);
        }
    }

    public Locale getAcceptLanguage() {
        Locale preferredLocale = null;
        float q = 0.0f;
        ListIterator it = this.message.getHeaders("Accept-Language");
        while (it.hasNext()) {
            AcceptLanguageHeader alh = (AcceptLanguageHeader)it.next();
            if (preferredLocale == null) {
                preferredLocale = alh.getAcceptLanguage();
                q = alh.getQValue();
                continue;
            }
            if (!(alh.getQValue() > q)) continue;
            preferredLocale = alh.getAcceptLanguage();
            q = alh.getQValue();
        }
        return preferredLocale;
    }

    public Iterator<Locale> getAcceptLanguages() {
        LinkedList<Locale> ll = new LinkedList<Locale>();
        ListIterator it = this.message.getHeaders("Accept-Language");
        while (it.hasNext()) {
            AcceptLanguageHeader alh = (AcceptLanguageHeader)it.next();
            ll.add(alh.getAcceptLanguage());
        }
        return ll.iterator();
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        String nameToSearch;
        ListIterator headers;
        ListIterator lit;
        if (name == null) {
            throw new NullPointerException();
        }
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching address header for name [" + hName + "]"));
        }
        if ((lit = (headers = this.message.getHeaders(nameToSearch = this.getCorrectHeaderName(hName)))) != null && lit.hasNext()) {
            Header first = (Header)lit.next();
            if (first instanceof HeaderAddress) {
                try {
                    if (this.isCommitted()) {
                        return new AddressImpl((HeaderAddress)first, false);
                    }
                    return new AddressImpl((HeaderAddress)first, true);
                }
                catch (ParseException e) {
                    throw new ServletParseException("Bad address " + first);
                }
            }
            Parameterable parametrable = SipServletMessageImpl.createParameterable(first, first.getName());
            try {
                if (this.isCommitted()) {
                    return new AddressImpl(SipFactories.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), false);
                }
                return new AddressImpl(SipFactories.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), false);
            }
            catch (ParseException e) {
                throw new ServletParseException("Impossible to parse the following header " + name + " as an address.", (Throwable)e);
            }
        }
        return null;
    }

    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        LinkedList<AddressImpl> retval = new LinkedList<AddressImpl>();
        String nameToSearch = this.getCorrectHeaderName(hName);
        ListIterator it = this.message.getHeaders(nameToSearch);
        while (it.hasNext()) {
            AddressImpl addressImpl;
            Header header = (Header)it.next();
            if (header instanceof HeaderAddress) {
                HeaderAddress aph = (HeaderAddress)header;
                try {
                    addressImpl = new AddressImpl(aph, true);
                    retval.add(addressImpl);
                    continue;
                }
                catch (ParseException ex) {
                    throw new ServletParseException("Bad header", (Throwable)ex);
                }
            }
            Parameterable parametrable = SipServletMessageImpl.createParameterable(header, header.getName());
            try {
                addressImpl = new AddressImpl(SipFactories.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), false);
                retval.add(addressImpl);
            }
            catch (ParseException e) {
                throw new ServletParseException("Impossible to parse the following header " + name + " as an address.", (Throwable)e);
            }
        }
        return retval.listIterator();
    }

    public SipApplicationSession getApplicationSession() {
        return this.getApplicationSession(true);
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        MobicentsSipApplicationSession sipApplicationSession;
        MobicentsSipSession sipSession = this.getSipSession();
        if (sipSession != null && (sipApplicationSession = sipSession.getSipApplicationSession()) != null) {
            return sipApplicationSession;
        }
        String applicationName = null;
        if (this.sessionKey != null) {
            applicationName = this.sessionKey.getApplicationName();
        }
        if (applicationName != null) {
            SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(applicationName);
            SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, this.sessionKey.getApplicationSessionId());
            MobicentsSipApplicationSession applicationSession = sipContext.getSipManager().getSipApplicationSession(sipApplicationSessionKey, create);
            return applicationSession;
        }
        return null;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name can not be null.");
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        Vector<String> names = new Vector<String>(this.attributes.keySet());
        return names.elements();
    }

    public String getCallId() {
        CallIdHeader id = (CallIdHeader)this.message.getHeader(this.getCorrectHeaderName("Call-ID"));
        if (id != null) {
            return id.getCallId();
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this.message.getContentEncoding() != null) {
            return this.message.getContentEncoding().getEncoding();
        }
        ContentTypeHeader cth = (ContentTypeHeader)this.message.getHeader("Content-Type");
        if (cth == null) {
            return null;
        }
        return cth.getParameter("charset");
    }

    public Object getContent() throws IOException, UnsupportedEncodingException {
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.message.getHeader("Content-Type");
        if (contentTypeHeader != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Content type " + contentTypeHeader.getContentType()));
            logger.debug((Object)("Content sub type " + contentTypeHeader.getContentSubType()));
        }
        if (contentTypeHeader != null && CONTENT_TYPE_TEXT.equals(contentTypeHeader.getContentType())) {
            String charset;
            String content = null;
            content = this.message.getRawContent() != null ? ((charset = this.getCharacterEncoding()) == null ? new String(this.message.getRawContent()) : new String(this.message.getRawContent(), charset)) : "";
            return content;
        }
        if (contentTypeHeader != null && CONTENT_TYPE_MULTIPART.equals(contentTypeHeader.getContentType())) {
            return SipServletMessageImpl.getContentAsMimeMultipart(contentTypeHeader, this.message.getRawContent());
        }
        return this.message.getRawContent();
    }

    private static MimeMultipart getContentAsMimeMultipart(ContentTypeHeader contentTypeHeader, byte[] rawContent) {
        String delimiter = contentTypeHeader.getParameter(MULTIPART_BOUNDARY);
        String start = contentTypeHeader.getParameter(MULTIPART_START);
        MimeMultipart mimeMultipart = new MimeMultipart(contentTypeHeader.getContentSubType());
        if (delimiter == null) {
            MimeBodyPart mbp = new MimeBodyPart();
            ByteArrayDataSource ds = new ByteArrayDataSource(rawContent, contentTypeHeader.getContentSubType());
            try {
                mbp.setDataHandler(new DataHandler((DataSource)ds));
                mimeMultipart.addBodyPart((BodyPart)mbp);
            }
            catch (MessagingException e) {
                throw new IllegalArgumentException("couldn't create the multipart object from the message content " + rawContent, e);
            }
        } else {
            String[] fragments;
            for (String fragment : fragments = new String(rawContent).split(MULTIPART_BOUNDARY_DELIM + delimiter)) {
                int indexOfStart;
                String trimmedFragment = fragment.trim();
                if (trimmedFragment.length() <= 0 || MULTIPART_BOUNDARY_DELIM.equals(trimmedFragment)) continue;
                String fragmentHeaders = null;
                String fragmentBody = fragment;
                if (start != null && start.length() > 0 && (indexOfStart = fragment.indexOf(start)) != -1) {
                    fragmentHeaders = fragmentBody.substring(0, indexOfStart + start.length());
                    fragmentBody = fragmentBody.substring(indexOfStart + start.length()).trim();
                }
                MimeBodyPart mbp = new MimeBodyPart();
                try {
                    String contentType = contentTypeHeader.getContentSubType();
                    if (fragmentBody.startsWith("Content-Type")) {
                        int indexOfLineReturn = fragmentBody.indexOf(LINE_RETURN_DELIM);
                        contentType = fragmentBody.substring(0, indexOfLineReturn - 1).trim();
                        fragmentBody = fragmentBody.substring(indexOfLineReturn).trim();
                    }
                    mbp.setContent((Object)fragmentBody, contentType);
                    mbp.addHeaderLine(contentType);
                    if (fragmentHeaders != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(fragmentHeaders, LINE_RETURN_DELIM);
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken().trim();
                            if (token == null || token.length() <= 0) continue;
                            mbp.addHeaderLine(token);
                        }
                    }
                    mimeMultipart.addBodyPart((BodyPart)mbp);
                }
                catch (MessagingException e) {
                    throw new IllegalArgumentException("couldn't create the multipart object from the message content " + rawContent, e);
                }
            }
        }
        return mimeMultipart;
    }

    public Locale getContentLanguage() {
        if (this.message.getContentLanguage() != null) {
            return this.message.getContentLanguage().getContentLanguage();
        }
        return null;
    }

    public int getContentLength() {
        if (this.message.getContentLength() != null) {
            return this.message.getContentLength().getContentLength();
        }
        return 0;
    }

    public String getContentType() {
        ContentTypeHeader cth = (ContentTypeHeader)this.message.getHeader(this.getCorrectHeaderName("Content-Type"));
        if (cth != null) {
            String contentType = cth.getContentType();
            String contentSubType = cth.getContentSubType();
            if (contentSubType != null) {
                return contentType + "/" + contentSubType;
            }
            return contentType;
        }
        return null;
    }

    public int getExpires() {
        if (this.message.getExpires() != null) {
            return this.message.getExpires().getExpires();
        }
        return -1;
    }

    public Address getFrom() {
        FromHeader from = (FromHeader)this.message.getHeader(this.getCorrectHeaderName("From"));
        AddressImpl address = new AddressImpl(from.getAddress(), AddressImpl.getParameters((Parameters)from), this.transaction == null);
        return address;
    }

    public String getHeader(String name) {
        String nameToSearch = this.getCorrectHeaderName(name);
        String value = null;
        if (this.message.getHeader(nameToSearch) != null) {
            value = ((SIPHeader)this.message.getHeader(nameToSearch)).getValue();
        }
        return value;
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return this.headerForm;
    }

    public Iterator<String> getHeaderNames() {
        return this.message.getHeaderNames();
    }

    public ListIterator<String> getHeaders(String name) {
        String nameToSearch = this.getCorrectHeaderName(name);
        ArrayList<String> result = new ArrayList<String>();
        try {
            ListIterator list = this.message.getHeaders(nameToSearch);
            while (list != null && list.hasNext()) {
                Header h = (Header)list.next();
                result.add(((SIPHeader)h).getHeaderValue());
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("Couldnt fetch headers, original name[" + name + "], name searched[" + nameToSearch + "]"), (Throwable)e);
            return result.listIterator();
        }
        return result.listIterator();
    }

    public final String getMethod() {
        if (this.method == null) {
            this.method = this.message instanceof Request ? ((Request)this.message).getMethod() : ((CSeqHeader)this.message.getHeader("CSeq")).getMethod();
        }
        return this.method;
    }

    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        if (name == null) {
            throw new NullPointerException("Parametrable header name cant be null!!!");
        }
        String nameToSearch = this.getCorrectHeaderName(name);
        Header h = this.message.getHeader(nameToSearch);
        if (!SipServletMessageImpl.isParameterable(name)) {
            throw new ServletParseException(name + " header is not parameterable !");
        }
        if (h == null) {
            return null;
        }
        return SipServletMessageImpl.createParameterable(h, SipServletMessageImpl.getFullHeaderName(name));
    }

    public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        ListIterator headers = this.message.getHeaders(this.getCorrectHeaderName(name));
        ArrayList<Parameterable> result = new ArrayList<Parameterable>();
        while (headers != null && headers.hasNext()) {
            result.add(SipServletMessageImpl.createParameterable((Header)headers.next(), SipServletMessageImpl.getFullHeaderName(name)));
        }
        if (!SipServletMessageImpl.isParameterable(name)) {
            throw new ServletParseException(name + " header is not parameterable !");
        }
        return result.listIterator();
    }

    public String getProtocol() {
        return "SIP/2.0";
    }

    public byte[] getRawContent() throws IOException {
        if (this.message != null) {
            return this.message.getRawContent();
        }
        return null;
    }

    public String getInitialRemoteAddr() {
        return this.transactionApplicationData.getInitialRemoteHostAddress();
    }

    public int getInitialRemotePort() {
        return this.transactionApplicationData.getInitialRemotePort();
    }

    public String getInitialTransport() {
        return this.transactionApplicationData.getInitialRemoteTransport();
    }

    public String getRemoteAddr() {
        if (this.getTransaction() != null) {
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.getTransaction() != null) {
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourcePort();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerPort();
        }
        return -1;
    }

    public String getTransport() {
        if (this.getTransaction() != null) {
            return ((SIPTransaction)this.getTransaction()).getTransport();
        }
        return null;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public SipSession getSession() {
        return this.getSession(true);
    }

    public SipSession getSession(boolean create) {
        MobicentsSipSession session = this.getSipSession();
        if (session == null && create) {
            MobicentsSipApplicationSession sipApplicationSessionImpl = (MobicentsSipApplicationSession)this.getApplicationSession(create);
            SipSessionKey sessionKey = SessionManagerUtil.getSipSessionKey(sipApplicationSessionImpl.getKey().getId(), this.currentApplicationName, this.message, false);
            session = ((SipManager)sipApplicationSessionImpl.getSipContext().getManager()).getSipSession(sessionKey, create, this.sipFactoryImpl, sipApplicationSessionImpl);
            session.setSessionCreatingTransactionRequest(this);
            sessionKey = session.getKey();
        }
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    public final MobicentsSipSession getSipSession() {
        if (this.sipSession == null && this.sessionKey != null) {
            String applicationName = this.sessionKey.getApplicationName();
            SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(applicationName);
            SipApplicationSessionKey sipApplicationSessionKey = new SipApplicationSessionKey(this.sessionKey.getApplicationSessionId(), this.sessionKey.getApplicationName());
            MobicentsSipApplicationSession sipApplicationSession = sipContext.getSipManager().getSipApplicationSession(sipApplicationSessionKey, false);
            this.sipSession = sipContext.getSipManager().getSipSession(this.sessionKey, false, this.sipFactoryImpl, sipApplicationSession);
        }
        return this.sipSession;
    }

    public void setSipSession(MobicentsSipSession session) {
        this.sipSession = session;
        this.sessionKey = session != null ? session.getKey() : null;
    }

    public SipSessionKey getSipSessionKey() {
        return this.sessionKey;
    }

    public Address getTo() {
        ToHeader to = (ToHeader)this.message.getHeader(this.getCorrectHeaderName("To"));
        return new AddressImpl(to.getAddress(), AddressImpl.getParameters((Parameters)to), this.transaction == null);
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null && this.getSipSession() != null) {
            this.userPrincipal = this.getSipSession().getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public boolean isSecure() {
        return "TLS".equalsIgnoreCase(JainSipUtils.findTransport(this.message));
    }

    public boolean isUserInRole(String role) {
        if (this.userPrincipal != null) {
            return ((GenericPrincipal)this.userPrincipal).hasRole(role);
        }
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeHeader(String name) {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (this.isSystemHeader(hName)) {
            throw new IllegalArgumentException("Cant remove system header[" + hName + "]");
        }
        String nameToSearch = this.getCorrectHeaderName(hName);
        this.message.removeHeader(nameToSearch);
    }

    public void removeHeaderInternal(String name, boolean bypassSystemHeaderCheck) {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing header under name [" + hName + "]"));
        }
        if (!bypassSystemHeaderCheck && this.isSystemHeader(hName)) {
            logger.error((Object)("Cant remove system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, can't remove it!!!");
        }
        String nameToRemove = this.getCorrectHeaderName(hName);
        try {
            this.message.removeHeader(nameToRemove);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied ", ex);
        }
    }

    public abstract void send();

    public void setAcceptLanguage(Locale locale) {
        this.checkCommitted();
        AcceptLanguageHeader alh = SipFactories.headerFactory.createAcceptLanguageHeader(locale);
        this.message.setHeader((Header)alh);
    }

    public void setAddressHeader(String name, Address addr) {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting address header [" + name + "] to value [" + addr + "]"));
        }
        if (this.isSystemHeader(hName)) {
            logger.error((Object)("Error, cant remove system header [" + hName + "]"));
            throw new IllegalArgumentException("Cant set system header, it is maintained by container!!");
        }
        String headerNameToAdd = this.getCorrectHeaderName(hName);
        try {
            Header h = SipFactories.headerFactory.createHeader(headerNameToAdd, addr.toString());
            this.message.setHeader(h);
        }
        catch (ParseException e) {
            logger.error((Object)("Parsing problem while setting address header with name " + name + " and address " + addr), (Throwable)e);
        }
    }

    public void setAttribute(String name, Object o) {
        if (name == null) {
            throw new NullPointerException("Attribute name can not be null.");
        }
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        new String("testEncoding".getBytes(), enc);
        this.checkCommitted();
        try {
            this.message.setContentEncoding(SipFactories.headerFactory.createContentEncodingHeader(enc));
        }
        catch (Exception ex) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        this.checkMessageState();
        this.checkContentType(contentType);
        this.checkCommitted();
        if (contentType != null && contentType.length() > 0) {
            this.addHeader("Content-Type", contentType);
            String charset = this.getCharacterEncoding();
            try {
                Object tmpContent = content;
                if (tmpContent instanceof String && charset != null) {
                    new String("testEncoding".getBytes(charset));
                    tmpContent = new String(((String)tmpContent).getBytes());
                }
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.message.getHeader("Content-Type");
                this.message.setContent(content, contentTypeHeader);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Parse error reading content type", e);
            }
        }
    }

    protected abstract void checkMessageState();

    private void checkContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("the content type cannot be null");
        }
        int indexOfSlash = contentType.indexOf("/");
        if (indexOfSlash != -1 ? !JainSipUtils.IANA_ALLOWED_CONTENT_TYPES.contains(contentType.substring(0, indexOfSlash)) : !JainSipUtils.IANA_ALLOWED_CONTENT_TYPES.contains(contentType.toLowerCase())) {
            throw new IllegalArgumentException("the given content type " + contentType + " is not allowed");
        }
    }

    public void setContentLanguage(Locale locale) {
        this.checkCommitted();
        ContentLanguageHeader contentLanguageHeader = SipFactories.headerFactory.createContentLanguageHeader(locale);
        this.message.setContentLanguage(contentLanguageHeader);
    }

    public void setContentLength(int len) {
        this.checkMessageState();
        this.checkCommitted();
        try {
            ContentLengthHeader h = SipFactories.headerFactory.createContentLengthHeader(len);
            this.message.setHeader((Header)h);
        }
        catch (InvalidArgumentException e) {
            throw new IllegalStateException("Impossible to set a content length lower than 0", e);
        }
    }

    public void setContentType(String type) {
        this.checkContentType(type);
        this.checkCommitted();
        String name = this.getCorrectHeaderName("Content-Type");
        try {
            Header h = SipFactories.headerFactory.createHeader(name, type);
            this.message.removeHeader(this.getCorrectHeaderName("Content-Type"));
            this.message.addHeader(h);
        }
        catch (ParseException e) {
            logger.error((Object)"Error while setting content type header !!!", (Throwable)e);
        }
    }

    public void setExpires(int seconds) {
        try {
            ExpiresHeader expiresHeader = SipFactories.headerFactory.createExpiresHeader(seconds);
            expiresHeader.setExpires(seconds);
            this.message.setExpires(expiresHeader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error setting expiration header!", e);
        }
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name parameter is null");
        }
        if (value == null) {
            throw new NullPointerException("value parameter is null");
        }
        if (this.isSystemHeader(name)) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        this.checkCommitted();
        try {
            if (JainSipUtils.LIST_HEADER_NAMES.contains(name)) {
                this.message.removeHeader(name);
                List headers = SipFactory.getInstance().createHeaderFactory().createHeaders(name + ":" + value);
                for (Header header : headers) {
                    this.message.addHeader(header);
                }
            } else {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
                this.message.setHeader(header);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating header!", e);
        }
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        this.headerForm = form;
        if (form == SipServletMessage.HeaderForm.DEFAULT) {
            return;
        }
    }

    public void setParameterableHeader(String name, Parameterable param) {
        this.checkCommitted();
        if (this.isSystemHeader(name)) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        try {
            this.message.setHeader(SipFactories.headerFactory.createHeader(name, param.toString()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set this parameterable header", e);
        }
    }

    public abstract boolean isSystemHeader(String var1);

    public static boolean isAddressTypeHeader(String headerName) {
        return JainSipUtils.ADDRESS_HEADER_NAMES.contains(SipServletMessageImpl.getFullHeaderName(headerName));
    }

    protected static String getFullHeaderName(String headerName) {
        String fullName = null;
        fullName = JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.containsKey(headerName) ? JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.get(headerName) : headerName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching full header name for [" + headerName + "] returning [" + fullName + "]"));
        }
        return fullName;
    }

    public static String getCompactName(String headerName) {
        String compactName = null;
        compactName = JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.containsKey(headerName) ? JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.get(headerName) : JainSipUtils.HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.get(headerName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching compact header name for [" + headerName + "] returning [" + compactName + "]"));
        }
        return compactName;
    }

    public String getCorrectHeaderName(String name) {
        return SipServletMessageImpl.getCorrectHeaderName(name, this.headerForm);
    }

    protected static String getCorrectHeaderName(String name, SipServletMessage.HeaderForm form) {
        if (form == SipServletMessage.HeaderForm.DEFAULT) {
            return name;
        }
        if (form == SipServletMessage.HeaderForm.COMPACT) {
            String compact = SipServletMessageImpl.getCompactName(name);
            if (compact != null) {
                return compact;
            }
            return name;
        }
        if (form == SipServletMessage.HeaderForm.LONG) {
            return SipServletMessageImpl.getFullHeaderName(name);
        }
        throw new IllegalStateException("No default form of a header set!!!");
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.message.toString();
    }

    public TransactionApplicationData getTransactionApplicationData() {
        return this.transactionApplicationData;
    }

    public Message getMessage() {
        return this.message;
    }

    public Dialog getDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        if (this.transaction != null) {
            return this.transaction.getDialog();
        }
        return null;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    protected static Parameterable createParameterable(Header header, String hName) throws ServletParseException {
        String whole = header.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating parametrable for [" + hName + "] from [" + whole + "]"));
        }
        String stringHeader = whole.substring(whole.indexOf(":") + 1).trim();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String value = stringHeader;
        if (stringHeader.trim().indexOf("<") == 0) {
            stringHeader = stringHeader.substring(1);
            String[] split = stringHeader.split(">");
            value = split[0];
            if (split.length > 1 && split[1].contains(";")) {
                split[1] = split[1].replaceFirst(";", "");
                for (String pair : split = split[1].split(";")) {
                    String[] vals = pair.split("=");
                    if (vals.length > 2) {
                        logger.error((Object)("Wrong parameter format, expected value and name, got [" + pair + "]"));
                        throw new ServletParseException("Wrong parameter format, expected value or name[" + pair + "]");
                    }
                    paramMap.put(vals[0], vals.length == 2 ? vals[1] : "");
                }
            }
        } else if (value.length() > 1 && value.contains(";")) {
            String[] split;
            String parameters = value.substring(value.indexOf(";") + 1);
            value = value.substring(0, value.indexOf(";"));
            for (String pair : split = parameters.split(";")) {
                String[] vals = pair.split("=");
                if (vals.length > 2) {
                    logger.error((Object)("Wrong parameter format, expected value and name, got [" + pair + "]"));
                    throw new ServletParseException("Wrong parameter format, expected value or name[" + pair + "]");
                }
                paramMap.put(vals[0], vals.length == 2 ? vals[1] : "");
            }
        }
        boolean isNotModifiable = JainSipUtils.SYSTEM_HEADERS.contains(header.getName());
        ParameterableHeaderImpl parameterable = new ParameterableHeaderImpl(header, value, paramMap, isNotModifiable);
        return parameterable;
    }

    public static boolean isParameterable(String header) {
        return JainSipUtils.PARAMETERABLE_HEADER_NAMES.contains(header);
    }

    public String getCurrentApplicationName() {
        return this.currentApplicationName;
    }

    public void setCurrentApplicationName(String currentApplicationName) {
        this.currentApplicationName = currentApplicationName;
    }

    public String getLocalAddr() {
        SIPTransaction sipTransaction = (SIPTransaction)this.getTransaction();
        if (sipTransaction != null) {
            return sipTransaction.getHostPort().getHost().getIpAddress();
        }
        String transport = JainSipUtils.findTransport(this.message);
        ExtendedListeningPoint listeningPoint = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
        return listeningPoint.getHost(true);
    }

    public int getLocalPort() {
        SIPTransaction sipTransaction = (SIPTransaction)this.getTransaction();
        if (sipTransaction != null) {
            return sipTransaction.getPort();
        }
        String transport = JainSipUtils.findTransport(this.message);
        ExtendedListeningPoint listeningPoint = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
        return listeningPoint.getPort();
    }

    protected boolean containsRel100(Message message) {
        ListIterator supportedHeaders;
        ListIterator requireHeaders = message.getHeaders("Require");
        if (requireHeaders != null) {
            while (requireHeaders.hasNext()) {
                if (!REL100_OPTION_TAG.equals(((SIPHeader)requireHeaders.next()).getValue())) continue;
                return true;
            }
        }
        if ((supportedHeaders = message.getHeaders("Supported")) != null) {
            while (supportedHeaders.hasNext()) {
                if (!REL100_OPTION_TAG.equals(((SIPHeader)supportedHeaders.next()).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void cleanUp();
}

