/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.sip.SipException;
import javax.sip.address.TelURL;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.GenericURIImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.security.AuthInfoImpl;
import org.mobicents.servlet.sip.startup.SipContext;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SipFactoryImpl
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipFactoryImpl.class.getCanonicalName());
    private static final String TAG_PARAM = "tag";
    private static final String METHOD_PARAM = "method";
    private static final String MADDR_PARAM = "maddr";
    private static final String TTL_PARAM = "ttl";
    private static final String TRANSPORT_PARAM = "transport";
    private static final String LR_PARAM = "lr";
    private boolean useLoadBalancer = false;
    private SipLoadBalancer loadBalancerToUse = null;
    public static final Set<String> FORBIDDEN_PARAMS = new HashSet<String>();
    private transient SipApplicationDispatcher sipApplicationDispatcher = null;

    public SipFactoryImpl() {
    }

    public SipFactoryImpl(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public Address createAddress(String sipAddress) throws ServletParseException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating Address from [" + sipAddress + "]"));
            }
            AddressImpl retval = new AddressImpl();
            retval.setValue(sipAddress);
            return retval;
        }
        catch (IllegalArgumentException e) {
            throw new ServletParseException((Throwable)e);
        }
    }

    public Address createAddress(URI uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Address fromm URI[" + uri.toString() + "]"));
        }
        URIImpl uriImpl = (URIImpl)uri;
        return new AddressImpl(SipFactories.addressFactory.createAddress(uriImpl.getURI()), null, true);
    }

    public Address createAddress(URI uri, String displayName) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating Address from URI[" + uri.toString() + "] with display name[" + displayName + "]"));
            }
            javax.sip.address.Address address = SipFactories.addressFactory.createAddress(((URIImpl)uri).getURI());
            address.setDisplayName(displayName);
            return new AddressImpl(address, null, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SipApplicationSession createApplicationSession() {
        throw new UnsupportedOperationException("use createApplicationSession(SipContext sipContext) instead !");
    }

    public SipApplicationSession createApplicationSession(SipContext sipContext) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new application session for sip context " + sipContext.getApplicationName()));
        }
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(sipContext.getApplicationName(), null);
        MobicentsSipApplicationSession sipApplicationSession = ((SipManager)sipContext.getManager()).getSipApplicationSession(sipApplicationSessionKey, true);
        return sipApplicationSession.getSession();
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, Address from, Address to, String handler, String originalCallId, String fromTagToUse) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM_A[" + from + "] TO_A[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        try {
            return this.createSipServletRequest(sipAppSession, method, (Address)from.clone(), (Address)to.clone(), handler, originalCallId, fromTagToUse);
        }
        catch (ServletParseException e) {
            logger.error((Object)"Error creating sipServletRequest", (Throwable)e);
            return null;
        }
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, URI from, URI to, String handler) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM_URI[" + from + "] TO_URI[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        Address toA = this.createAddress(to.clone());
        Address fromA = this.createAddress(from.clone());
        try {
            return this.createSipServletRequest(sipAppSession, method, fromA, toA, handler, null, null);
        }
        catch (ServletParseException e) {
            logger.error((Object)"Error creating sipServletRequest", (Throwable)e);
            return null;
        }
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, String from, String to, String handler) throws ServletParseException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM[" + from + "] TO[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        Address toA = this.createAddress(to);
        Address fromA = this.createAddress(from);
        return this.createSipServletRequest(sipAppSession, method, fromA, toA, handler, null, null);
    }

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean sameCallId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating SipServletRequest from original request[" + origRequest + "] with same call id[" + sameCallId + "]"));
        }
        return origRequest.getB2buaHelper().createRequest(origRequest);
    }

    public SipURI createSipURI(String user, String host) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating SipURI from USER[" + user + "] HOST[" + host + "]"));
        }
        try {
            return new SipURIImpl(SipFactories.addressFactory.createSipURI(user, host));
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + user + "] HOST[" + host + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + user + " host = " + host);
        }
    }

    public URI createURI(String uri) throws ServletParseException {
        try {
            javax.sip.address.URI jainUri = SipFactories.addressFactory.createURI(uri);
            if (jainUri instanceof javax.sip.address.SipURI) {
                return new SipURIImpl((javax.sip.address.SipURI)jainUri);
            }
            if (jainUri instanceof TelURL) {
                return new TelURLImpl((TelURL)jainUri);
            }
            return new GenericURIImpl(jainUri);
        }
        catch (ParseException ex) {
            throw new ServletParseException("Bad param " + uri, (Throwable)ex);
        }
    }

    private static void validateCreation(String method, SipApplicationSession app) {
        if (method.equals("ACK")) {
            throw new IllegalArgumentException("Wrong method to create request with[ACK]!");
        }
        if (method.equals("PRACK")) {
            throw new IllegalArgumentException("Wrong method to create request with[PRACK]!");
        }
        if (method.equals("CANCEL")) {
            throw new IllegalArgumentException("Wrong method to create request with[CANCEL]!");
        }
        if (!((MobicentsSipApplicationSession)app).isValidInternal()) {
            throw new IllegalArgumentException("Cant associate request with invalidaded sip session application!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SipServletRequest createSipServletRequest(SipApplicationSession sipAppSession, String method, Address from, Address to, String handler, String originalCallId, String fromTagToUse) throws ServletParseException {
        MobicentsSipApplicationSession mobicentsSipApplicationSession = (MobicentsSipApplicationSession)sipAppSession;
        Request requestToWrap = null;
        ContactHeader contactHeader = null;
        ToHeader toHeader = null;
        FromHeader fromHeader = null;
        CSeqHeader cseqHeader = null;
        CallIdHeader callIdHeader = null;
        MaxForwardsHeader maxForwardsHeader = null;
        String transport = "UDP";
        javax.sip.address.Address fromAddress = null;
        try {
            for (String param : FORBIDDEN_PARAMS) {
                from.getURI().removeParameter(param);
            }
            from.removeParameter(TAG_PARAM);
            fromAddress = SipFactories.addressFactory.createAddress(((URIImpl)from.getURI()).getURI());
            fromAddress.setDisplayName(from.getDisplayName());
            fromHeader = SipFactories.headerFactory.createFromHeader(fromAddress, null);
        }
        catch (Exception pe) {
            throw new ServletParseException("Impossoible to parse the given From " + from.toString(), (Throwable)pe);
        }
        javax.sip.address.Address toAddress = null;
        try {
            for (String param : FORBIDDEN_PARAMS) {
                to.getURI().removeParameter(param);
            }
            to.removeParameter(TAG_PARAM);
            toAddress = SipFactories.addressFactory.createAddress(((URIImpl)to.getURI()).getURI());
            toAddress.setDisplayName(to.getDisplayName());
            toHeader = SipFactories.headerFactory.createToHeader(toAddress, null);
        }
        catch (Exception pe) {
            throw new ServletParseException("Impossoible to parse the given To " + to.toString(), (Throwable)pe);
        }
        try {
            cseqHeader = SipFactories.headerFactory.createCSeqHeader(1L, method);
            SipApplicationSessionKey sipApplicationSessionKey = mobicentsSipApplicationSession.getKey();
            if (originalCallId == null) {
                Iterator<ExtendedListeningPoint> listeningPointsIterator = this.getSipNetworkInterfaceManager().getExtendedListeningPoints();
                if (!listeningPointsIterator.hasNext()) throw new IllegalStateException("There is no SIP connectors available to create the request");
                callIdHeader = SipFactories.headerFactory.createCallIdHeader(listeningPointsIterator.next().getSipProvider().getNewCallId().getCallId());
            } else {
                callIdHeader = SipFactories.headerFactory.createCallIdHeader(originalCallId);
            }
            maxForwardsHeader = SipFactories.headerFactory.createMaxForwardsHeader(70);
            URIImpl requestURI = (URIImpl)to.getURI().clone();
            ArrayList viaHeaders = new ArrayList();
            requestToWrap = SipFactories.messageFactory.createRequest(requestURI.getURI(), method, callIdHeader, cseqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
            if (JainSipUtils.CONTACT_HEADER_METHODS.contains(method)) {
                String fromName = null;
                if (fromHeader.getAddress().getURI() instanceof javax.sip.address.SipURI) {
                    fromName = ((javax.sip.address.SipURI)fromHeader.getAddress().getURI()).getUser();
                }
                contactHeader = null;
                if (this.useLoadBalancer) {
                    javax.sip.address.SipURI sipURI = SipFactories.addressFactory.createSipURI(fromName, this.loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setHost(this.loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setPort(this.loadBalancerToUse.getSipPort());
                    sipURI.setTransportParam(transport);
                    javax.sip.address.Address contactAddress = SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipURI);
                    if (fromName != null && fromName.length() > 0) {
                        contactAddress.setDisplayName(fromName);
                    }
                    contactHeader = SipFactories.headerFactory.createContactHeader(contactAddress);
                } else {
                    contactHeader = JainSipUtils.createContactHeader(this.getSipNetworkInterfaceManager(), requestToWrap, fromName, null);
                }
            }
            if (contactHeader != null) {
                requestToWrap.addHeader(contactHeader);
            }
            if (fromTagToUse == null) {
                fromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.sipApplicationDispatcher, sipAppSession.getApplicationName(), sipApplicationSessionKey.getId()));
            } else {
                fromHeader.setTag(fromTagToUse);
            }
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(mobicentsSipApplicationSession.getKey().getId(), mobicentsSipApplicationSession.getKey().getApplicationName(), (Message)requestToWrap, false);
            MobicentsSipSession session = ((SipManager)mobicentsSipApplicationSession.getSipContext().getManager()).getSipSession(key, true, this, mobicentsSipApplicationSession);
            session.setHandler(handler);
            session.setLocalParty(new AddressImpl(fromAddress, null, false));
            session.setRemoteParty(new AddressImpl(toAddress, null, false));
            return new SipServletRequestImpl(requestToWrap, this, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(method));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating sipServletRequest", e);
        }
    }

    public Parameterable createParameterable(String value) throws ServletParseException {
        try {
            Header header = SipFactories.headerFactory.createHeader("Contact", value);
            return SipServletMessageImpl.createParameterable(header, SipServletMessageImpl.getFullHeaderName(header.getName()));
        }
        catch (ParseException e) {
            try {
                Header header = SipFactories.headerFactory.createHeader("Content-Type", value);
                return SipServletMessageImpl.createParameterable(header, SipServletMessageImpl.getFullHeaderName(header.getName()));
            }
            catch (ParseException pe) {
                throw new ServletParseException("Impossible to parse the following parameterable " + value, (Throwable)pe);
            }
        }
    }

    public SipApplicationRouterInfo getNextInterestedApplication(SipServletRequestImpl sipServletRequestImpl) {
        return this.sipApplicationDispatcher.getNextInterestedApplication(sipServletRequestImpl);
    }

    public SipApplicationSession createApplicationSessionByAppName(String sipAppName) {
        SipContext sipContext;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new application session for application name " + sipAppName));
        }
        if ((sipContext = this.sipApplicationDispatcher.findSipApplication(sipAppName)) == null) {
            throw new IllegalArgumentException("The specified application " + sipAppName + " is not currently deployed");
        }
        return this.createApplicationSession(sipContext);
    }

    public SipApplicationSession createApplicationSessionByKey(String sipApplicationKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new application session by following key " + sipApplicationKey));
        }
        SipApplicationSessionKey sipApplicationSessionKey = null;
        try {
            sipApplicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey(sipApplicationKey);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(sipApplicationKey + " is not a valid sip application session key", e);
        }
        SipContext sipContext = this.sipApplicationDispatcher.findSipApplication(sipApplicationSessionKey.getApplicationName());
        if (sipContext == null) {
            throw new IllegalArgumentException("The specified application " + sipApplicationSessionKey.getApplicationName() + " is not currently deployed");
        }
        MobicentsSipApplicationSession sipApplicationSession = ((SipManager)sipContext.getManager()).getSipApplicationSession(sipApplicationSessionKey, true);
        return sipApplicationSession.getSession();
    }

    public AuthInfo createAuthInfo() {
        return new AuthInfoImpl();
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        return this.sipApplicationDispatcher;
    }

    public void setSipApplicationDispatcher(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public SipNetworkInterfaceManager getSipNetworkInterfaceManager() {
        return this.sipApplicationDispatcher.getSipNetworkInterfaceManager();
    }

    public SipLoadBalancer getLoadBalancerToUse() {
        return this.loadBalancerToUse;
    }

    public void setLoadBalancerToUse(SipLoadBalancer loadBalancerToUse) {
        this.useLoadBalancer = loadBalancerToUse != null;
        this.loadBalancerToUse = loadBalancerToUse;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Load Balancer to Use " + loadBalancerToUse));
        }
    }

    public boolean isUseLoadBalancer() {
        return this.useLoadBalancer;
    }

    public void addLoadBalancerRouteHeader(Request request) {
        try {
            String host = null;
            int port = -1;
            String proxy = StaticServiceHolder.sipStandardService.getOutboundProxy();
            if (proxy == null) {
                host = this.loadBalancerToUse.getAddress().getHostAddress();
                port = this.loadBalancerToUse.getSipPort();
            } else {
                int separatorIndex = proxy.indexOf(":");
                if (separatorIndex > 0) {
                    host = proxy.substring(0, separatorIndex);
                    port = Integer.parseInt(proxy.substring(separatorIndex + 1));
                }
            }
            javax.sip.address.SipURI sipUri = SipFactories.addressFactory.createSipURI(null, host);
            sipUri.setPort(port);
            sipUri.setLrParam();
            String transport = JainSipUtils.findTransport((Message)request);
            sipUri.setTransportParam(transport);
            ExtendedListeningPoint listeningPoint = this.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
            sipUri.setParameter("node_host", listeningPoint.getHost(JainSipUtils.findUsePublicAddress(this.getSipNetworkInterfaceManager(), (Message)request, listeningPoint)));
            sipUri.setParameter("node_port", "" + listeningPoint.getPort());
            javax.sip.address.Address routeAddress = SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipUri);
            RouteHeader routeHeader = SipFactories.headerFactory.createRouteHeader(routeAddress);
            request.addFirst((Header)routeHeader);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
        catch (SipException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
    }

    public void addIpLoadBalancerRouteHeader(Request request, String lbhost, int lbport) {
        try {
            String host = null;
            int port = -1;
            String proxy = StaticServiceHolder.sipStandardService.getOutboundProxy();
            if (proxy == null) {
                host = lbhost;
                port = lbport;
            } else {
                int separatorIndex = proxy.indexOf(":");
                if (separatorIndex > 0) {
                    host = proxy.substring(0, separatorIndex);
                    port = Integer.parseInt(proxy.substring(separatorIndex + 1));
                }
            }
            javax.sip.address.SipURI sipUri = SipFactories.addressFactory.createSipURI(null, host);
            sipUri.setPort(port);
            sipUri.setLrParam();
            String transport = JainSipUtils.findTransport((Message)request);
            sipUri.setTransportParam(transport);
            ExtendedListeningPoint listeningPoint = this.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
            sipUri.setParameter("node_host", listeningPoint.getHost(JainSipUtils.findUsePublicAddress(this.getSipNetworkInterfaceManager(), (Message)request, listeningPoint)));
            sipUri.setParameter("node_port", "" + listeningPoint.getPort());
            javax.sip.address.Address routeAddress = SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipUri);
            RouteHeader routeHeader = SipFactories.headerFactory.createRouteHeader(routeAddress);
            request.addFirst((Header)routeHeader);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
        catch (SipException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.useLoadBalancer = in.readBoolean();
        if (this.useLoadBalancer) {
            this.loadBalancerToUse = (SipLoadBalancer)in.readObject();
        }
        this.sipApplicationDispatcher = StaticServiceHolder.sipStandardService.getSipApplicationDispatcher();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.useLoadBalancer);
        if (this.useLoadBalancer) {
            out.writeObject(this.loadBalancerToUse);
        }
    }

    static {
        FORBIDDEN_PARAMS.add(TAG_PARAM);
        FORBIDDEN_PARAMS.add(METHOD_PARAM);
        FORBIDDEN_PARAMS.add(MADDR_PARAM);
        FORBIDDEN_PARAMS.add(TTL_PARAM);
        FORBIDDEN_PARAMS.add(TRANSPORT_PARAM);
        FORBIDDEN_PARAMS.add(LR_PARAM);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamesComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

