/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.message.SIPMessage;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B2buaHelperImpl
implements B2buaHelper,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(B2buaHelperImpl.class);
    protected static final Set<String> B2BUA_SYSTEM_HEADERS = new HashSet<String>();
    protected static final Set<String> CONTACT_FORBIDDEN_PARAMETER;
    private Map<SipSessionKey, SipSessionKey> sessionMap = new ConcurrentHashMap<SipSessionKey, SipSessionKey>();
    private transient Map<SipServletRequestImpl, SipServletRequestImpl> originalRequestMap = new ConcurrentHashMap<SipServletRequestImpl, SipServletRequestImpl>();
    private transient SipFactoryImpl sipFactoryImpl;
    private transient SipManager sipManager;

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean linked, Map<String, List<String>> headerMap) throws TooManyHopsException {
        if (origRequest == null) {
            throw new NullPointerException("original request cannot be null");
        }
        if (origRequest.getMaxForwards() == 0) {
            throw new TooManyHopsException();
        }
        try {
            SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
            Request newRequest = (Request)origRequestImpl.message.clone();
            ((SIPMessage)newRequest).setApplicationData(null);
            newRequest.removeHeader("Via");
            newRequest.removeHeader("Record-Route");
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)newRequest.getHeader("Max-Forwards");
            try {
                maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            Iterator<ExtendedListeningPoint> listeningPointsIterator = this.sipFactoryImpl.getSipNetworkInterfaceManager().getExtendedListeningPoints();
            if (!listeningPointsIterator.hasNext()) {
                throw new IllegalStateException("There is no SIP connectors available to create the request");
            }
            ExtendedListeningPoint extendedListeningPoint = listeningPointsIterator.next();
            CallIdHeader callIdHeader = SipFactories.headerFactory.createCallIdHeader(extendedListeningPoint.getSipProvider().getNewCallId().getCallId());
            newRequest.setHeader((Header)callIdHeader);
            List<String> contactHeaderSet = B2buaHelperImpl.retrieveContactHeaders(headerMap, newRequest);
            FromHeader newFromHeader = (FromHeader)newRequest.getHeader("From");
            newFromHeader.removeParameter("tag");
            ((ToHeader)newRequest.getHeader("To")).removeParameter("tag");
            MobicentsSipSession originalSession = origRequestImpl.getSipSession();
            MobicentsSipApplicationSession appSession = originalSession.getSipApplicationSession();
            newFromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), originalSession.getKey().getApplicationName(), appSession.getKey().getId()));
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(appSession.getKey().getId(), originalSession.getKey().getApplicationName(), (Message)newRequest, false);
            MobicentsSipSession session = appSession.getSipContext().getSipManager().getSipSession(key, true, this.sipFactoryImpl, appSession);
            session.setHandler(originalSession.getHandler());
            SipServletRequestImpl newSipServletRequest = new SipServletRequestImpl(newRequest, this.sipFactoryImpl, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(newRequest.getMethod()));
            newSipServletRequest.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, origRequest);
            String method = origRequest.getMethod();
            newRequest.removeHeader("Contact");
            if ("REGISTER".equalsIgnoreCase(method) && contactHeaderSet.size() > 0) {
                for (String contactHeaderValue : contactHeaderSet) {
                    newSipServletRequest.addHeaderInternal("Contact", contactHeaderValue, true);
                }
            } else {
                ContactHeader contactHeader = null;
                String fromName = null;
                if (newFromHeader.getAddress().getURI() instanceof SipURI) {
                    fromName = ((SipURI)newFromHeader.getAddress().getURI()).getUser();
                }
                if (this.sipFactoryImpl.isUseLoadBalancer()) {
                    SipLoadBalancer loadBalancerToUse = this.sipFactoryImpl.getLoadBalancerToUse();
                    SipURI sipURI = SipFactories.addressFactory.createSipURI(fromName, loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setHost(loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setPort(loadBalancerToUse.getSipPort());
                    sipURI.setTransportParam("UDP");
                    Address contactAddress = SipFactories.addressFactory.createAddress((URI)sipURI);
                    if (fromName != null && fromName.length() > 0) {
                        contactAddress.setDisplayName(fromName);
                    }
                    contactHeader = SipFactories.headerFactory.createContactHeader(contactAddress);
                } else {
                    contactHeader = JainSipUtils.createContactHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), newRequest, fromName, session.getOutboundInterface());
                }
                if (contactHeaderSet.size() > 0) {
                    this.setContactHeaders(contactHeaderSet, newSipServletRequest, contactHeader);
                } else if (JainSipUtils.CONTACT_HEADER_METHODS.contains(method)) {
                    newRequest.setHeader((Header)contactHeader);
                }
            }
            this.originalRequestMap.put(newSipServletRequest, origRequestImpl);
            this.originalRequestMap.put(origRequestImpl, newSipServletRequest);
            if (linked) {
                this.sessionMap.put(originalSession.getKey(), session.getKey());
                this.sessionMap.put(session.getKey(), originalSession.getKey());
                this.dumpLinkedSessions();
            }
            session.setB2buaHelper(this);
            originalSession.setB2buaHelper(this);
            session.setSessionCreatingTransactionRequest(newSipServletRequest);
            return newSipServletRequest;
        }
        catch (ParseException ex) {
            logger.error((Object)"Unexpected parse exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg encountered while creating b2bua", ex);
        }
        catch (ServletException ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Unexpected problem while creating b2bua", ex);
        }
    }

    public SipServletRequest createRequest(SipSession session, SipServletRequest origRequest, Map<String, List<String>> headerMap) {
        if (origRequest == null) {
            throw new NullPointerException("original request cannot be null");
        }
        try {
            SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
            MobicentsSipSession originalSession = origRequestImpl.getSipSession();
            MobicentsSipSession sessionImpl = (MobicentsSipSession)session;
            SipServletRequestImpl newSubsequentServletRequest = (SipServletRequestImpl)session.createRequest(origRequest.getMethod());
            List<String> contactHeaderSet = B2buaHelperImpl.retrieveContactHeaders(headerMap, (Request)newSubsequentServletRequest.getMessage());
            Request subsequentRequest = (Request)newSubsequentServletRequest.getMessage();
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)subsequentRequest.getHeader("Max-Forwards");
            try {
                maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            ContactHeader contactHeader = (ContactHeader)subsequentRequest.getHeader("Contact");
            if (contactHeader != null && contactHeaderSet.size() > 0) {
                this.setContactHeaders(contactHeaderSet, newSubsequentServletRequest, contactHeader);
            }
            if (origRequest.getContent() != null && origRequest.getContentType() != null) {
                newSubsequentServletRequest.setContentLength(origRequest.getContentLength());
                newSubsequentServletRequest.setContent(origRequest.getContent(), origRequest.getContentType());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("newSubsequentServletRequest = " + newSubsequentServletRequest));
            }
            this.copyNonSystemHeaders(origRequestImpl, newSubsequentServletRequest);
            this.originalRequestMap.put(newSubsequentServletRequest, origRequestImpl);
            this.originalRequestMap.put(origRequestImpl, newSubsequentServletRequest);
            this.sessionMap.put(originalSession.getKey(), sessionImpl.getKey());
            this.sessionMap.put(sessionImpl.getKey(), originalSession.getKey());
            this.dumpLinkedSessions();
            sessionImpl.setB2buaHelper(this);
            originalSession.setB2buaHelper(this);
            return newSubsequentServletRequest;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg encountered while creating b2bua", ex);
        }
    }

    private void copyNonSystemHeaders(SipServletRequestImpl origRequestImpl, SipServletRequestImpl newSubsequentServletRequest) {
        Message origMessage = origRequestImpl.getMessage();
        ListIterator headerNames = origMessage.getHeaderNames();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            if (JainSipUtils.SYSTEM_HEADERS.contains(headerName) || headerName.equalsIgnoreCase("Contact")) continue;
            Header origHeader = origMessage.getHeader(headerName);
            newSubsequentServletRequest.getMessage().addHeader((Header)origHeader.clone());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("original header " + origHeader + " copied in the new subsequent request"));
        }
    }

    private void setContactHeaders(List<String> contactHeaderSet, SipServletRequestImpl newSipServletRequest, ContactHeader contactHeader) throws ParseException {
        Request newRequest = (Request)newSipServletRequest.getMessage();
        for (String contactHeaderValue : contactHeaderSet) {
            newSipServletRequest.addHeaderInternal("Contact", contactHeaderValue, true);
        }
        ArrayList<ContactHeader> newContactHeaders = new ArrayList<ContactHeader>();
        ListIterator contactHeaders = newRequest.getHeaders("Contact");
        while (contactHeaders.hasNext()) {
            ContactHeader newContactHeader = (ContactHeader)contactHeader.clone();
            ContactHeader newRequestContactHeader = (ContactHeader)contactHeaders.next();
            URI newURI = newRequestContactHeader.getAddress().getURI();
            newContactHeader.getAddress().setDisplayName(newRequestContactHeader.getAddress().getDisplayName());
            if (newURI instanceof SipURI) {
                SipURI newSipURI = (SipURI)newURI;
                SipURI newContactSipURI = (SipURI)newContactHeader.getAddress().getURI();
                ((SipURI)newContactHeader.getAddress().getURI()).setUser(newSipURI.getUser());
                Iterator uriParameters = newSipURI.getParameterNames();
                while (uriParameters.hasNext()) {
                    String parameter = (String)uriParameters.next();
                    if (CONTACT_FORBIDDEN_PARAMETER.contains(parameter)) continue;
                    String value = newSipURI.getParameter(parameter);
                    newContactSipURI.setParameter(parameter, "".equals(value) ? null : value);
                }
            }
            Iterator headerParameters = newRequestContactHeader.getParameterNames();
            while (headerParameters.hasNext()) {
                String parameter;
                String value = newRequestContactHeader.getParameter(parameter = (String)headerParameters.next());
                newContactHeader.setParameter(parameter, "".equals(value) ? null : value);
            }
            newContactHeaders.add(newContactHeader);
        }
        newRequest.removeHeader("Contact");
        for (ContactHeader newContactHeader : newContactHeaders) {
            newRequest.addHeader((Header)newContactHeader);
        }
    }

    private static final List<String> retrieveContactHeaders(Map<String, List<String>> headerMap, Request newRequest) throws ParseException {
        List<String> contactHeaderList = new ArrayList<String>();
        if (headerMap != null) {
            for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
                String headerName = entry.getKey();
                if (!headerName.equalsIgnoreCase("Contact")) {
                    if (B2BUA_SYSTEM_HEADERS.contains(headerName)) {
                        throw new IllegalArgumentException(headerName + " in the provided map is a system header");
                    }
                    if (entry.getValue().size() > 0) {
                        newRequest.removeHeader(headerName);
                    }
                    for (String value : entry.getValue()) {
                        Header header = SipFactories.headerFactory.createHeader(headerName, value);
                        if (!JainSipUtils.SINGLETON_HEADER_NAMES.contains(header.getName())) {
                            newRequest.addHeader(header);
                            continue;
                        }
                        newRequest.setHeader(header);
                    }
                    continue;
                }
                contactHeaderList = headerMap.get(headerName);
            }
        }
        return contactHeaderList;
    }

    public SipServletResponse createResponseToOriginalRequest(SipSession session, int status, String reasonPhrase) {
        if (session == null) {
            throw new NullPointerException("Null arg");
        }
        MobicentsSipSession sipSession = (MobicentsSipSession)session;
        if (!sipSession.isValidInternal()) {
            throw new IllegalArgumentException("sip session " + sipSession.getId() + " is invalid !");
        }
        SipServletMessageImpl sipServletMessageImpl = sipSession.getSessionCreatingTransactionRequest();
        if (!(sipServletMessageImpl instanceof SipServletRequestImpl)) {
            throw new IllegalStateException("session creating transaction message is not a request !");
        }
        SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)sipServletMessageImpl;
        if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)sipServletRequestImpl.getRoutingState())) {
            throw new IllegalStateException("subsequent response is inconsistent with an already sent response. a Final response has already been sent ! ");
        }
        return sipServletRequestImpl.createResponse(status, reasonPhrase);
    }

    public SipSession getLinkedSession(SipSession session) {
        if (session == null) {
            throw new NullPointerException("the argument is null");
        }
        MobicentsSipSession mobicentsSipSession = (MobicentsSipSession)session;
        if (!mobicentsSipSession.isValidInternal()) {
            throw new IllegalArgumentException("the session " + mobicentsSipSession.getId() + " is invalid");
        }
        SipSessionKey sipSessionKey = this.sessionMap.get(mobicentsSipSession.getKey());
        if (sipSessionKey == null) {
            this.dumpLinkedSessions();
            return null;
        }
        MobicentsSipSession linkedSession = this.sipManager.getSipSession(sipSessionKey, false, null, mobicentsSipSession.getSipApplicationSession());
        if (logger.isDebugEnabled()) {
            if (linkedSession != null) {
                logger.debug((Object)("Linked Session found : " + linkedSession.getKey() + " for this session " + session.getId()));
            } else {
                logger.debug((Object)("No Linked Session found for this session " + session.getId()));
            }
        }
        if (linkedSession != null) {
            return linkedSession.getSession();
        }
        return null;
    }

    public SipServletRequest getLinkedSipServletRequest(SipServletRequest req) {
        if (req == null) {
            throw new NullPointerException("the argument is null");
        }
        return this.originalRequestMap.get(req);
    }

    public List<SipServletMessage> getPendingMessages(SipSession session, UAMode mode) {
        ArrayList<SipServletMessage> retval;
        block6: {
            MobicentsSipSession sipSessionImpl;
            block5: {
                sipSessionImpl = (MobicentsSipSession)session;
                if (!sipSessionImpl.isValidInternal()) {
                    throw new IllegalArgumentException("the session " + sipSessionImpl.getId() + " is invalid");
                }
                retval = new ArrayList<SipServletMessage>();
                if (!mode.equals((Object)UAMode.UAC)) break block5;
                Set<Transaction> ongoingTransactions = sipSessionImpl.getOngoingTransactions();
                if (ongoingTransactions == null) break block6;
                for (Transaction transaction : ongoingTransactions) {
                    Set<SipServletResponseImpl> sipServletsResponses;
                    SipServletMessageImpl sipServletMessage;
                    TransactionApplicationData tad;
                    if (!(transaction instanceof ClientTransaction) || (tad = (TransactionApplicationData)transaction.getApplicationData()) == null || (sipServletMessage = tad.getSipServletMessage()) == null) continue;
                    if (!(sipServletMessage.isCommitted() || "ACK".equals(sipServletMessage.getMethod()) || "PRACK".equals(sipServletMessage.getMethod()))) {
                        retval.add(sipServletMessage);
                    }
                    if ((sipServletsResponses = tad.getSipServletResponses()) == null) continue;
                    for (SipServletResponseImpl sipServletResponseImpl : sipServletsResponses) {
                        if (sipServletResponseImpl.isCommitted()) continue;
                        retval.add(sipServletResponseImpl);
                    }
                }
                break block6;
            }
            for (Transaction transaction : sipSessionImpl.getOngoingTransactions()) {
                TransactionApplicationData tad;
                SipServletMessageImpl sipServletMessage;
                if (!(transaction instanceof ServerTransaction) || (sipServletMessage = (tad = (TransactionApplicationData)transaction.getApplicationData()).getSipServletMessage()).isCommitted() || "ACK".equals(sipServletMessage.getMethod())) continue;
                retval.add(sipServletMessage);
            }
        }
        return retval;
    }

    public void linkSipSessions(SipSession session1, SipSession session2) {
        if (session1 == null) {
            throw new NullPointerException("First argument is null");
        }
        if (session2 == null) {
            throw new NullPointerException("Second argument is null");
        }
        if (!((MobicentsSipSession)session1).isValidInternal() || !((MobicentsSipSession)session2).isValidInternal() || SipSession.State.TERMINATED.equals((Object)((MobicentsSipSession)session1).getState()) || SipSession.State.TERMINATED.equals((Object)((MobicentsSipSession)session2).getState()) || !session1.getApplicationSession().equals(session2.getApplicationSession()) || this.sessionMap.get(((MobicentsSipSession)session1).getKey()) != null || this.sessionMap.get(((MobicentsSipSession)session2).getKey()) != null) {
            throw new IllegalArgumentException("either of the specified sessions has been terminated or the sessions do not belong to the same application session or one or both the sessions are already linked with some other session(s)");
        }
        this.sessionMap.put(((MobicentsSipSession)session1).getKey(), ((MobicentsSipSession)session2).getKey());
        this.sessionMap.put(((MobicentsSipSession)session2).getKey(), ((MobicentsSipSession)session1).getKey());
        this.dumpLinkedSessions();
    }

    public void unlinkSipSessions(SipSession session) {
        this.unlinkSipSessionsInternal(session, true);
    }

    public void unlinkSipSessionsInternal(SipSession session, boolean checkSession) {
        if (session == null) {
            throw new NullPointerException("the argument is null");
        }
        MobicentsSipSession key = (MobicentsSipSession)session;
        SipSessionKey sipSessionKey = key.getKey();
        if (checkSession && (!((MobicentsSipSession)session).isValidInternal() || SipSession.State.TERMINATED.equals((Object)key.getState()) || this.sessionMap.get(sipSessionKey) == null)) {
            throw new IllegalArgumentException("the session is not currently linked to another session or it has been terminated");
        }
        SipSessionKey value = this.sessionMap.get(sipSessionKey);
        if (value != null) {
            this.sessionMap.remove(value);
        }
        this.sessionMap.remove(sipSessionKey);
        this.unlinkOriginalRequestInternal(sipSessionKey);
        this.dumpLinkedSessions();
    }

    public void unlinkOriginalRequestInternal(SipSessionKey sipSessionKey) {
        for (Map.Entry<SipServletRequestImpl, SipServletRequestImpl> linkedRequests : this.originalRequestMap.entrySet()) {
            if (!linkedRequests.getKey().getSipSessionKey().equals(sipSessionKey) && !linkedRequests.getValue().getSipSessionKey().equals(sipSessionKey)) continue;
            this.unlinkOriginalRequestInternal(linkedRequests.getKey());
            this.unlinkOriginalRequestInternal(linkedRequests.getValue());
        }
    }

    public void unlinkOriginalRequestInternal(SipServletRequestImpl sipServletRequestImpl) {
        SipServletRequestImpl linkedRequest = this.originalRequestMap.remove(sipServletRequestImpl);
        if (linkedRequest != null) {
            this.originalRequestMap.remove(linkedRequest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("following linked request " + linkedRequest + " unlinked from " + sipServletRequestImpl));
            }
        }
    }

    public SipServletRequest createRequest(SipServletRequest origRequest) {
        try {
            Iterator<ExtendedListeningPoint> listeningPointsIterator;
            SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
            Request newRequest = (Request)origRequestImpl.message.clone();
            ((SIPMessage)newRequest).setApplicationData(null);
            newRequest.removeHeader("Via");
            FromHeader newFromHeader = (FromHeader)newRequest.getHeader("From");
            newFromHeader.removeParameter("tag");
            ((ToHeader)newRequest.getHeader("To")).removeParameter("tag");
            newRequest.removeHeader("Record-Route");
            if (!"REGISTER".equalsIgnoreCase(origRequest.getMethod())) {
                newRequest.removeHeader("Contact");
            }
            if (!(listeningPointsIterator = this.sipFactoryImpl.getSipNetworkInterfaceManager().getExtendedListeningPoints()).hasNext()) {
                throw new IllegalStateException("There is no SIP connectors available to create the request");
            }
            ExtendedListeningPoint extendedListeningPoint = listeningPointsIterator.next();
            CallIdHeader callIdHeader = SipFactories.headerFactory.createCallIdHeader(extendedListeningPoint.getSipProvider().getNewCallId().getCallId());
            newRequest.setHeader((Header)callIdHeader);
            MobicentsSipSession originalSession = origRequestImpl.getSipSession();
            MobicentsSipApplicationSession originalAppSession = originalSession.getSipApplicationSession();
            newFromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), originalSession.getKey().getApplicationName(), originalAppSession.getKey().getId()));
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(originalAppSession.getKey().getId(), originalSession.getKey().getApplicationName(), (Message)newRequest, false);
            MobicentsSipSession session = ((SipManager)originalAppSession.getSipContext().getManager()).getSipSession(key, true, this.sipFactoryImpl, originalAppSession);
            session.setHandler(originalSession.getHandler());
            SipServletRequestImpl newSipServletRequest = new SipServletRequestImpl(newRequest, this.sipFactoryImpl, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(newRequest.getMethod()));
            newSipServletRequest.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, origRequest);
            this.sessionMap.put(originalSession.getKey(), session.getKey());
            this.sessionMap.put(session.getKey(), originalSession.getKey());
            this.dumpLinkedSessions();
            this.originalRequestMap.put(newSipServletRequest, origRequestImpl);
            this.originalRequestMap.put(origRequestImpl, newSipServletRequest);
            session.setB2buaHelper(this);
            originalSession.setB2buaHelper(this);
            return newSipServletRequest;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg ecnountered while creatigng b2bua", ex);
        }
    }

    public SipServletRequest createCancel(SipSession session) {
        if (session == null) {
            throw new NullPointerException("The session for createCancel cannot be null");
        }
        for (SipServletRequestImpl linkedRequest : this.originalRequestMap.keySet()) {
            if (!linkedRequest.getSipSessionKey().equals(((MobicentsSipSession)session).getKey()) || !linkedRequest.getMethod().equalsIgnoreCase("INVITE") || linkedRequest.isFinalResponseGenerated()) continue;
            SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)linkedRequest.createCancel();
            ((MobicentsSipSession)sipServletRequestImpl.getSession()).setB2buaHelper(this);
            return sipServletRequestImpl;
        }
        return null;
    }

    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipFactoryImpl;
    }

    public void setSipFactoryImpl(SipFactoryImpl sipFactoryImpl) {
        this.sipFactoryImpl = sipFactoryImpl;
    }

    public SipManager getSipManager() {
        return this.sipManager;
    }

    public void setSipManager(SipManager sipManager) {
        this.sipManager = sipManager;
    }

    private void dumpLinkedSessions() {
        if (logger.isDebugEnabled()) {
            for (SipSessionKey key : this.sessionMap.keySet()) {
                logger.debug((Object)(key + " tied to session " + this.sessionMap.get(key)));
            }
        }
    }

    public void setSessionMap(Map<SipSessionKey, SipSessionKey> sessionMap) {
        this.sessionMap = sessionMap;
    }

    public Map<SipSessionKey, SipSessionKey> getSessionMap() {
        return this.sessionMap;
    }

    static {
        B2BUA_SYSTEM_HEADERS.add("Call-ID");
        B2BUA_SYSTEM_HEADERS.add("CSeq");
        B2BUA_SYSTEM_HEADERS.add("Via");
        B2BUA_SYSTEM_HEADERS.add("Route");
        B2BUA_SYSTEM_HEADERS.add("Record-Route");
        B2BUA_SYSTEM_HEADERS.add("Path");
        CONTACT_FORBIDDEN_PARAMETER = new HashSet<String>();
        CONTACT_FORBIDDEN_PARAMETER.add("method");
        CONTACT_FORBIDDEN_PARAMETER.add("ttl");
        CONTACT_FORBIDDEN_PARAMETER.add("maddr");
        CONTACT_FORBIDDEN_PARAMETER.add("lr");
    }
}

