/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.timers.ServletTimerImpl;
import org.mobicents.servlet.sip.core.timers.SipServletTimerService;

public class TimerServiceImpl
implements SipServletTimerService {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)TimerServiceImpl.class.getName());
    public static final int SCHEDULER_THREAD_POOL_DEFAULT_SIZE = 4;
    private transient ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(4);

    public ServletTimer createTimer(SipApplicationSession appSession, long delay, boolean isPersistent, Serializable info) {
        MobicentsSipApplicationSession sipApplicationSessionImpl = (MobicentsSipApplicationSession)appSession;
        if (!sipApplicationSessionImpl.isValid()) {
            throw new IllegalStateException("Sip application session has been invalidated!!!");
        }
        if (!sipApplicationSessionImpl.hasTimerListener()) {
            throw new IllegalStateException("No Timer listeners have been configured for this application ");
        }
        TimerListener listener = sipApplicationSessionImpl.getSipContext().getListeners().getTimerListener();
        ServletTimerImpl servletTimer = this.createTimerLocaly(listener, delay, isPersistent, info, sipApplicationSessionImpl);
        return servletTimer;
    }

    public ServletTimer createTimer(SipApplicationSession appSession, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        if (period < 1L) {
            throw new IllegalArgumentException("Period should be greater than 0");
        }
        MobicentsSipApplicationSession sipApplicationSessionImpl = (MobicentsSipApplicationSession)appSession;
        if (!sipApplicationSessionImpl.isValid()) {
            throw new IllegalStateException("Sip application session has been invalidated!!!");
        }
        if (!sipApplicationSessionImpl.hasTimerListener()) {
            throw new IllegalStateException("No Timer listeners have been configured for this application ");
        }
        TimerListener timerListener = sipApplicationSessionImpl.getSipContext().getListeners().getTimerListener();
        ServletTimerImpl servletTimer = this.createTimerLocaly(timerListener, delay, period, fixedDelay, isPersistent, info, sipApplicationSessionImpl);
        return servletTimer;
    }

    private ServletTimerImpl createTimerLocaly(TimerListener listener, long delay, boolean isPersistent, Serializable info, MobicentsSipApplicationSession sipApplicationSession) {
        ServletTimerImpl servletTimer = new ServletTimerImpl(info, delay, listener, sipApplicationSession);
        ScheduledFuture<?> future = this.scheduledExecutor.schedule(servletTimer, delay, TimeUnit.MILLISECONDS);
        servletTimer.setFuture(future);
        sipApplicationSession.addServletTimer(servletTimer);
        if (isPersistent) {
            this.persist(servletTimer);
        }
        return servletTimer;
    }

    private ServletTimerImpl createTimerLocaly(TimerListener listener, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info, MobicentsSipApplicationSession sipApplicationSession) {
        ServletTimerImpl servletTimer = new ServletTimerImpl(info, delay, fixedDelay, period, listener, sipApplicationSession);
        ScheduledFuture<?> future = null;
        future = fixedDelay ? this.scheduledExecutor.scheduleWithFixedDelay(servletTimer, delay, period, TimeUnit.MILLISECONDS) : this.scheduledExecutor.scheduleAtFixedRate(servletTimer, delay, period, TimeUnit.MILLISECONDS);
        servletTimer.setFuture(future);
        sipApplicationSession.addServletTimer(servletTimer);
        if (isPersistent) {
            this.persist(servletTimer);
        }
        return servletTimer;
    }

    private void persist(ServletTimerImpl st) {
    }

    public void stop() {
        this.scheduledExecutor.shutdownNow();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopped timer service " + this));
        }
    }

    public void start() {
        this.scheduledExecutor.prestartAllCoreThreads();
    }

    public boolean isStarted() {
        return this.scheduledExecutor.isTerminated();
    }
}

