/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.startup.SipContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTimerImpl
implements ServletTimer,
Runnable {
    private static final Logger logger = Logger.getLogger(ServletTimerImpl.class);
    private MobicentsSipApplicationSession appSession;
    private ScheduledFuture<?> future;
    private Serializable info;
    private long scheduledExecutionTime = 0L;
    private long delay = 0L;
    private long period = 0L;
    private long numInvocations = 0L;
    private long firstExecution = 0L;
    private boolean fixedDelay = false;
    private boolean persistent = true;
    private Boolean isCanceled = null;
    String id = null;
    private TimerListener listener;
    private boolean isRepeatingTimer = true;
    private final Object TIMER_LOCK = new Object();

    public ServletTimerImpl(Serializable info, long delay, TimerListener listener, MobicentsSipApplicationSession appSession) {
        this(info, delay, false, 0L, listener, appSession);
        this.isRepeatingTimer = false;
    }

    public ServletTimerImpl(Serializable info, long delay, boolean fixedDelay, long period, TimerListener listener, MobicentsSipApplicationSession appSession) {
        this.id = UUID.randomUUID().toString();
        this.info = info;
        this.delay = delay;
        this.scheduledExecutionTime = delay + System.currentTimeMillis();
        this.fixedDelay = fixedDelay;
        this.period = period;
        this.listener = listener;
        this.appSession = appSession;
    }

    public void cancel() {
        this.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean mayInterruptIfRunning) {
        MobicentsSipApplicationSession appSessionToCancelThisTimersFrom = null;
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            if (this.future != null) {
                boolean res = this.future.cancel(mayInterruptIfRunning);
                this.isCanceled = res;
                appSessionToCancelThisTimersFrom = this.appSession;
                this.future = null;
            }
        }
        if (appSessionToCancelThisTimersFrom != null) {
            appSessionToCancelThisTimersFrom.removeServletTimer(this);
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipApplicationSession getApplicationSession() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.appSession;
        }
    }

    public Serializable getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.scheduledExecutionTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFuture(ScheduledFuture<?> f) {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            this.future = f;
        }
    }

    public boolean canRun() {
        return !this.future.isCancelled() && !this.future.isDone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Info = ").append(this.info).append('\n');
        sb.append("Scheduled execution time = ").append(this.scheduledExecutionTime).append('\n');
        sb.append("Time now = ").append(System.currentTimeMillis()).append('\n');
        sb.append("SipApplicationSession = ").append(this.appSession).append('\n');
        sb.append("ScheduledFuture = ").append(this.future).append('\n');
        sb.append("Delay = ").append(this.delay).append('\n');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SipContext sipContext = this.appSession.getSipContext();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = sipContext.getLoader().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            sipContext.enterSipApp(this.appSession, null);
            sipContext.enterSipAppHa(true);
            this.listener.timeout((ServletTimer)this);
        }
        catch (Throwable t) {
            logger.error((Object)"An unexpected exception happened in the timer callback!", t);
        }
        finally {
            sipContext.exitSipAppHa(null, null);
            sipContext.exitSipApp(this.appSession, null);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            if (this.isRepeatingTimer) {
                this.estimateNextExecution();
            } else {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estimateNextExecution() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            if (this.fixedDelay) {
                this.scheduledExecutionTime = this.period + System.currentTimeMillis();
            } else {
                if (this.firstExecution == 0L) {
                    this.firstExecution = this.scheduledExecutionTime;
                }
                long now = System.currentTimeMillis();
                long executedTime = this.numInvocations++ * this.period;
                this.scheduledExecutionTime = this.firstExecution + executedTime;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("next execution estimated to run at " + this.scheduledExecutionTime));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("current time is " + now));
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeRemaining() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.scheduledExecutionTime - System.currentTimeMillis();
        }
    }
}

