/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.timers.DefaultSasTimerTask;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;
import org.mobicents.servlet.sip.startup.SipApplicationSessionTimerService;

public class DefaultSipApplicationSessionTimerService
extends ScheduledThreadPoolExecutor
implements SipApplicationSessionTimerService {
    private static final Logger logger = Logger.getLogger((String)DefaultSipApplicationSessionTimerService.class.getName());
    private static volatile int numCancelled = 0;

    public DefaultSipApplicationSessionTimerService(int corePoolSize) {
        super(corePoolSize);
    }

    public DefaultSipApplicationSessionTimerService(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public DefaultSipApplicationSessionTimerService(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public DefaultSipApplicationSessionTimerService(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public SipApplicationSessionTimerTask createSipApplicationSessionTimerTask(MobicentsSipApplicationSession sipApplicationSession) {
        return new DefaultSasTimerTask(sipApplicationSession);
    }

    public boolean cancel(SipApplicationSessionTimerTask expirationTimerTask) {
        ScheduledFuture<MobicentsSipApplicationSession> future = ((DefaultSasTimerTask)expirationTimerTask).getScheduledFuture();
        if (future != null) {
            boolean removed = super.remove((Runnable)((Object)future));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expiration timer on sip application session " + expirationTimerTask.getSipApplicationSession().getKey() + " removed : " + removed));
            }
            boolean cancelled = future.cancel(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expiration timer on sip application session " + expirationTimerTask.getSipApplicationSession().getKey() + " Cancelled : " + cancelled));
            }
            future = null;
            if (++numCancelled % 100 == 0) {
                super.purge();
            }
            return cancelled;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"expiration timer future is null, thus cannot be Cancelled");
        }
        return false;
    }

    public SipApplicationSessionTimerTask schedule(SipApplicationSessionTimerTask expirationTimerTask, long delay, TimeUnit unit) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduling sip application session " + expirationTimerTask.getSipApplicationSession().getKey() + " to expire in " + (double)delay / 1000.0 / 60.0 + " minutes"));
        }
        ((DefaultSasTimerTask)expirationTimerTask).setScheduledFuture(super.schedule(expirationTimerTask, delay, unit));
        return expirationTimerTask;
    }

    public void start() {
        this.prestartAllCoreThreads();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Started timer service " + this));
        }
    }

    public void stop() {
        super.shutdownNow();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopped timer service " + this));
        }
    }

    public boolean isStarted() {
        return super.isTerminated();
    }
}

