/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.servlet.sip.core.session.ConvergedStandardSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipManagerDelegate;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.core.session.SipStandardManagerDelegate;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.startup.SipContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipStandardManager
extends StandardManager
implements SipManager {
    private static final Logger logger = Logger.getLogger(SipStandardManager.class);
    private SipManagerDelegate sipManagerDelegate = new SipStandardManagerDelegate();
    protected static final String INFO = "SipStandardManager/1.0";
    protected static final String NAME = "SipStandardManager";

    public void init() {
        if (this.initialized) {
            return;
        }
        if (this.oname == null && this.getContainer() instanceof SipContext) {
            SipContext ctx = (SipContext)this.getContainer();
            this.domain = ctx.getEngineName();
            this.distributable = ctx.getDistributable();
            StandardHost hst = (StandardHost)ctx.getParent();
            String path = ctx.getPath();
            if (path.equals("")) {
                path = "/";
            }
            String objectNameString = this.domain + ":type=SipManager,path=" + path + ",host=" + hst.getName();
            try {
                this.oname = new ObjectName(objectNameString);
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                throw new IllegalStateException("error registering the mbean " + objectNameString, e);
            }
        }
        super.init();
    }

    protected StandardSession getNewSession() {
        if (this.container instanceof SipContext) {
            return new ConvergedStandardSession(this);
        }
        return super.getNewSession();
    }

    @Override
    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipManagerDelegate.getSipFactoryImpl();
    }

    @Override
    public void setSipFactoryImpl(SipFactoryImpl sipFactoryImpl) {
        this.sipManagerDelegate.setSipFactoryImpl(sipFactoryImpl);
    }

    public Container getContainer() {
        return this.sipManagerDelegate.getContainer();
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.container = container;
        this.sipManagerDelegate.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    @Override
    public MobicentsSipSession removeSipSession(SipSessionKey key) {
        return this.sipManagerDelegate.removeSipSession(key);
    }

    @Override
    public MobicentsSipApplicationSession removeSipApplicationSession(SipApplicationSessionKey key) {
        return this.sipManagerDelegate.removeSipApplicationSession(key);
    }

    @Override
    public MobicentsSipApplicationSession getSipApplicationSession(SipApplicationSessionKey key, boolean create) {
        return this.sipManagerDelegate.getSipApplicationSession(key, create);
    }

    @Override
    public MobicentsSipSession getSipSession(SipSessionKey key, boolean create, SipFactoryImpl sipFactoryImpl, MobicentsSipApplicationSession sipApplicationSessionImpl) {
        return this.sipManagerDelegate.getSipSession(key, create, sipFactoryImpl, sipApplicationSessionImpl);
    }

    @Override
    public Iterator<MobicentsSipSession> getAllSipSessions() {
        return this.sipManagerDelegate.getAllSipSessions();
    }

    @Override
    public Iterator<MobicentsSipApplicationSession> getAllSipApplicationSessions() {
        return this.sipManagerDelegate.getAllSipApplicationSessions();
    }

    @Override
    public MobicentsSipApplicationSession findSipApplicationSession(HttpSession httpSession) {
        return this.sipManagerDelegate.findSipApplicationSession(httpSession);
    }

    @Override
    public void dumpSipSessions() {
        this.sipManagerDelegate.dumpSipSessions();
    }

    @Override
    public void dumpSipApplicationSessions() {
        this.sipManagerDelegate.dumpSipApplicationSessions();
    }

    @Override
    public void removeAllSessions() {
        this.sipManagerDelegate.removeAllSessions();
    }

    public String getInfo() {
        return INFO;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public int getMaxActiveSipSessions() {
        return this.sipManagerDelegate.maxActiveSipSessions;
    }

    @Override
    public void setMaxActiveSipSessions(int max) {
        int oldMaxActiveSipSessions = this.sipManagerDelegate.maxActiveSipSessions;
        this.sipManagerDelegate.maxActiveSipSessions = max;
        this.support.firePropertyChange("maxActiveSipSessions", (Object)oldMaxActiveSipSessions, (Object)this.sipManagerDelegate.maxActiveSipSessions);
    }

    @Override
    public int getMaxActiveSipApplicationSessions() {
        return this.sipManagerDelegate.maxActiveSipApplicationSessions;
    }

    @Override
    public void setMaxActiveSipApplicationSessions(int max) {
        int oldMaxActiveSipApplicationSessions = this.sipManagerDelegate.maxActiveSipApplicationSessions;
        this.sipManagerDelegate.maxActiveSipApplicationSessions = max;
        this.support.firePropertyChange("maxActiveSipApplicationSessions", (Object)oldMaxActiveSipApplicationSessions, (Object)this.sipManagerDelegate.maxActiveSipApplicationSessions);
    }

    @Override
    public int getRejectedSipSessions() {
        return this.sipManagerDelegate.rejectedSipSessions;
    }

    @Override
    public void setRejectedSipSessions(int rejectedSipSessions) {
        this.sipManagerDelegate.rejectedSipSessions = rejectedSipSessions;
    }

    @Override
    public int getRejectedSipApplicationSessions() {
        return this.sipManagerDelegate.rejectedSipApplicationSessions;
    }

    @Override
    public void setRejectedSipApplicationSessions(int rejectedSipApplicationSessions) {
        this.sipManagerDelegate.rejectedSipApplicationSessions = rejectedSipApplicationSessions;
    }

    @Override
    public void setSipSessionCounter(int sipSessionCounter) {
        this.sipManagerDelegate.sipSessionCounter = sipSessionCounter;
    }

    @Override
    public int getSipSessionCounter() {
        return this.sipManagerDelegate.sipSessionCounter;
    }

    @Override
    public int getActiveSipSessions() {
        return this.sipManagerDelegate.sipSessions.size();
    }

    @Override
    public int getSipSessionMaxAliveTime() {
        return this.sipManagerDelegate.sipSessionMaxAliveTime;
    }

    @Override
    public void setSipSessionMaxAliveTime(int sipSessionMaxAliveTime) {
        this.sipManagerDelegate.sipSessionMaxAliveTime = sipSessionMaxAliveTime;
    }

    @Override
    public int getSipSessionAverageAliveTime() {
        return this.sipManagerDelegate.sipSessionAverageAliveTime;
    }

    @Override
    public void setSipSessionAverageAliveTime(int sipSessionAverageAliveTime) {
        this.sipManagerDelegate.sipSessionAverageAliveTime = sipSessionAverageAliveTime;
    }

    @Override
    public void setSipApplicationSessionCounter(int sipApplicationSessionCounter) {
        this.sipManagerDelegate.sipApplicationSessionCounter = sipApplicationSessionCounter;
    }

    @Override
    public int getSipApplicationSessionCounter() {
        return this.sipManagerDelegate.sipApplicationSessionCounter;
    }

    @Override
    public int getActiveSipApplicationSessions() {
        return this.sipManagerDelegate.sipApplicationSessions.size();
    }

    @Override
    public int getSipApplicationSessionMaxAliveTime() {
        return this.sipManagerDelegate.sipApplicationSessionMaxAliveTime;
    }

    @Override
    public void setSipApplicationSessionMaxAliveTime(int sipApplicationSessionMaxAliveTime) {
        this.sipManagerDelegate.sipApplicationSessionMaxAliveTime = sipApplicationSessionMaxAliveTime;
    }

    @Override
    public int getSipApplicationSessionAverageAliveTime() {
        return this.sipManagerDelegate.sipApplicationSessionAverageAliveTime;
    }

    @Override
    public void setSipApplicationSessionAverageAliveTime(int sipApplicationSessionAverageAliveTime) {
        this.sipManagerDelegate.sipApplicationSessionAverageAliveTime = sipApplicationSessionAverageAliveTime;
    }

    @Override
    public int getExpiredSipSessions() {
        return this.sipManagerDelegate.expiredSipSessions;
    }

    @Override
    public void setExpiredSipSessions(int expiredSipSessions) {
        this.sipManagerDelegate.expiredSipSessions = expiredSipSessions;
    }

    @Override
    public int getExpiredSipApplicationSessions() {
        return this.sipManagerDelegate.expiredSipApplicationSessions;
    }

    @Override
    public void setExpiredSipApplicationSessions(int expiredSipApplicationSessions) {
        this.sipManagerDelegate.expiredSipApplicationSessions = expiredSipApplicationSessions;
    }

    public String listSipSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator<MobicentsSipSession> sipSessions = this.sipManagerDelegate.getAllSipSessions();
        while (sipSessions.hasNext()) {
            sb.append(sipSessions.next().getKey()).append(" ");
        }
        return sb.toString();
    }

    public String listSipApplicationSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator<MobicentsSipApplicationSession> sipApplicationSessions = this.sipManagerDelegate.getAllSipApplicationSessions();
        while (sipApplicationSessions.hasNext()) {
            sb.append(sipApplicationSessions.next().getKey()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public double getNumberOfSipApplicationSessionCreationPerSecond() {
        return this.sipManagerDelegate.getNumberOfSipApplicationSessionCreationPerSecond();
    }

    @Override
    public double getNumberOfSipSessionCreationPerSecond() {
        return this.sipManagerDelegate.getNumberOfSipSessionCreationPerSecond();
    }

    @Override
    public void updateStats() {
        this.sipManagerDelegate.updateStats();
    }
}

