/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionsUtil;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.startup.SipContext;

public class SipSessionsUtilImpl
implements SipSessionsUtil,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipSessionsUtilImpl.class);
    private transient SipContext sipContext;
    private transient ConcurrentHashMap<SipSessionKey, MobicentsSipSession> joinSession;
    private transient ConcurrentHashMap<SipSessionKey, MobicentsSipSession> replacesSession;
    private ConcurrentHashMap<SipApplicationSessionKey, SipApplicationSessionKey> joinApplicationSession;
    private ConcurrentHashMap<SipApplicationSessionKey, SipApplicationSessionKey> replacesApplicationSession;

    public SipSessionsUtilImpl(SipContext sipContext) {
        this.sipContext = sipContext;
        this.joinSession = new ConcurrentHashMap();
        this.replacesSession = new ConcurrentHashMap();
        this.joinApplicationSession = new ConcurrentHashMap();
        this.replacesApplicationSession = new ConcurrentHashMap();
    }

    public SipApplicationSession getApplicationSessionById(String applicationSessionId) {
        SipApplicationSessionKey applicationSessionKey;
        if (applicationSessionId == null) {
            throw new NullPointerException("the given id is null !");
        }
        try {
            applicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey(applicationSessionId);
        }
        catch (ParseException e) {
            logger.error((Object)("the given application session id : " + applicationSessionId + " couldn't be parsed correctly "), (Throwable)e);
            return null;
        }
        if (applicationSessionKey.getApplicationName().equals(this.sipContext.getApplicationName())) {
            MobicentsSipApplicationSession sipApplicationSession = ((SipManager)this.sipContext.getManager()).getSipApplicationSession(applicationSessionKey, false);
            if (sipApplicationSession == null) {
                return null;
            }
            return sipApplicationSession.getSession();
        }
        logger.warn((Object)("the given application session id : " + applicationSessionId + " tried to be retrieved from incorret application " + this.sipContext.getApplicationName()));
        return null;
    }

    public SipApplicationSession getApplicationSessionByKey(String applicationSessionKey, boolean create) {
        if (applicationSessionKey == null) {
            throw new NullPointerException("the given key is null !");
        }
        SipApplicationSessionKey sipApplicationSessionKey = new SipApplicationSessionKey(null, this.sipContext.getApplicationName());
        sipApplicationSessionKey.setAppGeneratedKey(applicationSessionKey);
        MobicentsSipApplicationSession sipApplicationSession = ((SipManager)this.sipContext.getManager()).getSipApplicationSession(sipApplicationSessionKey, create);
        if (sipApplicationSession == null) {
            return null;
        }
        return sipApplicationSession.getSession();
    }

    public SipSession getCorrespondingSipSession(SipSession sipSession, String headerName) {
        MobicentsSipSession correspondingSipSession = null;
        if (headerName.equalsIgnoreCase("Join")) {
            correspondingSipSession = this.joinSession.get(((MobicentsSipSession)sipSession).getKey());
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            correspondingSipSession = this.replacesSession.get(((MobicentsSipSession)sipSession).getKey());
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
        return correspondingSipSession;
    }

    public void addCorrespondingSipSession(MobicentsSipSession newSession, MobicentsSipSession correspondingSipSession, String headerName) {
        if ("Join".equalsIgnoreCase(headerName)) {
            this.joinSession.putIfAbsent(newSession.getKey(), correspondingSipSession);
        } else if ("Replaces".equalsIgnoreCase(headerName)) {
            this.replacesSession.putIfAbsent(newSession.getKey(), correspondingSipSession);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces, was : " + headerName);
        }
    }

    public void removeCorrespondingSipSession(SipSessionKey sipSession) {
        this.joinSession.remove(sipSession);
        this.replacesSession.remove(sipSession);
    }

    public SipApplicationSessionKey getCorrespondingSipApplicationSession(SipApplicationSessionKey sipApplicationSessionKey, String headerName) {
        SipApplicationSessionKey correspondingSipApplicationSession = null;
        if (headerName.equalsIgnoreCase("Join")) {
            correspondingSipApplicationSession = this.joinApplicationSession.get(sipApplicationSessionKey);
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            correspondingSipApplicationSession = this.replacesApplicationSession.get(sipApplicationSessionKey);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
        return correspondingSipApplicationSession;
    }

    public void addCorrespondingSipApplicationSession(SipApplicationSessionKey newApplicationSession, SipApplicationSessionKey correspondingSipApplicationSession, String headerName) {
        if (headerName.equalsIgnoreCase("Join")) {
            this.joinApplicationSession.putIfAbsent(newApplicationSession, correspondingSipApplicationSession);
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            this.replacesApplicationSession.putIfAbsent(newApplicationSession, correspondingSipApplicationSession);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
    }

    public void removeCorrespondingSipApplicationSession(SipApplicationSessionKey sipApplicationSession) {
        SipApplicationSessionKey sipApplicationSessionKey;
        this.joinApplicationSession.remove(sipApplicationSession);
        this.replacesApplicationSession.remove(sipApplicationSession);
        Iterator<SipApplicationSessionKey> it = this.joinApplicationSession.values().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            sipApplicationSessionKey = it.next();
            if (!sipApplicationSessionKey.equals(sipApplicationSession)) continue;
            this.joinApplicationSession.remove(sipApplicationSessionKey);
            found = true;
        }
        it = this.replacesApplicationSession.values().iterator();
        found = false;
        while (it.hasNext() && !found) {
            sipApplicationSessionKey = it.next();
            if (!sipApplicationSessionKey.equals(sipApplicationSession)) continue;
            this.replacesApplicationSession.remove(sipApplicationSessionKey);
            found = true;
        }
    }
}

