/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import gov.nist.javax.sip.ServerTransactionExt;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.catalina.Container;
import org.apache.catalina.security.SecurityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipListenersHolder;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.B2buaHelperImpl;
import org.mobicents.servlet.sip.message.MobicentsSipSessionFacade;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.startup.SipContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipSessionImpl
implements MobicentsSipSession {
    private static final Logger logger = Logger.getLogger(SipSessionImpl.class);
    protected transient SipApplicationSessionKey sipApplicationSessionKey;
    protected transient MobicentsSipApplicationSession sipApplicationSession;
    protected ProxyImpl proxy;
    protected B2buaHelperImpl b2buaHelper;
    protected volatile Map<String, Object> sipSessionAttributeMap;
    protected transient SipSessionKey key;
    protected transient Principal userPrincipal;
    protected transient boolean ackReceived;
    protected long cseq = -1L;
    protected String transport;
    protected long creationTime;
    protected long lastAccessedTime;
    protected transient SipApplicationRoutingRegion routingRegion;
    protected transient Serializable stateInfo;
    protected transient SipApplicationRouterInfo nextSipApplicationRouterInfo;
    protected SipSession.State state;
    protected AtomicBoolean isValidInternal;
    protected transient boolean isValid;
    protected String handlerServlet;
    protected transient String subscriberURI;
    protected transient String outboundInterface;
    protected transient Dialog sessionCreatingDialog;
    protected transient SipServletRequestImpl sessionCreatingTransactionRequest;
    protected transient boolean isSessionCreatingTransactionServer;
    protected transient Set<Transaction> ongoingTransactions;
    protected volatile transient ConcurrentHashMap<String, MobicentsSipSession> derivedSipSessions;
    protected transient SipFactoryImpl sipFactory;
    protected boolean invalidateWhenReady = true;
    protected boolean readyToInvalidate = false;
    protected transient MobicentsSipSession parentSession = null;
    protected transient Address localParty = null;
    protected transient Address remoteParty = null;
    protected volatile transient Set<EventHeader> subscriptions = null;
    protected transient String originalMethod = null;
    protected transient boolean okToByeSentOrReceived = false;
    protected transient Semaphore semaphore;
    protected transient MobicentsSipSessionFacade facade = null;

    protected SipSessionImpl(SipSessionKey key, SipFactoryImpl sipFactoryImpl, MobicentsSipApplicationSession mobicentsSipApplicationSession) {
        this.key = key;
        this.setSipApplicationSession(mobicentsSipApplicationSession);
        this.sipFactory = sipFactoryImpl;
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
        this.state = SipSession.State.INITIAL;
        this.isValidInternal = new AtomicBoolean(true);
        this.isValid = true;
        this.ongoingTransactions = new CopyOnWriteArraySet<Transaction>();
        if (mobicentsSipApplicationSession.getSipContext() != null && ConcurrencyControlMode.SipSession.equals((Object)mobicentsSipApplicationSession.getSipContext().getConcurrencyControlMode())) {
            this.semaphore = new Semaphore(1);
        }
        if (mobicentsSipApplicationSession.getSipContext() != null) {
            this.notifySipSessionListeners(SipSessionEventType.CREATION);
        }
    }

    private void notifySipSessionListeners(SipSessionEventType sipSessionEventType) {
        SipContext sipContext;
        List<SipSessionListener> sipSessionListeners;
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        if (sipApplicationSession != null && (sipSessionListeners = (sipContext = sipApplicationSession.getSipContext()).getListeners().getSipSessionListeners()).size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notifying sip session listeners of context " + sipContext.getApplicationName() + " of following event " + (Object)((Object)sipSessionEventType)));
            }
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(sipContext.getLoader().getClassLoader());
            SipSessionEvent sipSessionEvent = new SipSessionEvent((SipSession)this.getSession());
            for (SipSessionListener sipSessionListener : sipSessionListeners) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying sip session listener " + sipSessionListener.getClass().getName() + " of context " + this.key.getApplicationName() + " of following event " + (Object)((Object)sipSessionEventType)));
                    }
                    if (SipSessionEventType.CREATION.equals((Object)sipSessionEventType)) {
                        sipSessionListener.sessionCreated(sipSessionEvent);
                        continue;
                    }
                    if (SipSessionEventType.DELETION.equals((Object)sipSessionEventType)) {
                        sipSessionListener.sessionDestroyed(sipSessionEvent);
                        continue;
                    }
                    if (!SipSessionEventType.READYTOINVALIDATE.equals((Object)sipSessionEventType)) continue;
                    sipSessionListener.sessionReadyToInvalidate(sipSessionEvent);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionListener threw exception", t);
                }
            }
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public SipServletRequest createRequest(String method) {
        if (method.equalsIgnoreCase("ACK") || method.equalsIgnoreCase("PRACK") || method.equalsIgnoreCase("CANCEL")) {
            throw new IllegalArgumentException("Can not create ACK, PRACK or CANCEL requests with this method");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("cannot create a request because the session is invalid");
        }
        if (SipSession.State.TERMINATED.equals((Object)this.state)) {
            throw new IllegalStateException("cannot create a request because the session is in TERMINATED state");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dialog associated with this session to create the new request within that dialog " + this.sessionCreatingDialog));
        }
        SipServletRequestImpl sipServletRequest = null;
        if (this.sessionCreatingDialog != null && !DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState())) {
            try {
                ListIterator viaHeaders;
                Request methodRequest = this.sessionCreatingDialog.createRequest(method);
                if (methodRequest.getHeader("Contact") != null) {
                    try {
                        ContactHeader contactHeader = null;
                        if (this.sipFactory.isUseLoadBalancer()) {
                            SipLoadBalancer loadBalancerToUse = this.sipFactory.getLoadBalancerToUse();
                            javax.sip.address.SipURI sipURI = SipFactories.addressFactory.createSipURI("", loadBalancerToUse.getAddress().getHostAddress());
                            sipURI.setHost(loadBalancerToUse.getAddress().getHostAddress());
                            sipURI.setPort(loadBalancerToUse.getSipPort());
                            sipURI.setTransportParam("UDP");
                            javax.sip.address.Address contactAddress = SipFactories.addressFactory.createAddress((javax.sip.address.URI)sipURI);
                            contactHeader = SipFactories.headerFactory.createContactHeader(contactAddress);
                        } else {
                            contactHeader = JainSipUtils.createContactHeader(this.sipFactory.getSipNetworkInterfaceManager(), methodRequest, "", this.outboundInterface);
                        }
                        methodRequest.setHeader((Header)contactHeader);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Can not create contact header for subsequent request " + method + " for session " + this.key), (Throwable)e);
                    }
                }
                if ((viaHeaders = methodRequest.getHeaders("Via")) != null && viaHeaders.hasNext()) {
                    ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
                    ((MessageExt)methodRequest).setApplicationData((Object)viaHeader.getTransport());
                }
                methodRequest.removeHeader("Via");
                sipServletRequest = new SipServletRequestImpl(methodRequest, this.sipFactory, this, null, this.sessionCreatingDialog, false);
            }
            catch (SipException e) {
                logger.error((Object)("Cannot create the " + method + " request from the dialog " + this.sessionCreatingDialog), (Throwable)e);
                throw new IllegalArgumentException("Cannot create the " + method + " request from the dialog " + this.sessionCreatingDialog + " for sip session " + this.key, e);
            }
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (!this.isSessionCreatingTransactionServer) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("orignal tx for creating susbequent request " + method + " on session " + this.key + " was a Client Tx"));
                }
                Request request = (Request)this.sessionCreatingTransactionRequest.getMessage().clone();
                javax.sip.address.URI requestUri = (javax.sip.address.URI)request.getRequestURI().clone();
                ((SIPRequest)request).setMethod(method);
                ((SIPRequest)request).setRequestURI(requestUri);
                ((SIPMessage)request).setApplicationData(null);
                CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
                try {
                    cSeqHeader.setSeqNumber(cSeqHeader.getSeqNumber() + 1L);
                    cSeqHeader.setMethod(method);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)("Cannot increment the Cseq header to the new " + method + " on the susbequent request to create on session " + this.key), (Throwable)e);
                    throw new IllegalArgumentException("Cannot create the " + method + " on the susbequent request to create on session " + this.key, e);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot set the " + method + " on the susbequent request to create on session " + this.key, e);
                }
                ListIterator viaHeaders = request.getHeaders("Via");
                if (viaHeaders != null && viaHeaders.hasNext()) {
                    ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
                    ((MessageExt)request).setApplicationData((Object)viaHeader.getTransport());
                }
                request.removeHeader("Via");
                SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactory.getSipNetworkInterfaceManager();
                SipProvider sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(JainSipUtils.findTransport((Message)request), false).getSipProvider();
                SipApplicationDispatcher sipApplicationDispatcher = this.sipFactory.getSipApplicationDispatcher();
                String branch = JainSipUtils.createBranch(this.getSipApplicationSession().getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(this.getKey().getApplicationName()));
                ViaHeader viaHeader = JainSipUtils.createViaHeader(sipNetworkInterfaceManager, request, branch, this.outboundInterface);
                request.addHeader((Header)viaHeader);
                sipServletRequest = new SipServletRequestImpl(request, this.sipFactory, this, null, this.sessionCreatingDialog, true);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("orignal tx for creating susbequent request " + method + " on session " + this.key + " was a Server Tx"));
                }
                try {
                    Request originalRequest = (Request)this.sessionCreatingTransactionRequest.getMessage();
                    FromHeader fromHeader = (FromHeader)originalRequest.getHeader("From");
                    ToHeader toHeader = (ToHeader)originalRequest.getHeader("To");
                    AddressImpl currentLocalParty = (AddressImpl)this.getLocalParty().clone();
                    AddressImpl currentRemoteParty = (AddressImpl)this.getRemoteParty().clone();
                    ((Parameters)currentRemoteParty.getAddress().getURI()).removeParameter("tag");
                    ((Parameters)currentLocalParty.getAddress().getURI()).removeParameter("tag");
                    String originalCallId = ((CallIdHeader)originalRequest.getHeader("Call-ID")).getCallId();
                    sipServletRequest = (SipServletRequestImpl)this.sipFactory.createRequest(this.getSipApplicationSession(), method, currentLocalParty, currentRemoteParty, this.handlerServlet, originalCallId, fromHeader.getTag());
                    Request request = (Request)sipServletRequest.getMessage();
                    sipServletRequest.getSipSession().setCseq(((CSeqHeader)request.getHeader("CSeq")).getSeqNumber());
                    HashMap<String, String> fromParameters = new HashMap<String, String>();
                    Iterator fromParameterNames = fromHeader.getParameterNames();
                    while (fromParameterNames.hasNext()) {
                        String parameterName = (String)fromParameterNames.next();
                        if (SipFactoryImpl.FORBIDDEN_PARAMS.contains(parameterName)) continue;
                        fromParameters.put(parameterName, fromHeader.getParameter(parameterName));
                    }
                    HashMap<String, String> toParameters = new HashMap<String, String>();
                    Iterator toParameterNames = toHeader.getParameterNames();
                    while (toParameterNames.hasNext()) {
                        String parameterName = (String)toParameterNames.next();
                        if (SipFactoryImpl.FORBIDDEN_PARAMS.contains(parameterName)) continue;
                        toParameters.put(parameterName, toHeader.getParameter(parameterName));
                    }
                    ToHeader newTo = (ToHeader)request.getHeader("To");
                    for (Map.Entry fromParameter : fromParameters.entrySet()) {
                        String value = (String)fromParameter.getValue();
                        if (value == null) {
                            value = "";
                        }
                        newTo.setParameter((String)fromParameter.getKey(), value);
                    }
                    FromHeader newFrom = (FromHeader)request.getHeader("From");
                    for (Map.Entry toParameter : toParameters.entrySet()) {
                        String value = (String)toParameter.getValue();
                        if (value == null) {
                            value = "";
                        }
                        newFrom.setParameter((String)toParameter.getKey(), value);
                    }
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Problem setting param on the newly created susbequent request " + sipServletRequest, e);
                }
            }
            return sipServletRequest;
        }
        String errorMessage = "Couldn't create the subsequent request " + method + " for this session " + this.key + ", isValid " + this.isValid() + ", session state " + this.state + " , sessionCreatingDialog = " + this.sessionCreatingDialog;
        if (this.sessionCreatingDialog != null) {
            errorMessage = errorMessage + " , dialog state " + this.sessionCreatingDialog.getState();
        }
        errorMessage = errorMessage + " , sessionCreatingTransactionRequest = " + this.sessionCreatingTransactionRequest;
        throw new IllegalStateException(errorMessage);
        Request request = (Request)sipServletRequest.getMessage();
        ListIterator routeHeaders = request.getHeaders("Route");
        request.removeHeader("Route");
        while (routeHeaders.hasNext()) {
            RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
            String routeAppNameHashed = ((javax.sip.address.SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
            String routeAppName = null;
            if (routeAppNameHashed != null) {
                routeAppName = this.sipFactory.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
            }
            if (routeAppName != null && routeAppName.equals(this.getKey().getApplicationName())) continue;
            request.addHeader((Header)routeHeader);
        }
        return sipServletRequest;
    }

    public SipApplicationSession getApplicationSession() {
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        if (sipApplicationSession == null) {
            return null;
        }
        return sipApplicationSession.getSession();
    }

    protected Map<String, Object> getAttributeMap() {
        if (this.sipSessionAttributeMap == null) {
            this.sipSessionAttributeMap = new ConcurrentHashMap<String, Object>();
        }
        return this.sipSessionAttributeMap;
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.getAttributeMap().get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        Vector<String> names = new Vector<String>(this.getAttributeMap().keySet());
        return names.elements();
    }

    public String getCallId() {
        if (this.sessionCreatingDialog != null) {
            return this.sessionCreatingDialog.getCallId().getCallId();
        }
        return ((CallIdHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("Call-ID")).getCallId();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.key.toString();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    private void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    @Override
    public void access() {
        this.setLastAccessedTime(System.currentTimeMillis());
    }

    public Address getLocalParty() {
        if (this.sessionCreatingDialog != null) {
            return new AddressImpl(this.sessionCreatingDialog.getLocalParty(), null, false);
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (this.isSessionCreatingTransactionServer) {
                ToHeader toHeader = (ToHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("To");
                return new AddressImpl(toHeader.getAddress(), AddressImpl.getParameters((Parameters)toHeader), false);
            }
            FromHeader fromHeader = (FromHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("From");
            return new AddressImpl(fromHeader.getAddress(), AddressImpl.getParameters((Parameters)fromHeader), false);
        }
        return this.localParty;
    }

    public SipApplicationRoutingRegion getRegion() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (this.routingRegion == null) {
            throw new IllegalStateException("This methos can be called only on initial requests");
        }
        return this.routingRegion;
    }

    @Override
    public SipApplicationRoutingRegion getRegionInternal() {
        return this.routingRegion;
    }

    @Override
    public void setRoutingRegion(SipApplicationRoutingRegion routingRegion) {
        this.routingRegion = routingRegion;
    }

    @Override
    public Serializable getStateInfo() {
        return this.stateInfo;
    }

    @Override
    public void setStateInfo(Serializable stateInfo) {
        this.stateInfo = stateInfo;
    }

    public Address getRemoteParty() {
        if (this.sessionCreatingDialog != null) {
            return new AddressImpl(this.sessionCreatingDialog.getRemoteParty(), null, false);
        }
        if (this.sessionCreatingTransactionRequest != null) {
            try {
                if (!this.isSessionCreatingTransactionServer) {
                    ToHeader toHeader = (ToHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("To");
                    return new AddressImpl(toHeader.getAddress(), AddressImpl.getParameters((Parameters)toHeader), false);
                }
                FromHeader fromHeader = (FromHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("From");
                return new AddressImpl(fromHeader.getAddress(), AddressImpl.getParameters((Parameters)fromHeader), false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error creating Address", e);
            }
        }
        return this.remoteParty;
    }

    public SipSession.State getState() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.state;
    }

    public URI getSubscriberURI() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (this.subscriberURI == null) {
            throw new IllegalStateException("Subscriber URI is only available for outbound sessions.");
        }
        try {
            return this.sipFactory.createURI(this.subscriberURI);
        }
        catch (ServletParseException e) {
            throw new IllegalArgumentException("couldn't parse the outbound interface " + this.subscriberURI, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        SipManager manager;
        if (!this.isValidInternal.compareAndSet(true, false)) {
            throw new IllegalStateException("SipSession already invalidated !");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Invalidating the sip session " + this.key));
        }
        if (this.sipSessionAttributeMap != null) {
            for (String key : this.sipSessionAttributeMap.keySet()) {
                this.removeAttribute(key, true);
            }
        }
        this.notifySipSessionListeners(SipSessionEventType.DELETION);
        this.isValid = false;
        if (this.derivedSipSessions != null) {
            for (MobicentsSipSession derivedMobicentsSipSession : this.derivedSipSessions.values()) {
                derivedMobicentsSipSession.invalidate();
            }
            this.derivedSipSessions.clear();
        }
        long timeNow = System.currentTimeMillis();
        int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        SipManager sipManager = manager = sipApplicationSession.getSipContext().getSipManager();
        synchronized (sipManager) {
            if (timeAlive > manager.getSipSessionMaxAliveTime()) {
                manager.setSipSessionMaxAliveTime(timeAlive);
            }
            int numExpired = manager.getExpiredSipSessions();
            manager.setExpiredSipSessions(++numExpired);
            int average = manager.getSipSessionAverageAliveTime();
            average = (average * (numExpired - 1) + timeAlive) / numExpired;
            manager.setSipSessionAverageAliveTime(average);
        }
        manager.removeSipSession(this.key);
        sipApplicationSession.getSipContext().getSipSessionsUtil().removeCorrespondingSipSession(this.key);
        sipApplicationSession.onSipSessionReadyToInvalidate(this);
        if (this.ongoingTransactions != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.ongoingTransactions.size() + " ongoing transactions still present in the following sip session " + this.key + " on invalidation"));
            }
            for (Transaction transaction : this.ongoingTransactions) {
                if (TransactionState.TERMINATED.equals((Object)transaction.getState())) continue;
                if (transaction.getApplicationData() != null) {
                    ((TransactionApplicationData)transaction.getApplicationData()).cleanUp();
                }
                try {
                    transaction.terminate();
                }
                catch (ObjectInUseException e) {}
            }
            this.ongoingTransactions.clear();
        }
        if (this.subscriptions != null) {
            this.subscriptions.clear();
        }
        this.parentSession = null;
        this.userPrincipal = null;
        manager = null;
        if (this.b2buaHelper != null) {
            this.b2buaHelper.unlinkSipSessionsInternal(this, false);
            this.b2buaHelper = null;
        }
        this.derivedSipSessions = null;
        this.handlerServlet = null;
        this.localParty = null;
        this.ongoingTransactions = null;
        this.originalMethod = null;
        this.outboundInterface = null;
        this.sipSessionAttributeMap = null;
        if (this.sessionCreatingDialog != null) {
            if (!DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState())) {
                this.sessionCreatingDialog.delete();
            }
            this.sessionCreatingDialog = null;
        }
        if (this.sessionCreatingTransactionRequest != null) {
            Transaction sessionCreatingTransaction = this.sessionCreatingTransactionRequest.getTransaction();
            if (sessionCreatingTransaction != null && !TransactionState.TERMINATED.equals((Object)sessionCreatingTransaction.getState())) {
                try {
                    sessionCreatingTransaction.terminate();
                }
                catch (ObjectInUseException e) {
                    // empty catch block
                }
            }
            this.sessionCreatingTransactionRequest.cleanUp();
            this.sessionCreatingTransactionRequest = null;
        }
        if (this.proxy != null) {
            try {
                this.proxy.cancel();
            }
            catch (Exception e) {
                logger.debug((Object)"Problem cancelling proxy. We just try our best. This is not a critical error.", (Throwable)e);
            }
            this.proxy.getTransactionMap().clear();
            this.proxy.getProxyBranchesMap().clear();
            this.proxy = null;
        }
        this.remoteParty = null;
        this.routingRegion = null;
        this.sipFactory = null;
        this.state = null;
        this.stateInfo = null;
        this.subscriberURI = null;
        this.subscriptions = null;
        this.facade = null;
    }

    protected boolean hasOngoingTransaction() {
        if (!this.isSupervisedMode()) {
            return false;
        }
        if (this.ongoingTransactions != null) {
            for (Transaction transaction : this.ongoingTransactions) {
                if (!TransactionState.CALLING.equals((Object)transaction.getState()) && !TransactionState.TRYING.equals((Object)transaction.getState()) && !TransactionState.PROCEEDING.equals((Object)transaction.getState()) && !TransactionState.COMPLETED.equals((Object)transaction.getState()) && !TransactionState.CONFIRMED.equals((Object)transaction.getState())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isValidInternal() {
        return this.isValidInternal.get();
    }

    protected void setValid(boolean isValid) {
        this.isValidInternal.set(isValid);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, false);
    }

    public void removeAttribute(String name, boolean byPassValidCheck) {
        if (!byPassValidCheck && !this.isValid()) {
            throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
        }
        if (name == null) {
            return;
        }
        SipSessionBindingEvent event = null;
        Object value = this.getAttributeMap().get(name);
        if (value != null && value instanceof SipSessionBindingListener) {
            event = new SipSessionBindingEvent((SipSession)this, name);
            ((SipSessionBindingListener)value).valueUnbound(event);
        }
        this.getAttributeMap().remove(name);
        SipListenersHolder sipListenersHolder = this.getSipApplicationSession().getSipContext().getListeners();
        List<SipSessionAttributeListener> listenersList = sipListenersHolder.getSipSessionAttributeListeners();
        if (listenersList.size() > 0) {
            if (event == null) {
                event = new SipSessionBindingEvent((SipSession)this, name);
            }
            for (SipSessionAttributeListener listener : listenersList) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute removed on key " + this.key));
                }
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionAttributeListener threw exception", t);
                }
            }
        }
    }

    public void setAttribute(String key, Object attribute) {
        block20: {
            SipListenersHolder sipListenersHolder;
            List<SipSessionAttributeListener> listenersList;
            Object previousValue;
            Object oldValue;
            if (!this.isValid()) {
                throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
            }
            if (key == null) {
                throw new NullPointerException("Name of attribute to bind cant be null!!!");
            }
            if (attribute == null) {
                throw new NullPointerException("Attribute that is to be bound cant be null!!!");
            }
            SipSessionBindingEvent event = null;
            if (attribute instanceof SipSessionBindingListener && attribute != (oldValue = this.getAttributeMap().get(key))) {
                event = new SipSessionBindingEvent((SipSession)this, key);
                try {
                    ((SipSessionBindingListener)attribute).valueBound(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((previousValue = this.getAttributeMap().put(key, attribute)) != null && previousValue != attribute && previousValue instanceof SipSessionBindingListener) {
                try {
                    ((SipSessionBindingListener)previousValue).valueUnbound(new SipSessionBindingEvent((SipSession)this, key));
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((listenersList = (sipListenersHolder = this.getSipApplicationSession().getSipContext().getListeners()).getSipSessionAttributeListeners()).size() <= 0) break block20;
            if (event == null) {
                event = new SipSessionBindingEvent((SipSession)this, key);
            }
            if (previousValue == null) {
                for (SipSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute added on key " + key));
                    }
                    try {
                        listener.attributeAdded(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipSessionAttributeListener threw exception", t);
                    }
                }
            } else {
                for (SipSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute replaced on key " + key));
                    }
                    try {
                        listener.attributeReplaced(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipSessionAttributeListener threw exception", t);
                    }
                }
            }
        }
    }

    public void setHandler(String name) throws ServletException {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has already been invalidated, no handler can be set on it anymore !");
        }
        if (name != null && name.equals(this.handlerServlet)) {
            return;
        }
        SipContext sipContext = this.getSipApplicationSession().getSipContext();
        Container container = sipContext.findChildrenByName(name);
        if (container == null && sipContext.getSipRubyController() == null) {
            throw new ServletException("the sip servlet with the name " + name + " doesn't exist in the sip application " + sipContext.getApplicationName());
        }
        this.handlerServlet = name;
        this.getSipApplicationSession().setCurrentRequestHandler(this.handlerServlet);
        if (logger.isDebugEnabled()) {
            if (name != null) {
                logger.debug((Object)("Session Handler for application " + this.getKey().getApplicationName() + " set to " + this.handlerServlet + " on sip session " + this.key));
            } else {
                logger.debug((Object)("Session Handler for application " + this.getKey().getApplicationName() + " set to " + sipContext.getSipRubyController() + " on sip session " + this.key));
            }
        }
    }

    @Override
    public String getHandler() {
        return this.handlerServlet;
    }

    @Override
    public void setSessionCreatingDialog(Dialog dialog) {
        this.sessionCreatingDialog = dialog;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting session creating dialog for this session to " + dialog));
            if (dialog != null) {
                logger.debug((Object)("session creating dialog dialogId " + dialog.getDialogId()));
            }
        }
    }

    @Override
    public Dialog getSessionCreatingDialog() {
        return this.sessionCreatingDialog;
    }

    @Override
    public MobicentsSipApplicationSession getSipApplicationSession() {
        if (this.sipApplicationSession == null) {
            String applicationName = this.key.getApplicationName();
            SipContext sipContext = this.sipFactory.getSipApplicationDispatcher().findSipApplication(applicationName);
            if (sipContext != null) {
                this.sipApplicationSession = sipContext.getSipManager().getSipApplicationSession(this.sipApplicationSessionKey, false);
            }
        }
        return this.sipApplicationSession;
    }

    protected void setSipApplicationSession(MobicentsSipApplicationSession sipApplicationSession) {
        if (sipApplicationSession != null) {
            this.sipApplicationSessionKey = sipApplicationSession.getKey();
            sipApplicationSession.addSipSession(this);
        }
    }

    @Override
    public SipServletRequestImpl getSessionCreatingTransactionRequest() {
        return this.sessionCreatingTransactionRequest;
    }

    @Override
    public void setSessionCreatingTransactionRequest(SipServletMessageImpl message) {
        if (message != null) {
            SipServletMessageImpl sipServletMessageImpl;
            if (message instanceof SipServletRequestImpl) {
                this.sessionCreatingTransactionRequest = (SipServletRequestImpl)message;
                this.isSessionCreatingTransactionServer = message.getTransaction() instanceof ServerTransaction;
            } else if (message.getTransaction() != null && message.getTransaction().getApplicationData() != null && (sipServletMessageImpl = ((TransactionApplicationData)message.getTransaction().getApplicationData()).getSipServletMessage()) != null && sipServletMessageImpl instanceof SipServletRequestImpl) {
                this.sessionCreatingTransactionRequest = (SipServletRequestImpl)sipServletMessageImpl;
                this.isSessionCreatingTransactionServer = message.getTransaction() instanceof ServerTransaction;
            }
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (this.originalMethod == null) {
                this.originalMethod = this.sessionCreatingTransactionRequest.getMethod();
            }
            this.addOngoingTransaction(this.sessionCreatingTransactionRequest.getTransaction());
            if (this.parentSession != null && "REGISTER".equals(this.originalMethod)) {
                this.parentSession.setSessionCreatingTransactionRequest(message);
            }
        }
    }

    public boolean isSupervisedMode() {
        if (this.proxy == null) {
            return true;
        }
        return this.proxy.getSupervised();
    }

    @Override
    public void setSipSubscriberURI(String subscriberURI) {
        this.subscriberURI = subscriberURI;
    }

    @Override
    public String getSipSubscriberURI() {
        return this.subscriberURI;
    }

    @Override
    public String getOutboundInterface() {
        return this.outboundInterface;
    }

    public void onDialogTimeout(Dialog dialog) {
        if (this.hasOngoingTransaction()) {
            throw new IllegalStateException("Dialog timed out, but there are active transactions.");
        }
        this.state = SipSession.State.TERMINATED;
    }

    @Override
    public void setState(SipSession.State state) {
        this.state = state;
    }

    @Override
    public void onTerminatedState() {
        if (this.isValidInternal()) {
            this.onReadyToInvalidate();
            if (this.parentSession != null) {
                Iterator<MobicentsSipSession> derivedSessionsIterator = this.parentSession.getDerivedSipSessions();
                while (derivedSessionsIterator.hasNext()) {
                    MobicentsSipSession mobicentsSipSession = derivedSessionsIterator.next();
                    if (!mobicentsSipSession.isValidInternal() || mobicentsSipSession.isReadyToInvalidate()) continue;
                    return;
                }
                this.parentSession.onReadyToInvalidate();
            }
        }
    }

    @Override
    public void addOngoingTransaction(Transaction transaction) {
        boolean added;
        if (transaction != null && this.ongoingTransactions != null && !this.isReadyToInvalidate() && (added = this.ongoingTransactions.add(transaction))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transaction " + transaction + " has been added to sip session's ongoingTransactions"));
            }
            this.setReadyToInvalidate(false);
        }
    }

    @Override
    public void removeOngoingTransaction(Transaction transaction) {
        if (this.ongoingTransactions != null) {
            this.ongoingTransactions.remove(transaction);
        }
        if (this.sessionCreatingTransactionRequest != null && this.sessionCreatingTransactionRequest.getTransaction() != null && this.sessionCreatingTransactionRequest.getTransaction().equals(transaction)) {
            this.sessionCreatingTransactionRequest.cleanUp();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + transaction + " has been removed from sip session's ongoingTransactions"));
        }
        this.updateReadyToInvalidate(transaction);
    }

    @Override
    public Set<Transaction> getOngoingTransactions() {
        return this.ongoingTransactions;
    }

    @Override
    public void updateStateOnResponse(SipServletResponseImpl response, boolean receive) {
        block22: {
            String method = response.getMethod();
            if (!JainSipUtils.DIALOG_CREATING_METHODS.contains(method) && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                return;
            }
            if ((SipSession.State.INITIAL.equals((Object)this.state) || SipSession.State.EARLY.equals((Object)this.state)) && response.getStatus() >= 200 && response.getStatus() < 300 && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                this.setState(SipSession.State.CONFIRMED);
                if (this.proxy != null && response.getProxyBranch() != null && !response.getProxyBranch().getRecordRoute()) {
                    this.setReadyToInvalidate(true);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
            if (SipSession.State.INITIAL.equals((Object)this.state) && response.getStatus() >= 100 && response.getStatus() < 200) {
                this.setState(SipSession.State.EARLY);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
            if ((SipSession.State.INITIAL.equals((Object)this.state) || SipSession.State.EARLY.equals((Object)this.state)) && response.getStatus() >= 300 && response.getStatus() < 700 && JainSipUtils.DIALOG_CREATING_METHODS.contains(method) && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                if (receive) {
                    this.setState(SipSession.State.INITIAL);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                    }
                } else {
                    this.setState(SipSession.State.TERMINATED);
                    this.setReadyToInvalidate(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                    }
                }
            }
            if ((SipSession.State.CONFIRMED.equals((Object)this.state) || SipSession.State.TERMINATED.equals((Object)this.state)) && response.getStatus() == 200 && "BYE".equals(method) || !SipSession.State.CONFIRMED.equals((Object)this.state) && response.getStatus() == 487) {
                boolean hasOngoingSubscriptions = false;
                if (this.subscriptions != null) {
                    if (this.subscriptions.size() > 0) {
                        hasOngoingSubscriptions = true;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has " + this.subscriptions.size() + " subscriptions"));
                    }
                    if (!hasOngoingSubscriptions && this.sessionCreatingDialog != null) {
                        this.sessionCreatingDialog.delete();
                    }
                }
                if (!(hasOngoingSubscriptions || this.getProxy() != null && response.getStatus() == 487)) {
                    this.setState(SipSession.State.TERMINATED);
                    this.setReadyToInvalidate(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                        logger.debug((Object)("the following sip session " + this.getKey() + " is ready to be invalidated "));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
                this.okToByeSentOrReceived = true;
            }
            if (response.getTransactionApplicationData().isCanceled()) {
                SipServletRequest request = (SipServletRequest)response.getTransactionApplicationData().getSipServletMessage();
                try {
                    request.createCancel().send();
                }
                catch (IOException e) {
                    if (!logger.isEnabledFor(Priority.WARN)) break block22;
                    logger.warn((Object)("Couldn't send CANCEL for a transaction that has been CANCELLED but CANCEL was not sent because there was no response from the other side. We just stopped the retransmissions." + response + "\nThe transaction" + response.getTransaction()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void updateStateOnSubsequentRequest(SipServletRequestImpl request, boolean receive) {
        if ("CANCEL".equalsIgnoreCase(request.getMethod())) {
            if (!(request.getTransaction() instanceof ServerTransactionExt)) {
                return;
            }
            ServerTransaction inviteTransaction = ((ServerTransactionExt)request.getTransaction()).getCanceledInviteTransaction();
            TransactionApplicationData inviteAppData = (TransactionApplicationData)inviteTransaction.getApplicationData();
            SipServletRequestImpl inviteRequest = (SipServletRequestImpl)inviteAppData.getSipServletMessage();
            if (inviteRequest != null && inviteRequest.isInitial() && inviteRequest.getLastFinalResponse() == null || this.proxy != null && this.proxy.getBestResponse() == null) {
                this.setState(SipSession.State.TERMINATED);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
        }
        if ("ACK".equalsIgnoreCase(request.getMethod()) && this.sessionCreatingTransactionRequest != null) {
            this.sessionCreatingTransactionRequest.cleanUpLastResponses();
        }
    }

    private void updateReadyToInvalidate(Transaction transaction) {
        if (!this.readyToInvalidate && (this.ongoingTransactions == null || this.ongoingTransactions.isEmpty()) && transaction instanceof ClientTransaction && this.getProxy() == null && this.state != null && this.state.equals((Object)SipSession.State.INITIAL)) {
            this.setReadyToInvalidate(true);
        }
    }

    @Override
    public void onReadyToInvalidate() {
        this.setReadyToInvalidate(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invalidateWhenReady flag is set to " + this.invalidateWhenReady));
        }
        if (this.isValid() && this.invalidateWhenReady) {
            this.notifySipSessionListeners(SipSessionEventType.READYTOINVALIDATE);
            if (this.isValid()) {
                this.invalidate();
            }
        }
    }

    @Override
    public SipSessionKey getKey() {
        return this.key;
    }

    public void setKey(SipSessionKey key) {
        this.key = key;
    }

    @Override
    public ProxyImpl getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(ProxyImpl proxy) {
        this.proxy = proxy;
    }

    @Override
    public void setB2buaHelper(B2buaHelperImpl helperImpl) {
        this.b2buaHelper = helperImpl;
    }

    @Override
    public B2buaHelperImpl getB2buaHelper() {
        return this.b2buaHelper;
    }

    public void passivate() {
        SipSessionEvent event = null;
        if (this.sipSessionAttributeMap != null) {
            Set<String> keySet = this.getAttributeMap().keySet();
            for (String key : keySet) {
                Object attribute = this.getAttributeMap().get(key);
                if (!(attribute instanceof SipSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipSessionEvent((SipSession)this);
                }
                try {
                    ((SipSessionActivationListener)attribute).sessionWillPassivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionActivationListener threw exception", t);
                }
            }
        }
    }

    public void activate() {
        SipSessionEvent event = null;
        if (this.sipSessionAttributeMap != null) {
            Set<String> keySet = this.getAttributeMap().keySet();
            for (String key : keySet) {
                Object attribute = this.getAttributeMap().get(key);
                if (!(attribute instanceof SipSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipSessionEvent((SipSession)this);
                }
                try {
                    ((SipSessionActivationListener)attribute).sessionDidActivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionActivationListener threw exception", t);
                }
            }
        }
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public boolean getInvalidateWhenReady() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.invalidateWhenReady;
    }

    public boolean isReadyToInvalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.readyToInvalidate;
    }

    protected void setReadyToInvalidate(boolean readyToInvalidate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("readyToInvalidate flag is set to " + readyToInvalidate));
        }
        this.readyToInvalidate = readyToInvalidate;
    }

    public boolean isReadyToInvalidateInternal() {
        return this.readyToInvalidate;
    }

    public void setInvalidateWhenReady(boolean arg0) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        this.invalidateWhenReady = arg0;
    }

    public void setOutboundInterface(InetAddress inetAddress) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (inetAddress == null) {
            throw new NullPointerException("parameter is null");
        }
        String address = inetAddress.getHostAddress();
        List<SipURI> list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        try {
            this.outboundInterface = new SipURIImpl(SipFactories.addressFactory.createSipURI(null, address)).toString();
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + null + "] HOST[" + address + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + null + " host = " + address);
        }
    }

    public void setOutboundInterface(InetSocketAddress inetSocketAddress) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("parameter is null");
        }
        String address = inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        List<SipURI> list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        try {
            this.outboundInterface = new SipURIImpl(SipFactories.addressFactory.createSipURI(null, address)).toString();
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + null + "] HOST[" + address + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + null + " host = " + address);
        }
    }

    public void setOutboundInterface(SipURI outboundInterface) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (outboundInterface == null) {
            throw new NullPointerException("parameter is null");
        }
        List<SipURI> list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.equals(outboundInterface)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + outboundInterface + " not found");
        }
        this.outboundInterface = outboundInterface.toString();
    }

    public ServletContext getServletContext() {
        return this.getSipApplicationSession().getSipContext().getServletContext();
    }

    @Override
    public MobicentsSipSession removeDerivedSipSession(String toTag) {
        return this.derivedSipSessions.remove(toTag);
    }

    @Override
    public MobicentsSipSession findDerivedSipSession(String toTag) {
        if (this.derivedSipSessions != null) {
            return this.derivedSipSessions.get(toTag);
        }
        return null;
    }

    @Override
    public Iterator<MobicentsSipSession> getDerivedSipSessions() {
        if (this.derivedSipSessions != null) {
            return this.derivedSipSessions.values().iterator();
        }
        return new HashMap().values().iterator();
    }

    @Override
    public void setParentSession(MobicentsSipSession mobicentsSipSession) {
        this.parentSession = mobicentsSipSession;
    }

    @Override
    public void setSipSessionAttributeMap(Map<String, Object> sipSessionAttributeMap) {
        this.sipSessionAttributeMap = sipSessionAttributeMap;
    }

    @Override
    public void addDerivedSipSessions(MobicentsSipSession derivedSession) {
        if (this.derivedSipSessions == null) {
            this.derivedSipSessions = new ConcurrentHashMap();
        }
        this.derivedSipSessions.putIfAbsent(derivedSession.getKey().getToTag(), derivedSession);
    }

    @Override
    public Map<String, Object> getSipSessionAttributeMap() {
        return this.getAttributeMap();
    }

    @Override
    public void setLocalParty(Address localParty) {
        this.localParty = localParty;
    }

    @Override
    public void setRemoteParty(Address remoteParty) {
        this.remoteParty = remoteParty;
    }

    @Override
    public void addSubscription(SipServletMessageImpl sipServletMessageImpl) throws SipException {
        EventHeader eventHeader = null;
        eventHeader = sipServletMessageImpl instanceof SipServletResponseImpl ? (EventHeader)((SipServletRequestImpl)((SipServletResponseImpl)sipServletMessageImpl).getRequest()).getMessage().getHeader("Event") : (EventHeader)sipServletMessageImpl.getMessage().getHeader("Event");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding subscription " + eventHeader + " to sip session " + this.getId()));
        }
        if (this.subscriptions == null) {
            this.subscriptions = new CopyOnWriteArraySet<EventHeader>();
        }
        this.subscriptions.add(eventHeader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request from Original Transaction is " + this.originalMethod));
            logger.debug((Object)("Dialog is " + this.sessionCreatingDialog));
        }
        if (this.subscriptions.size() < 2 && "INVITE".equals(this.originalMethod)) {
            this.sessionCreatingDialog.terminateOnBye(false);
        }
    }

    @Override
    public void removeSubscription(SipServletMessageImpl sipServletMessageImpl) {
        EventHeader eventHeader = (EventHeader)sipServletMessageImpl.getMessage().getHeader("Event");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removing subscription " + eventHeader + " to sip session " + this.getId()));
        }
        boolean hasOngoingSubscriptions = false;
        if (this.subscriptions != null) {
            this.subscriptions.remove(eventHeader);
            if (this.subscriptions.size() > 0) {
                hasOngoingSubscriptions = true;
            }
            if (!hasOngoingSubscriptions && this.subscriptions.size() < 1 && (this.originalMethod != null && this.okToByeSentOrReceived || !"INVITE".equals(this.originalMethod))) {
                this.setReadyToInvalidate(true);
                this.setState(SipSession.State.TERMINATED);
            }
        }
        if (this.isReadyToInvalidateInternal()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no more subscriptions in session " + this.getId()));
            }
            if (this.sessionCreatingDialog != null) {
                this.sessionCreatingDialog.delete();
            }
        }
    }

    @Override
    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Override
    public MobicentsSipSessionFacade getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final SipSessionImpl fsession = this;
                this.facade = (MobicentsSipSessionFacade)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MobicentsSipSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new MobicentsSipSessionFacade(this);
            }
        }
        return this.facade;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MobicentsSipSession) {
            return ((MobicentsSipSession)obj).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getKey().toString();
    }

    @Override
    public SipApplicationRouterInfo getNextSipApplicationRouterInfo() {
        return this.nextSipApplicationRouterInfo;
    }

    @Override
    public void setNextSipApplicationRouterInfo(SipApplicationRouterInfo routerInfo) {
        this.nextSipApplicationRouterInfo = routerInfo;
    }

    @Override
    public boolean isAckReceived() {
        return this.ackReceived;
    }

    @Override
    public void setAckReceived(boolean ackReceived) {
        this.ackReceived = ackReceived;
    }

    @Override
    public long getCseq() {
        return this.cseq;
    }

    @Override
    public void setCseq(long cseq) {
        this.cseq = cseq;
    }

    @Override
    public synchronized boolean validateCSeq(SipServletRequestImpl sipServletRequest) {
        boolean isAckRetranmission;
        Request request = (Request)sipServletRequest.getMessage();
        long localCseq = this.cseq;
        long remoteCseq = ((CSeqHeader)request.getHeader("CSeq")).getSeqNumber();
        String method = request.getMethod();
        boolean isAck = "ACK".equalsIgnoreCase(method);
        boolean isPrackCancel = "PRACK".equalsIgnoreCase(method) || "CANCEL".equalsIgnoreCase(method);
        boolean bl = isAckRetranmission = this.isAckReceived() && isAck;
        if (isAck) {
            this.setAckReceived(true);
        }
        if (isAckRetranmission) {
            logger.debug((Object)"ACK filtered out as a retransmission. This Sip Session already has been ACKed.");
            return false;
        }
        if (localCseq == remoteCseq && !isAck) {
            logger.debug((Object)("dropping retransmission " + request + " since it matches the current sip session cseq " + localCseq));
            return false;
        }
        if (localCseq > remoteCseq && !isAck && !isPrackCancel) {
            logger.error((Object)("CSeq out of order for the following request " + sipServletRequest));
            SipServletResponse response = sipServletRequest.createResponse(500, "CSeq out of order");
            try {
                response.send();
            }
            catch (IOException e) {
                logger.error((Object)"Can not send error response", (Throwable)e);
            }
            return false;
        }
        if ("INVITE".equalsIgnoreCase(method)) {
            this.setAckReceived(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("resetting the ack retransmission flag on the sip session " + this.getKey() + " because following reINVITE has been received " + request));
            }
        }
        this.setCseq(remoteCseq);
        return true;
    }

    @Override
    public String getTransport() {
        return this.transport;
    }

    @Override
    public void setTransport(String transport) {
        this.transport = transport;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SipSessionEventType {
        CREATION,
        DELETION,
        READYTOINVALIDATE;

    }
}

