/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.text.ParseException;
import java.util.StringTokenizer;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;

public class SessionManagerUtil {
    private static final Logger logger = Logger.getLogger(SessionManagerUtil.class);
    public static final String TAG_PARAMETER_NAME = "tag";
    public static final String SESSION_KEY_SEPARATOR = ":";

    public static SipSessionKey getSipSessionKey(String applicationSessionId, String applicationName, Message message, boolean inverted) {
        if (applicationName == null) {
            throw new NullPointerException("the application name cannot be null for sip session key creation");
        }
        ToHeader to = (ToHeader)message.getHeader("To");
        FromHeader from = (FromHeader)message.getHeader("From");
        String toTag = to.getTag();
        String fromTag = from.getTag();
        if (inverted) {
            return new SipSessionKey(toTag, fromTag, ((CallIdHeader)message.getHeader("Call-ID")).getCallId(), applicationSessionId, applicationName);
        }
        return new SipSessionKey(fromTag, toTag, ((CallIdHeader)message.getHeader("Call-ID")).getCallId(), applicationSessionId, applicationName);
    }

    public static SipApplicationSessionKey getSipApplicationSessionKey(String applicationName, String id) {
        if (applicationName == null) {
            throw new NullPointerException("the application name cannot be null for sip application session key creation");
        }
        return new SipApplicationSessionKey(id, applicationName);
    }

    public static SipApplicationSessionKey parseSipApplicationSessionKey(String sipApplicationKey) throws ParseException {
        int indexOfLeftParenthesis = sipApplicationKey.indexOf("(");
        int indexOfComma = sipApplicationKey.indexOf(SESSION_KEY_SEPARATOR);
        int indexOfRightParenthesis = sipApplicationKey.indexOf(")");
        if (indexOfLeftParenthesis == -1) {
            throw new ParseException("The left parenthesis could not be found in the following key " + sipApplicationKey, 0);
        }
        if (indexOfComma == -1) {
            throw new ParseException("The comma could not be found in the following key " + sipApplicationKey, 0);
        }
        if (indexOfRightParenthesis == -1) {
            throw new ParseException("The right parenthesis could not be found in the following key " + sipApplicationKey, 0);
        }
        String uuid = sipApplicationKey.substring(indexOfLeftParenthesis + 1, indexOfComma);
        String applicationName = sipApplicationKey.substring(indexOfComma + 1, indexOfRightParenthesis);
        return SessionManagerUtil.getSipApplicationSessionKey(applicationName, uuid);
    }

    public static SipSessionKey parseSipSessionKey(String sipSessionKey) throws ParseException {
        int indexOfLeftParenthesis = sipSessionKey.indexOf("(");
        int indexOfRightParenthesis = sipSessionKey.indexOf(")");
        if (indexOfLeftParenthesis == -1) {
            throw new ParseException("The left parenthesis could not be found in the following key " + sipSessionKey, 0);
        }
        if (indexOfRightParenthesis == -1) {
            throw new ParseException("The right parenthesis could not be found in the following key " + sipSessionKey, 0);
        }
        String sipSessionKeyToParse = sipSessionKey.substring(indexOfLeftParenthesis + 1, indexOfRightParenthesis);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sipSession key to parse " + sipSessionKeyToParse));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(sipSessionKeyToParse, SESSION_KEY_SEPARATOR);
        String fromTag = stringTokenizer.nextToken();
        String callId = stringTokenizer.nextToken();
        String applicationSessionId = stringTokenizer.nextToken();
        String applicationName = stringTokenizer.nextToken();
        return new SipSessionKey(fromTag, null, callId, applicationSessionId, applicationName);
    }

    public static SipSessionKey parseHaSipSessionKey(String sipSessionKey, String sipAppSessionId, String sipApplicationName) throws ParseException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sipSession key to parse " + sipSessionKey));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(sipSessionKey, SESSION_KEY_SEPARATOR);
        String fromTag = stringTokenizer.nextToken();
        String callId = stringTokenizer.nextToken();
        return new SipSessionKey(fromTag, null, callId, sipAppSessionId, sipApplicationName);
    }

    public static String getSipSessionHaKey(SipSessionKey key) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(key.getFromTag()).append(SESSION_KEY_SEPARATOR).append(key.getCallId());
        return stringBuilder.toString();
    }
}

