/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipApplicationSession;
import org.apache.catalina.Manager;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSession;
import org.mobicents.servlet.sip.core.session.ConvergedSession;
import org.mobicents.servlet.sip.core.session.ConvergedSessionDelegate;
import org.mobicents.servlet.sip.core.session.ConvergedSessionFacade;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.SipManager;

public class ConvergedStandardSession
extends StandardSession
implements ConvergedSession {
    private static final long serialVersionUID = 1L;
    protected transient ConvergedSessionFacade convergedFacade = null;
    private transient ConvergedSessionDelegate convergedSessionDelegate = null;

    public ConvergedStandardSession(SipManager manager) {
        super((Manager)manager);
        this.convergedSessionDelegate = new ConvergedSessionDelegate(manager, this);
    }

    public HttpSession getSession() {
        if (this.convergedFacade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final ConvergedStandardSession fsession = this;
                this.convergedFacade = AccessController.doPrivileged(new PrivilegedAction<ConvergedSessionFacade>(){

                    @Override
                    public ConvergedSessionFacade run() {
                        return new ConvergedSessionFacade(fsession);
                    }
                });
            } else {
                this.convergedFacade = new ConvergedSessionFacade(this);
            }
        }
        return this.convergedFacade;
    }

    public String encodeURL(String url) {
        return this.convergedSessionDelegate.encodeURL(url);
    }

    public String encodeURL(String relativePath, String scheme) {
        return this.convergedSessionDelegate.encodeURL(relativePath, scheme);
    }

    public SipApplicationSession getApplicationSession() {
        return this.convergedSessionDelegate.getApplicationSession(true);
    }

    public MobicentsSipApplicationSession getApplicationSession(boolean create) {
        return this.convergedSessionDelegate.getApplicationSession(create);
    }

    public boolean isValid() {
        return this.isValidInternal();
    }

    public void invalidate() {
        super.invalidate();
        MobicentsSipApplicationSession sipApplicationSession = this.convergedSessionDelegate.getApplicationSession(false);
        if (sipApplicationSession != null) {
            sipApplicationSession.tryToInvalidate();
        }
    }

    public void access() {
        super.access();
        MobicentsSipApplicationSession sipApplicationSession = this.convergedSessionDelegate.getApplicationSession(false);
        if (sipApplicationSession != null) {
            sipApplicationSession.access();
        }
    }
}

