/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.ConvergedSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.startup.SipContext;

public class ConvergedSessionDelegate {
    private static final Logger logger = Logger.getLogger(ConvergedSessionDelegate.class);
    private static final String APPLICATION_SESSION_ID_ATTRIBUTE_NAME = "org.mobicents.servlet.sip.SipApplicationSessionId";
    protected SipManager sipManager;
    protected ConvergedSession httpSession;

    public ConvergedSessionDelegate(SipManager manager, ConvergedSession httpSession) {
        this.sipManager = manager;
        this.httpSession = httpSession;
    }

    public String encodeURL(String url) {
        StringBuffer urlEncoded = new StringBuffer();
        int indexOfQuestionMark = url.indexOf("?");
        if (indexOfQuestionMark > 0) {
            String urlBeforeQuestionMark = url.substring(0, indexOfQuestionMark);
            String urlAfterQuestionMark = url.substring(indexOfQuestionMark);
            urlEncoded = urlEncoded.append(urlBeforeQuestionMark);
            urlEncoded = urlEncoded.append(";jsessionid=");
            urlEncoded = urlEncoded.append(this.httpSession.getId());
            urlEncoded = urlEncoded.append(urlAfterQuestionMark);
        } else {
            int indexOfPoundSign = url.indexOf("#");
            if (indexOfPoundSign > 0) {
                String urlBeforePoundSign = url.substring(0, indexOfPoundSign);
                String urlAfterPoundSign = url.substring(indexOfPoundSign);
                urlEncoded = urlEncoded.append(urlBeforePoundSign);
                urlEncoded = urlEncoded.append(";jsessionid=");
                urlEncoded = urlEncoded.append(this.httpSession.getId());
                urlEncoded = urlEncoded.append(urlAfterPoundSign);
            } else {
                urlEncoded = urlEncoded.append(url);
                urlEncoded = urlEncoded.append(";jsessionid=");
                urlEncoded = urlEncoded.append(this.httpSession.getId());
            }
        }
        return urlEncoded.toString();
    }

    public String encodeURL(String relativePath, String scheme) {
        StringBuffer urlEncoded = new StringBuffer();
        Context context = (Context)this.sipManager.getContainer();
        Host host = (Host)context.getParent();
        Service service = ((Engine)host.getParent()).getService();
        String hostname = host.getName();
        int port = -1;
        Connector[] connectors = service.findConnectors();
        for (int i = 0; i < connectors.length && port < 0; ++i) {
            if (scheme == null || !connectors[i].getProtocol().toLowerCase().contains(scheme.toLowerCase())) continue;
            port = connectors[i].getPort();
        }
        urlEncoded = urlEncoded.append(scheme);
        urlEncoded = urlEncoded.append("://");
        urlEncoded = urlEncoded.append(hostname);
        urlEncoded = urlEncoded.append(":");
        urlEncoded = urlEncoded.append(port);
        urlEncoded = urlEncoded.append(((Context)this.sipManager.getContainer()).getPath());
        urlEncoded = urlEncoded.append(this.encodeURL(relativePath));
        return urlEncoded.toString();
    }

    public MobicentsSipApplicationSession getApplicationSession(boolean create) {
        MobicentsSipApplicationSession sipApplicationSession;
        SipApplicationSessionKey key = null;
        if (this.httpSession.isValid()) {
            key = (SipApplicationSessionKey)this.httpSession.getAttribute(APPLICATION_SESSION_ID_ATTRIBUTE_NAME);
        }
        if (key != null) {
            MobicentsSipApplicationSession sipAppSession = this.sipManager.getSipApplicationSession(key, false);
            if (sipAppSession != null) {
                return sipAppSession;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(key + " found in http session " + this.httpSession.getId() + " but not present in the manager. already invalidated ? creating new sip application session"));
            }
        }
        if ((sipApplicationSession = this.sipManager.findSipApplicationSession((HttpSession)this.httpSession)) == null && create) {
            SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(((SipContext)this.sipManager.getContainer()).getApplicationName(), null);
            sipApplicationSession = this.sipManager.getSipApplicationSession(sipApplicationSessionKey, true);
            this.httpSession.setAttribute(APPLICATION_SESSION_ID_ATTRIBUTE_NAME, sipApplicationSession.getKey());
            sipApplicationSession.addHttpSession((HttpSession)this.httpSession);
        }
        if (sipApplicationSession != null) {
            return sipApplicationSession.getSession();
        }
        return null;
    }
}

