/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletResponse;
import javax.sip.Dialog;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.SipURI;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.DispatcherException;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.startup.SipContext;

public class SubsequentRequestDispatcher
extends RequestDispatcher {
    private static final Logger logger = Logger.getLogger(SubsequentRequestDispatcher.class);

    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        boolean isValid;
        SipContext sipContext;
        Parameters poppedAddress;
        String applicationNameHashed;
        SipFactoryImpl sipFactoryImpl = this.sipApplicationDispatcher.getSipFactory();
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)sipServletMessage;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Routing of Subsequent Request " + sipServletRequest));
        }
        Request request = (Request)sipServletRequest.getMessage();
        Dialog dialog = sipServletRequest.getDialog();
        RouteHeader poppedRouteHeader = sipServletRequest.getPoppedRouteHeader();
        String method = request.getMethod();
        String applicationName = null;
        String applicationId = null;
        if (poppedRouteHeader != null && (applicationNameHashed = (poppedAddress = (Parameters)poppedRouteHeader.getAddress().getURI()).getParameter("appname")) != null && applicationNameHashed.length() > 0) {
            applicationName = this.sipApplicationDispatcher.getApplicationNameFromHash(applicationNameHashed);
            applicationId = poppedAddress.getParameter("app_id");
        }
        if (applicationId == null) {
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String arText = toHeader.getTag();
            try {
                String[] tuple = ApplicationRoutingHeaderComposer.getAppNameAndSessionId(this.sipApplicationDispatcher, arText);
                applicationName = tuple[0];
                applicationId = tuple[1];
            }
            catch (IllegalArgumentException e) {
                throw new DispatcherException(500, (Throwable)e);
            }
            if (applicationId == null && applicationName == null) {
                String transport;
                int port;
                SipURI sipRequestUri = (SipURI)request.getRequestURI();
                String host = sipRequestUri.getHost();
                boolean isAnotherDomain = this.sipApplicationDispatcher.isExternal(host, port = sipRequestUri.getPort(), transport = JainSipUtils.findTransport((Message)request));
                if (isAnotherDomain) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No application found to handle this request " + request + " with the following popped route header " + poppedRouteHeader + " so forwarding statelessly to the outside since it is not targeted at the container"));
                    }
                    try {
                        sipProvider.sendRequest(request);
                    }
                    catch (SipException e) {
                        throw new DispatcherException("cannot proxy statelessly outside of the container the following request " + request, (Throwable)e);
                    }
                    return;
                }
                if ("ACK".equals(method)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"The popped Route, application Id and name are null for an ACK, so this is an ACK to a container generated error response, so it is dropped");
                    }
                    return;
                }
                if (poppedRouteHeader != null) {
                    throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request + "in this popped routed header " + poppedRouteHeader);
                }
                throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request);
            }
        }
        boolean inverted = false;
        if (dialog != null && !dialog.isServer()) {
            inverted = true;
        }
        if ((sipContext = this.sipApplicationDispatcher.findSipApplication(applicationName)) == null) {
            if (poppedRouteHeader != null) {
                throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request + "in this popped routed header " + poppedRouteHeader);
            }
            throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request);
        }
        SipManager sipManager = (SipManager)sipContext.getManager();
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, applicationId);
        MobicentsSipSession tmpSipSession = null;
        MobicentsSipApplicationSession sipApplicationSession = sipManager.getSipApplicationSession(sipApplicationSessionKey, false);
        if (sipApplicationSession == null) {
            if (logger.isDebugEnabled()) {
                sipManager.dumpSipApplicationSessions();
            }
            SipApplicationSessionKey joinSipApplicationSessionKey = sipContext.getSipSessionsUtil().getCorrespondingSipApplicationSession(sipApplicationSessionKey, "Join");
            SipApplicationSessionKey replacesSipApplicationSessionKey = sipContext.getSipSessionsUtil().getCorrespondingSipApplicationSession(sipApplicationSessionKey, "Replaces");
            if (joinSipApplicationSessionKey != null) {
                sipApplicationSession = sipManager.getSipApplicationSession(joinSipApplicationSessionKey, false);
            } else if (replacesSipApplicationSessionKey != null) {
                sipApplicationSession = sipManager.getSipApplicationSession(replacesSipApplicationSessionKey, false);
            }
            if (sipApplicationSession == null) {
                if (poppedRouteHeader != null) {
                    throw new DispatcherException(500, "Cannot find the corresponding sip application session to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ", it may already have been invalidated or timed out");
                }
                throw new DispatcherException(500, "Cannot find the corresponding sip application session to this subsequent request " + request + ", it may already have been invalidated or timed out");
            }
        }
        SipSessionKey key = SessionManagerUtil.getSipSessionKey(sipApplicationSession.getKey().getId(), applicationName, (Message)request, inverted);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to find the corresponding sip session with key " + key + " to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute()));
        }
        if ((tmpSipSession = sipManager.getSipSession(key, false, sipFactoryImpl, sipApplicationSession)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot find the corresponding sip session with key " + key + " to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ". Trying inverted."));
            }
            key = SessionManagerUtil.getSipSessionKey(sipApplicationSession.getKey().getId(), applicationName, (Message)request, !inverted);
            tmpSipSession = sipManager.getSipSession(key, false, sipFactoryImpl, sipApplicationSession);
        }
        if (tmpSipSession == null) {
            sipManager.dumpSipSessions();
            if (poppedRouteHeader != null) {
                throw new DispatcherException(500, "Cannot find the corresponding sip session to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ", it may already have been invalidated or timed out");
            }
            throw new DispatcherException(500, "Cannot find the corresponding sip session to this subsequent request " + request + ", it may already have been invalidated or timed out");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inverted try worked. sip session found : " + tmpSipSession.getId()));
        }
        MobicentsSipSession sipSession = tmpSipSession;
        sipServletRequest.setSipSession(sipSession);
        if (sipSession.getProxy() == null && !(isValid = sipSession.validateCSeq(sipServletRequest))) {
            return;
        }
        SubsequentDispatchTask dispatchTask = new SubsequentDispatchTask(sipServletRequest, sipProvider);
        sipContext.enterSipApp(sipApplicationSession, sipSession);
        if (this.sipApplicationDispatcher.isBypassRequestExecutor() || ConcurrencyControlMode.Transaction.equals((Object)sipContext.getConcurrencyControlMode())) {
            dispatchTask.dispatchAndHandleExceptions();
        } else {
            this.getConcurrencyModelExecutorService(sipContext, sipServletMessage).execute(dispatchTask);
        }
    }

    public static class SubsequentDispatchTask
    extends DispatchTask {
        SubsequentDispatchTask(SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
            super(sipServletRequest, sipProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() throws DispatcherException {
            SubscriptionStateHeader subscriptionStateHeader;
            SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipServletMessage;
            MobicentsSipSession sipSession = sipServletRequest.getSipSession();
            MobicentsSipApplicationSession appSession = sipSession.getSipApplicationSession();
            SipContext sipContext = appSession.getSipContext();
            Request request = (Request)sipServletRequest.getMessage();
            sipContext.enterSipAppHa(true);
            String requestMethod = sipServletRequest.getMethod();
            try {
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    if (!"PRACK".equalsIgnoreCase(requestMethod)) {
                        sipSession.setSessionCreatingTransactionRequest(sipServletRequest);
                    }
                    sipSession.addOngoingTransaction(sipServletRequest.getTransaction());
                }
                try {
                    ProxyImpl proxy;
                    if ("NOTIFY".equals(requestMethod) && sipSession.getProxy() == null && (subscriptionStateHeader = (SubscriptionStateHeader)sipServletRequest.getMessage().getHeader("Subscription-State")) != null && ("active".equalsIgnoreCase(subscriptionStateHeader.getState()) || "pending".equalsIgnoreCase(subscriptionStateHeader.getState()))) {
                        sipSession.addSubscription(sipServletRequest);
                    }
                    if ((proxy = sipSession.getProxy()) != null) {
                        ProxyBranchImpl finalBranch = proxy.getFinalBranchForSubsequentRequests();
                        boolean isPrack = requestMethod.equalsIgnoreCase("PRACK");
                        sipSession.updateStateOnSubsequentRequest(sipServletRequest, true);
                        if (finalBranch != null) {
                            proxy.setAckReceived(requestMethod.equalsIgnoreCase("ACK"));
                            proxy.setOriginalRequest(sipServletRequest);
                            MessageDispatcher.callServlet(sipServletRequest);
                            finalBranch.proxySubsequentRequest(sipServletRequest);
                        } else if (isPrack) {
                            MessageDispatcher.callServlet(sipServletRequest);
                            List<ProxyBranch> branches = proxy.getProxyBranches();
                            for (ProxyBranch pb : branches) {
                                ProxyBranchImpl proxyBranch = (ProxyBranchImpl)pb;
                                if (!proxyBranch.isWaitingForPrack()) continue;
                                proxyBranch.proxyDialogStateless(sipServletRequest);
                                proxyBranch.setWaitingForPrack(false);
                            }
                        } else if (!"ACK".equalsIgnoreCase(requestMethod)) {
                            logger.warn((Object)"Final branch is null, enable debug for more information.");
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Final branch is null, this will probably result in a lost call or request. Here is the request:\n" + request), (Throwable)new RuntimeException("Final branch is null"));
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Final branch is null, Here is the request:\n" + request));
                        }
                    } else {
                        boolean callServlet = true;
                        SipServletRequestImpl sessionCreatingTransactionRequest = (SipServletRequestImpl)sipSession.getSessionCreatingTransactionRequest();
                        if (sessionCreatingTransactionRequest != null) {
                            SipServletResponse lastFinalResponse = sessionCreatingTransactionRequest.getLastFinalResponse();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("last final response " + lastFinalResponse));
                            }
                            if ("ACK".equalsIgnoreCase(requestMethod)) {
                                if (lastFinalResponse != null && lastFinalResponse.getStatus() >= 300) {
                                    callServlet = false;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"not calling the servlet since this is an ACK for a final error response");
                                    }
                                }
                                if (lastFinalResponse == null) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"not calling the servlet since this is an ACK for a null last final response, which means the ACK was for a sip stack generated error response");
                                    }
                                    callServlet = false;
                                    sipSession.setAckReceived(false);
                                }
                            }
                        }
                        sipSession.updateStateOnSubsequentRequest(sipServletRequest, true);
                        if (callServlet) {
                            MessageDispatcher.callServlet(sipServletRequest);
                        }
                    }
                }
                catch (ServletException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, e);
                }
                catch (SipException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, e);
                }
                catch (IOException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, e);
                }
            }
            finally {
                if ("NOTIFY".equals(requestMethod) && sipSession.getProxy() == null && (subscriptionStateHeader = (SubscriptionStateHeader)sipServletRequest.getMessage().getHeader("Subscription-State")) != null && "terminated".equalsIgnoreCase(subscriptionStateHeader.getState())) {
                    sipSession.removeSubscription(sipServletRequest);
                }
                sipContext.exitSipAppHa(sipServletRequest, null);
                sipContext.exitSipApp(sipSession.getSipApplicationSession(), sipSession);
            }
        }
    }
}

