/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.sip.SipSession;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.DispatcherException;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.startup.SipContext;

public class ResponseDispatcher
extends MessageDispatcher {
    private static final Logger logger = Logger.getLogger(ResponseDispatcher.class);

    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        SipFactoryImpl sipFactoryImpl = this.sipApplicationDispatcher.getSipFactory();
        final SipServletResponseImpl sipServletResponse = (SipServletResponseImpl)sipServletMessage;
        final Response response = sipServletResponse.getResponse();
        ListIterator viaHeaders = response.getHeaders("Via");
        ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("viaHeader = " + viaHeader.toString()));
        }
        if (!this.sipApplicationDispatcher.isViaHeaderExternal(viaHeader)) {
            SipContext sipContext;
            ClientTransaction clientTransaction = (ClientTransaction)sipServletResponse.getTransaction();
            final Dialog dialog = sipServletResponse.getDialog();
            TransactionApplicationData applicationData = null;
            SipServletRequestImpl tmpOriginalRequest = null;
            if (clientTransaction != null) {
                applicationData = (TransactionApplicationData)clientTransaction.getApplicationData();
                if (applicationData.getSipServletMessage() instanceof SipServletRequestImpl) {
                    tmpOriginalRequest = (SipServletRequestImpl)applicationData.getSipServletMessage();
                }
                applicationData.addSipServletResponse(sipServletResponse);
                ViaHeader nextViaHeader = null;
                if (viaHeaders.hasNext()) {
                    nextViaHeader = (ViaHeader)viaHeaders.next();
                }
                this.checkInitialRemoteInformation(sipServletMessage, nextViaHeader);
            } else if (dialog != null) {
                applicationData = (TransactionApplicationData)dialog.getApplicationData();
                if (applicationData != null) {
                    ProxyBranchImpl proxyBranch;
                    if (applicationData.getSipServletMessage() instanceof SipServletRequestImpl) {
                        tmpOriginalRequest = (SipServletRequestImpl)applicationData.getSipServletMessage();
                    }
                    if ((proxyBranch = applicationData.getProxyBranch()) == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("retransmission received for a non proxy application, dropping the response " + response));
                        }
                        return;
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"application data is null, it means that this is a forked response, please enable stack property support for it through gov.nist.javax.sip.MAX_FORK_TIME_SECONDS");
                    logger.debug((Object)("Dropping forked response " + response));
                    return;
                }
            }
            final SipServletRequestImpl originalRequest = tmpOriginalRequest;
            sipServletResponse.setOriginalRequest(originalRequest);
            if (applicationData != null) {
                String appNameNotDeployed = applicationData.getAppNotDeployed();
                if (appNameNotDeployed != null && appNameNotDeployed.length() > 0) {
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
                boolean noAppReturned = applicationData.isNoAppReturned();
                if (noAppReturned) {
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
                String modifier = applicationData.getModifier();
                if (modifier != null && modifier.length() > 0) {
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
            }
            final String branch = viaHeader.getBranch();
            String strippedBranchId = branch.substring("z9hG4bK".length());
            String appId = strippedBranchId.substring(0, strippedBranchId.indexOf("_"));
            String appNameHashed = (strippedBranchId = strippedBranchId.substring(strippedBranchId.indexOf("_") + 1)).substring(0, strippedBranchId.indexOf("_"));
            String appName = this.sipApplicationDispatcher.getApplicationNameFromHash(appNameHashed);
            if (appName == null) {
                throw new DispatcherException("the via header branch " + branch + " for the response is missing the appname previsouly set by the container");
            }
            boolean inverted = false;
            if (dialog != null && dialog.isServer()) {
                inverted = true;
            }
            if ((sipContext = this.sipApplicationDispatcher.findSipApplication(appName)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The application " + appName + " is not deployed anymore, fowarding response statefully to the next app in chain if any"));
                }
                this.forwardResponseStatefully(sipServletResponse);
                return;
            }
            SipManager sipManager = (SipManager)sipContext.getManager();
            SipSessionKey sessionKey = SessionManagerUtil.getSipSessionKey(appId, appName, (Message)response, inverted);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to find session with following session key " + sessionKey));
            }
            MobicentsSipSession tmpSession = null;
            tmpSession = sipManager.getSipSession(sessionKey, false, sipFactoryImpl, null);
            if (tmpSession == null) {
                sessionKey = SessionManagerUtil.getSipSessionKey(appId, appName, (Message)response, !inverted);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to find session with following session key " + sessionKey));
                }
                tmpSession = sipManager.getSipSession(sessionKey, false, sipFactoryImpl, null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("session found is " + tmpSession));
                if (tmpSession == null) {
                    sipManager.dumpSipSessions();
                }
            }
            if (tmpSession == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dropping the response since no active sip session has been found for it : " + response + ", it may already have been invalidated"));
                }
                return;
            }
            sipServletResponse.setSipSession(tmpSession);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("route response on following session " + tmpSession.getId()));
            }
            final MobicentsSipSession session = tmpSession;
            final TransactionApplicationData finalApplicationData = applicationData;
            DispatchTask dispatchTask = new DispatchTask(sipServletResponse, sipProvider){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispatch() throws DispatcherException {
                    block29: {
                        sipContext.enterSipAppHa(true);
                        try {
                            session.setSessionCreatingTransactionRequest(sipServletResponse);
                            session.setSessionCreatingDialog(dialog);
                            if (originalRequest != null) {
                                originalRequest.setResponse(sipServletResponse);
                            }
                            int status = sipServletResponse.getStatus();
                            if ("SUBSCRIBE".equals(sipServletResponse.getMethod()) && status >= 200 && status <= 300 && session.getProxy() == null) {
                                session.addSubscription(sipServletResponse);
                            }
                            ProxyBranchImpl proxyBranch = null;
                            if (finalApplicationData != null) {
                                proxyBranch = finalApplicationData.getProxyBranch();
                            }
                            if (session.getProxy() != null) {
                                if (proxyBranch == null) {
                                    proxyBranch = session.getProxy().getFinalBranchForSubsequentRequests();
                                }
                                if (proxyBranch == null) {
                                    TransactionApplicationData tad;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Attempting to recover lost transaction app data for " + branch));
                                    }
                                    if ((tad = (TransactionApplicationData)session.getProxy().getTransactionMap().get(branch)) != null) {
                                        proxyBranch = tad.getProxyBranch();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Sucessfully recovered app data for " + branch + " " + tad));
                                        }
                                    }
                                }
                                if (proxyBranch == null) {
                                    logger.warn((Object)"A proxy retransmission has arrived without knowing which proxybranch to use (tx data lost)");
                                    if (session.getProxy().getSupervised() && status != 100) {
                                        MessageDispatcher.callServlet(sipServletResponse);
                                    }
                                    ResponseDispatcher.this.forwardResponseStatefully(sipServletResponse);
                                }
                            }
                            if (proxyBranch != null) {
                                sipServletResponse.setProxyBranch(proxyBranch);
                                session.updateStateOnResponse(sipServletResponse, true);
                                proxyBranch.setResponse(sipServletResponse);
                                ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Is Supervised enabled for this proxy branch ? " + proxy.getSupervised()));
                                }
                                if (proxy.getSupervised() && status != 100) {
                                    MessageDispatcher.callServlet(sipServletResponse);
                                }
                                if (status == 487 && proxy.allResponsesHaveArrived()) {
                                    session.setState(SipSession.State.TERMINATED);
                                    session.setInvalidateWhenReady(true);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Received 487 on a proxy branch and we are not waiting on other branches. Setting state to TERMINATED for " + this.toString()));
                                    }
                                }
                                proxyBranch.onResponse(sipServletResponse, status);
                                break block29;
                            }
                            if (100 == status) {
                                session.updateStateOnResponse(sipServletResponse, true);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"the response is dropped accordingly to JSR 289 since this a 100 for a non proxy application");
                                }
                                return;
                            }
                            if (sipServletResponse.getTransaction() == null && sipServletResponse.getDialog() == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("the following response is dropped since there is no client transaction nor dialog for it : " + response));
                                }
                                return;
                            }
                            try {
                                session.updateStateOnResponse(sipServletResponse, true);
                                MessageDispatcher.callServlet(sipServletResponse);
                                ResponseDispatcher.this.forwardResponseStatefully(sipServletResponse);
                            }
                            catch (ServletException e) {
                                throw new DispatcherException("Unexpected servlet exception while processing the response : " + response, (Throwable)e);
                            }
                            catch (IOException e) {
                                throw new DispatcherException("Unexpected io exception while processing the response : " + response, (Throwable)e);
                            }
                            catch (Throwable e) {
                                throw new DispatcherException("Unexpected exception while processing response : " + response, e);
                            }
                        }
                        finally {
                            sipContext.exitSipAppHa(null, sipServletResponse);
                            sipContext.exitSipApp(session.getSipApplicationSession(), session);
                        }
                    }
                }
            };
            sipContext.enterSipApp(session.getSipApplicationSession(), session);
            if (this.sipApplicationDispatcher.isBypassResponseExecutor() || ConcurrencyControlMode.Transaction.equals((Object)sipContext.getConcurrencyControlMode())) {
                dispatchTask.dispatchAndHandleExceptions();
            } else {
                this.getConcurrencyModelExecutorService(sipContext, sipServletMessage).execute(dispatchTask);
            }
        } else {
            this.forwardResponseStatefully(sipServletResponse);
        }
    }

    private final void forwardResponseStatefully(SipServletResponseImpl sipServletResponse) {
        Response response = sipServletResponse.getResponse();
        ListIterator viaHeadersLeft = response.getHeaders("Via");
        if (viaHeadersLeft.hasNext()) {
            viaHeadersLeft.next();
        }
        if (viaHeadersLeft.hasNext()) {
            ClientTransaction clientTransaction = (ClientTransaction)sipServletResponse.getTransaction();
            Dialog dialog = sipServletResponse.getDialog();
            Response newResponse = (Response)response.clone();
            ((SIPMessage)newResponse).setApplicationData(null);
            newResponse.removeFirst("Via");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("forwarding the response statefully " + newResponse));
            }
            TransactionApplicationData applicationData = null;
            if (clientTransaction != null) {
                applicationData = (TransactionApplicationData)clientTransaction.getApplicationData();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ctx application Data " + applicationData));
                }
            } else if (dialog != null) {
                applicationData = (TransactionApplicationData)dialog.getApplicationData();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dialog application data " + applicationData));
                }
            }
            if (applicationData != null) {
                ServerTransaction serverTransaction = (ServerTransaction)applicationData.getTransaction();
                try {
                    serverTransaction.sendResponse(newResponse);
                }
                catch (SipException e) {
                    logger.error((Object)"cannot forward the response statefully", (Throwable)e);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)"cannot forward the response statefully", (Throwable)e);
                }
            } else {
                try {
                    String transport = JainSipUtils.findTransport((Message)newResponse);
                    SipProvider sipProvider = this.sipApplicationDispatcher.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                    sipProvider.sendResponse(newResponse);
                }
                catch (SipException e) {
                    logger.error((Object)"cannot forward the response statelessly", (Throwable)e);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Not forwarding the response statefully. It was either an endpoint or a B2BUA, ie an endpoint too " + response));
        }
    }

    public void checkInitialRemoteInformation(SipServletMessageImpl sipServletMessage, ViaHeader nextViaHeader) {
        SIPTransaction transaction = (SIPTransaction)sipServletMessage.getTransaction();
        String remoteAddr = transaction.getPeerAddress();
        int remotePort = transaction.getPeerPort();
        if (transaction.getPeerPacketSourceAddress() != null) {
            remoteAddr = transaction.getPeerPacketSourceAddress().getHostAddress();
            remotePort = transaction.getPeerPacketSourcePort();
        }
        String initialRemoteAddr = remoteAddr;
        int initialRemotePort = remotePort;
        String initialRemoteTransport = transaction.getTransport();
        TransactionApplicationData transactionApplicationData = sipServletMessage.getTransactionApplicationData();
        if (this.sipApplicationDispatcher.isExternal(initialRemoteAddr, initialRemotePort, initialRemoteTransport)) {
            transactionApplicationData.setInitialRemoteHostAddress(initialRemoteAddr);
            transactionApplicationData.setInitialRemotePort(initialRemotePort);
            transactionApplicationData.setInitialRemoteTransport(initialRemoteTransport);
            if (nextViaHeader != null && !this.sipApplicationDispatcher.isViaHeaderExternal(nextViaHeader)) {
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Addr", initialRemoteAddr, true);
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Port", "" + initialRemotePort, true);
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Transport", initialRemoteTransport, true);
            }
        } else {
            transactionApplicationData.setInitialRemoteHostAddress(sipServletMessage.getHeader("MSS_Initial_Remote_Addr"));
            String remotePortHeader = sipServletMessage.getHeader("MSS_Initial_Remote_Port");
            int intRemotePort = -1;
            if (remotePortHeader != null) {
                intRemotePort = Integer.parseInt(remotePortHeader);
            }
            transactionApplicationData.setInitialRemotePort(intRemotePort);
            transactionApplicationData.setInitialRemoteTransport(sipServletMessage.getHeader("MSS_Initial_Remote_Transport"));
            if (nextViaHeader == null || this.sipApplicationDispatcher.isViaHeaderExternal(nextViaHeader)) {
                sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Addr", true);
                sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Port", true);
                sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Transport", true);
            }
        }
    }
}

