/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.core.dispatchers.CancelRequestDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.InitialRequestDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.ResponseDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.SubsequentRequestDispatcher;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;

public class MessageDispatcherFactory {
    private final InitialRequestDispatcher initialRequestDispatcher = new InitialRequestDispatcher();
    private final SubsequentRequestDispatcher subsequentRequestDispatcher = new SubsequentRequestDispatcher();
    private final CancelRequestDispatcher cancelRequestDispatcher = new CancelRequestDispatcher();
    private final ResponseDispatcher responseDispatcher = new ResponseDispatcher();

    public MessageDispatcherFactory(SipApplicationDispatcher sipApplicationDispatcher) {
        this.initialRequestDispatcher.sipApplicationDispatcher = sipApplicationDispatcher;
        this.subsequentRequestDispatcher.sipApplicationDispatcher = sipApplicationDispatcher;
        this.cancelRequestDispatcher.sipApplicationDispatcher = sipApplicationDispatcher;
        this.responseDispatcher.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public final RequestDispatcher getRequestDispatcher(SipServletRequestImpl sipServletRequest, SipApplicationDispatcherImpl sipApplicationDispatcher) {
        if (sipServletRequest.isInitial()) {
            return this.initialRequestDispatcher;
        }
        if (sipServletRequest.getMethod().equals("CANCEL")) {
            return this.cancelRequestDispatcher;
        }
        return this.subsequentRequestDispatcher;
    }

    public final ResponseDispatcher getResponseDispatcher(SipServletResponseImpl sipServletResponse, SipApplicationDispatcherImpl sipApplicationDispatcher) {
        return this.responseDispatcher;
    }
}

