/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletMessage;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.catalina.Wrapper;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.core.dispatchers.DispatcherException;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.security.SipSecurityUtils;
import org.mobicents.servlet.sip.startup.SipContext;

public abstract class MessageDispatcher {
    private static final Logger logger = Logger.getLogger(MessageDispatcher.class);
    public static final String ROUTE_PARAM_DIRECTIVE = "directive";
    public static final String ROUTE_PARAM_REGION_LABEL = "region_label";
    public static final String ROUTE_PARAM_REGION_TYPE = "region_type";
    public static final String ROUTE_PARAM_PREV_APPLICATION_NAME = "previousappname";
    public static final String ROUTE_PARAM_PREV_APP_ID = "previousappid";
    public static final String RR_PARAM_APPLICATION_NAME = "appname";
    public static final String RR_PARAM_PROXY_APP = "proxy";
    public static final String BRANCH_MAGIC_COOKIE = "z9hG4bK";
    public static final String APP_ID = "app_id";
    public static final String ROUTE_PARAM_NODE_HOST = "node_host";
    public static final String ROUTE_PARAM_NODE_PORT = "node_port";
    protected SipApplicationDispatcher sipApplicationDispatcher = null;

    public static void sendErrorResponse(int errorCode, ServerTransaction transaction, Request request, SipProvider sipProvider) {
        try {
            Response response = SipFactories.messageFactory.createResponse(errorCode, request);
            if (transaction != null) {
                transaction.sendResponse(response);
            } else {
                sipProvider.sendResponse(response);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problem while sending the error response to the following request " + request.toString()), (Throwable)e);
        }
    }

    protected static SipApplicationSessionKey makeAppSessionKey(SipContext sipContext, SipServletRequestImpl sipServletRequestImpl, String applicationName) throws DispatcherException {
        String appGeneratedKey = null;
        Method appKeyMethod = null;
        if (sipServletRequestImpl.isInitial() && sipContext != null) {
            appKeyMethod = sipContext.getSipApplicationKeyMethod();
        }
        if (appKeyMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("For request target to application " + sipContext.getApplicationName() + ", using the following annotated method to generate the application key " + appKeyMethod));
            }
            sipServletRequestImpl.setReadOnly(true);
            Servlet servlet = null;
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(sipContext.getLoader().getClassLoader());
            Class<?> methodDeclaringClass = appKeyMethod.getDeclaringClass();
            Wrapper sipServletImpl = (Wrapper)sipContext.findChildrenByClassName(methodDeclaringClass.getCanonicalName());
            if (sipServletImpl != null) {
                try {
                    Method newMethod;
                    servlet = sipServletImpl.allocate();
                    appKeyMethod = newMethod = servlet.getClass().getMethod(appKeyMethod.getName(), appKeyMethod.getParameterTypes());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking the application key method " + appKeyMethod.getName() + ", on the following servlet " + methodDeclaringClass.getCanonicalName()));
                    }
                }
                catch (ServletException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", e);
                }
                catch (SecurityException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", e);
                }
                catch (NoSuchMethodException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            try {
                appGeneratedKey = (String)appKeyMethod.invoke((Object)servlet, sipServletRequestImpl);
            }
            catch (IllegalArgumentException e) {
                throw new DispatcherException(500, "Couldn't invoke the app session key annotated method !", e);
            }
            catch (IllegalAccessException e) {
                throw new DispatcherException(500, "Couldn't invoke the app session key annotated method !", e);
            }
            catch (InvocationTargetException e) {
                throw new DispatcherException(500, "A Problem occured while invoking the app session key annotated method !", e);
            }
            finally {
                sipServletRequestImpl.setReadOnly(false);
                if (sipServletImpl != null) {
                    try {
                        sipServletImpl.deallocate(servlet);
                    }
                    catch (ServletException e) {
                        throw new DispatcherException(500, "Couldn't deallocate the sip servlet to invoke the key annotated method !", e);
                    }
                }
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("For request target to application " + sipContext.getApplicationName() + ", following annotated method " + appKeyMethod + " generated the application key : " + appGeneratedKey));
            }
        }
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, null);
        sipApplicationSessionKey.setAppGeneratedKey(appGeneratedKey);
        return sipApplicationSessionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServlet(SipServletRequestImpl request) throws ServletException, IOException {
        block20: {
            MobicentsSipSession session = request.getSipSession();
            String sessionHandler = session.getHandler();
            MobicentsSipApplicationSession sipApplicationSessionImpl = session.getSipApplicationSession();
            SipContext sipContext = sipApplicationSessionImpl.getSipContext();
            Wrapper sipServletImpl = (Wrapper)sipContext.findChildrenByName(sessionHandler);
            if (sipServletImpl != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching request " + request.toString() + " to following App/servlet => " + session.getKey().getApplicationName() + "/" + session.getHandler() + " on following sip session " + session.getId()));
                }
                Servlet servlet = sipServletImpl.allocate();
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getLoader().getClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    if (!MessageDispatcher.securityCheck(request)) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking instance " + servlet));
                    }
                    try {
                        servlet.service((ServletRequest)request, null);
                        break block20;
                    }
                    finally {
                        sipServletImpl.deallocate(servlet);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            if (sipContext.getSipRubyController() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching request " + request.toString() + " to following App/ruby controller => " + request.getSipSession().getKey().getApplicationName() + "/" + sipContext.getSipRubyController().getName()));
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getLoader().getClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    sipContext.getSipRubyController().routeSipMessageToRubyApp(sipContext.getServletContext(), (SipServletMessage)request);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            logger.error((Object)("no handler found for sip session " + session.getKey() + " and request " + request));
            Transaction transaction = request.getTransaction();
            if (transaction != null) {
                TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
                if (tad != null) {
                    tad.cleanUp();
                }
                transaction.setApplicationData(null);
                try {
                    transaction.terminate();
                }
                catch (ObjectInUseException e) {
                    logger.error((Object)("transaction " + transaction.getBranchId() + " for request " + request + " couldn't be terminated"));
                }
            }
            request.setSipSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServlet(SipServletResponseImpl response) throws ServletException, IOException {
        MobicentsSipSession session = response.getSipSession();
        String sessionHandler = session.getHandler();
        MobicentsSipApplicationSession sipApplicationSessionImpl = session.getSipApplicationSession();
        SipContext sipContext = sipApplicationSessionImpl.getSipContext();
        Wrapper sipServletImpl = (Wrapper)sipContext.findChildrenByName(sessionHandler);
        if (sipServletImpl == null || sipServletImpl.isUnavailable()) {
            if (sipContext.getSipRubyController() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching response " + response.toString() + " to following App/ruby controller => " + response.getSipSession().getKey().getApplicationName() + "/" + sipContext.getSipRubyController().getName()));
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getLoader().getClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    sipContext.getSipRubyController().routeSipMessageToRubyApp(sipContext.getServletContext(), (SipServletMessage)response);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            } else {
                logger.warn((Object)(sessionHandler + " is unavailable, dropping response " + response));
            }
        } else {
            Servlet servlet = sipServletImpl.allocate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dispatching response " + response.toString() + " to following App/servlet => " + session.getKey().getApplicationName() + "/" + session.getHandler() + " on following sip session " + session.getId()));
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = sipContext.getLoader().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    servlet.service(null, (ServletResponse)response);
                }
                finally {
                    sipServletImpl.deallocate(servlet);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public static boolean securityCheck(SipServletRequestImpl request) {
        MobicentsSipApplicationSession appSession = (MobicentsSipApplicationSession)request.getApplicationSession();
        SipContext sipStandardContext = appSession.getSipContext();
        boolean authorized = SipSecurityUtils.authorize(sipStandardContext, request);
        return authorized;
    }

    public abstract void dispatchMessage(SipProvider var1, SipServletMessageImpl var2) throws DispatcherException;

    public final ExecutorService getConcurrencyModelExecutorService(SipContext sipContext, SipServletMessageImpl sipServletMessage) {
        return ((SipApplicationDispatcherImpl)this.sipApplicationDispatcher).getAsynchronousExecutor();
    }
}

