/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.ServerTransactionExt;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.SipSession;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.DispatcherException;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.startup.SipContext;

public class CancelRequestDispatcher
extends RequestDispatcher {
    private static final Logger logger = Logger.getLogger(CancelRequestDispatcher.class);

    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)sipServletMessage;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Routing of Cancel Request " + sipServletRequest));
        }
        ServerTransaction cancelTransaction = (ServerTransaction)sipServletRequest.getTransaction();
        try {
            SipServletResponseImpl cancelResponse = (SipServletResponseImpl)sipServletRequest.createResponse(200, "Canceling");
            Response cancelJsipResponse = (Response)cancelResponse.getMessage();
            cancelTransaction.sendResponse(cancelJsipResponse);
        }
        catch (SipException e) {
            throw new DispatcherException(500, "Impossible to send the ok to the CANCEL", e);
        }
        catch (InvalidArgumentException e) {
            throw new DispatcherException(500, "Impossible to send the ok to the CANCEL", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checking what to do with the CANCEL " + sipServletRequest));
        }
        CancelDispatchTask dispatchTask = new CancelDispatchTask(sipServletRequest, sipProvider);
        ((SipApplicationDispatcherImpl)this.sipApplicationDispatcher).getAsynchronousExecutor().execute(dispatchTask);
    }

    private static final void send487Response(Transaction inviteTransaction, SipServletRequestImpl inviteRequest) throws IllegalStateException, DispatcherException {
        SipServletResponseImpl inviteResponse = (SipServletResponseImpl)inviteRequest.createResponse(487);
        inviteRequest.setRoutingState(RoutingState.CANCELLED);
        if (inviteRequest.isInitial()) {
            inviteRequest.getSipSession().setState(SipSession.State.TERMINATED);
        }
        try {
            Response requestTerminatedResponse = (Response)inviteResponse.getMessage();
            ((ServerTransaction)inviteTransaction).sendResponse(requestTerminatedResponse);
        }
        catch (SipException e) {
            throw new DispatcherException(500, "Impossible to send the 487 to the INVITE transaction corresponding to CANCEL", e);
        }
        catch (InvalidArgumentException e) {
            throw new DispatcherException(500, "Impossible to send the 487 to the INVITE transaction corresponding to CANCEL", e);
        }
    }

    public static class CancelDispatchTask
    extends DispatchTask {
        CancelDispatchTask(SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
            super(sipServletRequest, sipProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() throws DispatcherException {
            block32: {
                SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipServletMessage;
                Request request = (Request)sipServletRequest.getMessage();
                ServerTransaction inviteTransaction = ((ServerTransactionExt)sipServletRequest.getTransaction()).getCanceledInviteTransaction();
                if (inviteTransaction == null) {
                    logger.error((Object)("couldn't find the original invite transaction for this cancel " + request));
                    return;
                }
                TransactionApplicationData inviteAppData = (TransactionApplicationData)inviteTransaction.getApplicationData();
                SipServletRequestImpl inviteRequest = (SipServletRequestImpl)inviteAppData.getSipServletMessage();
                MobicentsSipSession sipSession = inviteRequest.getSipSession();
                sipServletRequest.setSipSession(sipSession);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("message associated with the inviteAppData of the CANCEL " + inviteRequest));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("invite transaction associated with the inviteAppData of the CANCEL " + inviteTransaction));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("app data of the invite transaction associated with the inviteAppData of the CANCEL " + inviteAppData));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("routing state of the INVITE request for the CANCEL = " + (Object)((Object)inviteRequest.getRoutingState())));
                }
                MobicentsSipApplicationSession sipApplicationSession = sipSession.getSipApplicationSession();
                SipContext sipContext = sipApplicationSession.getSipContext();
                try {
                    sipContext.enterSipApp(sipApplicationSession, sipSession);
                    ProxyImpl proxy = sipSession.getProxy();
                    if (proxy != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("proxying the CANCEL " + sipServletRequest));
                        }
                        if (!RoutingState.PROXIED.equals((Object)inviteRequest.getRoutingState())) {
                            try {
                                CancelRequestDispatcher.send487Response((Transaction)inviteTransaction, inviteRequest);
                            }
                            catch (IllegalStateException iae) {
                                logger.info((Object)"request already proxied, dropping the cancel");
                                sipContext.exitSipApp(sipApplicationSession, sipSession);
                                return;
                            }
                        } else {
                            proxy.cancel();
                        }
                        try {
                            MessageDispatcher.callServlet(sipServletRequest);
                            break block32;
                        }
                        catch (ServletException e) {
                            throw new DispatcherException(500, "An unexpected servlet exception occured while routing the following CANCEL " + request, e);
                        }
                        catch (IOException e) {
                            throw new DispatcherException(500, "An unexpected IO exception occured while routing the following CANCEL " + request, e);
                        }
                        catch (Throwable e) {
                            throw new DispatcherException(500, "An unexpected exception occured while routing the following CANCEL " + request, e);
                        }
                    }
                    if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)inviteRequest.getRoutingState())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"the final response has already been sent, nothing to do here");
                        }
                        break block32;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite transaction of the CANCEL " + inviteTransaction));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite message : 1xx response was generated ? " + ((SipServletRequestImpl)inviteAppData.getSipServletMessage()).is1xxResponseGenerated()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite message : Final response was generated ? " + ((SipServletRequestImpl)inviteAppData.getSipServletMessage()).isFinalResponseGenerated()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"replying 487 to INVITE cancelled");
                    }
                    try {
                        CancelRequestDispatcher.send487Response((Transaction)inviteTransaction, inviteRequest);
                    }
                    catch (IllegalStateException iae) {
                        logger.info((Object)"request already proxied, dropping the cancel");
                        sipContext.exitSipApp(sipApplicationSession, sipSession);
                        return;
                    }
                    try {
                        MessageDispatcher.callServlet(sipServletRequest);
                    }
                    catch (ServletException e) {
                        throw new DispatcherException(500, "An unexpected servlet exception occured while routing the following CANCEL " + request, e);
                    }
                    catch (IOException e) {
                        throw new DispatcherException(500, "An unexpected IO exception occured while routing the following CANCEL " + request, e);
                    }
                    catch (Throwable e) {
                        throw new DispatcherException(500, "An unexpected exception occured while routing the following CANCEL " + request, e);
                    }
                }
                finally {
                    sipContext.exitSipApp(sipApplicationSession, sipSession);
                }
            }
        }
    }
}

