/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.core.DNSAddressResolver;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.HopImpl;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.startup.SipContext;
import org.mobicents.servlet.sip.utils.Inet6Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipNetworkInterfaceManager {
    private static final Logger logger = Logger.getLogger(SipNetworkInterfaceManager.class);
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_PORT_NUMBER = 1024;
    Set<ExtendedListeningPoint> extendedListeningPointList = null;
    List<javax.servlet.sip.SipURI> outboundInterfaces = null;
    Set<String> outboundInterfacesIpAddresses = null;
    private SipApplicationDispatcher sipApplicationDispatcher;
    Map<String, Set<ExtendedListeningPoint>> transportMappingCacheMap = null;
    Map<String, ExtendedListeningPoint> extendedListeningPointsCacheMap = null;
    Lock lock = null;

    public SipNetworkInterfaceManager(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
        this.extendedListeningPointList = new CopyOnWriteArraySet<ExtendedListeningPoint>();
        this.outboundInterfaces = new CopyOnWriteArrayList<javax.servlet.sip.SipURI>();
        this.outboundInterfacesIpAddresses = new CopyOnWriteArraySet<String>();
        this.transportMappingCacheMap = new HashMap<String, Set<ExtendedListeningPoint>>();
        this.transportMappingCacheMap.put("TCP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("UDP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("SCTP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("TLS".toLowerCase(), new CopyOnWriteArraySet());
        this.extendedListeningPointsCacheMap = new ConcurrentHashMap<String, ExtendedListeningPoint>();
        this.lock = new ReentrantLock();
    }

    public Iterator<ExtendedListeningPoint> getExtendedListeningPoints() {
        return this.extendedListeningPointList.iterator();
    }

    public void addExtendedListeningPoint(ExtendedListeningPoint extendedListeningPoint) {
        this.extendedListeningPointList.add(extendedListeningPoint);
        this.computeOutboundInterfaces();
        Set<ExtendedListeningPoint> extendedListeningPoints = this.transportMappingCacheMap.get(extendedListeningPoint.getTransport().toLowerCase());
        boolean added = extendedListeningPoints.add(extendedListeningPoint);
        if (added) {
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                this.extendedListeningPointsCacheMap.put(ipAddress + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
            }
            if (extendedListeningPoint.getGlobalIpAddress() != null) {
                this.extendedListeningPointsCacheMap.put(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
                this.extendedListeningPointsCacheMap.put(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getGlobalPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
            }
            Iterator<SipContext> sipContextIterator = this.sipApplicationDispatcher.findSipApplications();
            while (sipContextIterator.hasNext()) {
                SipContext sipContext = sipContextIterator.next();
                sipContext.notifySipContextListeners(new SipContextEvent(SipContextEventType.SIP_CONNECTOR_ADDED, extendedListeningPoint.getSipConnector()));
            }
        }
    }

    public void removeExtendedListeningPoint(ExtendedListeningPoint extendedListeningPoint) {
        if (this.extendedListeningPointList.contains(extendedListeningPoint)) {
            Iterator<SipContext> sipContextIterator = this.sipApplicationDispatcher.findSipApplications();
            while (sipContextIterator.hasNext()) {
                SipContext sipContext = sipContextIterator.next();
                sipContext.notifySipContextListeners(new SipContextEvent(SipContextEventType.SIP_CONNECTOR_REMOVED, extendedListeningPoint.getSipConnector()));
            }
            this.extendedListeningPointList.remove(extendedListeningPoint);
            this.computeOutboundInterfaces();
            Set<ExtendedListeningPoint> extendedListeningPoints = this.transportMappingCacheMap.get(extendedListeningPoint.getTransport().toLowerCase());
            extendedListeningPoints.remove(extendedListeningPoint);
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                this.extendedListeningPointsCacheMap.remove(ipAddress + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
            }
            if (extendedListeningPoint.getGlobalIpAddress() != null) {
                this.extendedListeningPointsCacheMap.remove(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
                this.extendedListeningPointsCacheMap.remove(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getGlobalPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
            }
        }
    }

    public ExtendedListeningPoint findMatchingListeningPoint(String transport, boolean strict) {
        Set<ExtendedListeningPoint> extendedListeningPoints;
        String tmpTransport = transport;
        if (tmpTransport == null) {
            tmpTransport = "UDP";
        }
        if ((extendedListeningPoints = this.transportMappingCacheMap.get(tmpTransport.toLowerCase())).size() > 0) {
            return extendedListeningPoints.iterator().next();
        }
        if (strict) {
            return null;
        }
        if (this.extendedListeningPointList.size() > 0) {
            return this.extendedListeningPointList.iterator().next();
        }
        throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
    }

    public ExtendedListeningPoint findMatchingListeningPoint(SipURI outboundInterface, boolean strict) {
        Set<ExtendedListeningPoint> extendedListeningPoints;
        String tmpTransport = outboundInterface.getTransportParam();
        if (tmpTransport == null) {
            tmpTransport = outboundInterface.isSecure() ? "TCP" : "UDP";
        }
        if ((extendedListeningPoints = this.transportMappingCacheMap.get(tmpTransport.toLowerCase())).size() > 0) {
            for (ExtendedListeningPoint extendedListeningPoint : extendedListeningPoints) {
                if (!extendedListeningPoint.getIpAddresses().contains(outboundInterface.getHost())) continue;
                return extendedListeningPoint;
            }
        }
        if (strict) {
            return null;
        }
        if (this.extendedListeningPointList.size() > 0) {
            for (ExtendedListeningPoint extendedListeningPoint : extendedListeningPoints) {
                if (!extendedListeningPoint.getIpAddresses().contains(outboundInterface.getHost())) continue;
                return extendedListeningPoint;
            }
            throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
        }
        throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
    }

    public ExtendedListeningPoint findMatchingListeningPoint(String ipAddress, int port, String transport) {
        ExtendedListeningPoint listeningPoint;
        String tmpTransport = transport;
        int portChecked = SipNetworkInterfaceManager.checkPortRange(port, tmpTransport);
        if (tmpTransport == null) {
            tmpTransport = "UDP";
        }
        if ((listeningPoint = this.extendedListeningPointsCacheMap.get(ipAddress + "/" + portChecked + ":" + tmpTransport.toLowerCase())) == null && !Inet6Util.isValidIP6Address(ipAddress) && !Inet6Util.isValidIPV4Address(ipAddress)) {
            InetAddress[] inetAddresses = new InetAddress[]{};
            try {
                inetAddresses = InetAddress.getAllByName(ipAddress);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            for (InetAddress inetAddress : inetAddresses) {
                listeningPoint = this.extendedListeningPointsCacheMap.get(inetAddress.getHostAddress() + "/" + portChecked + ":" + tmpTransport.toLowerCase());
                if (listeningPoint == null) continue;
                return listeningPoint;
            }
        }
        return listeningPoint;
    }

    public static int checkPortRange(int port, String transport) {
        if (port < 1024 || port > 65535) {
            if ("TLS".equalsIgnoreCase(transport)) {
                return 5061;
            }
            return 5060;
        }
        return port;
    }

    public List<javax.servlet.sip.SipURI> getOutboundInterfaces() {
        return Collections.unmodifiableList(this.outboundInterfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeOutboundInterfaces() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Outbound Interface List : ");
        }
        CopyOnWriteArrayList<javax.servlet.sip.SipURI> newlyComputedOutboundInterfaces = new CopyOnWriteArrayList<javax.servlet.sip.SipURI>();
        CopyOnWriteArraySet<String> newlyComputedOutboundInterfacesIpAddresses = new CopyOnWriteArraySet<String>();
        Iterator<ExtendedListeningPoint> it = this.getExtendedListeningPoints();
        while (it.hasNext()) {
            ExtendedListeningPoint extendedListeningPoint = it.next();
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                try {
                    newlyComputedOutboundInterfacesIpAddresses.add(ipAddress);
                    SipURI jainSipURI = SipFactories.addressFactory.createSipURI(null, ipAddress);
                    jainSipURI.setPort(extendedListeningPoint.getPort());
                    jainSipURI.setTransportParam(extendedListeningPoint.getTransport());
                    SipURIImpl sipURI = new SipURIImpl(jainSipURI);
                    newlyComputedOutboundInterfaces.add(sipURI);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Outbound Interface : " + jainSipURI));
                }
                catch (ParseException e) {
                    logger.error((Object)("cannot add the following listening point " + ipAddress + ":" + extendedListeningPoint.getPort() + ";transport=" + extendedListeningPoint.getTransport() + " to the outbound interfaces"), (Throwable)e);
                }
            }
        }
        this.lock.lock();
        try {
            this.outboundInterfaces = newlyComputedOutboundInterfaces;
            this.outboundInterfacesIpAddresses = newlyComputedOutboundInterfacesIpAddresses;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static boolean findUsePublicAddress(Message message) {
        boolean usePublicAddress = true;
        String host = null;
        String transport = JainSipUtils.findTransport(message);
        if (message instanceof Request) {
            Request request = (Request)message;
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            URI uri = null;
            uri = routeHeader != null ? routeHeader.getAddress().getURI() : request.getRequestURI();
            if (uri instanceof SipURI) {
                SipURI sipUri = (SipURI)uri;
                host = sipUri.getHost();
            }
        } else {
            ViaHeader topmostViaHeader = (ViaHeader)message.getHeader("Via");
            if (topmostViaHeader != null) {
                host = topmostViaHeader.getHost();
            }
        }
        if (host != null) {
            if (Inet6Util.isValidIP6Address(host)) {
                usePublicAddress = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("host " + host + " is a numeric IPV6 address, " + "no DNS SRV lookup to be done and no need for STUN"));
                }
            } else if (Inet6Util.isValidIPV4Address(host)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("host " + host + " is a numeric IPV4 address, " + "no DNS SRV lookup to be done"));
                }
                usePublicAddress = !SipNetworkInterfaceManager.isIPAddressPartOfPrivateNetwork(host);
            } else {
                logger.debug((Object)("host " + host + " is a hostname, " + "doing DNS SRV lookup"));
                HopImpl hop = new HopImpl(host, -1, transport);
                Hop lookedupHop = DNSAddressResolver.resolveHostByDnsSrvLookup(hop);
                if (!hop.equals(lookedupHop)) {
                    boolean bl = usePublicAddress = !SipNetworkInterfaceManager.isIPAddressPartOfPrivateNetwork(lookedupHop.getHost());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STUN enabled : use public adress " + usePublicAddress + " for following host " + host));
        }
        return usePublicAddress;
    }

    public static boolean isIPAddressPartOfPrivateNetwork(String ipAddress) {
        int addressOutboundness = JainSipUtils.getAddressOutboundness(ipAddress);
        if (addressOutboundness < 4) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + ipAddress + " is part of a private network we will not use the public address resolved by STUN"));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("host " + ipAddress + " is not part of a private network we will use the public address resolved by STUN"));
        }
        return false;
    }
}

