/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import gov.nist.javax.sip.ClientTransactionExt;
import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.TransactionExt;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.spi.ServiceRegistry;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.spi.SipApplicationRouterProvider;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.catalina.LifecycleException;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.modeler.Registry;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.GenericUtils;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.CongestionControlPolicy;
import org.mobicents.servlet.sip.core.ExtendedListeningPoint;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.dispatchers.DispatcherException;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcherFactory;
import org.mobicents.servlet.sip.core.session.DistributableSipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipManager;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.B2buaHelperImpl;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.router.ManageableApplicationRouter;
import org.mobicents.servlet.sip.startup.SipContext;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipApplicationDispatcherImpl
implements SipApplicationDispatcher,
MBeanRegistration,
LoadBalancerHeartBeatingListener {
    private static final String[] METHODS_SUPPORTED = new String[]{"REGISTER", "INVITE", "ACK", "BYE", "CANCEL", "MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "PRACK", "OPTIONS"};
    private static final String[] EXTENSIONS_SUPPORTED = new String[]{"MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "PRACK", "100rel", "STUN", "path", "join"};
    private static final String[] RFC_SUPPORTED = new String[]{"3261", "3428", "2976", "3265", "3311", "3903", "3515", "3262", "3489", "3327", "3911"};
    private static final String[] RESPONSES_PER_CLASS_OF_SC = new String[]{"1XX", "2XX", "3XX", "4XX", "5XX", "6XX", "7XX", "8XX", "9XX"};
    private static final Logger logger = Logger.getLogger(SipApplicationDispatcherImpl.class);
    private SipFactoryImpl sipFactoryImpl = null;
    private SipApplicationRouter sipApplicationRouter = null;
    private Map<String, SipContext> applicationDeployed = null;
    private Map<String, String> mdToApplicationName = null;
    private Map<String, String> applicationNameToMd = null;
    private Set<String> hostNames = null;
    private Boolean started = Boolean.FALSE;
    private Lock statusLock = new ReentrantLock();
    private SipNetworkInterfaceManager sipNetworkInterfaceManager;
    private boolean gatherStatistics = true;
    private static AtomicLong requestsProcessed = new AtomicLong(0L);
    private static AtomicLong responsesProcessed = new AtomicLong(0L);
    static final Map<String, AtomicLong> requestsProcessedByMethod = new ConcurrentHashMap<String, AtomicLong>();
    static final Map<String, AtomicLong> responsesProcessedByStatusCode;
    private boolean memoryToHigh = false;
    private double maxMemory;
    private int memoryThreshold;
    private int backToNormalMemoryThreshold;
    private boolean rejectSipMessages = false;
    private long congestionControlCheckingInterval;
    protected transient CongestionControlTimerTask congestionControlTimerTask;
    protected transient ScheduledFuture congestionControlTimerFuture;
    private CongestionControlPolicy congestionControlPolicy;
    private int numberOfMessagesInQueue;
    private double percentageOfMemoryUsed;
    private int queueSize;
    private int backToNormalQueueSize;
    private ScheduledThreadPoolExecutor congestionControlThreadPool = null;
    private boolean bypassResponseExecutor = true;
    private boolean bypassRequestExecutor = true;
    private int baseTimerInterval = 500;
    private int t2Interval = 4000;
    private int t4Interval = 5000;
    private int timerDInterval = 32000;
    private ConcurrencyControlMode concurrencyControlMode;
    private ThreadPoolExecutor asynchronousExecutor = null;
    private MessageDispatcherFactory messageDispatcherFactory;
    private Set<SipLoadBalancer> sipLoadBalancers = new CopyOnWriteArraySet<SipLoadBalancer>();
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public SipApplicationDispatcherImpl() {
        this.applicationDeployed = new ConcurrentHashMap<String, SipContext>();
        this.mdToApplicationName = new ConcurrentHashMap<String, String>();
        this.applicationNameToMd = new ConcurrentHashMap<String, String>();
        this.sipFactoryImpl = new SipFactoryImpl(this);
        this.hostNames = new CopyOnWriteArraySet<String>();
        this.sipNetworkInterfaceManager = new SipNetworkInterfaceManager(this);
        this.maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0;
        this.congestionControlPolicy = CongestionControlPolicy.ErrorResponse;
    }

    @Override
    public void init() throws LifecycleException {
        String sipApplicationRouterProviderClassName = System.getProperty("javax.servlet.sip.ar.spi.SipApplicationRouterProvider");
        if (sipApplicationRouterProviderClassName != null && sipApplicationRouterProviderClassName.length() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Using the javax.servlet.sip.ar.spi.SipApplicationRouterProvider system property to load the application router provider");
            }
            try {
                this.sipApplicationRouter = ((SipApplicationRouterProvider)Class.forName(sipApplicationRouterProviderClassName).newInstance()).getSipApplicationRouter();
            }
            catch (InstantiationException e) {
                throw new LifecycleException("Impossible to load the Sip Application Router", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new LifecycleException("Impossible to load the Sip Application Router", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new LifecycleException("Impossible to load the Sip Application Router", (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new LifecycleException("Sip Application Router defined does not implement " + SipApplicationRouterProvider.class.getName(), (Throwable)e);
            }
        } else {
            Iterator<SipApplicationRouterProvider> providers;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Using the Service Provider Framework to load the application router provider");
            }
            if ((providers = ServiceRegistry.lookupProviders(SipApplicationRouterProvider.class)).hasNext()) {
                this.sipApplicationRouter = providers.next().getSipApplicationRouter();
            }
        }
        if (this.sipApplicationRouter == null) {
            throw new LifecycleException("No Sip Application Router Provider could be loaded. No jar compliant with JSR 289 Section Section 15.4.2 could be found on the classpath and no javax.servlet.sip.ar.spi.SipApplicationRouterProvider system property set");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this + " Using the following Application Router instance: " + this.sipApplicationRouter));
        }
        this.sipApplicationRouter.init();
        this.sipApplicationRouter.applicationDeployed(new ArrayList<String>(this.applicationDeployed.keySet()));
        if (this.oname == null) {
            try {
                this.oname = new ObjectName(this.domain + ":type=SipApplicationDispatcher");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Sip Application dispatcher registered under following name " + this.oname));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Impossible to register the Sip Application dispatcher in domain" + this.domain), (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("bypassRequestExecutor ? " + this.bypassRequestExecutor));
            logger.info((Object)("bypassResponseExecutor ? " + this.bypassResponseExecutor));
        }
        this.messageDispatcherFactory = new MessageDispatcherFactory(this);
        this.congestionControlThreadPool = new ScheduledThreadPoolExecutor(2, new ThreadPoolExecutor.CallerRunsPolicy());
        this.congestionControlThreadPool.prestartAllCoreThreads();
        this.asynchronousExecutor = new ThreadPoolExecutor(StaticServiceHolder.sipStandardService.getDispatcherThreadPoolSize(), 64, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        logger.info((Object)("AsynchronousThreadPoolExecutor size is " + StaticServiceHolder.sipStandardService.getDispatcherThreadPoolSize()));
        this.asynchronousExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.warn((Object)("Executor job was rejected " + r.toString()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.statusLock.lock();
        try {
            if (this.started.booleanValue()) {
                return;
            }
            this.started = Boolean.TRUE;
        }
        finally {
            this.statusLock.unlock();
        }
        this.congestionControlTimerTask = new CongestionControlTimerTask();
        if (this.congestionControlTimerFuture == null && this.congestionControlCheckingInterval > 0L) {
            this.congestionControlTimerFuture = this.congestionControlThreadPool.scheduleWithFixedDelay(this.congestionControlTimerTask, this.congestionControlCheckingInterval, this.congestionControlCheckingInterval, TimeUnit.MILLISECONDS);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Congestion control background task started and checking every " + this.congestionControlCheckingInterval + " milliseconds."));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("No Congestion control background task started since the checking interval is equals to " + this.congestionControlCheckingInterval + " milliseconds."));
        }
        if (logger.isInfoEnabled()) {
            Properties versionProperties = new Properties();
            try {
                InputStream in = SipApplicationDispatcherImpl.class.getResourceAsStream("version.properties");
                if (in != null) {
                    versionProperties.load(in);
                    in.close();
                    String version = versionProperties.getProperty("release.version");
                    if (version != null) {
                        logger.info((Object)("Mobicents Sip Servlets " + version + " started."));
                    } else {
                        logger.warn((Object)"Unable to extract the version of Mobicents Sip Servlets currently running");
                    }
                } else {
                    logger.warn((Object)"Unable to extract the version of Mobicents Sip Servlets currently running");
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to extract the version of Mobicents Sip Servlets currently running", (Throwable)e);
            }
        }
        this.resetOutboundInterfaces();
        for (SipContext sipContext : this.applicationDeployed.values()) {
            sipContext.notifySipContextListeners(new SipContextEvent(SipContextEventType.SERVLET_INITIALIZED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.statusLock.lock();
        try {
            if (!this.started.booleanValue()) {
                return;
            }
            this.started = Boolean.FALSE;
        }
        finally {
            this.statusLock.unlock();
        }
        this.congestionControlThreadPool.shutdownNow();
        this.asynchronousExecutor.shutdownNow();
        this.sipApplicationRouter.destroy();
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSipApplication(String sipApplicationName, SipContext sipApplication) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding the following sip servlet application " + sipApplicationName + ", SipContext=" + sipApplication));
        }
        if (sipApplicationName == null) {
            throw new IllegalArgumentException("Something when wrong while initializing a sip servlets or converged application ");
        }
        if (sipApplication == null) {
            throw new IllegalArgumentException("Something when wrong while initializing the following application " + sipApplicationName);
        }
        SipContext app = this.applicationDeployed.get(sipApplicationName);
        if (app != null) {
            logger.error((Object)("An application with the app name " + sipApplicationName + " is already deployed under the following context " + app.getPath()));
            throw new IllegalStateException("An application with the app name " + sipApplicationName + " is already deployed under the following context " + app.getPath());
        }
        if (sipApplication.getConcurrencyControlMode() == null) {
            sipApplication.setConcurrencyControlMode(this.concurrencyControlMode);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No concurrency control mode for application " + sipApplicationName + " , defaulting to the container wide one : " + this.concurrencyControlMode));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Concurrency control mode for application " + sipApplicationName + " is " + sipApplication.getConcurrencyControlMode()));
        }
        sipApplication.getServletContext().setAttribute(ConcurrencyControlMode.class.getCanonicalName(), (Object)sipApplication.getConcurrencyControlMode());
        this.applicationDeployed.put(sipApplicationName, sipApplication);
        String hash = GenericUtils.hashString(sipApplicationName);
        this.mdToApplicationName.put(hash, sipApplicationName);
        this.applicationNameToMd.put(sipApplicationName, hash);
        ArrayList<String> newlyApplicationsDeployed = new ArrayList<String>();
        newlyApplicationsDeployed.add(sipApplicationName);
        this.sipApplicationRouter.applicationDeployed(newlyApplicationsDeployed);
        this.statusLock.lock();
        try {
            if (this.started.booleanValue()) {
                sipApplication.notifySipContextListeners(new SipContextEvent(SipContextEventType.SERVLET_INITIALIZED, null));
            }
        }
        finally {
            this.statusLock.unlock();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("the following sip servlet application has been added : " + sipApplicationName));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"It contains the following Sip Servlets : ");
            for (String servletName : sipApplication.getChildrenMap().keySet()) {
                logger.info((Object)("SipApplicationName : " + sipApplicationName + "/ServletName : " + servletName));
            }
            if (sipApplication.getSipRubyController() != null) {
                logger.info((Object)("It contains the following Sip Ruby Controller : " + sipApplication.getSipRubyController()));
            }
        }
    }

    @Override
    public SipContext removeSipApplication(String sipApplicationName) {
        SipContext sipContext = this.applicationDeployed.remove(sipApplicationName);
        ArrayList<String> applicationsUndeployed = new ArrayList<String>();
        applicationsUndeployed.add(sipApplicationName);
        this.sipApplicationRouter.applicationUndeployed(applicationsUndeployed);
        if (sipContext != null) {
            ((SipManager)sipContext.getManager()).removeAllSessions();
        }
        String hash = GenericUtils.hashString(sipApplicationName);
        this.mdToApplicationName.remove(hash);
        this.applicationNameToMd.remove(sipApplicationName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("the following sip servlet application has been removed : " + sipApplicationName));
        }
        return sipContext;
    }

    public void processIOException(IOExceptionEvent event) {
        logger.error((Object)("An IOException occured on " + event.getHost() + ":" + event.getPort() + "/" + event.getTransport() + " for provider " + event.getSource()));
    }

    public int getNumberOfPendingMessages() {
        return this.asynchronousExecutor.getQueue().size();
    }

    private void analyzeQueueCongestionState() {
        this.numberOfMessagesInQueue = this.getNumberOfPendingMessages();
        if (this.rejectSipMessages) {
            if (this.numberOfMessagesInQueue < this.backToNormalQueueSize) {
                logger.warn((Object)("number of pending messages in the queues : " + this.numberOfMessagesInQueue + " < to the back to normal queue Size : " + this.backToNormalQueueSize + " => stopping to reject requests"));
                this.rejectSipMessages = false;
            }
        } else if (this.numberOfMessagesInQueue > this.queueSize) {
            logger.warn((Object)("number of pending messages in the queues : " + this.numberOfMessagesInQueue + " > to the queue Size : " + this.queueSize + " => starting to reject requests"));
            this.rejectSipMessages = true;
        }
    }

    private void analyzeMemory() {
        Runtime runtime = Runtime.getRuntime();
        double allocatedMemory = (double)runtime.totalMemory() / 1024.0;
        double freeMemory = (double)runtime.freeMemory() / 1024.0;
        double totalFreeMemory = freeMemory + (this.maxMemory - allocatedMemory);
        this.percentageOfMemoryUsed = 100.0 - totalFreeMemory / this.maxMemory * 100.0;
        if (this.memoryToHigh) {
            if (this.percentageOfMemoryUsed < (double)this.backToNormalMemoryThreshold) {
                logger.warn((Object)("Memory used: " + this.percentageOfMemoryUsed + "% < to the back to normal memory threshold : " + this.backToNormalMemoryThreshold + " => stopping to reject requests"));
                this.memoryToHigh = false;
            }
        } else if (this.percentageOfMemoryUsed > (double)this.memoryThreshold) {
            logger.warn((Object)("Memory used: " + this.percentageOfMemoryUsed + "% > to the memory threshold : " + this.memoryThreshold + " => starting to reject requests"));
            this.memoryToHigh = true;
        }
    }

    public void processRequest(RequestEvent requestEvent) {
        if ((this.rejectSipMessages || this.memoryToHigh) && CongestionControlPolicy.DropMessage.equals((Object)this.congestionControlPolicy)) {
            boolean goodMethod;
            String method = requestEvent.getRequest().getMethod();
            boolean bl = goodMethod = method.equals("ACK") || method.equals("PRACK") || method.equals("BYE") || method.equals("CANCEL");
            if (!goodMethod) {
                logger.error((Object)"dropping request, memory is too high or too many messages present in queues");
                return;
            }
        }
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        ServerTransaction requestTransaction = requestEvent.getServerTransaction();
        Dialog dialog = requestEvent.getDialog();
        Request request = requestEvent.getRequest();
        String requestMethod = request.getMethod();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sipApplicationDispatcher " + this + ", Got a request event " + request.toString()));
            }
            if (!"ACK".equals(requestMethod) && requestTransaction == null) {
                try {
                    if (request.getHeader("Max-Forwards") == null) {
                        request.setHeader((Header)SipFactories.headerFactory.createMaxForwardsHeader(70));
                    }
                    requestTransaction = sipProvider.getNewServerTransaction(request);
                    requestTransaction.setRetransmitTimer(this.baseTimerInterval);
                    ((TransactionExt)requestTransaction).setTimerT2(this.t2Interval);
                    ((TransactionExt)requestTransaction).setTimerT4(this.t4Interval);
                    ((TransactionExt)requestTransaction).setTimerD(this.timerDInterval);
                }
                catch (TransactionUnavailableException tae) {
                    logger.error((Object)("cannot get a new Server transaction for this request " + request), (Throwable)tae);
                    MessageDispatcher.sendErrorResponse(500, requestTransaction, request, sipProvider);
                    return;
                }
                catch (TransactionAlreadyExistsException taex) {
                    return;
                }
            }
            ServerTransaction transaction = requestTransaction;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ServerTx ref " + transaction));
                logger.debug((Object)("Dialog ref " + dialog));
            }
            SipServletRequestImpl sipServletRequest = new SipServletRequestImpl(request, this.sipFactoryImpl, null, (Transaction)transaction, dialog, JainSipUtils.DIALOG_CREATING_METHODS.contains(requestMethod));
            this.updateRequestStatistics(request);
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            if (!this.isRouteExternal(routeHeader)) {
                TransactionApplicationData transactionApplicationData;
                request.removeFirst("Route");
                sipServletRequest.setPoppedRoute(routeHeader);
                Parameters poppedAddress = (Parameters)routeHeader.getAddress().getURI();
                if (poppedAddress.getParameter("proxy") != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"the request is for a proxy application, thus it is a subsequent request ");
                    }
                    sipServletRequest.setRoutingState(RoutingState.SUBSEQUENT);
                }
                if (transaction != null && (transactionApplicationData = (TransactionApplicationData)transaction.getApplicationData()) != null && transactionApplicationData.getInitialPoppedRoute() == null) {
                    transactionApplicationData.setInitialPoppedRoute(new AddressImpl(routeHeader.getAddress(), null, false));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Routing State " + (Object)((Object)sipServletRequest.getRoutingState())));
            }
            try {
                if ((this.rejectSipMessages || this.memoryToHigh) && !"ACK".equals(requestMethod) && !"PRACK".equals(requestMethod)) {
                    boolean goodMethod;
                    String method = requestEvent.getRequest().getMethod();
                    boolean bl = goodMethod = method.equals("BYE") || method.equals("CANCEL");
                    if (!goodMethod) {
                        MessageDispatcher.sendErrorResponse(503, (ServerTransaction)sipServletRequest.getTransaction(), (Request)sipServletRequest.getMessage(), sipProvider);
                        return;
                    }
                }
                this.messageDispatcherFactory.getRequestDispatcher(sipServletRequest, this).dispatchMessage(sipProvider, sipServletRequest);
            }
            catch (DispatcherException e) {
                logger.error((Object)("Unexpected exception while processing request " + request), (Throwable)e);
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    MessageDispatcher.sendErrorResponse(e.getErrorCode(), (ServerTransaction)sipServletRequest.getTransaction(), (Request)sipServletRequest.getMessage(), sipProvider);
                }
                return;
            }
            catch (Throwable e) {
                logger.error((Object)("Unexpected exception while processing request " + request), e);
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    MessageDispatcher.sendErrorResponse(500, (ServerTransaction)sipServletRequest.getTransaction(), (Request)sipServletRequest.getMessage(), sipProvider);
                }
                return;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Unexpected exception while processing request " + request), e);
            if (!"ACK".equalsIgnoreCase(request.getMethod())) {
                MessageDispatcher.sendErrorResponse(500, requestTransaction, request, sipProvider);
            }
            return;
        }
    }

    private void updateRequestStatistics(Request request) {
        if (this.gatherStatistics) {
            requestsProcessed.incrementAndGet();
            String method = request.getMethod();
            AtomicLong requestsProcessed = requestsProcessedByMethod.get(method);
            if (requestsProcessed == null) {
                requestsProcessedByMethod.put(method, new AtomicLong());
            } else {
                requestsProcessed.incrementAndGet();
            }
        }
    }

    private void updateResponseStatistics(Response response) {
        if (this.gatherStatistics) {
            responsesProcessed.incrementAndGet();
            int statusCode = response.getStatusCode();
            int statusCodeDiv = statusCode / 100;
            switch (statusCodeDiv) {
                case 1: {
                    responsesProcessedByStatusCode.get("1XX").incrementAndGet();
                    break;
                }
                case 2: {
                    responsesProcessedByStatusCode.get("2XX").incrementAndGet();
                    break;
                }
                case 3: {
                    responsesProcessedByStatusCode.get("3XX").incrementAndGet();
                    break;
                }
                case 4: {
                    responsesProcessedByStatusCode.get("4XX").incrementAndGet();
                    break;
                }
                case 5: {
                    responsesProcessedByStatusCode.get("5XX").incrementAndGet();
                    break;
                }
                case 6: {
                    responsesProcessedByStatusCode.get("6XX").incrementAndGet();
                    break;
                }
                case 7: {
                    responsesProcessedByStatusCode.get("7XX").incrementAndGet();
                    break;
                }
                case 8: {
                    responsesProcessedByStatusCode.get("8XX").incrementAndGet();
                    break;
                }
                case 9: {
                    responsesProcessedByStatusCode.get("9XX").incrementAndGet();
                }
            }
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        Response response;
        CSeqHeader cSeqHeader;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response " + responseEvent.getResponse().toString()));
        }
        if ("CANCEL".equalsIgnoreCase((cSeqHeader = (CSeqHeader)(response = responseEvent.getResponse()).getHeader("CSeq")).getMethod())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"the response is dropped accordingly to JSR 289 since this a response to a CANCEL");
            }
            return;
        }
        this.updateResponseStatistics(response);
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Dialog dialog = responseEvent.getDialog();
        boolean isForkedResponse = ((ResponseEventExt)responseEvent).isForkedResponse();
        ClientTransactionExt originalTransaction = ((ResponseEventExt)responseEvent).getOriginalTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("is Forked Response " + isForkedResponse));
            logger.debug((Object)("Client Transaction " + clientTransaction));
            logger.debug((Object)("Original Transaction " + originalTransaction));
            logger.debug((Object)("Dialog " + dialog));
        }
        if (isForkedResponse && originalTransaction != null) {
            Dialog defaultDialog = originalTransaction.getDefaultDialog();
            Dialog orginalTransactionDialog = originalTransaction.getDialog();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Original Transaction Dialog " + orginalTransactionDialog));
                logger.debug((Object)("Original Transaction Default Dialog " + defaultDialog));
            }
            clientTransaction = originalTransaction;
        }
        SipServletResponseImpl sipServletResponse = new SipServletResponseImpl(response, this.sipFactoryImpl, (Transaction)clientTransaction, null, dialog, true);
        try {
            this.messageDispatcherFactory.getResponseDispatcher(sipServletResponse, this).dispatchMessage((SipProvider)responseEvent.getSource(), sipServletResponse);
        }
        catch (Throwable e) {
            logger.error((Object)("An unexpected exception happened while routing the response " + sipServletResponse), e);
            return;
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        Dialog dialog = dialogTerminatedEvent.getDialog();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dialog Terminated => dialog Id : " + dialogTerminatedEvent.getDialog().getDialogId()));
        }
        boolean appDataFound = false;
        TransactionApplicationData dialogAppData = (TransactionApplicationData)dialog.getApplicationData();
        TransactionApplicationData txAppData = null;
        if (dialogAppData != null) {
            if (dialogAppData.getSipServletMessage() == null) {
                Transaction transaction = dialogAppData.getTransaction();
                if (transaction != null && transaction.getApplicationData() != null) {
                    txAppData = (TransactionApplicationData)transaction.getApplicationData();
                    txAppData.cleanUp();
                }
            } else {
                SipServletMessageImpl sipServletMessageImpl = dialogAppData.getSipServletMessage();
                SipSessionKey sipSessionKey = sipServletMessageImpl.getSipSessionKey();
                this.tryToInvalidateSession(sipSessionKey, false);
            }
            dialogAppData.cleanUp();
        }
        if (!appDataFound && logger.isDebugEnabled()) {
            logger.debug((Object)("no application data for this dialog " + dialogTerminatedEvent.getDialog().getDialogId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToInvalidateSession(SipSessionKey sipSessionKey, boolean invalidateProxySession) {
        block25: {
            SipContext sipContext;
            if (sipSessionKey != null && (sipContext = this.findSipApplication(sipSessionKey.getApplicationName())) != null) {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getLoader().getClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    SipManager sipManager = sipContext.getSipManager();
                    SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(sipSessionKey.getApplicationName(), sipSessionKey.getApplicationSessionId());
                    MobicentsSipSession sipSessionImpl = null;
                    MobicentsSipApplicationSession sipApplicationSession = null;
                    if (sipManager instanceof DistributableSipManager) {
                        DistributableSipManager distributableSipManager = (DistributableSipManager)sipManager;
                        sipApplicationSession = distributableSipManager.getSipApplicationSession(sipApplicationSessionKey, false, true);
                        sipSessionImpl = distributableSipManager.getSipSession(sipSessionKey, false, this.sipFactoryImpl, sipApplicationSession, true);
                    } else {
                        sipApplicationSession = sipManager.getSipApplicationSession(sipApplicationSessionKey, false);
                        sipSessionImpl = sipManager.getSipSession(sipSessionKey, false, this.sipFactoryImpl, sipApplicationSession);
                    }
                    if (sipSessionImpl != null) {
                        ProxyImpl proxy = sipSessionImpl.getProxy();
                        if (!invalidateProxySession && (proxy == null || proxy != null && proxy.getFinalBranchForSubsequentRequests() != null && !proxy.getFinalBranchForSubsequentRequests().getRecordRoute())) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("try to Invalidate Proxy session if it is non record routing " + sipSessionKey));
                            }
                            invalidateProxySession = true;
                        }
                        if (!invalidateProxySession) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"don't Invalidate Proxy session");
                            }
                            return;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("sip session " + sipSessionKey + " is valid ? :" + sipSessionImpl.isValidInternal()));
                            if (sipSessionImpl.isValidInternal()) {
                                logger.debug((Object)("Sip session " + sipSessionKey + " is ready to be invalidated ? :" + sipSessionImpl.isReadyToInvalidate()));
                            }
                        }
                        if (sipSessionImpl.isValidInternal() && sipSessionImpl.isReadyToInvalidate()) {
                            sipContext.enterSipApp(sipApplicationSession, sipSessionImpl);
                            try {
                                sipSessionImpl.onTerminatedState();
                            }
                            finally {
                                sipContext.exitSipApp(sipApplicationSession, sipSessionImpl);
                            }
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sip session already invalidated" + sipSessionKey));
                    }
                    if (sipApplicationSession == null) break block25;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sip app session " + sipApplicationSession.getKey() + " is valid ? :" + sipApplicationSession.isValidInternal()));
                        if (sipApplicationSession.isValidInternal()) {
                            logger.debug((Object)("Sip app session " + sipApplicationSession.getKey() + " is ready to be invalidated ? :" + sipApplicationSession.isReadyToInvalidate()));
                        }
                    }
                    if (!sipApplicationSession.isValidInternal() || !sipApplicationSession.isReadyToInvalidate()) break block25;
                    sipContext.enterSipApp(sipApplicationSession, sipSessionImpl);
                    try {
                        sipApplicationSession.tryToInvalidate();
                    }
                    finally {
                        sipContext.exitSipApp(sipApplicationSession, sipSessionImpl);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        }
    }

    public void processDialogTimeout(DialogTimeoutEvent timeoutEvent) {
        TransactionApplicationData tad;
        Dialog dialog = timeoutEvent.getDialog();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("dialog timeout " + dialog + " reason => " + timeoutEvent.getReason()));
        }
        if (timeoutEvent.getReason() == DialogTimeoutEvent.Reason.AckNotReceived && (tad = (TransactionApplicationData)dialog.getApplicationData()) != null && tad.getSipServletMessage() != null) {
            SipServletMessageImpl sipServletMessage = tad.getSipServletMessage();
            SipSessionKey sipSessionKey = sipServletMessage.getSipSessionKey();
            MobicentsSipSession sipSession = sipServletMessage.getSipSession();
            if (sipSession != null) {
                this.checkForAckNotReceived(sipServletMessage);
                this.checkForPrackNotReceived(sipServletMessage);
                dialog.delete();
                this.tryToInvalidateSession(sipSessionKey, false);
            }
            tad.cleanUp();
        }
        dialog.setApplicationData(null);
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        TransactionApplicationData tad;
        Object transaction = null;
        transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + transaction + " timed out => " + transaction.getRequest().toString()));
        }
        if ((tad = (TransactionApplicationData)transaction.getApplicationData()) != null && tad.getSipServletMessage() != null) {
            SipServletMessageImpl sipServletMessage = tad.getSipServletMessage();
            SipSessionKey sipSessionKey = sipServletMessage.getSipSessionKey();
            MobicentsSipSession sipSession = sipServletMessage.getSipSession();
            boolean appNotifiedOfPrackNotReceived = false;
            if (sipSession != null) {
                if (sipServletMessage instanceof SipServletRequestImpl && !timeoutEvent.isServerTransaction()) {
                    try {
                        SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)sipServletMessage;
                        sipServletMessage.setTransaction((Transaction)transaction);
                        SipServletResponseImpl response = (SipServletResponseImpl)sipServletRequestImpl.createResponse(408, null, false);
                        MessageDispatcher.callServlet(response);
                        if (tad.getProxyBranch() != null) {
                            tad.getProxyBranch().setResponse(response);
                            tad.getProxyBranch().onResponse(response, response.getStatus());
                        }
                        sipSession.updateStateOnResponse(response, true);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Failed to deliver 408 response on transaction timeout" + transaction), t);
                    }
                }
                this.checkForAckNotReceived(sipServletMessage);
                appNotifiedOfPrackNotReceived = this.checkForPrackNotReceived(sipServletMessage);
                sipSession.removeOngoingTransaction((Transaction)transaction);
                if (!appNotifiedOfPrackNotReceived) {
                    this.tryToInvalidateSession(sipSessionKey, false);
                }
            }
            tad.cleanUp();
            transaction.setApplicationData(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForAckNotReceived(SipServletMessageImpl sipServletMessage) {
        MobicentsSipSession sipSession = sipServletMessage.getSipSession();
        SipServletResponseImpl lastFinalResponse = (SipServletResponseImpl)((SipServletRequestImpl)sipServletMessage).getLastFinalResponse();
        ProxyImpl proxy = sipSession.getProxy();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checkForAckNotReceived : last Final Response " + lastFinalResponse));
        }
        boolean notifiedApplication = false;
        if (sipServletMessage instanceof SipServletRequestImpl && proxy == null && lastFinalResponse != null) {
            SipContext sipContext = sipSession.getSipApplicationSession().getSipContext();
            List<SipErrorListener> sipErrorListeners = sipContext.getListeners().getSipErrorListeners();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipApp(sipSession.getSipApplicationSession(), sipSession);
                ClassLoader cl = sipContext.getLoader().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                SipErrorEvent sipErrorEvent = new SipErrorEvent((SipServletRequest)sipServletMessage, (SipServletResponse)lastFinalResponse);
                for (SipErrorListener sipErrorListener : sipErrorListeners) {
                    try {
                        notifiedApplication = true;
                        sipErrorListener.noAckReceived(sipErrorEvent);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipErrorListener threw exception", t);
                    }
                }
            }
            finally {
                sipContext.exitSipApp(sipSession.getSipApplicationSession(), sipSession);
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return notifiedApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForPrackNotReceived(SipServletMessageImpl sipServletMessage) {
        MobicentsSipSession sipSession = sipServletMessage.getSipSession();
        SipServletResponseImpl lastInfoResponse = (SipServletResponseImpl)((SipServletRequestImpl)sipServletMessage).getLastInformationalResponse();
        ProxyImpl proxy = sipSession.getProxy();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checkForPrackNotReceived : last Informational Response " + lastInfoResponse));
        }
        boolean notifiedApplication = false;
        if (sipServletMessage instanceof SipServletRequestImpl && proxy == null && lastInfoResponse != null) {
            SipContext sipContext = sipSession.getSipApplicationSession().getSipContext();
            List<SipErrorListener> sipErrorListeners = sipContext.getListeners().getSipErrorListeners();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipApp(sipSession.getSipApplicationSession(), sipSession);
                ClassLoader cl = sipContext.getLoader().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                SipErrorEvent sipErrorEvent = new SipErrorEvent((SipServletRequest)sipServletMessage, (SipServletResponse)lastInfoResponse);
                for (SipErrorListener sipErrorListener : sipErrorListeners) {
                    try {
                        notifiedApplication = true;
                        sipErrorListener.noPrackReceived(sipErrorEvent);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipErrorListener threw exception", t);
                    }
                }
            }
            finally {
                sipContext.exitSipApp(sipSession.getSipApplicationSession(), sipSession);
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return notifiedApplication;
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        TransactionApplicationData tad;
        Object transaction = null;
        transaction = transactionTerminatedEvent.isServerTransaction() ? transactionTerminatedEvent.getServerTransaction() : transactionTerminatedEvent.getClientTransaction();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("transaction " + transaction + " terminated => " + transaction.getRequest().toString()));
        }
        if ((tad = (TransactionApplicationData)transaction.getApplicationData()) != null && tad.getSipServletMessage() != null) {
            SipServletMessageImpl sipServletMessageImpl = tad.getSipServletMessage();
            SipSessionKey sipSessionKey = sipServletMessageImpl.getSipSessionKey();
            MobicentsSipSession sipSession = sipServletMessageImpl.getSipSession();
            B2buaHelperImpl b2buaHelperImpl = null;
            if (sipSession != null) {
                b2buaHelperImpl = sipSession.getB2buaHelper();
            }
            if (sipSessionKey == null && logger.isDebugEnabled()) {
                logger.debug((Object)("no sip session were returned for this key " + sipServletMessageImpl.getSipSessionKey() + " and message " + sipServletMessageImpl));
            }
            if (sipSession != null) {
                boolean removeTx = true;
                if (b2buaHelperImpl != null && transaction instanceof ClientTransaction && "INVITE".equals(sipServletMessageImpl.getMethod())) {
                    removeTx = false;
                }
                if (removeTx) {
                    if (b2buaHelperImpl != null && tad.getSipServletMessage() instanceof SipServletRequestImpl) {
                        b2buaHelperImpl.unlinkOriginalRequestInternal((SipServletRequestImpl)tad.getSipServletMessage());
                    }
                    sipSession.removeOngoingTransaction((Transaction)transaction);
                    tad.cleanUp();
                    boolean nullifyAppData = true;
                    if (((SipStackImpl)((SipProvider)transactionTerminatedEvent.getSource()).getSipStack()).getMaxForkTime() > 0 && "INVITE".equals(sipServletMessageImpl.getMethod())) {
                        nullifyAppData = false;
                    }
                    if (nullifyAppData) {
                        transaction.setApplicationData(null);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transaction " + transaction + " not removed from session " + sipSessionKey + " because the B2BUA might still need it to create the ACK"));
                }
                this.tryToInvalidateSession(sipSessionKey, transactionTerminatedEvent.isServerTransaction());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TransactionApplicationData not available on the following request " + transaction.getRequest().toString()));
            }
            if (tad != null) {
                tad.cleanUp();
            }
            transaction.setApplicationData(null);
        }
    }

    @Override
    public String getApplicationNameFromHash(String hash) {
        return this.mdToApplicationName.get(hash);
    }

    @Override
    public String getHashFromApplicationName(String appName) {
        return this.applicationNameToMd.get(appName);
    }

    @Override
    public final boolean isRouteExternal(RouteHeader routeHeader) {
        if (routeHeader != null) {
            javax.sip.address.SipURI routeUri = (javax.sip.address.SipURI)routeHeader.getAddress().getURI();
            String routeTransport = routeUri.getTransportParam();
            if (routeTransport == null) {
                routeTransport = "UDP";
            }
            return this.isExternal(routeUri.getHost(), routeUri.getPort(), routeTransport);
        }
        return true;
    }

    @Override
    public final boolean isViaHeaderExternal(ViaHeader viaHeader) {
        if (viaHeader != null) {
            return this.isExternal(viaHeader.getHost(), viaHeader.getPort(), viaHeader.getTransport());
        }
        return true;
    }

    @Override
    public final boolean isExternal(String host, int port, String transport) {
        boolean isExternal = true;
        ExtendedListeningPoint listeningPoint = this.sipNetworkInterfaceManager.findMatchingListeningPoint(host, port, transport);
        if (this.hostNames.contains(host) || this.hostNames.contains(host + ":" + port) || listeningPoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hostNames.contains(host)=" + this.hostNames.contains(host) + " | listeningPoint found = " + listeningPoint));
            }
            isExternal = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the triplet host/port/transport : " + host + "/" + port + "/" + transport + " is external : " + isExternal));
        }
        return isExternal;
    }

    @Override
    public SipApplicationRouter getSipApplicationRouter() {
        return this.sipApplicationRouter;
    }

    public void setSipApplicationRouter(SipApplicationRouter sipApplicationRouter) {
        this.sipApplicationRouter = sipApplicationRouter;
    }

    @Override
    public SipNetworkInterfaceManager getSipNetworkInterfaceManager() {
        return this.sipNetworkInterfaceManager;
    }

    @Override
    public SipFactoryImpl getSipFactory() {
        return this.sipFactoryImpl;
    }

    @Override
    public List<SipURI> getOutboundInterfaces() {
        return this.sipNetworkInterfaceManager.getOutboundInterfaces();
    }

    private void resetOutboundInterfaces() {
        List<SipURI> outboundInterfaces = this.sipNetworkInterfaceManager.getOutboundInterfaces();
        for (SipContext sipContext : this.applicationDeployed.values()) {
            sipContext.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", outboundInterfaces);
        }
    }

    @Override
    public void addHostName(String hostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this);
            logger.debug((Object)("Adding hostname " + hostName));
        }
        this.hostNames.add(hostName);
    }

    @Override
    public Set<String> findHostNames() {
        return this.hostNames;
    }

    @Override
    public void removeHostName(String hostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing hostname " + hostName));
        }
        this.hostNames.remove(hostName);
    }

    @Override
    public SipApplicationRouterInfo getNextInterestedApplication(SipServletRequestImpl sipServletRequest) {
        SipApplicationRoutingRegion routingRegion = null;
        Serializable stateInfo = null;
        if (sipServletRequest.getSipSession() != null) {
            routingRegion = sipServletRequest.getSipSession().getRegionInternal();
            stateInfo = sipServletRequest.getSipSession().getStateInfo();
        }
        Request request = (Request)sipServletRequest.getMessage();
        sipServletRequest.setReadOnly(true);
        SipApplicationRouterInfo applicationRouterInfo = this.sipApplicationRouter.getNextApplication((SipServletRequest)sipServletRequest, routingRegion, sipServletRequest.getRoutingDirective(), null, stateInfo);
        sipServletRequest.setReadOnly(false);
        SipRouteModifier sipRouteModifier = applicationRouterInfo.getRouteModifier();
        String[] routes = applicationRouterInfo.getRoutes();
        try {
            if (SipRouteModifier.ROUTE.equals((Object)sipRouteModifier)) {
                Address routeAddress = SipFactories.addressFactory.createAddress(routes[0]);
                RouteHeader applicationRouterInfoRouteHeader = SipFactories.headerFactory.createRouteHeader(routeAddress);
                if (this.isRouteExternal(applicationRouterInfoRouteHeader)) {
                    for (int i = routes.length - 1; i >= 0; --i) {
                        RouteHeader routeHeader = (RouteHeader)SipFactories.headerFactory.createHeader("Route", routes[i]);
                        URI routeURI = routeHeader.getAddress().getURI();
                        if (routeURI.isSipURI()) {
                            ((javax.sip.address.SipURI)routeURI).setLrParam();
                        }
                        request.addHeader((Header)routeHeader);
                    }
                }
            } else if (SipRouteModifier.ROUTE_BACK.equals((Object)sipRouteModifier)) {
                SipURI sipURI = this.getOutboundInterfaces().get(0);
                sipURI.setParameter("modifier", "route_back");
                Header routeHeader = SipFactories.headerFactory.createHeader("Route", sipURI.toString());
                request.addHeader(routeHeader);
                for (int i = routes.length - 1; i >= 0; --i) {
                    routeHeader = SipFactories.headerFactory.createHeader("Route", routes[i]);
                    request.addHeader(routeHeader);
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)"Impossible to parse the route returned by the application router into a compliant address", (Throwable)e);
        }
        return applicationRouterInfo;
    }

    public ThreadPoolExecutor getAsynchronousExecutor() {
        return this.asynchronousExecutor;
    }

    @Override
    public Iterator<SipContext> findSipApplications() {
        return this.applicationDeployed.values().iterator();
    }

    @Override
    public SipContext findSipApplication(String applicationName) {
        return this.applicationDeployed.get(applicationName);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public String[] findInstalledSipApplications() {
        Iterator<SipContext> apps = this.findSipApplications();
        ArrayList<String> appList = new ArrayList<String>();
        while (apps.hasNext()) {
            SipContext ctx = apps.next();
            appList.add(ctx.getApplicationName());
        }
        String[] ret = new String[appList.size()];
        for (int q = 0; q < appList.size(); ++q) {
            ret[q] = (String)appList.get(q);
        }
        return ret;
    }

    public Object retrieveApplicationRouterConfiguration() {
        if (this.sipApplicationRouter instanceof ManageableApplicationRouter) {
            ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
            return router.getCurrentConfiguration();
        }
        throw new RuntimeException("This application router is not manageable");
    }

    public void updateApplicationRouterConfiguration(Object configuration) {
        if (!(this.sipApplicationRouter instanceof ManageableApplicationRouter)) {
            throw new RuntimeException("This application router is not manageable");
        }
        ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
        router.configure(configuration);
    }

    @Override
    public ConcurrencyControlMode getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    @Override
    public void setConcurrencyControlMode(ConcurrencyControlMode concurrencyControlMode) {
        this.concurrencyControlMode = concurrencyControlMode;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Container wide Concurrency Control set to " + concurrencyControlMode));
        }
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Queue Size set to " + queueSize));
        }
    }

    @Override
    public void setConcurrencyControlModeByName(String concurrencyControlMode) {
        this.concurrencyControlMode = ConcurrencyControlMode.valueOf((String)concurrencyControlMode);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Container wide Concurrency Control set to " + concurrencyControlMode));
        }
    }

    public long getRequestsProcessed() {
        return requestsProcessed.get();
    }

    public Map<String, AtomicLong> getRequestsProcessedByMethod() {
        return requestsProcessedByMethod;
    }

    public Map<String, AtomicLong> getResponsesProcessedByStatusCode() {
        return responsesProcessedByStatusCode;
    }

    public long getRequestsProcessedByMethod(String method) {
        AtomicLong requestsProcessed = requestsProcessedByMethod.get(method);
        if (requestsProcessed != null) {
            return requestsProcessed.get();
        }
        return 0L;
    }

    public long getResponsesProcessedByStatusCode(String statusCode) {
        AtomicLong responsesProcessed = responsesProcessedByStatusCode.get(statusCode);
        if (responsesProcessed != null) {
            return responsesProcessed.get();
        }
        return 0L;
    }

    public long getResponsesProcessed() {
        return responsesProcessed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCongestionControlCheckingInterval(long congestionControlCheckingInterval) {
        if (congestionControlCheckingInterval != this.congestionControlCheckingInterval) {
            this.congestionControlCheckingInterval = congestionControlCheckingInterval;
            this.statusLock.lock();
            try {
                if (this.started.booleanValue()) {
                    if (this.congestionControlTimerFuture != null) {
                        this.congestionControlTimerFuture.cancel(false);
                    }
                    if (congestionControlCheckingInterval > 0L) {
                        this.congestionControlTimerFuture = this.congestionControlThreadPool.scheduleWithFixedDelay(this.congestionControlTimerTask, congestionControlCheckingInterval, congestionControlCheckingInterval, TimeUnit.MILLISECONDS);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Congestion control background task modified to check every " + congestionControlCheckingInterval + " milliseconds."));
                        }
                    } else if (logger.isInfoEnabled()) {
                        logger.info((Object)("No Congestion control background task started since the checking interval is equals to " + congestionControlCheckingInterval + " milliseconds."));
                    }
                }
            }
            finally {
                this.statusLock.unlock();
            }
        }
    }

    @Override
    public long getCongestionControlCheckingInterval() {
        return this.congestionControlCheckingInterval;
    }

    @Override
    public void setCongestionControlPolicy(CongestionControlPolicy congestionControlPolicy) {
        this.congestionControlPolicy = congestionControlPolicy;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Congestion Control policy set to " + this.congestionControlPolicy.toString()));
        }
    }

    @Override
    public void setCongestionControlPolicyByName(String congestionControlPolicy) {
        this.congestionControlPolicy = CongestionControlPolicy.valueOf(congestionControlPolicy);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Congestion Control policy set to " + this.congestionControlPolicy.toString()));
        }
    }

    @Override
    public CongestionControlPolicy getCongestionControlPolicy() {
        return this.congestionControlPolicy;
    }

    @Override
    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Memory threshold set to " + this.memoryThreshold + "%"));
        }
    }

    @Override
    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    @Override
    public int getNumberOfMessagesInQueue() {
        return this.numberOfMessagesInQueue;
    }

    @Override
    public double getPercentageOfMemoryUsed() {
        return this.percentageOfMemoryUsed;
    }

    @Override
    public void setBypassRequestExecutor(boolean bypassRequestExecutor) {
        this.bypassRequestExecutor = bypassRequestExecutor;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bypass Request Executor enabled ?" + this.bypassRequestExecutor));
        }
    }

    @Override
    public boolean isBypassRequestExecutor() {
        return this.bypassRequestExecutor;
    }

    @Override
    public void setBypassResponseExecutor(boolean bypassResponseExecutor) {
        this.bypassResponseExecutor = bypassResponseExecutor;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bypass Response Executor enabled ?" + this.bypassResponseExecutor));
        }
    }

    @Override
    public boolean isBypassResponseExecutor() {
        return this.bypassResponseExecutor;
    }

    @Override
    public void setBaseTimerInterval(int baseTimerInterval) {
        if (baseTimerInterval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the Base Timer Interval to a non positive value");
        }
        this.baseTimerInterval = baseTimerInterval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Base Timer Interval set to " + this.baseTimerInterval + "ms"));
        }
    }

    @Override
    public int getBaseTimerInterval() {
        return this.baseTimerInterval;
    }

    @Override
    public void setT2Interval(int t2Interval) {
        if (t2Interval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer T2 Interval to a non positive value");
        }
        this.t2Interval = t2Interval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer T2 Interval set to " + this.t2Interval + "ms"));
        }
    }

    @Override
    public int getT2Interval() {
        return this.t2Interval;
    }

    @Override
    public void setT4Interval(int t4Interval) {
        if (t4Interval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer T4 Interval to a non positive value");
        }
        this.t4Interval = t4Interval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer T4 Interval set to " + this.t4Interval + "ms"));
        }
    }

    @Override
    public int getT4Interval() {
        return this.t4Interval;
    }

    @Override
    public void setTimerDInterval(int timerDInterval) {
        if (timerDInterval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer TD Interval to a non positive value");
        }
        if (timerDInterval < 32000) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer TD Interval to a value lower than 32s");
        }
        this.timerDInterval = timerDInterval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer D Interval set to " + this.timerDInterval + "ms"));
        }
    }

    @Override
    public int getTimerDInterval() {
        return this.timerDInterval;
    }

    @Override
    public String[] getExtensionsSupported() {
        return EXTENSIONS_SUPPORTED;
    }

    @Override
    public String[] getRfcSupported() {
        return RFC_SUPPORTED;
    }

    public void loadBalancerAdded(SipLoadBalancer sipLoadBalancer) {
        this.sipLoadBalancers.add(sipLoadBalancer);
        if (this.sipFactoryImpl.getLoadBalancerToUse() == null) {
            this.sipFactoryImpl.setLoadBalancerToUse(sipLoadBalancer);
        }
    }

    public void loadBalancerRemoved(SipLoadBalancer sipLoadBalancer) {
        this.sipLoadBalancers.remove(sipLoadBalancer);
        if (this.sipFactoryImpl.getLoadBalancerToUse() != null && this.sipFactoryImpl.getLoadBalancerToUse().equals((Object)sipLoadBalancer)) {
            if (this.sipLoadBalancers.size() > 0) {
                this.sipFactoryImpl.setLoadBalancerToUse(this.sipLoadBalancers.iterator().next());
            } else {
                this.sipFactoryImpl.setLoadBalancerToUse(null);
            }
        }
    }

    @Override
    public void sendSwitchoverInstruction(String fromJvmRoute, String toJvmRoute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("switching over from " + fromJvmRoute + " to " + toJvmRoute));
        }
        if (fromJvmRoute == null || toJvmRoute == null) {
            return;
        }
        for (SipLoadBalancer sipLoadBalancer : this.sipLoadBalancers) {
            sipLoadBalancer.switchover(fromJvmRoute, toJvmRoute);
        }
    }

    @Override
    public void setGatherStatistics(boolean skipStatistics) {
        this.gatherStatistics = skipStatistics;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Gathering Statistics set to " + skipStatistics));
        }
    }

    @Override
    public boolean isGatherStatistics() {
        return this.gatherStatistics;
    }

    public boolean getGatherStatistics() {
        return this.gatherStatistics;
    }

    @Override
    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal Memory threshold set to " + backToNormalMemoryThreshold + "%"));
        }
    }

    @Override
    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    @Override
    public void setBackToNormalQueueSize(int backToNormalQueueSize) {
        this.backToNormalQueueSize = backToNormalQueueSize;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal Queue Size set to " + backToNormalQueueSize));
        }
    }

    @Override
    public int getBackToNormalQueueSize() {
        return this.backToNormalQueueSize;
    }

    static {
        for (String method : METHODS_SUPPORTED) {
            requestsProcessedByMethod.put(method, new AtomicLong(0L));
        }
        responsesProcessedByStatusCode = new ConcurrentHashMap<String, AtomicLong>();
        for (String classOfSc : RESPONSES_PER_CLASS_OF_SC) {
            responsesProcessedByStatusCode.put(classOfSc, new AtomicLong(0L));
        }
    }

    public class CongestionControlTimerTask
    implements Runnable {
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"CongestionControlTimerTask now running ");
            }
            SipApplicationDispatcherImpl.this.analyzeQueueCongestionState();
            SipApplicationDispatcherImpl.this.analyzeMemory();
            if (SipApplicationDispatcherImpl.this.gatherStatistics) {
                for (SipContext sipContext : SipApplicationDispatcherImpl.this.applicationDeployed.values()) {
                    sipContext.getSipManager().updateStats();
                }
            }
        }
    }
}

