/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import gov.nist.core.net.AddressResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.address.Hop;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.HopImpl;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.utils.Inet6Util;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSAddressResolver
implements AddressResolver {
    private static final Logger logger = Logger.getLogger(DNSAddressResolver.class);
    SipApplicationDispatcher sipApplicationDispatcher;
    static ConcurrentHashMap<String, Map<String, String>> cachedLookup = new ConcurrentHashMap();

    public DNSAddressResolver(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public Hop resolveAddress(Hop hop) {
        String hopHost = hop.getHost();
        int hopPort = hop.getPort();
        String hopTransport = hop.getTransport();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving " + hopHost + " transport " + hopTransport));
        }
        if (Inet6Util.isValidIP6Address(hopHost) || Inet6Util.isValidIPV4Address(hopHost)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + hopHost + " is a numeric IP address, " + "no DNS SRV lookup to be done, using the hop given in param"));
            }
            return hop;
        }
        if (this.sipApplicationDispatcher.findHostNames().contains(hopHost)) {
            try {
                InetAddress ipAddress = InetAddress.getByName(hopHost);
                return new HopImpl(ipAddress.getHostAddress(), hopPort, hopTransport);
            }
            catch (UnknownHostException e) {
                logger.warn((Object)(hopHost + " belonging to the container cannoit be resolved"));
            }
        }
        return DNSAddressResolver.resolveHostByDnsSrvLookup(hop);
    }

    public static Hop resolveHostByDnsSrvLookup(Hop hop) {
        String host = hop.getHost();
        String transport = hop.getTransport();
        if (transport == null) {
            transport = "UDP";
        }
        transport = transport.toLowerCase();
        Record[] records = null;
        try {
            records = new Lookup("_sip._" + transport + "." + host, 33).run();
        }
        catch (TextParseException e) {
            logger.error((Object)"Impossible to parse the parameters for dns lookup", (Throwable)e);
        }
        if (records == null || records.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SRV lookup for host:transport " + host + "/" + transport + " returned nothing " + "-- we are going to just use the domain name directly"));
            }
            return hop;
        }
        Map<String, String> cachedEntry = DNSAddressResolver.foundCachedEntry(host, transport, records);
        if (cachedEntry == null) {
            SRVRecord record = (SRVRecord)records[0];
            int recordPort = record.getPort();
            String resolvedName = record.getTarget().toString();
            try {
                String hostAddress = InetAddress.getByName(resolvedName).getHostAddress();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Did a successful DNS SRV lookup for host:transport " + host + "/" + transport + " , Host Name = " + resolvedName + " , Host IP Address = " + hostAddress + ", Host Port = " + recordPort));
                }
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("hostName", resolvedName);
                entry.put("hostAddress", hostAddress);
                entry.put("hostPort", "" + recordPort);
                cachedLookup.putIfAbsent(host + transport, entry);
                return new HopImpl(hostAddress, recordPort, transport);
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Impossible to get the host address of the resolved name, we are going to just use the domain name directly" + resolvedName), (Throwable)e);
                return hop;
            }
        }
        String entryResolvedName = cachedEntry.get("hostName");
        String hostAddress = cachedEntry.get("hostAddress");
        String hostPort = cachedEntry.get("hostPort");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reusing a previous DNS SRV lookup for host:transport " + host + "/" + transport + " , Host Name = " + entryResolvedName + " , Host IP Address = " + hostAddress + ", Host Port = " + hostPort));
        }
        return new HopImpl(hostAddress, Integer.parseInt(hostPort), transport);
    }

    public static Map<String, String> foundCachedEntry(String host, String transport, Record[] records) {
        Map<String, String> entry = cachedLookup.get(host + transport);
        if (entry == null) {
            return null;
        }
        String entryResolvedName = entry.get("hostName");
        String hostAddress = entry.get("hostAddress");
        String hostPort = entry.get("hostPort");
        for (Record record : records) {
            if (!(record instanceof SRVRecord)) continue;
            SRVRecord srvRecord = (SRVRecord)record;
            String resolvedName = srvRecord.getTarget().toString();
            try {
                String resolvedHostAddress = InetAddress.getByName(resolvedName).getHostAddress();
                int recordPort = srvRecord.getPort();
                if (!entryResolvedName.equalsIgnoreCase(resolvedName) || !hostAddress.equalsIgnoreCase(resolvedHostAddress) || !hostPort.equalsIgnoreCase("" + recordPort)) continue;
                return entry;
            }
            catch (UnknownHostException e) {
                logger.warn((Object)("Couldn't resolve address " + resolvedName));
            }
        }
        return null;
    }
}

