/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import java.util.Random;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;

public class ApplicationRoutingHeaderComposer {
    private static final Logger logger = Logger.getLogger((String)ApplicationRoutingHeaderComposer.class.getCanonicalName());
    private static final Random RANDOM = new Random();
    private static final String TOKEN_SEPARATOR = "_";

    private static final String reduceRandomValue(String str, int maxChars) {
        int len = str.length();
        if (len > maxChars) {
            return str.substring(len - maxChars, len);
        }
        return str;
    }

    public static final String randomString() {
        long randValue = Math.abs((long)RANDOM.nextInt(1211111) ^ System.nanoTime());
        return ApplicationRoutingHeaderComposer.reduceRandomValue(String.valueOf(randValue), 8);
    }

    public static final String[] getAppNameAndSessionId(SipApplicationDispatcher sipApplicationDispatcher, String text) {
        String[] tokens;
        String[] tuple = new String[2];
        if (text != null && (tokens = text.split(TOKEN_SEPARATOR)).length > 1) {
            String hashedAppName = tokens[1];
            String appName = sipApplicationDispatcher.getApplicationNameFromHash(hashedAppName);
            if (appName == null) {
                throw new IllegalArgumentException("The hash doesn't correspond to any app name: " + hashedAppName);
            }
            tuple[0] = appName;
            tuple[1] = tokens[2];
        }
        return tuple;
    }

    public static final String getHash(SipApplicationDispatcher sipApplicationDispatcher, String applicationName, String applicationId) {
        String text = ApplicationRoutingHeaderComposer.randomString() + TOKEN_SEPARATOR;
        text = text + sipApplicationDispatcher.getHashFromApplicationName(applicationName);
        if (applicationId != null && applicationId.length() > 0) {
            text = text + TOKEN_SEPARATOR + applicationId;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("tag will be equal to " + text));
        }
        return text;
    }
}

