/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class SipApplicationAnnotationUtils {
    private static final Logger logger = Logger.getLogger(SipApplicationAnnotationUtils.class);
    private static final byte[] SIP_APPLICATION_BYTES = "SipApplication".getBytes();
    private static final byte[] ANNOTATION_BYTES = "annotation".getBytes();

    private static boolean contains(byte[] text, byte[] subtext) {
        if (text.length < subtext.length) {
            return false;
        }
        for (int q = 0; q < text.length - subtext.length; ++q) {
            boolean found = true;
            for (int w = 0; w < subtext.length; ++w) {
                if (text[q + w] == subtext[w]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean findPackageInfoInArchive(File archive) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
        }
        catch (Exception e1) {
            logger.error((Object)("Unable to open " + archive.getAbsolutePath() + ". No sip applications were parsed."));
            return false;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().contains("package-info.class")) continue;
            try {
                if (!SipApplicationAnnotationUtils.findSipApplicationAnnotation(zipFile.getInputStream(entry))) continue;
                return true;
            }
            catch (IOException e) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findPackageInfoinDirectory(File file) {
        if (file.getName().equals("package-info.class")) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                if (SipApplicationAnnotationUtils.findSipApplicationAnnotation(stream)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                if (!SipApplicationAnnotationUtils.findPackageInfoinDirectory(subFile)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean findSipApplicationAnnotation(InputStream stream) {
        try {
            byte[] rawClassBytes = new byte[stream.available()];
            stream.read(rawClassBytes);
            boolean one = SipApplicationAnnotationUtils.contains(rawClassBytes, SIP_APPLICATION_BYTES);
            boolean two = SipApplicationAnnotationUtils.contains(rawClassBytes, ANNOTATION_BYTES);
            if (one && two) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

