/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.URI;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.header.Parameters;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.ParameterableImpl;

public abstract class URIImpl
extends ParameterableImpl
implements URI {
    private static final long serialVersionUID = 1L;
    javax.sip.address.URI uri;

    public URIImpl(javax.sip.address.URI uri) {
        this.uri = uri;
    }

    public URIImpl(TelURL telUrl) {
        this.uri = telUrl;
        if (this.uri instanceof Parameters) {
            super.setParameters(AddressImpl.getParameters((Parameters)this.uri));
        } else {
            super.setParameters(new ConcurrentHashMap<String, String>());
        }
    }

    public URIImpl(SipURI sipUri) {
        this.uri = sipUri;
        if (this.uri instanceof Parameters) {
            super.setParameters(AddressImpl.getParameters((Parameters)this.uri));
        } else {
            super.setParameters(new ConcurrentHashMap<String, String>());
        }
    }

    public javax.sip.address.URI getURI() {
        return this.uri;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public boolean isSipURI() {
        return this.uri.isSipURI();
    }

    public String toString() {
        return this.uri.toString();
    }

    public abstract URI clone();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URIImpl other = (URIImpl)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

