/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;
import java.util.Iterator;
import javax.servlet.sip.TelURL;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.RFC2396UrlDecoder;
import org.mobicents.servlet.sip.address.URIImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelURLImpl
extends URIImpl
implements TelURL {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)TelURLImpl.class.getCanonicalName());
    private javax.sip.address.TelURL telUrl;

    public TelURLImpl(javax.sip.address.TelURL telUrl) {
        super(telUrl);
        this.telUrl = telUrl;
    }

    public String getPhoneNumber() {
        return this.telUrl.getPhoneNumber();
    }

    public boolean isGlobal() {
        return this.telUrl.isGlobal();
    }

    public void setPhoneNumber(String number) {
        String phoneNumber = number;
        if (number.startsWith("+")) {
            phoneNumber = phoneNumber.substring(1);
        }
        try {
            TelURLImpl.basePhoneNumber(phoneNumber);
            this.telUrl.setPhoneNumber(phoneNumber);
        }
        catch (ParseException ex) {
            logger.error((Object)("Error setting phone number " + number));
            throw new IllegalArgumentException("phone number " + number + " is invalid", ex);
        }
    }

    @Override
    public String getParameter(String key) {
        return this.telUrl.getParameter(key);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.telUrl.getParameterNames();
    }

    @Override
    public String getScheme() {
        return this.telUrl.getScheme();
    }

    @Override
    public boolean isSipURI() {
        return false;
    }

    @Override
    public void removeParameter(String name) {
        super.removeParameter(name);
        this.telUrl.removeParameter(name);
    }

    @Override
    public void setParameter(String name, String value) {
        String escapedValue = RFC2396UrlDecoder.encode(value);
        super.setParameter(name, value);
        try {
            this.telUrl.setParameter(name, escapedValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Problem setting parameter", e);
        }
    }

    public TelURL clone() {
        return new TelURLImpl((javax.sip.address.TelURL)this.telUrl.clone());
    }

    @Override
    public String toString() {
        return this.telUrl.toString();
    }

    public String getValue() {
        return this.telUrl.toString();
    }

    public void setValue(String value) {
        try {
            this.telUrl = SipFactories.addressFactory.createTelURL(value);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad url string " + value);
        }
    }

    public String getPhoneContext() {
        return this.telUrl.getPhoneContext();
    }

    public void setPhoneNumber(String number, String phoneContext) {
        this.setPhoneNumber(number);
        try {
            this.telUrl.setPhoneContext(phoneContext);
        }
        catch (ParseException ex) {
            logger.error((Object)("Error setting phone number " + number));
            throw new IllegalArgumentException("phone number " + number + " is invalid", ex);
        }
    }

    private static final String basePhoneNumber(String number) throws ParseException {
        StringBuffer s = new StringBuffer();
        Lexer lexer = new Lexer("sip_urlLexer", number);
        int lc = 0;
        while (lexer.hasMoreChars()) {
            char w = lexer.lookAhead(0);
            if (Lexer.isDigit((char)w) || w == '-' || w == '.' || w == '(' || w == ')') {
                lexer.consume(1);
                s.append(w);
                ++lc;
                continue;
            }
            throw new IllegalArgumentException("unexpected " + w + " in the phone number");
        }
        return s.toString();
    }
}

