/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import gov.nist.javax.sip.address.SipURIExt;
import java.text.ParseException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.InvalidArgumentException;
import javax.sip.address.SipURI;
import javax.sip.header.Parameters;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipFactories;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.RFC2396UrlDecoder;
import org.mobicents.servlet.sip.address.URIImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipURIImpl
extends URIImpl
implements javax.servlet.sip.SipURI {
    private static final long serialVersionUID = 1L;
    private static final String LR_PARAM = "lr";
    private static final String MADDR = "maddr";
    protected static final String METHOD = "method";
    protected static final String TTL = "ttl";
    protected static final String USER = "user";
    protected static final String TRANSPORT = "transport";
    private static final Logger logger = Logger.getLogger((String)SipURIImpl.class.getCanonicalName());

    public SipURIImpl(SipURI sipUri) {
        super(sipUri);
    }

    public SipURI getSipURI() {
        return (SipURI)this.uri;
    }

    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("header name is null");
        }
        try {
            return RFC2396UrlDecoder.decode(((SipURI)this.uri).getHeader(name));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Iterator<String> getHeaderNames() {
        return this.getSipURI().getHeaderNames();
    }

    public String getHost() {
        return this.getSipURI().getHost();
    }

    public boolean getLrParam() {
        return this.getSipURI().hasLrParam();
    }

    public int getPort() {
        return this.getSipURI().getPort();
    }

    public int getTTLParam() {
        return this.getSipURI().getTTLParam();
    }

    public String getTransportParam() {
        return this.getSipURI().getTransportParam();
    }

    public String getUser() {
        return RFC2396UrlDecoder.decode(this.getSipURI().getUser());
    }

    public String getUserParam() {
        return RFC2396UrlDecoder.decode(this.getSipURI().getUserParam());
    }

    public String getUserPassword() {
        if (this.getSipURI().getUserPassword() == null) {
            return null;
        }
        return RFC2396UrlDecoder.decode(this.getSipURI().getUserPassword());
    }

    public boolean isSecure() {
        return this.getSipURI().isSecure();
    }

    public void setHeader(String name, String value) {
        try {
            this.getSipURI().setHeader(name, value);
        }
        catch (ParseException ex) {
            logger.error((Object)"parse exception occured", (Throwable)ex);
            throw new IllegalArgumentException("Bad arg!", ex);
        }
    }

    public void setHost(String host) {
        try {
            this.getSipURI().setHost(host);
        }
        catch (ParseException e) {
            logger.error((Object)"parse exception occured", (Throwable)e);
            throw new IllegalArgumentException("Bad arg!", e);
        }
    }

    public void setLrParam(boolean flag) {
        if (flag) {
            this.getSipURI().setLrParam();
            this.parameters.put(LR_PARAM, "");
        } else {
            this.getSipURI().removeParameter(LR_PARAM);
            this.parameters.remove(LR_PARAM);
        }
    }

    public void setMAddrParam(String maddr) {
        try {
            this.getSipURI().setMAddrParam(maddr);
            this.parameters.put(MADDR, maddr);
        }
        catch (ParseException e) {
            logger.error((Object)"parse exception occured", (Throwable)e);
        }
    }

    public void setMethodParam(String method) {
        try {
            this.getSipURI().setMethodParam(method);
            this.parameters.put(METHOD, method);
        }
        catch (ParseException e) {
            logger.error((Object)"parse exception occured", (Throwable)e);
            throw new IllegalArgumentException("Bad arg " + method, e);
        }
    }

    public void setPort(int port) {
        this.getSipURI().setPort(port);
    }

    public void setSecure(boolean b) {
        this.getSipURI().setSecure(b);
    }

    public void setTTLParam(int ttl) {
        try {
            this.getSipURI().setTTLParam(ttl);
            this.parameters.put(TTL, "" + ttl);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"invalid argument", (Throwable)e);
        }
    }

    public void setTransportParam(String transport) {
        try {
            this.getSipURI().setParameter(TRANSPORT, transport);
            this.parameters.put(TRANSPORT, transport);
        }
        catch (ParseException e) {
            logger.error((Object)"error setting transport ", (Throwable)e);
        }
    }

    public void setUser(String user) {
        try {
            this.getSipURI().setUser(user);
        }
        catch (ParseException e) {
            logger.error((Object)"error setting parameter ", (Throwable)e);
        }
    }

    public void setUserParam(String user) {
        try {
            this.getSipURI().setUserParam(user);
            this.parameters.put(USER, user);
        }
        catch (ParseException e) {
            logger.error((Object)"error setting parameter ", (Throwable)e);
        }
    }

    public void setUserPassword(String password) {
        try {
            this.getSipURI().setUserPassword(password);
        }
        catch (ParseException e) {
            logger.error((Object)"error setting parameter ", (Throwable)e);
            throw new IllegalArgumentException("Bad arg", e);
        }
    }

    public String getMAddrParam() {
        return this.getSipURI().getMAddrParam();
    }

    public String getMethodParam() {
        return RFC2396UrlDecoder.decode(this.getSipURI().getMethodParam());
    }

    @Override
    public String toString() {
        return this.getSipURI().toString();
    }

    public void setValue(String value) {
        try {
            this.uri = SipFactories.addressFactory.createURI(value);
            if (this.uri instanceof Parameters) {
                super.setParameters(AddressImpl.getParameters((Parameters)this.uri));
            } else {
                super.setParameters(new ConcurrentHashMap<String, String>());
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"Bad input arg", (Throwable)ex);
            throw new IllegalArgumentException("Bad input arg", ex);
        }
    }

    public String getValue() {
        return RFC2396UrlDecoder.decode(this.uri.toString());
    }

    public javax.servlet.sip.SipURI clone() {
        return new SipURIImpl((SipURI)this.getSipURI().clone());
    }

    public void removeHeader(String name) {
        ((SipURIExt)this.getSipURI()).removeHeader(name);
    }

    @Override
    public void setParameter(String name, String value) {
        if (LR_PARAM.equals(name) && (value == null || value.length() < 1)) {
            this.setLrParam(true);
            return;
        }
        String escapedValue = RFC2396UrlDecoder.encode(value);
        super.setParameter(name, value);
        try {
            this.getSipURI().setParameter(name, escapedValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Problem setting parameter", e);
        }
    }

    @Override
    public void removeParameter(String name) {
        super.removeParameter(name);
        this.getSipURI().removeParameter(name);
    }
}

