/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import org.mobicents.servlet.sip.address.ParameterableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterableHeaderImpl
extends ParameterableImpl {
    private static final long serialVersionUID = 1L;
    protected String value = null;

    public ParameterableHeaderImpl() {
    }

    public ParameterableHeaderImpl(Header header, String value, Map<String, String> params, boolean isNotModifiable) {
        super(header, params, !isNotModifiable);
        this.value = value;
    }

    @Override
    public Object clone() {
        ParameterableHeaderImpl cloned = new ParameterableHeaderImpl();
        cloned.parameters = ParameterableHeaderImpl.cloneParameters(this.parameters);
        cloned.value = this.value;
        cloned.header = (Parameters)((Header)this.header).clone();
        return cloned;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("value is null ! ");
        }
        if (!this.isModifiable) {
            throw new IllegalStateException("it is forbidden for an application to set the From Header");
        }
        this.value = value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterableHeaderImpl other = (ParameterableHeaderImpl)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public String toString() {
        String retVal = this.value;
        if (retVal.trim().startsWith("<") && !retVal.trim().endsWith(">")) {
            retVal = retVal.concat(">");
        }
        if (!super.toString().trim().equals("")) {
            retVal = retVal.concat(";" + super.toString());
        }
        return retVal;
    }

    public static final Map<String, String> cloneParameters(Map<String, String> parametersToClone) {
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> param : parametersToClone.entrySet()) {
            params.put(param.getKey(), param.getValue());
        }
        return params;
    }
}

