/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip;

import gov.nist.javax.sip.header.HeaderFactoryImpl;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import org.apache.log4j.Logger;

public class SipFactories {
    private static final Logger logger = Logger.getLogger((String)SipFactories.class.getCanonicalName());
    private static boolean initialized;
    public static AddressFactory addressFactory;
    public static HeaderFactory headerFactory;
    public static SipFactory sipFactory;
    public static MessageFactory messageFactory;

    public static void initialize(String pathName, boolean prettyEncoding) {
        if (!initialized) {
            try {
                System.setProperty("gov.nist.core.STRIP_ADDR_SCOPES", "true");
                sipFactory = SipFactory.getInstance();
                sipFactory.setPathName(pathName);
                addressFactory = sipFactory.createAddressFactory();
                headerFactory = sipFactory.createHeaderFactory();
                if (prettyEncoding) {
                    ((HeaderFactoryImpl)headerFactory).setPrettyEncoding(prettyEncoding);
                }
                messageFactory = sipFactory.createMessageFactory();
                initialized = true;
            }
            catch (PeerUnavailableException ex) {
                logger.error((Object)"Could not instantiate factories -- exitting", (Throwable)ex);
                throw new IllegalArgumentException("Cannot instantiate factories ", ex);
            }
        }
    }
}

