/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;

public class DeleteConnectionHandler
extends TransactionHandler {
    private DeleteConnection command;
    private DeleteConnectionResponse response;
    private static final Logger logger = Logger.getLogger(DeleteConnectionHandler.class);

    public DeleteConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public DeleteConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decode of DLCX command failed", (Throwable)e);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            logger.error((Object)"Decode of DLCX Response failed", (Throwable)e);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        DeleteConnection evt = (DeleteConnection)event;
        StringBuffer s = new StringBuffer();
        s.append("DLCX ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" ").append(" MGCP 1.0").append("\n");
        if (evt.getBearerInformation() != null) {
            s.append("B:e:").append(evt.getBearerInformation()).append("\n");
        }
        if (evt.getCallIdentifier() != null) {
            s.append("C:").append(evt.getCallIdentifier()).append("\n");
        }
        if (evt.getConnectionIdentifier() != null) {
            s.append("I:").append(evt.getConnectionIdentifier()).append("\n");
        }
        if (evt.getConnectionParms() != null) {
            s.append("P:").append(this.utils.encodeConnectionParms(evt.getConnectionParms())).append("\n");
        }
        if (evt.getNotificationRequestParms() != null) {
            s.append(this.utils.encodeNotificationRequestParms(evt.getNotificationRequestParms()));
        }
        if (evt.getReasonCode() != null) {
            s.append("E:").append(evt.getReasonCode());
        }
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        DeleteConnectionResponse response = (DeleteConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        if (response.getConnectionParms() != null) {
            s.append(response.getConnectionParms()).append("\n");
        }
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        DeleteConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new DeleteConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.commandEvent.getTransactionHandle());
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = DeleteConnectionHandler.this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            DeleteConnectionHandler.this.response = new DeleteConnectionResponse(DeleteConnectionHandler.this.source != null ? DeleteConnectionHandler.this.source : DeleteConnectionHandler.this.stack, DeleteConnectionHandler.this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            DeleteConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("I")) {
                // empty if block
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }

    public class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = DeleteConnectionHandler.this.utils.splitStringBySpace(header);
            String transactionID = tokens[1].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = DeleteConnectionHandler.this.utils.decodeEndpointIdentifier(tokens[2].trim());
            DeleteConnectionHandler.this.command = new DeleteConnection(DeleteConnectionHandler.this.getObjectSource(tid), endpoint);
            DeleteConnectionHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                DeleteConnectionHandler.this.command.setBearerInformation(DeleteConnectionHandler.this.utils.decodeBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                DeleteConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            } else if (name.equalsIgnoreCase("I")) {
                DeleteConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("X")) {
                DeleteConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("R")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(DeleteConnectionHandler.this.utils.decodeRequestedEventList(value));
            } else if (name.equalsIgnoreCase("S")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(DeleteConnectionHandler.this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(DeleteConnectionHandler.this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("P")) {
                DeleteConnectionHandler.this.command.setConnectionParms(DeleteConnectionHandler.this.utils.decodeConnectionParms(value));
            } else if (name.equalsIgnoreCase("E")) {
                DeleteConnectionHandler.this.command.setReasonCode(DeleteConnectionHandler.this.utils.decodeReasonCode(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

