/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;

public class MgcpMessageParser {
    private MgcpContentHandler contentHandler;
    private static final Logger logger = Logger.getLogger(MgcpMessageParser.class);

    public MgcpMessageParser(MgcpContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new IllegalArgumentException("Content handler cannot be null");
        }
        this.contentHandler = contentHandler;
    }

    public void parse(String message) throws IOException, ParseException {
        StringReader stringReader = new StringReader(message);
        BufferedReader reader = new BufferedReader(stringReader);
        String header = reader.readLine();
        this.contentHandler.header(header);
        boolean sdpPresent = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            boolean bl = sdpPresent = (line = line.trim()).length() == 0;
            if (sdpPresent) break;
            int pos = line.indexOf(58);
            if (pos < 0) {
                logger.warn((Object)("Unrecognized parameter: " + line));
                continue;
            }
            String parmName = line.substring(0, pos).trim();
            String parmValue = line.substring(pos + 1).trim();
            this.contentHandler.param(parmName, parmValue);
        }
        boolean hasMore = false;
        String ss = null;
        try {
            ss = reader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        boolean bl = hasMore = ss != null;
        if (sdpPresent || hasMore) {
            String sdp = ss + "\n";
            while ((line = reader.readLine()) != null) {
                sdp = sdp + line.trim() + "\r\n";
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read session description: " + sdp));
            }
            this.contentHandler.sessionDescription(sdp);
        }
    }
}

