/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.RestartInProgress;
import jain.protocol.ip.mgcp.message.RestartInProgressResponse;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;

public class RestartInProgressHandler
extends TransactionHandler {
    private RestartInProgress command;
    private RestartInProgressResponse response;

    public RestartInProgressHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public RestartInProgressHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        RestartInProgress rsip = (RestartInProgress)event;
        StringBuffer message = new StringBuffer();
        message.append("RSIP " + event.getTransactionHandle() + " " + rsip.getEndpointIdentifier() + " MGCP 1.0\n");
        message.append("RM:" + rsip.getRestartMethod() + "\n");
        if (rsip.getRestartDelay() != 0) {
            message.append("RD:" + rsip.getRestartDelay() + "\n");
        }
        if (rsip.getReasonCode() != null) {
            message.append("E:" + rsip.getReasonCode() + "\n");
        }
        return message.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        return event.getReturnCode().getValue() + " " + event.getTransactionHandle() + " " + event.getReturnCode().getComment() + "\n";
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        RestartInProgressResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new RestartInProgressResponse(this.commandEvent.getSource(), ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private ResponseContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            RestartInProgressHandler.this.response = new RestartInProgressResponse((Object)RestartInProgressHandler.this.stack, RestartInProgressHandler.this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            RestartInProgressHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private CommandContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = RestartInProgressHandler.this.utils.decodeEndpointIdentifier(tokens[2].trim());
            RestartInProgressHandler.this.command = new RestartInProgress(RestartInProgressHandler.this.getObjectSource(tid), endpoint, RestartMethod.Restart);
            RestartInProgressHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("RM")) {
                RestartInProgressHandler.this.command.setRestartMethod(RestartInProgressHandler.this.utils.decodeRestartMethod(value));
            } else if (name.equalsIgnoreCase("RD")) {
                RestartInProgressHandler.this.command.setRestartDelay(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("E")) {
                RestartInProgressHandler.this.command.setReasonCode(RestartInProgressHandler.this.utils.decodeReasonCode(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

